import _sfc_main$1 from './timeAgo-D7-A3XOx.mjs';
import _sfc_main$2 from './blink-DRvWMg-X.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElEmpty } from './index-Dbj2uCwz.mjs';
import { g as getServerSettings, e as useUtils, r as useRequest } from './server.mjs';
import { useSSRContext, reactive, mergeProps, unref, withCtx, createTextVNode, toDisplayString, openBlock, createBlock } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderList, ssrRenderStyle, ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';
import './nuxt-link-Dd6LuEo9.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';

const _sfc_main = {
  __name: "ModulesAccountPromotionList",
  __ssrInlineRender: true,
  setup(__props) {
    const settingsStore = getServerSettings();
    const state = reactive({
      list: {
        edges: null,
        pageInfo: null
      },
      loading: false,
      loaded: false,
      itemData: (data) => {
        try {
          return JSON.parse(data);
        } catch (error) {
          return {};
        }
      },
      loadMore: async () => {
        if (state.loading) return;
        state.loading = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              after: state.list.pageInfo?.endCursor ?? ""
            }
          }
        });
        if (res?.guaqi?.account?.promotion?.list?.edges) {
          if (!state.list.edges) {
            state.list.edges = res.guaqi.account.promotion.list.edges;
            state.list.pageInfo = res.guaqi.account.promotion.list.pageInfo;
          } else {
            state.list.edges = [
              ...state.list.edges,
              ...res.guaqi.account.promotion.list.edges
            ];
            state.list.pageInfo = res.guaqi.account.promotion.list.pageInfo;
          }
          if (state.list.edges.length > 0 && state.list.edges.length < 16) {
            state.list.edges = [
              ...state.list.edges,
              ...Array(16 - state.list.edges.length).fill({})
            ];
          }
        }
        state.loading = false;
        state.loaded = true;
      },
      amount: (credit, currency) => {
        if (!credit) {
          return `${useUtils.isoToSymbol(
            currency,
            settingsStore.currency
          )}${0}`;
        }
        let c = Math.abs(credit).toFixed(2);
        if (credit >= 0) {
          return `${useUtils.isoToSymbol(
            currency,
            settingsStore.currency
          )}${c}`;
        }
        return `-${useUtils.isoToSymbol(
          currency,
          settingsStore.currency
        )}${c}`;
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_TimeAgo = _sfc_main$1;
      const _component_Blink = _sfc_main$2;
      const _component_el_button = ElButton;
      const _component_el_empty = ElEmpty;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "min-h-160 load-success" }, _attrs))} data-v-42919ff4>`);
      if (!unref(state).loaded || unref(state).list.edges?.length > 0) {
        _push(`<div class="mt-4 border-1 rounded overflow-hidden" data-v-42919ff4><div class="grid grid-cols-5 text-xs divide-x bg-[--el-color-info-light-10]" data-v-42919ff4><div class="item opacity-70" data-v-42919ff4>${ssrInterpolate(_ctx.$t("page.account.promotion.promotionDetail.time"))}</div><div class="item opacity-70" data-v-42919ff4>${ssrInterpolate(_ctx.$t("page.account.promotion.promotionDetail.product"))}</div><div class="item opacity-70" data-v-42919ff4>${ssrInterpolate(_ctx.$t("page.account.promotion.promotionDetail.user"))}</div><div class="item opacity-70" data-v-42919ff4>${ssrInterpolate(_ctx.$t("page.account.promotion.promotionDetail.commission"))}</div><div class="item opacity-70" data-v-42919ff4>${ssrInterpolate(_ctx.$t("page.account.promotion.promotionDetail.status"))}</div></div><!--[-->`);
        ssrRenderList(unref(state).list.edges || Array(20).fill({}), (item, index) => {
          _push(`<div class="grid grid-cols-5 text-xs divide-x" style="${ssrRenderStyle(`--xyz-index:${index % 20}`)}" data-v-42919ff4><div class="item" data-v-42919ff4>`);
          if (item?.node?.createdAt) {
            _push(ssrRenderComponent(_component_TimeAgo, {
              date: item?.node?.createdAt,
              class: "gq-gs"
            }, null, _parent));
          } else {
            _push(`<span data-v-42919ff4>-</span>`);
          }
          _push(`</div><div class="item" data-v-42919ff4>`);
          if (item?.node?.orderData) {
            _push(`<!--[--><span class="line-clamp-2" data-v-42919ff4>${ssrInterpolate(unref(state).itemData(item?.node?.orderData)?.title ?? "")}</span><span class="opacity-50 text-[10px]" data-v-42919ff4>${ssrInterpolate(unref(state).amount(item?.node?.finalAmount, item?.node?.currency) ?? "")}</span><!--]-->`);
          } else {
            _push(`<!--[-->-<!--]-->`);
          }
          _push(`</div><div class="item" data-v-42919ff4>`);
          if (item?.node?.fromUser) {
            _push(`<!--[-->`);
            _push(ssrRenderComponent(_component_Blink, {
              class: "line-clamp-1",
              to: `${item?.node?.fromUser?.gqSlug ?? ""}`
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(`${ssrInterpolate(item?.node?.fromUser?.name ?? "")}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(item?.node?.fromUser?.name ?? ""), 1)
                  ];
                }
              }),
              _: 2
            }, _parent));
            if (item?.node?.level) {
              _push(`<span class="opacity-50 text-[10px]" data-v-42919ff4> Level${ssrInterpolate(item?.node?.level ?? "")}</span>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<!--]-->`);
          } else {
            _push(`<!--[-->-<!--]-->`);
          }
          _push(`</div><div class="item flex flex-col" data-v-42919ff4>`);
          if (item?.node?.commission) {
            _push(`<!--[--><span data-v-42919ff4>${ssrInterpolate(unref(state).amount(item?.node?.commission, item?.node?.currency) ?? "")}</span><span class="opacity-50 text-[10px]" data-v-42919ff4>${ssrInterpolate(item?.node?.commissionRate * 100)}% </span><!--]-->`);
          } else {
            _push(`<!--[-->-<!--]-->`);
          }
          _push(`</div><div class="item" data-v-42919ff4>`);
          if (item?.node?.status) {
            _push(`<!--[-->${ssrInterpolate(item?.node?.status ? _ctx.$t(`page.account.promotion.list.status.${item?.node?.status}`) : "")}<!--]-->`);
          } else {
            _push(`<!--[-->-<!--]-->`);
          }
          _push(`</div></div>`);
        });
        _push(`<!--]-->`);
        if (unref(state).list.pageInfo) {
          _push(`<div class="flex justify-center" data-v-42919ff4>`);
          _push(ssrRenderComponent(_component_el_button, {
            plain: "",
            text: "",
            size: "small",
            class: "w-full !p-6",
            loading: unref(state).loading,
            onClick: unref(state).loadMore,
            disabled: !unref(state).list.pageInfo?.hasNextPage
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                if (unref(state).list.pageInfo?.hasNextPage) {
                  _push2(`<span data-v-42919ff4${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.notification.more"))}</span>`);
                } else if (unref(state).loading) {
                  _push2(`<span data-v-42919ff4${_scopeId}>${ssrInterpolate(_ctx.$t("page.modules.post.loading"))}</span>`);
                } else {
                  _push2(`<span data-v-42919ff4${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.notification.noMore"))}</span>`);
                }
              } else {
                return [
                  unref(state).list.pageInfo?.hasNextPage ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("page.account.notification.more")), 1)) : unref(state).loading ? (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("page.modules.post.loading")), 1)) : (openBlock(), createBlock("span", { key: 2 }, toDisplayString(_ctx.$t("page.account.notification.noMore")), 1))
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<div class="mt-4 border-1 rounded" data-v-42919ff4>`);
        _push(ssrRenderComponent(_component_el_empty, {
          description: _ctx.$t("common.editor.library.empty")
        }, null, _parent));
        _push(`</div>`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/account/promotion/list.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_3 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-42919ff4"]]);

export { __nuxt_component_3 as default };
