import { E as ElPopover } from './index-CPT03ebO.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import { E as ElSelect, a as ElOption } from './index-03hfIBa_.mjs';
import { j as actionStore, a as useI18n, d as useRoute, V as useNuxtApp, aY as useSwitchLocalePath, aZ as useCookie, n as navigateTo$1, e as useUtils, aL as onClickOutside } from './server.mjs';
import { ref, reactive, computed, mergeProps, unref, withCtx, createVNode, createTextVNode, toDisplayString, openBlock, createBlock, Fragment, renderList, createCommentVNode, withModifiers, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderList, ssrInterpolate } from 'vue/server-renderer';
import './dropdown-cQfpmYSu.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import '@vue/shared';
import './index-ChPMoinw.mjs';
import './constants-hAKFmBbq.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import '@ctrl/tinycolor';
import './image-viewer-DG2qIWb8.mjs';
import './index-Di0Jlzch.mjs';
import './index-BKB3Djp4.mjs';
import './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './index-tCyBRCDx.mjs';
import './index-Bp-nwGzu.mjs';
import './event-BZTOGHfp.mjs';
import './index-BY8mj3AC.mjs';
import './vnode-l2ZP2UQa.mjs';

const _sfc_main = {
  __name: "CommonLocaleButton",
  __ssrInlineRender: true,
  props: ["isBuilder"],
  setup(__props) {
    const selectEle = ref(null);
    const buttonEle = ref(null);
    const action = actionStore();
    const props = __props;
    const { locale } = useI18n();
    const route = useRoute();
    const { $serverSettings } = useNuxtApp();
    const switchLocalePath = useSwitchLocalePath();
    const state = reactive({
      locale: locale.value,
      currency: action.currency.iso,
      visible: false,
      switch: (val) => {
        navigateTo$1(switchLocalePath(val));
      },
      changeLocale: (val) => {
        navigateTo$1(useUtils.removeParam(switchLocalePath(val), "setCache"));
      },
      changeCurrency: (val) => {
        useCookie("currency").value = val;
        action.currency.iso = val;
        action.currency.symbol = $serverSettings?.currency?.find(
          (cur) => cur.symbol_iso == val
        )?.symbol;
      }
      // submit: () => {
      //   useCookie("currency").value = state.currency;
      //   action.currency.iso = state.currency;
      //   action.currency.symbol = settingsStore.settings?.currency?.find(
      //     (cur) => cur.symbol_iso == state.currency
      //   )?.symbol;
      //   state.visible = false;
      //   // action.reloadLoginData = true;
      // },
    });
    onClickOutside(selectEle, (event) => {
      state.visible = false;
    }, {
      ignore: [
        ".locale-popover",
        ".el-select-dropdown",
        ".el-select-dropdown__wrap",
        '[popper-class*="el-select"]'
      ]
    });
    const languages = computed(() => {
      return route.path.includes("builder") ? [
        {
          name: "简体中文",
          code: "zh-hans",
          locale: "zh-CN",
          flag: "/flags/zh-hans.svg",
          currency: "RMB"
        },
        {
          name: "English",
          code: "en",
          locale: "en-US",
          flag: "/flags/en.svg",
          currency: "USD"
        },
        {
          name: "Español",
          code: "es",
          locale: "es-ES",
          flag: "/flags/es.svg",
          currency: "EUR"
        }
      ] : $serverSettings.languages;
    });
    const currentLocale = computed(() => {
      return languages?.value?.find((lang) => lang.code == state.locale);
    });
    const currentCur = computed(() => {
      if (!$serverSettings?.currency) {
        return "";
      }
      return $serverSettings?.currency.find(
        (cur) => cur.symbol_iso == state.currency
      );
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_popover = ElPopover;
      const _component_el_button = ElButton;
      const _component_Image = __nuxt_component_4;
      const _component_el_select = ElSelect;
      const _component_el_option = ElOption;
      _push(ssrRenderComponent(_component_el_popover, mergeProps({
        visible: unref(state).visible,
        width: 170,
        offset: 16,
        "hide-after": 0,
        "virtual-ref": unref(buttonEle),
        class: "locale-popover"
      }, _attrs), {
        reference: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_el_button, {
              link: "",
              class: "!h-7",
              onClick: ($event) => unref(state).visible = !unref(state).visible,
              ref_key: "buttonEle",
              ref: buttonEle
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="flex items-center gap-1 locale-button"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_Image, {
                    src: unref(currentLocale)?.flag,
                    class: "@md:w-4.4 @md:h-4.4 w-4.8 h-4.8 rounded-full",
                    style: { "--el-color-info-light-10": "transparent" }
                  }, null, _parent3, _scopeId2));
                  _push3(`<div class="text-xs hidden @md:flex"${_scopeId2}><span class="capitalize"${_scopeId2}>${ssrInterpolate(unref(currentLocale)?.name)}</span><span class="mx-0.4"${_scopeId2}>/</span><span class="opacity-80"${_scopeId2}>${ssrInterpolate(unref(currentCur)?.symbol_iso)} (<b class="text-[var(--el-color-primary)]"${_scopeId2}>${ssrInterpolate(unref(currentCur)?.symbol)}</b>) </span></div></div>`);
                } else {
                  return [
                    createVNode("div", { class: "flex items-center gap-1 locale-button" }, [
                      createVNode(_component_Image, {
                        src: unref(currentLocale)?.flag,
                        class: "@md:w-4.4 @md:h-4.4 w-4.8 h-4.8 rounded-full",
                        style: { "--el-color-info-light-10": "transparent" }
                      }, null, 8, ["src"]),
                      createVNode("div", { class: "text-xs hidden @md:flex" }, [
                        createVNode("span", { class: "capitalize" }, toDisplayString(unref(currentLocale)?.name), 1),
                        createVNode("span", { class: "mx-0.4" }, "/"),
                        createVNode("span", { class: "opacity-80" }, [
                          createTextVNode(toDisplayString(unref(currentCur)?.symbol_iso) + " (", 1),
                          createVNode("b", { class: "text-[var(--el-color-primary)]" }, toDisplayString(unref(currentCur)?.symbol), 1),
                          createTextVNode(") ")
                        ])
                      ])
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_el_button, {
                link: "",
                class: "!h-7",
                onClick: withModifiers(($event) => unref(state).visible = !unref(state).visible, ["stop"]),
                ref_key: "buttonEle",
                ref: buttonEle
              }, {
                default: withCtx(() => [
                  createVNode("div", { class: "flex items-center gap-1 locale-button" }, [
                    createVNode(_component_Image, {
                      src: unref(currentLocale)?.flag,
                      class: "@md:w-4.4 @md:h-4.4 w-4.8 h-4.8 rounded-full",
                      style: { "--el-color-info-light-10": "transparent" }
                    }, null, 8, ["src"]),
                    createVNode("div", { class: "text-xs hidden @md:flex" }, [
                      createVNode("span", { class: "capitalize" }, toDisplayString(unref(currentLocale)?.name), 1),
                      createVNode("span", { class: "mx-0.4" }, "/"),
                      createVNode("span", { class: "opacity-80" }, [
                        createTextVNode(toDisplayString(unref(currentCur)?.symbol_iso) + " (", 1),
                        createVNode("b", { class: "text-[var(--el-color-primary)]" }, toDisplayString(unref(currentCur)?.symbol), 1),
                        createTextVNode(") ")
                      ])
                    ])
                  ])
                ]),
                _: 1
              }, 8, ["onClick"])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex flex-col gap-3 locale-select"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_select, {
              modelValue: unref(state).locale,
              "onUpdate:modelValue": ($event) => unref(state).locale = $event,
              class: "w-full",
              onChange: unref(state).changeLocale
            }, {
              prefix: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_Image, {
                    src: unref(currentLocale)?.flag,
                    class: "w-4 h-4 mr-1.4 rounded-full"
                  }, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_Image, {
                      src: unref(currentLocale)?.flag,
                      class: "w-4 h-4 mr-1.4 rounded-full"
                    }, null, 8, ["src"])
                  ];
                }
              }),
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<!--[-->`);
                  ssrRenderList(unref(languages), (lang) => {
                    _push3(ssrRenderComponent(_component_el_option, {
                      key: lang.code,
                      label: lang.name,
                      value: lang.code,
                      class: "flex items-center"
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_Image, {
                            src: lang.flag,
                            class: "w-4 h-4 mr-1.4 rounded-full"
                          }, null, _parent4, _scopeId3));
                          _push4(` ${ssrInterpolate(lang.name)}`);
                        } else {
                          return [
                            createVNode(_component_Image, {
                              src: lang.flag,
                              class: "w-4 h-4 mr-1.4 rounded-full"
                            }, null, 8, ["src"]),
                            createTextVNode(" " + toDisplayString(lang.name), 1)
                          ];
                        }
                      }),
                      _: 2
                    }, _parent3, _scopeId2));
                  });
                  _push3(`<!--]-->`);
                } else {
                  return [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(languages), (lang) => {
                      return openBlock(), createBlock(_component_el_option, {
                        key: lang.code,
                        label: lang.name,
                        value: lang.code,
                        class: "flex items-center"
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_Image, {
                            src: lang.flag,
                            class: "w-4 h-4 mr-1.4 rounded-full"
                          }, null, 8, ["src"]),
                          createTextVNode(" " + toDisplayString(lang.name), 1)
                        ]),
                        _: 2
                      }, 1032, ["label", "value"]);
                    }), 128))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if (!props.isBuilder) {
              _push2(ssrRenderComponent(_component_el_select, {
                modelValue: unref(state).currency,
                "onUpdate:modelValue": ($event) => unref(state).currency = $event,
                class: "w-full locale-select-currency",
                onChange: unref(state).changeCurrency
              }, {
                prefix: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(unref(currentCur)?.symbol_iso + " (" + unref(currentCur)?.symbol + ")")}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(unref(currentCur)?.symbol_iso + " (" + unref(currentCur)?.symbol + ")"), 1)
                    ];
                  }
                }),
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<!--[-->`);
                    ssrRenderList(unref($serverSettings).currency, (currency) => {
                      _push3(ssrRenderComponent(_component_el_option, {
                        key: currency.symbol_iso,
                        label: currency.name[unref(state).locale],
                        value: currency.symbol_iso
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(`<span${_scopeId3}>${ssrInterpolate(currency.name[unref(state).locale])}</span><span class="opacity-80 ml-2"${_scopeId3}>${ssrInterpolate(currency.symbol_iso)} (${ssrInterpolate(currency.symbol)}) </span>`);
                          } else {
                            return [
                              createVNode("span", null, toDisplayString(currency.name[unref(state).locale]), 1),
                              createVNode("span", { class: "opacity-80 ml-2" }, toDisplayString(currency.symbol_iso) + " (" + toDisplayString(currency.symbol) + ") ", 1)
                            ];
                          }
                        }),
                        _: 2
                      }, _parent3, _scopeId2));
                    });
                    _push3(`<!--]-->`);
                  } else {
                    return [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref($serverSettings).currency, (currency) => {
                        return openBlock(), createBlock(_component_el_option, {
                          key: currency.symbol_iso,
                          label: currency.name[unref(state).locale],
                          value: currency.symbol_iso
                        }, {
                          default: withCtx(() => [
                            createVNode("span", null, toDisplayString(currency.name[unref(state).locale]), 1),
                            createVNode("span", { class: "opacity-80 ml-2" }, toDisplayString(currency.symbol_iso) + " (" + toDisplayString(currency.symbol) + ") ", 1)
                          ]),
                          _: 2
                        }, 1032, ["label", "value"]);
                      }), 128))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", {
                class: "flex flex-col gap-3 locale-select",
                ref_key: "selectEle",
                ref: selectEle
              }, [
                createVNode(_component_el_select, {
                  modelValue: unref(state).locale,
                  "onUpdate:modelValue": ($event) => unref(state).locale = $event,
                  class: "w-full",
                  onChange: unref(state).changeLocale
                }, {
                  prefix: withCtx(() => [
                    createVNode(_component_Image, {
                      src: unref(currentLocale)?.flag,
                      class: "w-4 h-4 mr-1.4 rounded-full"
                    }, null, 8, ["src"])
                  ]),
                  default: withCtx(() => [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(languages), (lang) => {
                      return openBlock(), createBlock(_component_el_option, {
                        key: lang.code,
                        label: lang.name,
                        value: lang.code,
                        class: "flex items-center"
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_Image, {
                            src: lang.flag,
                            class: "w-4 h-4 mr-1.4 rounded-full"
                          }, null, 8, ["src"]),
                          createTextVNode(" " + toDisplayString(lang.name), 1)
                        ]),
                        _: 2
                      }, 1032, ["label", "value"]);
                    }), 128))
                  ]),
                  _: 1
                }, 8, ["modelValue", "onUpdate:modelValue", "onChange"]),
                !props.isBuilder ? (openBlock(), createBlock(_component_el_select, {
                  key: 0,
                  modelValue: unref(state).currency,
                  "onUpdate:modelValue": ($event) => unref(state).currency = $event,
                  class: "w-full locale-select-currency",
                  onChange: unref(state).changeCurrency
                }, {
                  prefix: withCtx(() => [
                    createTextVNode(toDisplayString(unref(currentCur)?.symbol_iso + " (" + unref(currentCur)?.symbol + ")"), 1)
                  ]),
                  default: withCtx(() => [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref($serverSettings).currency, (currency) => {
                      return openBlock(), createBlock(_component_el_option, {
                        key: currency.symbol_iso,
                        label: currency.name[unref(state).locale],
                        value: currency.symbol_iso
                      }, {
                        default: withCtx(() => [
                          createVNode("span", null, toDisplayString(currency.name[unref(state).locale]), 1),
                          createVNode("span", { class: "opacity-80 ml-2" }, toDisplayString(currency.symbol_iso) + " (" + toDisplayString(currency.symbol) + ") ", 1)
                        ]),
                        _: 2
                      }, 1032, ["label", "value"]);
                    }), 128))
                  ]),
                  _: 1
                }, 8, ["modelValue", "onUpdate:modelValue", "onChange"])) : createCommentVNode("", true)
              ], 512)
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/localeButton.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
