import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import _sfc_main$a from './svgIcon-BpIUCf-e.mjs';
import { defineComponent, ref, inject, computed, unref, provide, toRef, readonly, watch, getCurrentInstance, useSSRContext, nextTick, reactive, mergeProps, withCtx, createVNode, openBlock, createBlock, toDisplayString, createCommentVNode, Fragment, renderList, createSlots, createTextVNode, withDirectives, vShow, renderSlot, resolveComponent, normalizeProps, guardReactiveProps, createElementBlock, normalizeClass, createElementVNode, withModifiers, resolveDynamicComponent, normalizeStyle } from 'vue';
import { O as OnlyChild, E as ElTooltip } from './index-Cx5QSQzK.mjs';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { E as ElIcon } from './index-CRbm0e05.mjs';
import { a as useEventListener } from './index-ChPMoinw.mjs';
import { c as composeEventHandlers, g as getEventCode, b as EVENT_CODE, w as whenMouse, _ as _export_sfc$1 } from './focus-trap.vue-9ChHxs3Q.mjs';
import { a0 as buildProps, a2 as definePropType, G as arrow_down_default, C as useNamespace, D as useLocale, ay as useId, P as withInstall, Q as withNoopInstall, d as useRoute, j as actionStore, a as useI18n, v as viewerStore, V as useNuxtApp, r as useRequest, aM as getLoginData, E as ElMessage, s as useIntervalFn, _ as __nuxt_component_0$2 } from './server.mjs';
import { d as dropdownProps, a as dropdownItemProps, b as dropdownMenuProps } from './dropdown-cQfpmYSu.mjs';
import { a as addUnit } from './style-h263bamF.mjs';
import { b as useFormSize } from './use-form-item-Cr81A1TZ.mjs';
import { castArray } from 'lodash-unified';
import { c as composeRefs } from './index-awVc4A7-.mjs';
import { E as ElDivider } from './divider-b4ipVVip.mjs';
import { E as ElForm, a as ElFormItem } from './index-DwNba9hO.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import _sfc_main$b from './countryDialCodes-DK3oAU-H.mjs';
import { a as ElCheckbox } from './index-VQeHi7JP.mjs';
import _sfc_main$c from './blink-DRvWMg-X.mjs';
import __nuxt_component_8 from './loginSocial-Eg5oJz0W.mjs';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrRenderClass } from 'vue/server-renderer';
import { Carousel, Slide, Pagination } from 'vue3-carousel';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './image-viewer-DG2qIWb8.mjs';
import './index-Di0Jlzch.mjs';
import './index-BKB3Djp4.mjs';
import '@vue/shared';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './aria-BhThsKez.mjs';
import './index-31HAFSrO.mjs';
import '@ctrl/tinycolor';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import './constants-hAKFmBbq.mjs';
import './use-dialog-7J0bwlna.mjs';
import './event-BZTOGHfp.mjs';
import './vnode-l2ZP2UQa.mjs';
import 'async-validator';
import './index-Bp-nwGzu.mjs';
import './popover-B8HtRMY4.mjs';
import './nuxt-link-Dd6LuEo9.mjs';

/* empty css                */
/* empty css                 */
var _sfc_main$9 = defineComponent({
  inheritAttrs: false
});
function _sfc_render$8(_ctx, _cache, $props, $setup, $data, $options) {
  return renderSlot(_ctx.$slots, "default");
}
var Collection = /* @__PURE__ */ _export_sfc$1(_sfc_main$9, [["render", _sfc_render$8]]);
var _sfc_main$8 = defineComponent({
  name: "ElCollectionItem",
  inheritAttrs: false
});
function _sfc_render$7(_ctx, _cache, $props, $setup, $data, $options) {
  return renderSlot(_ctx.$slots, "default");
}
var CollectionItem = /* @__PURE__ */ _export_sfc$1(_sfc_main$8, [["render", _sfc_render$7]]);
const COLLECTION_ITEM_SIGN = `data-el-collection-item`;
const createCollectionWithScope = (name) => {
  const COLLECTION_NAME = `El${name}Collection`;
  const COLLECTION_ITEM_NAME = `${COLLECTION_NAME}Item`;
  const COLLECTION_INJECTION_KEY2 = Symbol(COLLECTION_NAME);
  const COLLECTION_ITEM_INJECTION_KEY2 = Symbol(COLLECTION_ITEM_NAME);
  const ElCollection2 = Object.assign({}, Collection, {
    name: COLLECTION_NAME,
    setup() {
      const collectionRef = ref();
      const itemMap = /* @__PURE__ */ new Map();
      const getItems = (() => {
        const collectionEl = unref(collectionRef);
        if (!collectionEl) return [];
        const orderedNodes = Array.from(
          collectionEl.querySelectorAll(`[${COLLECTION_ITEM_SIGN}]`)
        );
        const items = [...itemMap.values()];
        return items.sort(
          (a, b) => orderedNodes.indexOf(a.ref) - orderedNodes.indexOf(b.ref)
        );
      });
      provide(COLLECTION_INJECTION_KEY2, {
        itemMap,
        getItems,
        collectionRef
      });
    }
  });
  const ElCollectionItem2 = Object.assign({}, CollectionItem, {
    name: COLLECTION_ITEM_NAME,
    setup(_, { attrs }) {
      const collectionItemRef = ref();
      inject(COLLECTION_INJECTION_KEY2, void 0);
      provide(COLLECTION_ITEM_INJECTION_KEY2, {
        collectionItemRef
      });
    }
  });
  return {
    COLLECTION_INJECTION_KEY: COLLECTION_INJECTION_KEY2,
    COLLECTION_ITEM_INJECTION_KEY: COLLECTION_ITEM_INJECTION_KEY2,
    ElCollection: ElCollection2,
    ElCollectionItem: ElCollectionItem2
  };
};
const rovingFocusGroupProps = buildProps({
  style: { type: definePropType([String, Array, Object]) },
  currentTabId: {
    type: definePropType(String)
  },
  defaultCurrentTabId: String,
  loop: Boolean,
  dir: {
    type: String,
    // left for direction support
    values: ["ltr", "rtl"],
    default: "ltr"
  },
  orientation: {
    // left for orientation support
    type: definePropType(String)
  },
  onBlur: Function,
  onFocus: Function,
  onMousedown: Function
});
const {
  ElCollection,
  ElCollectionItem,
  COLLECTION_INJECTION_KEY,
  COLLECTION_ITEM_INJECTION_KEY
} = createCollectionWithScope("RovingFocusGroup");
const ROVING_FOCUS_GROUP_INJECTION_KEY = /* @__PURE__ */ Symbol("elRovingFocusGroup");
const ROVING_FOCUS_GROUP_ITEM_INJECTION_KEY = /* @__PURE__ */ Symbol("elRovingFocusGroupItem");
const MAP_KEY_TO_FOCUS_INTENT = {
  ArrowLeft: "prev",
  ArrowUp: "prev",
  ArrowRight: "next",
  ArrowDown: "next",
  PageUp: "first",
  Home: "first",
  PageDown: "last",
  End: "last"
};
const getDirectionAwareKey = (key, dir) => {
  return key;
};
const getFocusIntent = (event, orientation, dir) => {
  const code = getEventCode(event);
  const key = getDirectionAwareKey(code);
  return MAP_KEY_TO_FOCUS_INTENT[key];
};
const reorderArray = (array, atIdx) => {
  return array.map((_, idx) => array[(idx + atIdx) % array.length]);
};
const focusFirst = (elements) => {
  const { activeElement: prevActive } = void 0;
  for (const element of elements) {
    if (element === prevActive) return;
    element.focus();
    if (prevActive !== (void 0).activeElement) return;
  }
};
const CURRENT_TAB_ID_CHANGE_EVT = "currentTabIdChange";
const ENTRY_FOCUS_EVT = "rovingFocusGroup.entryFocus";
const EVT_OPTS = { bubbles: false, cancelable: true };
var _sfc_main$7 = defineComponent({
  name: "ElRovingFocusGroupImpl",
  inheritAttrs: false,
  props: rovingFocusGroupProps,
  emits: [CURRENT_TAB_ID_CHANGE_EVT, "entryFocus"],
  setup(props, { emit }) {
    var _a;
    const currentTabbedId = ref(
      (_a = props.currentTabId || props.defaultCurrentTabId) != null ? _a : null
    );
    const isBackingOut = ref(false);
    const isClickFocus = ref(false);
    const rovingFocusGroupRef = ref();
    const { getItems } = inject(
      COLLECTION_INJECTION_KEY,
      void 0
    );
    const rovingFocusGroupRootStyle = computed(() => {
      return [
        {
          outline: "none"
        },
        props.style
      ];
    });
    const onItemFocus = (tabbedId) => {
      emit(CURRENT_TAB_ID_CHANGE_EVT, tabbedId);
    };
    const onItemShiftTab = () => {
      isBackingOut.value = true;
    };
    const onMousedown = composeEventHandlers(
      (e) => {
        var _a2;
        (_a2 = props.onMousedown) == null ? void 0 : _a2.call(props, e);
      },
      () => {
        isClickFocus.value = true;
      }
    );
    const onFocus = composeEventHandlers(
      (e) => {
        var _a2;
        (_a2 = props.onFocus) == null ? void 0 : _a2.call(props, e);
      },
      (e) => {
        const isKeyboardFocus = !unref(isClickFocus);
        const { target, currentTarget } = e;
        if (target === currentTarget && isKeyboardFocus && !unref(isBackingOut)) {
          const entryFocusEvt = new Event(ENTRY_FOCUS_EVT, EVT_OPTS);
          currentTarget == null ? void 0 : currentTarget.dispatchEvent(entryFocusEvt);
          if (!entryFocusEvt.defaultPrevented) {
            const items = getItems().filter((item) => item.focusable);
            const activeItem = items.find((item) => item.active);
            const currentItem = items.find(
              (item) => item.id === unref(currentTabbedId)
            );
            const candidates = [activeItem, currentItem, ...items].filter(
              Boolean
            );
            const candidateNodes = candidates.map((item) => item.ref);
            focusFirst(candidateNodes);
          }
        }
        isClickFocus.value = false;
      }
    );
    const onBlur = composeEventHandlers(
      (e) => {
        var _a2;
        (_a2 = props.onBlur) == null ? void 0 : _a2.call(props, e);
      },
      () => {
        isBackingOut.value = false;
      }
    );
    const handleEntryFocus = (...args) => {
      emit("entryFocus", ...args);
    };
    const onKeydown = (e) => {
      const focusIntent = getFocusIntent(e);
      if (focusIntent) {
        e.preventDefault();
        const items = getItems().filter((item) => item.focusable);
        let elements = items.map((item) => item.ref);
        switch (focusIntent) {
          case "last": {
            elements.reverse();
            break;
          }
          case "prev":
          case "next": {
            if (focusIntent === "prev") {
              elements.reverse();
            }
            const currentIdx = elements.indexOf(e.currentTarget);
            elements = props.loop ? reorderArray(elements, currentIdx + 1) : elements.slice(currentIdx + 1);
            break;
          }
        }
        nextTick(() => {
          focusFirst(elements);
        });
      }
    };
    provide(ROVING_FOCUS_GROUP_INJECTION_KEY, {
      currentTabbedId: readonly(currentTabbedId),
      loop: toRef(props, "loop"),
      tabIndex: computed(() => {
        return unref(isBackingOut) ? -1 : 0;
      }),
      rovingFocusGroupRef,
      rovingFocusGroupRootStyle,
      orientation: toRef(props, "orientation"),
      dir: toRef(props, "dir"),
      onItemFocus,
      onItemShiftTab,
      onBlur,
      onFocus,
      onMousedown,
      onKeydown
    });
    watch(
      () => props.currentTabId,
      (val) => {
        currentTabbedId.value = val != null ? val : null;
      }
    );
    useEventListener(rovingFocusGroupRef, ENTRY_FOCUS_EVT, handleEntryFocus);
  }
});
function _sfc_render$6(_ctx, _cache, $props, $setup, $data, $options) {
  return renderSlot(_ctx.$slots, "default");
}
var ElRovingFocusGroupImpl = /* @__PURE__ */ _export_sfc$1(_sfc_main$7, [["render", _sfc_render$6]]);
var _sfc_main$6 = defineComponent({
  name: "ElRovingFocusGroup",
  components: {
    ElFocusGroupCollection: ElCollection,
    ElRovingFocusGroupImpl
  }
});
function _sfc_render$5(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_roving_focus_group_impl = resolveComponent("el-roving-focus-group-impl");
  const _component_el_focus_group_collection = resolveComponent("el-focus-group-collection");
  return openBlock(), createBlock(_component_el_focus_group_collection, null, {
    default: withCtx(() => [
      createVNode(
        _component_el_roving_focus_group_impl,
        normalizeProps(guardReactiveProps(_ctx.$attrs)),
        {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "default")
          ]),
          _: 3
          /* FORWARDED */
        },
        16
        /* FULL_PROPS */
      )
    ]),
    _: 3
    /* FORWARDED */
  });
}
var ElRovingFocusGroup = /* @__PURE__ */ _export_sfc$1(_sfc_main$6, [["render", _sfc_render$5]]);
const DROPDOWN_INJECTION_KEY = /* @__PURE__ */ Symbol("elDropdown");
const DROPDOWN_INSTANCE_INJECTION_KEY = "elDropdown";
const { ButtonGroup: ElButtonGroup } = ElButton;
var _sfc_main$5 = defineComponent({
  name: "ElDropdown",
  components: {
    ElButton,
    ElButtonGroup,
    ElScrollbar,
    ElTooltip,
    ElRovingFocusGroup,
    ElOnlyChild: OnlyChild,
    ElIcon,
    ArrowDown: arrow_down_default
  },
  props: dropdownProps,
  emits: ["visible-change", "click", "command"],
  setup(props, { emit }) {
    const _instance = getCurrentInstance();
    const ns = useNamespace("dropdown");
    const { t } = useLocale();
    const triggeringElementRef = ref();
    const referenceElementRef = ref();
    const popperRef = ref();
    const contentRef = ref();
    const scrollbar = ref(null);
    const currentTabId = ref(null);
    const isUsingKeyboard = ref(false);
    const wrapStyle = computed(() => ({
      maxHeight: addUnit(props.maxHeight)
    }));
    const dropdownTriggerKls = computed(() => [ns.m(dropdownSize.value)]);
    const trigger = computed(() => castArray(props.trigger));
    const defaultTriggerId = useId().value;
    const triggerId = computed(() => props.id || defaultTriggerId);
    function handleClick() {
      var _a;
      (_a = popperRef.value) == null ? void 0 : _a.onClose(void 0, 0);
    }
    function handleClose() {
      var _a;
      (_a = popperRef.value) == null ? void 0 : _a.onClose();
    }
    function handleOpen() {
      var _a;
      (_a = popperRef.value) == null ? void 0 : _a.onOpen();
    }
    const dropdownSize = useFormSize();
    function commandHandler(...args) {
      emit("command", ...args);
    }
    function onItemEnter() {
    }
    function onItemLeave() {
      const contentEl = unref(contentRef);
      trigger.value.includes("hover") && (contentEl == null ? void 0 : contentEl.focus({
        preventScroll: true
      }));
      currentTabId.value = null;
    }
    function handleCurrentTabIdChange(id) {
      currentTabId.value = id;
    }
    function handleBeforeShowTooltip() {
      emit("visible-change", true);
    }
    function handleShowTooltip(event) {
      var _a;
      isUsingKeyboard.value = (event == null ? void 0 : event.type) === "keydown";
      (_a = contentRef.value) == null ? void 0 : _a.focus();
    }
    function handleBeforeHideTooltip() {
      emit("visible-change", false);
    }
    provide(DROPDOWN_INJECTION_KEY, {
      contentRef,
      role: computed(() => props.role),
      triggerId,
      isUsingKeyboard,
      onItemEnter,
      onItemLeave,
      handleClose
    });
    provide(DROPDOWN_INSTANCE_INJECTION_KEY, {
      instance: _instance,
      dropdownSize,
      handleClick,
      commandHandler,
      trigger: toRef(props, "trigger"),
      hideOnClick: toRef(props, "hideOnClick")
    });
    const handlerMainButtonClick = (event) => {
      emit("click", event);
    };
    return {
      t,
      ns,
      scrollbar,
      wrapStyle,
      dropdownTriggerKls,
      dropdownSize,
      triggerId,
      currentTabId,
      handleCurrentTabIdChange,
      handlerMainButtonClick,
      handleClose,
      handleOpen,
      handleBeforeShowTooltip,
      handleShowTooltip,
      handleBeforeHideTooltip,
      popperRef,
      contentRef,
      triggeringElementRef,
      referenceElementRef
    };
  }
});
function _sfc_render$4(_ctx, _cache, $props, $setup, $data, $options) {
  var _a;
  const _component_el_roving_focus_group = resolveComponent("el-roving-focus-group");
  const _component_el_scrollbar = resolveComponent("el-scrollbar");
  const _component_el_only_child = resolveComponent("el-only-child");
  const _component_el_tooltip = resolveComponent("el-tooltip");
  const _component_el_button = resolveComponent("el-button");
  const _component_arrow_down = resolveComponent("arrow-down");
  const _component_el_icon = resolveComponent("el-icon");
  const _component_el_button_group = resolveComponent("el-button-group");
  return openBlock(), createElementBlock(
    "div",
    {
      class: normalizeClass([_ctx.ns.b(), _ctx.ns.is("disabled", _ctx.disabled)])
    },
    [
      createVNode(_component_el_tooltip, {
        ref: "popperRef",
        role: _ctx.role,
        effect: _ctx.effect,
        "fallback-placements": ["bottom", "top"],
        "popper-options": _ctx.popperOptions,
        "gpu-acceleration": false,
        placement: _ctx.placement,
        "popper-class": [_ctx.ns.e("popper"), _ctx.popperClass],
        "popper-style": _ctx.popperStyle,
        trigger: _ctx.trigger,
        "trigger-keys": _ctx.triggerKeys,
        "trigger-target-el": _ctx.contentRef,
        "show-arrow": _ctx.showArrow,
        "show-after": _ctx.trigger === "hover" ? _ctx.showTimeout : 0,
        "hide-after": _ctx.trigger === "hover" ? _ctx.hideTimeout : 0,
        "virtual-ref": (_a = _ctx.virtualRef) != null ? _a : _ctx.triggeringElementRef,
        "virtual-triggering": _ctx.virtualTriggering || _ctx.splitButton,
        disabled: _ctx.disabled,
        transition: `${_ctx.ns.namespace.value}-zoom-in-top`,
        teleported: _ctx.teleported,
        "append-to": _ctx.appendTo,
        pure: "",
        "focus-on-target": "",
        persistent: _ctx.persistent,
        onBeforeShow: _ctx.handleBeforeShowTooltip,
        onShow: _ctx.handleShowTooltip,
        onBeforeHide: _ctx.handleBeforeHideTooltip
      }, createSlots({
        content: withCtx(() => [
          createVNode(_component_el_scrollbar, {
            ref: "scrollbar",
            "wrap-style": _ctx.wrapStyle,
            tag: "div",
            "view-class": _ctx.ns.e("list")
          }, {
            default: withCtx(() => [
              createVNode(_component_el_roving_focus_group, {
                loop: _ctx.loop,
                "current-tab-id": _ctx.currentTabId,
                orientation: "horizontal",
                onCurrentTabIdChange: _ctx.handleCurrentTabIdChange
              }, {
                default: withCtx(() => [
                  renderSlot(_ctx.$slots, "dropdown")
                ]),
                _: 3
                /* FORWARDED */
              }, 8, ["loop", "current-tab-id", "onCurrentTabIdChange"])
            ]),
            _: 3
            /* FORWARDED */
          }, 8, ["wrap-style", "view-class"])
        ]),
        _: 2
        /* DYNAMIC */
      }, [
        !_ctx.splitButton ? {
          name: "default",
          fn: withCtx(() => [
            createVNode(_component_el_only_child, {
              id: _ctx.triggerId,
              ref: "triggeringElementRef",
              role: "button",
              tabindex: _ctx.tabindex
            }, {
              default: withCtx(() => [
                renderSlot(_ctx.$slots, "default")
              ]),
              _: 3
              /* FORWARDED */
            }, 8, ["id", "tabindex"])
          ]),
          key: "0"
        } : void 0
      ]), 1032, ["role", "effect", "popper-options", "placement", "popper-class", "popper-style", "trigger", "trigger-keys", "trigger-target-el", "show-arrow", "show-after", "hide-after", "virtual-ref", "virtual-triggering", "disabled", "transition", "teleported", "append-to", "persistent", "onBeforeShow", "onShow", "onBeforeHide"]),
      _ctx.splitButton ? (openBlock(), createBlock(_component_el_button_group, { key: 0 }, {
        default: withCtx(() => [
          createVNode(_component_el_button, mergeProps({ ref: "referenceElementRef" }, _ctx.buttonProps, {
            size: _ctx.dropdownSize,
            type: _ctx.type,
            disabled: _ctx.disabled,
            tabindex: _ctx.tabindex,
            onClick: _ctx.handlerMainButtonClick
          }), {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "default")
            ]),
            _: 3
            /* FORWARDED */
          }, 16, ["size", "type", "disabled", "tabindex", "onClick"]),
          createVNode(_component_el_button, mergeProps({
            id: _ctx.triggerId,
            ref: "triggeringElementRef"
          }, _ctx.buttonProps, {
            role: "button",
            size: _ctx.dropdownSize,
            type: _ctx.type,
            class: _ctx.ns.e("caret-button"),
            disabled: _ctx.disabled,
            tabindex: _ctx.tabindex,
            "aria-label": _ctx.t("el.dropdown.toggleDropdown")
          }), {
            default: withCtx(() => [
              createVNode(_component_el_icon, {
                class: normalizeClass(_ctx.ns.e("icon"))
              }, {
                default: withCtx(() => [
                  createVNode(_component_arrow_down)
                ]),
                _: 1
                /* STABLE */
              }, 8, ["class"])
            ]),
            _: 1
            /* STABLE */
          }, 16, ["id", "size", "type", "class", "disabled", "tabindex", "aria-label"])
        ]),
        _: 3
        /* FORWARDED */
      })) : createCommentVNode("v-if", true)
    ],
    2
    /* CLASS */
  );
}
var Dropdown = /* @__PURE__ */ _export_sfc$1(_sfc_main$5, [["render", _sfc_render$4]]);
var _sfc_main$4 = defineComponent({
  components: {
    ElRovingFocusCollectionItem: ElCollectionItem
  },
  props: {
    focusable: {
      type: Boolean,
      default: true
    },
    active: Boolean
  },
  emits: ["mousedown", "focus", "keydown"],
  setup(props, { emit }) {
    const { currentTabbedId, onItemFocus, onItemShiftTab, onKeydown } = inject(
      ROVING_FOCUS_GROUP_INJECTION_KEY,
      void 0
    );
    const id = useId();
    const rovingFocusGroupItemRef = ref();
    const handleMousedown = composeEventHandlers(
      (e) => {
        emit("mousedown", e);
      },
      (e) => {
        if (!props.focusable) {
          e.preventDefault();
        } else {
          onItemFocus(unref(id));
        }
      }
    );
    const handleFocus = composeEventHandlers(
      (e) => {
        emit("focus", e);
      },
      () => {
        onItemFocus(unref(id));
      }
    );
    const handleKeydown = composeEventHandlers(
      (e) => {
        emit("keydown", e);
      },
      (e) => {
        const { shiftKey, target, currentTarget } = e;
        const code = getEventCode(e);
        if (code === EVENT_CODE.tab && shiftKey) {
          onItemShiftTab();
          return;
        }
        if (target !== currentTarget) return;
        onKeydown(e);
      }
    );
    const isCurrentTab = computed(() => currentTabbedId.value === unref(id));
    provide(ROVING_FOCUS_GROUP_ITEM_INJECTION_KEY, {
      rovingFocusGroupItemRef,
      tabIndex: computed(() => unref(isCurrentTab) ? 0 : -1),
      handleMousedown,
      handleFocus,
      handleKeydown
    });
    return {
      id,
      handleKeydown,
      handleFocus,
      handleMousedown
    };
  }
});
function _sfc_render$3(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_roving_focus_collection_item = resolveComponent("el-roving-focus-collection-item");
  return openBlock(), createBlock(_component_el_roving_focus_collection_item, {
    id: _ctx.id,
    focusable: _ctx.focusable,
    active: _ctx.active
  }, {
    default: withCtx(() => [
      renderSlot(_ctx.$slots, "default")
    ]),
    _: 3
    /* FORWARDED */
  }, 8, ["id", "focusable", "active"]);
}
var ElRovingFocusItem = /* @__PURE__ */ _export_sfc$1(_sfc_main$4, [["render", _sfc_render$3]]);
var _sfc_main$3 = defineComponent({
  name: "DropdownItemImpl",
  components: {
    ElIcon
  },
  props: dropdownItemProps,
  emits: ["pointermove", "pointerleave", "click", "clickimpl"],
  setup(_, { emit }) {
    const ns = useNamespace("dropdown");
    const { role: menuRole } = inject(DROPDOWN_INJECTION_KEY, void 0);
    const { collectionItemRef: rovingFocusCollectionItemRef } = inject(
      COLLECTION_ITEM_INJECTION_KEY,
      void 0
    );
    const {
      rovingFocusGroupItemRef,
      tabIndex,
      handleFocus,
      handleKeydown: handleItemKeydown,
      handleMousedown
    } = inject(ROVING_FOCUS_GROUP_ITEM_INJECTION_KEY, void 0);
    const itemRef = composeRefs(
      rovingFocusCollectionItemRef,
      rovingFocusGroupItemRef
    );
    const role = computed(() => {
      if (menuRole.value === "menu") {
        return "menuitem";
      } else if (menuRole.value === "navigation") {
        return "link";
      }
      return "button";
    });
    const handleKeydown = composeEventHandlers((e) => {
      const code = getEventCode(e);
      if ([EVENT_CODE.enter, EVENT_CODE.numpadEnter, EVENT_CODE.space].includes(
        code
      )) {
        e.preventDefault();
        e.stopImmediatePropagation();
        emit("clickimpl", e);
        return true;
      }
    }, handleItemKeydown);
    return {
      ns,
      itemRef,
      dataset: {
        [COLLECTION_ITEM_SIGN]: ""
      },
      role,
      tabIndex,
      handleFocus,
      handleKeydown,
      handleMousedown
    };
  }
});
const _hoisted_1$1 = ["aria-disabled", "tabindex", "role"];
function _sfc_render$2(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_icon = resolveComponent("el-icon");
  return openBlock(), createElementBlock(
    Fragment,
    null,
    [
      _ctx.divided ? (openBlock(), createElementBlock(
        "li",
        {
          key: 0,
          role: "separator",
          class: normalizeClass(_ctx.ns.bem("menu", "item", "divided"))
        },
        null,
        2
        /* CLASS */
      )) : createCommentVNode("v-if", true),
      createElementVNode("li", mergeProps({ ref: _ctx.itemRef }, { ..._ctx.dataset, ..._ctx.$attrs }, {
        "aria-disabled": _ctx.disabled,
        class: [_ctx.ns.be("menu", "item"), _ctx.ns.is("disabled", _ctx.disabled)],
        tabindex: _ctx.tabIndex,
        role: _ctx.role,
        onClick: _cache[0] || (_cache[0] = (e) => _ctx.$emit("clickimpl", e)),
        onFocus: _cache[1] || (_cache[1] = (...args) => _ctx.handleFocus && _ctx.handleFocus(...args)),
        onKeydown: _cache[2] || (_cache[2] = withModifiers((...args) => _ctx.handleKeydown && _ctx.handleKeydown(...args), ["self"])),
        onMousedown: _cache[3] || (_cache[3] = (...args) => _ctx.handleMousedown && _ctx.handleMousedown(...args)),
        onPointermove: _cache[4] || (_cache[4] = (e) => _ctx.$emit("pointermove", e)),
        onPointerleave: _cache[5] || (_cache[5] = (e) => _ctx.$emit("pointerleave", e))
      }), [
        _ctx.icon || _ctx.$slots.icon ? (openBlock(), createBlock(_component_el_icon, { key: 0 }, {
          default: withCtx(() => [
            renderSlot(_ctx.$slots, "icon", {}, () => [
              (openBlock(), createBlock(resolveDynamicComponent(_ctx.icon)))
            ])
          ]),
          _: 3
          /* FORWARDED */
        })) : createCommentVNode("v-if", true),
        renderSlot(_ctx.$slots, "default")
      ], 16, _hoisted_1$1)
    ],
    64
    /* STABLE_FRAGMENT */
  );
}
var ElDropdownItemImpl = /* @__PURE__ */ _export_sfc$1(_sfc_main$3, [["render", _sfc_render$2]]);
const useDropdown = () => {
  const elDropdown = inject(
    DROPDOWN_INSTANCE_INJECTION_KEY,
    {}
  );
  const _elDropdownSize = computed(() => elDropdown == null ? void 0 : elDropdown.dropdownSize);
  return {
    elDropdown,
    _elDropdownSize
  };
};
var _sfc_main$2 = defineComponent({
  name: "ElDropdownItem",
  components: {
    ElRovingFocusItem,
    ElDropdownItemImpl
  },
  inheritAttrs: false,
  props: dropdownItemProps,
  emits: ["pointermove", "pointerleave", "click"],
  setup(props, { emit, attrs }) {
    const { elDropdown } = useDropdown();
    const _instance = getCurrentInstance();
    const { onItemEnter, onItemLeave } = inject(
      DROPDOWN_INJECTION_KEY,
      void 0
    );
    const handlePointerMove = composeEventHandlers(
      (e) => {
        emit("pointermove", e);
        return e.defaultPrevented;
      },
      whenMouse((e) => {
        if (props.disabled) {
          onItemLeave(e);
          return;
        }
        const target = e.currentTarget;
        if (target === (void 0).activeElement || target.contains((void 0).activeElement)) {
          return;
        }
        onItemEnter(e);
        if (!e.defaultPrevented) {
          target == null ? void 0 : target.focus({
            preventScroll: true
          });
        }
      })
    );
    const handlePointerLeave = composeEventHandlers((e) => {
      emit("pointerleave", e);
      return e.defaultPrevented;
    }, whenMouse(onItemLeave));
    const handleClick = composeEventHandlers(
      (e) => {
        if (props.disabled) {
          return;
        }
        emit("click", e);
        return e.type !== "keydown" && e.defaultPrevented;
      },
      (e) => {
        var _a, _b, _c;
        if (props.disabled) {
          e.stopImmediatePropagation();
          return;
        }
        if ((_a = elDropdown == null ? void 0 : elDropdown.hideOnClick) == null ? void 0 : _a.value) {
          (_b = elDropdown.handleClick) == null ? void 0 : _b.call(elDropdown);
        }
        (_c = elDropdown.commandHandler) == null ? void 0 : _c.call(elDropdown, props.command, _instance, e);
      }
    );
    const propsAndAttrs = computed(() => ({ ...props, ...attrs }));
    return {
      handleClick,
      handlePointerMove,
      handlePointerLeave,
      propsAndAttrs
    };
  }
});
function _sfc_render$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_dropdown_item_impl = resolveComponent("el-dropdown-item-impl");
  const _component_el_roving_focus_item = resolveComponent("el-roving-focus-item");
  return openBlock(), createBlock(_component_el_roving_focus_item, {
    focusable: !_ctx.disabled
  }, {
    default: withCtx(() => [
      createVNode(_component_el_dropdown_item_impl, mergeProps(_ctx.propsAndAttrs, {
        onPointerleave: _ctx.handlePointerLeave,
        onPointermove: _ctx.handlePointerMove,
        onClickimpl: _ctx.handleClick
      }), createSlots({
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 2
        /* DYNAMIC */
      }, [
        _ctx.$slots.icon ? {
          name: "icon",
          fn: withCtx(() => [
            renderSlot(_ctx.$slots, "icon")
          ]),
          key: "0"
        } : void 0
      ]), 1040, ["onPointerleave", "onPointermove", "onClickimpl"])
    ]),
    _: 3
    /* FORWARDED */
  }, 8, ["focusable"]);
}
var DropdownItem = /* @__PURE__ */ _export_sfc$1(_sfc_main$2, [["render", _sfc_render$1]]);
var _sfc_main$1 = defineComponent({
  name: "ElDropdownMenu",
  props: dropdownMenuProps,
  setup(props) {
    const ns = useNamespace("dropdown");
    const { _elDropdownSize } = useDropdown();
    const size = _elDropdownSize.value;
    const { contentRef, role, triggerId, isUsingKeyboard, handleClose } = inject(DROPDOWN_INJECTION_KEY, void 0);
    const {
      rovingFocusGroupRef,
      rovingFocusGroupRootStyle,
      onBlur,
      onFocus,
      onKeydown,
      onMousedown
    } = inject(ROVING_FOCUS_GROUP_INJECTION_KEY, void 0);
    const { collectionRef: rovingFocusGroupCollectionRef } = inject(
      COLLECTION_INJECTION_KEY,
      void 0
    );
    const dropdownKls = computed(() => {
      return [ns.b("menu"), ns.bm("menu", size == null ? void 0 : size.value)];
    });
    const dropdownListWrapperRef = composeRefs(
      contentRef,
      rovingFocusGroupRef,
      rovingFocusGroupCollectionRef
    );
    const handleKeydown = composeEventHandlers(
      (e) => {
        var _a;
        (_a = props.onKeydown) == null ? void 0 : _a.call(props, e);
      },
      (e) => {
        const { currentTarget, target } = e;
        const code = getEventCode(e);
        currentTarget.contains(
          target
        );
        if (EVENT_CODE.tab === code) {
          return handleClose();
        }
        onKeydown(e);
      }
    );
    function handleFocus(e) {
      isUsingKeyboard.value && onFocus(e);
    }
    return {
      size,
      rovingFocusGroupRootStyle,
      dropdownKls,
      role,
      triggerId,
      dropdownListWrapperRef,
      handleKeydown,
      onBlur,
      handleFocus,
      onMousedown
    };
  }
});
const _hoisted_1 = ["role", "aria-labelledby"];
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("ul", {
    ref: _ctx.dropdownListWrapperRef,
    class: normalizeClass(_ctx.dropdownKls),
    style: normalizeStyle(_ctx.rovingFocusGroupRootStyle),
    tabindex: -1,
    role: _ctx.role,
    "aria-labelledby": _ctx.triggerId,
    onFocusin: _cache[0] || (_cache[0] = (...args) => _ctx.handleFocus && _ctx.handleFocus(...args)),
    onFocusout: _cache[1] || (_cache[1] = (...args) => _ctx.onBlur && _ctx.onBlur(...args)),
    onKeydown: _cache[2] || (_cache[2] = withModifiers((...args) => _ctx.handleKeydown && _ctx.handleKeydown(...args), ["self"])),
    onMousedown: _cache[3] || (_cache[3] = withModifiers((...args) => _ctx.onMousedown && _ctx.onMousedown(...args), ["self"]))
  }, [
    renderSlot(_ctx.$slots, "default")
  ], 46, _hoisted_1);
}
var DropdownMenu = /* @__PURE__ */ _export_sfc$1(_sfc_main$1, [["render", _sfc_render]]);
const ElDropdown = withInstall(Dropdown, {
  DropdownItem,
  DropdownMenu
});
const ElDropdownItem = withNoopInstall(DropdownItem);
const ElDropdownMenu = withNoopInstall(DropdownMenu);
const _sfc_main = {
  __name: "CommonFormLoginForm",
  __ssrInlineRender: true,
  setup(__props) {
    const route = useRoute();
    const action = actionStore();
    const { t, locale } = useI18n();
    const viewer = viewerStore();
    const captcha = ref(null);
    const { $serverSettings } = useNuxtApp();
    const registerBox = computed(() => $serverSettings?.login_box);
    const favicon = computed(() => {
      return $serverSettings?.guaqi_logo?.favicon;
    });
    const switchType = (type) => {
      form.type = type;
    };
    const loginSocial = ref(null);
    const countryDialCodes = ref(null);
    const form = reactive({
      action: "login",
      type: registerBox.value?.login_type?.[0] || "email",
      socials: [],
      protocol: true,
      submitLocked: false,
      socialLocked: false,
      phoneOrEmail: "",
      password: "",
      inviteCode: "",
      rePassword: "",
      timer: 0,
      getCodeLocked: false,
      resetPasswordSuccess: false,
      verificationInput: "",
      verificationSign: "",
      socialBox: {
        show: false,
        img: ""
      },
      socialLogin: async (item) => {
        if (form.socialLocked) {
          return;
        }
        form.socialLocked = true;
        await loginSocial.value.form.socialLogin(item);
        form.socialLocked = false;
      },
      submit: function() {
        if (form.action == "login") {
          form.doAction.login();
        }
        if (form.action == "signup") {
          form.doAction.register();
        }
        if (form.action == "forget") {
          form.doAction.next();
        }
        if (form.action == "repass") {
          form.doAction.resetPassword();
        }
      },
      interval: useIntervalFn(
        () => {
          if (form.timer <= 0) {
            form.getCodeLocked = false;
            form.interval.pause();
          } else {
            form.timer--;
          }
        },
        1e3,
        {
          // 默认不开启定时任务
          immediate: false
        }
      ),
      getSocial: async function() {
        const res = await $fetch("/api/socialData");
        form.socials = res;
      },
      doAction: {
        next: async function() {
          if (form.submitLocked) {
            return;
          }
          form.submitLocked = true;
          const res = await useRequest("/api/request", {
            body: {
              data: {
                phoneOrEmail: form.type == "phone" ? (countryDialCodes.value?.countryDialCodes?.picked[1] ?? "") + " " + form.phoneOrEmail : form.phoneOrEmail,
                verificationInput: form.verificationInput,
                verificationSign: form.verificationSign,
                captchaInput: captcha.value.captchaInput,
                captchaSign: captcha.value.captchaSign,
                timestamp: captcha.value.timestamp,
                action: form.action
              }
            }
          });
          if (res) {
            form.action = "repass";
          }
          form.submitLocked = false;
        },
        resetPassword: async function() {
          if (!form.password) {
            ElMessage.error(t("common.login.error.requiredPassword"));
            return;
          }
          if (form.password != form.rePassword) {
            ElMessage.error(t("common.login.error.passwordNotMatch"));
            return;
          }
          if (form.submitLocked) {
            return;
          }
          form.submitLocked = true;
          const res = await useRequest("/api/request", {
            body: {
              data: {
                phoneOrEmail: form.type == "phone" ? (countryDialCodes.value?.countryDialCodes?.picked[1] ?? "") + " " + form.phoneOrEmail : form.phoneOrEmail,
                password: form.password,
                verificationInput: form.verificationInput,
                verificationSign: form.verificationSign,
                captchaInput: captcha.value.captchaInput,
                captchaSign: captcha.value.captchaSign,
                timestamp: captcha.value.timestamp,
                action: form.action
              }
            }
          });
          if (res) {
            ElMessage.success(t("common.login.error.resetPasswordSuccess"));
            form.action = "login";
            form.resetPasswordSuccess = true;
          }
          form.submitLocked = false;
        },
        getCode: async function() {
          if (!form.phoneOrEmail) {
            if (form.type == "phone") {
              ElMessage.error(t("common.login.error.requiredPhone"));
            } else {
              ElMessage.error(t("common.login.error.requiredEmail"));
            }
          }
          if (form.getCodeLocked) {
            return;
          }
          form.getCodeLocked = true;
          const res = await useRequest("/api/request", {
            body: {
              data: {
                captchaSign: captcha.value.captchaSign,
                captchaInput: captcha.value.captchaInput,
                phoneOrEmail: form.type == "phone" ? (countryDialCodes.value?.countryDialCodes?.picked[1] ?? "") + " " + form.phoneOrEmail : form.phoneOrEmail,
                lang: locale.value,
                siteUrl: (void 0).origin,
                timestamp: captcha.value.timestamp,
                action: form.action
              }
            }
          });
          if (res) {
            if (form.timer === 0) {
              form.timer = 60;
              form.interval.resume();
            } else {
              form.getCodeLocked = false;
              form.interval.pause();
              form.timer = 0;
            }
            form.verificationSign = res?.guaqi?.utils?.getCode;
          } else {
            captcha.value.success = false;
            form.getCodeLocked = false;
            form.interval.pause();
            form.timer = 0;
          }
        },
        login: async function() {
          if (form.submitLocked) {
            return;
          }
          form.submitLocked = true;
          const res = await useRequest("/api/request", {
            body: {
              data: {
                editStatus: route.path == "/builder" ? true : false,
                username: form.type == "phone" ? countryDialCodes.value?.countryDialCodes?.picked[1] + " " + form.phoneOrEmail : form.phoneOrEmail,
                password: form.password
              }
            }
          });
          if (res?.login?.user) {
            viewer.setData(res.login.user);
            getLoginData(action.pageData[route.path]);
            ElMessage.success(t("common.login.loginSuccess"));
            action.loginAction = !action.loginAction;
            action.showLogin = false;
          }
          form.submitLocked = false;
        },
        register: async function() {
          if (form.submitLocked) {
            return;
          }
          form.submitLocked = true;
          const res = await useRequest("/api/request", {
            body: {
              data: {
                editStatus: route.path == "/builder" ? true : false,
                phoneOrEmail: form.type == "phone" ? (countryDialCodes.value?.countryDialCodes?.picked[1] ?? "") + " " + form.phoneOrEmail : form.phoneOrEmail,
                password: form.password,
                verificationInput: form.verificationInput,
                verificationSign: form.verificationSign,
                captchaInput: captcha.value.captchaInput,
                captchaSign: captcha.value.captchaSign,
                timestamp: captcha.value.timestamp,
                action: form.action,
                inviteCode: localStorage.getItem("gqRef")
              }
            }
          });
          if (res?.registerUser?.user) {
            delete res.registerUser.user.auth;
            viewer.setData(res.registerUser.user);
            action.showLogin = false;
            getLoginData(action.pageData[route.path]);
            localStorage.setItem("has_complete_infomation", 1);
            action.showMoreInfomation = true;
            action.loginAction = !action.loginAction;
            ElMessage.success(t("common.login.registerSuccess"));
          }
          form.submitLocked = false;
        },
        forget: async function() {
        }
      }
    });
    watch(
      () => form.type,
      (newValue) => {
        form.phoneOrEmail = "";
      }
    );
    const carouselConfig = {
      height: "100%",
      itemsToShow: 1,
      wrapAround: true,
      gap: 5,
      autoplay: 3e3,
      mouseWheel: true
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Image = __nuxt_component_4;
      const _component_el_button = ElButton;
      const _component_CommonSvgIcon = _sfc_main$a;
      const _component_el_dropdown = ElDropdown;
      const _component_el_dropdown_menu = ElDropdownMenu;
      const _component_el_dropdown_item = ElDropdownItem;
      const _component_el_divider = ElDivider;
      const _component_el_form = ElForm;
      const _component_el_form_item = ElFormItem;
      const _component_el_input = ElInput;
      const _component_CommonFormCountryDialCodes = _sfc_main$b;
      const _component_el_checkbox = ElCheckbox;
      const _component_Blink = _sfc_main$c;
      const _component_CommonFormCaptcha = __nuxt_component_0$2;
      const _component_CommonFormLoginSocial = __nuxt_component_8;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "container-box" }, _attrs))} data-v-d0efaa0e><div class="flex gap-4" data-v-d0efaa0e>`);
      if (unref(registerBox).carousel?.length > 0) {
        _push(`<div class="w-45% rounded hidden @md:block relative" data-v-d0efaa0e>`);
        _push(ssrRenderComponent(unref(Carousel), mergeProps(carouselConfig, {
          style: { "--vc-pgn-border-radius": "100%", "--vc-pgn-height": "0.25rem", "--vc-pgn-width": "0.25rem", "--vc-pgn-background-color": "var(--el-mask-color-extra-light)", "--vc-pgn-active-color": "var(--el-color-primary)", "--vc-png-bottom": "64px" },
          class: "absolute top-0 left-0 w-full h-full rounded"
        }), {
          addons: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(unref(Pagination), null, null, _parent2, _scopeId));
            } else {
              return [
                createVNode(unref(Pagination))
              ];
            }
          }),
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<!--[-->`);
              ssrRenderList(unref(registerBox).carousel || 1, (item, i) => {
                _push2(ssrRenderComponent(unref(Slide), { key: i }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(ssrRenderComponent(_component_Image, {
                        src: item?.url,
                        class: "w-full h-full"
                      }, null, _parent3, _scopeId2));
                      if (item?.caption) {
                        _push3(`<div class="absolute bottom-0 font-600 left-0 w-full text-white text-center p-2 caption" data-v-d0efaa0e${_scopeId2}>${ssrInterpolate(item?.caption)}</div>`);
                      } else {
                        _push3(`<!---->`);
                      }
                    } else {
                      return [
                        createVNode(_component_Image, {
                          src: item?.url,
                          class: "w-full h-full"
                        }, null, 8, ["src"]),
                        item?.caption ? (openBlock(), createBlock("div", {
                          key: 0,
                          class: "absolute bottom-0 font-600 left-0 w-full text-white text-center p-2 caption"
                        }, toDisplayString(item?.caption), 1)) : createCommentVNode("", true)
                      ];
                    }
                  }),
                  _: 2
                }, _parent2, _scopeId));
              });
              _push2(`<!--]-->`);
            } else {
              return [
                (openBlock(true), createBlock(Fragment, null, renderList(unref(registerBox).carousel || 1, (item, i) => {
                  return openBlock(), createBlock(unref(Slide), { key: i }, {
                    default: withCtx(() => [
                      createVNode(_component_Image, {
                        src: item?.url,
                        class: "w-full h-full"
                      }, null, 8, ["src"]),
                      item?.caption ? (openBlock(), createBlock("div", {
                        key: 0,
                        class: "absolute bottom-0 font-600 left-0 w-full text-white text-center p-2 caption"
                      }, toDisplayString(item?.caption), 1)) : createCommentVNode("", true)
                    ]),
                    _: 2
                  }, 1024);
                }), 128))
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flex-1 flex gap-4 flex-col w-full py-2" data-v-d0efaa0e><h2 class="text-lg text-[--el-text-color-primary] w-fit flex items-center cursor-pointer user-select-none" data-v-d0efaa0e><div class="mr-2 rounded-full p-1 flex items-center justify-center overflow-hidden" data-v-d0efaa0e>`);
      _push(ssrRenderComponent(_component_Image, {
        src: unref(favicon),
        class: "w-5 h-5"
      }, null, _parent));
      _push(`</div> ${ssrInterpolate(_ctx.$t("common.login.action." + unref(form).action))}</h2>`);
      if (unref(form).resetPasswordSuccess && unref(form).action == "login") {
        _push(`<div class="text-xs flex items-center border-1 rounded p-2 text-[--el-color-success-dark-2]" data-v-d0efaa0e><i class="i-ph-check-circle w-6 h-6 mr-2" data-v-d0efaa0e></i> ${ssrInterpolate(_ctx.$t("common.login.error.resetPasswordSuccess"))}</div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(registerBox)?.social?.length > 0 && unref(form).action != "forget" && unref(form).action != "repass" && unref(registerBox).social_open) {
        _push(`<!--[--><div class="flex gap-2" data-v-d0efaa0e><!--[-->`);
        ssrRenderList(unref(registerBox)?.social.slice(0, 3) || 0, (item, i) => {
          _push(ssrRenderComponent(_component_el_button, {
            text: "",
            bg: "",
            class: `${i == 0 ? "!h-9 w-full" : "!w-9 !h-9"} !m-0`,
            key: item.key,
            onClick: ($event) => unref(form).socialLogin(item.key)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(ssrRenderComponent(_component_CommonSvgIcon, {
                  class: "w-5 h-5",
                  d: unref(form).socials?.[item.key]?.icon,
                  style: { color: unref(form).socials?.[item.key]?.color }
                }, null, _parent2, _scopeId));
                if (i == 0) {
                  _push2(`<span class="ml-1" data-v-d0efaa0e${_scopeId}>${ssrInterpolate(_ctx.$t("common.login.social." + item.key))}</span>`);
                } else {
                  _push2(`<!---->`);
                }
              } else {
                return [
                  createVNode(_component_CommonSvgIcon, {
                    class: "w-5 h-5",
                    d: unref(form).socials?.[item.key]?.icon,
                    style: { color: unref(form).socials?.[item.key]?.color }
                  }, null, 8, ["d", "style"]),
                  i == 0 ? (openBlock(), createBlock("span", {
                    key: 0,
                    class: "ml-1"
                  }, toDisplayString(_ctx.$t("common.login.social." + item.key)), 1)) : createCommentVNode("", true)
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]-->`);
        if (unref(registerBox)?.social?.length > 3) {
          _push(ssrRenderComponent(_component_el_dropdown, { trigger: "click" }, {
            dropdown: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(ssrRenderComponent(_component_el_dropdown_menu, null, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`<!--[-->`);
                      ssrRenderList(unref(registerBox)?.social?.slice(3), (item) => {
                        _push3(ssrRenderComponent(_component_el_dropdown_item, {
                          key: item.key,
                          onClick: ($event) => unref(form).socialLogin(item.key)
                        }, {
                          default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                            if (_push4) {
                              _push4(ssrRenderComponent(_component_CommonSvgIcon, {
                                class: "w-5 h-5",
                                d: unref(form).socials?.[item.key]?.icon,
                                style: { color: unref(form).socials?.[item.key]?.color }
                              }, null, _parent4, _scopeId3));
                              _push4(`<span class="ml-1" data-v-d0efaa0e${_scopeId3}>${ssrInterpolate(_ctx.$t("common.login.social." + item.key))}</span>`);
                            } else {
                              return [
                                createVNode(_component_CommonSvgIcon, {
                                  class: "w-5 h-5",
                                  d: unref(form).socials?.[item.key]?.icon,
                                  style: { color: unref(form).socials?.[item.key]?.color }
                                }, null, 8, ["d", "style"]),
                                createVNode("span", { class: "ml-1" }, toDisplayString(_ctx.$t("common.login.social." + item.key)), 1)
                              ];
                            }
                          }),
                          _: 2
                        }, _parent3, _scopeId2));
                      });
                      _push3(`<!--]-->`);
                    } else {
                      return [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(registerBox)?.social?.slice(3), (item) => {
                          return openBlock(), createBlock(_component_el_dropdown_item, {
                            key: item.key,
                            onClick: ($event) => unref(form).socialLogin(item.key)
                          }, {
                            default: withCtx(() => [
                              createVNode(_component_CommonSvgIcon, {
                                class: "w-5 h-5",
                                d: unref(form).socials?.[item.key]?.icon,
                                style: { color: unref(form).socials?.[item.key]?.color }
                              }, null, 8, ["d", "style"]),
                              createVNode("span", { class: "ml-1" }, toDisplayString(_ctx.$t("common.login.social." + item.key)), 1)
                            ]),
                            _: 2
                          }, 1032, ["onClick"]);
                        }), 128))
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else {
                return [
                  createVNode(_component_el_dropdown_menu, null, {
                    default: withCtx(() => [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(registerBox)?.social?.slice(3), (item) => {
                        return openBlock(), createBlock(_component_el_dropdown_item, {
                          key: item.key,
                          onClick: ($event) => unref(form).socialLogin(item.key)
                        }, {
                          default: withCtx(() => [
                            createVNode(_component_CommonSvgIcon, {
                              class: "w-5 h-5",
                              d: unref(form).socials?.[item.key]?.icon,
                              style: { color: unref(form).socials?.[item.key]?.color }
                            }, null, 8, ["d", "style"]),
                            createVNode("span", { class: "ml-1" }, toDisplayString(_ctx.$t("common.login.social." + item.key)), 1)
                          ]),
                          _: 2
                        }, 1032, ["onClick"]);
                      }), 128))
                    ]),
                    _: 1
                  })
                ];
              }
            }),
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(ssrRenderComponent(_component_el_button, {
                  class: "!m-0 !w-9 !h-9",
                  type: "primary",
                  text: "",
                  bg: ""
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`<i class="i-ph-dots-three-bold w-5 h-5" data-v-d0efaa0e${_scopeId2}></i>`);
                    } else {
                      return [
                        createVNode("i", { class: "i-ph-dots-three-bold w-5 h-5" })
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else {
                return [
                  createVNode(_component_el_button, {
                    class: "!m-0 !w-9 !h-9",
                    type: "primary",
                    text: "",
                    bg: ""
                  }, {
                    default: withCtx(() => [
                      createVNode("i", { class: "i-ph-dots-three-bold w-5 h-5" })
                    ]),
                    _: 1
                  })
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        if (unref(registerBox)?.social?.length > 0 && unref(form).action != "forget" && unref(form).action != "repass") {
          _push(ssrRenderComponent(_component_el_divider, null, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<span class="text-xs flex text-[--el-color-danger]" data-v-d0efaa0e${_scopeId}><i class="i-ph-star-fill w-4 h-4" data-v-d0efaa0e${_scopeId}></i></span>`);
              } else {
                return [
                  createVNode("span", { class: "text-xs flex text-[--el-color-danger]" }, [
                    createVNode("i", { class: "i-ph-star-fill w-4 h-4" })
                  ])
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (!unref(registerBox).social_open) {
        _push(`<div class="h-4" data-v-d0efaa0e></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flex flex-col gap-5" data-v-d0efaa0e>`);
      _push(ssrRenderComponent(_component_el_form, {
        class: "flex flex-col gap-4",
        onKeyup: ($event) => unref(form).submit()
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_el_form_item, {
              style: unref(form).action != "repass" ? null : { display: "none" }
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  if (unref(registerBox)?.login_type?.includes("phone") && unref(registerBox)?.login_type?.includes("email")) {
                    _push3(`<div class="${ssrRenderClass(`flex ${!unref(registerBox).social_open ? "justify-start" : "justify-center"} gap-3 w-full mb-3`)}" data-v-d0efaa0e${_scopeId2}><!--[-->`);
                    ssrRenderList(unref(registerBox)?.login_type, (type) => {
                      _push3(ssrRenderComponent(_component_el_button, {
                        class: `flex !font-600 ${unref(form).type == type ? "!text-[var(--el-color-primary)]" : ""}`,
                        link: "",
                        onClick: ($event) => switchType(type),
                        key: type
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            if (unref(form).action == "signup") {
                              _push4(`<span data-v-d0efaa0e${_scopeId3}>${ssrInterpolate(_ctx.$t("common.login.type." + type))}</span>`);
                            } else if (unref(form).action == "forget") {
                              _push4(`<span data-v-d0efaa0e${_scopeId3}>${ssrInterpolate(_ctx.$t("common.login.type.use" + type))}</span>`);
                            } else {
                              _push4(`<span data-v-d0efaa0e${_scopeId3}>${ssrInterpolate(_ctx.$t("common.login.type.login" + type))}</span>`);
                            }
                          } else {
                            return [
                              unref(form).action == "signup" ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("common.login.type." + type)), 1)) : unref(form).action == "forget" ? (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("common.login.type.use" + type)), 1)) : (openBlock(), createBlock("span", { key: 2 }, toDisplayString(_ctx.$t("common.login.type.login" + type)), 1))
                            ];
                          }
                        }),
                        _: 2
                      }, _parent3, _scopeId2));
                    });
                    _push3(`<!--]--></div>`);
                  } else {
                    _push3(`<!---->`);
                  }
                  _push3(ssrRenderComponent(_component_el_input, {
                    size: "large",
                    id: unref(form).type == "phone" ? "phone" : "email",
                    name: unref(form).type == "phone" ? "phone" : "email",
                    modelValue: unref(form).phoneOrEmail,
                    "onUpdate:modelValue": ($event) => unref(form).phoneOrEmail = $event,
                    class: "shadow rounded",
                    placeholder: unref(form).type == "phone" ? _ctx.$t("common.login.type.phonePlaceholder") : _ctx.$t("common.login.type.emailPlaceholder"),
                    disabled: unref(form).submitLocked
                  }, createSlots({ _: 2 }, [
                    unref(form).type == "phone" ? {
                      name: "prepend",
                      fn: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_CommonFormCountryDialCodes, {
                            ref_key: "countryDialCodes",
                            ref: countryDialCodes
                          }, null, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_CommonFormCountryDialCodes, {
                              ref_key: "countryDialCodes",
                              ref: countryDialCodes
                            }, null, 512)
                          ];
                        }
                      }),
                      key: "0"
                    } : void 0
                  ]), _parent3, _scopeId2));
                } else {
                  return [
                    unref(registerBox)?.login_type?.includes("phone") && unref(registerBox)?.login_type?.includes("email") ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: `flex ${!unref(registerBox).social_open ? "justify-start" : "justify-center"} gap-3 w-full mb-3`
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(registerBox)?.login_type, (type) => {
                        return openBlock(), createBlock(_component_el_button, {
                          class: `flex !font-600 ${unref(form).type == type ? "!text-[var(--el-color-primary)]" : ""}`,
                          link: "",
                          onClick: ($event) => switchType(type),
                          key: type
                        }, {
                          default: withCtx(() => [
                            unref(form).action == "signup" ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("common.login.type." + type)), 1)) : unref(form).action == "forget" ? (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("common.login.type.use" + type)), 1)) : (openBlock(), createBlock("span", { key: 2 }, toDisplayString(_ctx.$t("common.login.type.login" + type)), 1))
                          ]),
                          _: 2
                        }, 1032, ["class", "onClick"]);
                      }), 128))
                    ], 2)) : createCommentVNode("", true),
                    createVNode(_component_el_input, {
                      size: "large",
                      id: unref(form).type == "phone" ? "phone" : "email",
                      name: unref(form).type == "phone" ? "phone" : "email",
                      modelValue: unref(form).phoneOrEmail,
                      "onUpdate:modelValue": ($event) => unref(form).phoneOrEmail = $event,
                      class: "shadow rounded",
                      placeholder: unref(form).type == "phone" ? _ctx.$t("common.login.type.phonePlaceholder") : _ctx.$t("common.login.type.emailPlaceholder"),
                      disabled: unref(form).submitLocked
                    }, createSlots({ _: 2 }, [
                      unref(form).type == "phone" ? {
                        name: "prepend",
                        fn: withCtx(() => [
                          createVNode(_component_CommonFormCountryDialCodes, {
                            ref_key: "countryDialCodes",
                            ref: countryDialCodes
                          }, null, 512)
                        ]),
                        key: "0"
                      } : void 0
                    ]), 1032, ["id", "name", "modelValue", "onUpdate:modelValue", "placeholder", "disabled"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if (unref(form).action == "signup" || unref(form).action == "forget") {
              _push2(ssrRenderComponent(_component_el_form_item, null, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_el_input, {
                      modelValue: unref(form).verificationInput,
                      "onUpdate:modelValue": ($event) => unref(form).verificationInput = $event,
                      size: "large",
                      class: "shadow rounded",
                      disabled: unref(form).submitLocked
                    }, {
                      append: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_el_button, {
                            size: "small",
                            disabled: unref(form).getCodeLocked,
                            class: "!text-[12px] !h-full",
                            onClick: ($event) => unref(captcha).show = true
                          }, {
                            default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                              if (_push5) {
                                _push5(`${ssrInterpolate(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode"))}`);
                              } else {
                                return [
                                  createTextVNode(toDisplayString(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode")), 1)
                                ];
                              }
                            }),
                            _: 1
                          }, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_el_button, {
                              size: "small",
                              disabled: unref(form).getCodeLocked,
                              class: "!text-[12px] !h-full",
                              onClick: ($event) => unref(captcha).show = true
                            }, {
                              default: withCtx(() => [
                                createTextVNode(toDisplayString(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode")), 1)
                              ]),
                              _: 1
                            }, 8, ["disabled", "onClick"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_el_input, {
                        modelValue: unref(form).verificationInput,
                        "onUpdate:modelValue": ($event) => unref(form).verificationInput = $event,
                        size: "large",
                        class: "shadow rounded",
                        disabled: unref(form).submitLocked
                      }, {
                        append: withCtx(() => [
                          createVNode(_component_el_button, {
                            size: "small",
                            disabled: unref(form).getCodeLocked,
                            class: "!text-[12px] !h-full",
                            onClick: ($event) => unref(captcha).show = true
                          }, {
                            default: withCtx(() => [
                              createTextVNode(toDisplayString(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode")), 1)
                            ]),
                            _: 1
                          }, 8, ["disabled", "onClick"])
                        ]),
                        _: 1
                      }, 8, ["modelValue", "onUpdate:modelValue", "disabled"])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            if (unref(form).action == "forget") {
              _push2(`<div class="bg-gradient-to-br border-1 from-[--el-color-info-light-10] to-[--el-color-info-light-10] p-2 rounded text-xs" data-v-d0efaa0e${_scopeId}>${ssrInterpolate(_ctx.$t("common.login.forgetTip", [
                unref(form).type == "email" ? _ctx.$t("common.login.type.emailPlaceholder") : _ctx.$t("common.login.type.phonePlaceholder")
              ]))}</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(form).action == "repass") {
              _push2(`<div class="items-center border-1 text-[--el-color-success-dark-2] p-2 rounded text-xs flex" data-v-d0efaa0e${_scopeId}><i class="i-ph-check-circle w-6 h-6 mr-2" data-v-d0efaa0e${_scopeId}></i><span class="flex" data-v-d0efaa0e${_scopeId}>${ssrInterpolate(_ctx.$t("common.login.verifySuccessTip", [
                unref(form).type == "email" ? _ctx.$t("common.login.type.emailPlaceholder") : _ctx.$t("common.login.type.phonePlaceholder")
              ]))}</span></div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(form).action != "forget") {
              _push2(ssrRenderComponent(_component_el_form_item, null, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_el_input, {
                      size: "large",
                      modelValue: unref(form).password,
                      "onUpdate:modelValue": ($event) => unref(form).password = $event,
                      class: "shadow rounded",
                      type: "password",
                      "show-password": "",
                      placeholder: unref(form).action == "repass" ? _ctx.$t("common.login.type.newPasswordPlaceholder") : _ctx.$t("common.login.type.passwordPlaceholder"),
                      disabled: unref(form).submitLocked
                    }, null, _parent3, _scopeId2));
                    if (unref(form).action == "repass") {
                      _push3(ssrRenderComponent(_component_el_input, {
                        size: "large",
                        modelValue: unref(form).rePassword,
                        "onUpdate:modelValue": ($event) => unref(form).rePassword = $event,
                        class: "shadow rounded mt-3",
                        type: "password",
                        "show-password": "",
                        placeholder: _ctx.$t("common.login.type.rePasswordPlaceholder"),
                        disabled: unref(form).submitLocked
                      }, null, _parent3, _scopeId2));
                    } else {
                      _push3(`<!---->`);
                    }
                  } else {
                    return [
                      createVNode(_component_el_input, {
                        size: "large",
                        modelValue: unref(form).password,
                        "onUpdate:modelValue": ($event) => unref(form).password = $event,
                        class: "shadow rounded",
                        type: "password",
                        "show-password": "",
                        placeholder: unref(form).action == "repass" ? _ctx.$t("common.login.type.newPasswordPlaceholder") : _ctx.$t("common.login.type.passwordPlaceholder"),
                        disabled: unref(form).submitLocked
                      }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "disabled"]),
                      unref(form).action == "repass" ? (openBlock(), createBlock(_component_el_input, {
                        key: 0,
                        size: "large",
                        modelValue: unref(form).rePassword,
                        "onUpdate:modelValue": ($event) => unref(form).rePassword = $event,
                        class: "shadow rounded mt-3",
                        type: "password",
                        "show-password": "",
                        placeholder: _ctx.$t("common.login.type.rePasswordPlaceholder"),
                        disabled: unref(form).submitLocked
                      }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "disabled"])) : createCommentVNode("", true)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div data-v-d0efaa0e${_scopeId}>`);
            if (unref(form).action == "signup") {
              _push2(ssrRenderComponent(_component_el_checkbox, {
                modelValue: unref(form).protocol,
                "onUpdate:modelValue": ($event) => unref(form).protocol = $event,
                class: "ml-1",
                style: { "--el-checkbox-input-border": "1px solid #ccc", "--el-checkbox-font-size": "13px" },
                disabled: unref(form).submitLocked
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="text-xs @md:text-sm flex flex-wrap items-start" data-v-d0efaa0e${_scopeId2}><span class="mr-1" data-v-d0efaa0e${_scopeId2}>${ssrInterpolate(_ctx.$t("common.login.protocol.label"))}</span>`);
                    _push3(ssrRenderComponent(_component_Blink, {
                      to: unref(registerBox)?.user_agreement_url,
                      class: "text-[var(--el-color-primary)] mr-1"
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(_ctx.$t("common.login.protocol.service"))}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(_ctx.$t("common.login.protocol.service")), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`<span class="mr-1" data-v-d0efaa0e${_scopeId2}>${ssrInterpolate(_ctx.$t("common.login.protocol.and"))}</span>`);
                    _push3(ssrRenderComponent(_component_Blink, {
                      to: unref(registerBox)?.privacy_policy_url,
                      class: "text-[var(--el-color-primary)] mr-1"
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(_ctx.$t("common.login.protocol.privacy"))}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(_ctx.$t("common.login.protocol.privacy")), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`</div>`);
                  } else {
                    return [
                      createVNode("div", { class: "text-xs @md:text-sm flex flex-wrap items-start" }, [
                        createVNode("span", { class: "mr-1" }, toDisplayString(_ctx.$t("common.login.protocol.label")), 1),
                        createVNode(_component_Blink, {
                          to: unref(registerBox)?.user_agreement_url,
                          class: "text-[var(--el-color-primary)] mr-1"
                        }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(_ctx.$t("common.login.protocol.service")), 1)
                          ]),
                          _: 1
                        }, 8, ["to"]),
                        createVNode("span", { class: "mr-1" }, toDisplayString(_ctx.$t("common.login.protocol.and")), 1),
                        createVNode(_component_Blink, {
                          to: unref(registerBox)?.privacy_policy_url,
                          class: "text-[var(--el-color-primary)] mr-1"
                        }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(_ctx.$t("common.login.protocol.privacy")), 1)
                          ]),
                          _: 1
                        }, 8, ["to"])
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
            _push2(ssrRenderComponent(_component_el_button, {
              size: "large",
              type: "primary",
              class: "w-full -mt-2",
              style: { "--el-font-size-base": "16px" },
              onClick: ($event) => unref(form).submit(),
              loading: unref(form).submitLocked,
              disabled: !unref(form).protocol && unref(form).action == "signup"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  if (unref(form).action == "login") {
                    _push3(`<!--[-->${ssrInterpolate(_ctx.$t("common.login.action.login"))}<!--]-->`);
                  } else if (unref(form).action == "signup") {
                    _push3(`<!--[-->${ssrInterpolate(_ctx.$t("common.login.action.signup"))}<!--]-->`);
                  } else if (unref(form).action == "forget") {
                    _push3(`<!--[-->${ssrInterpolate(_ctx.$t("common.login.action.next"))}<!--]-->`);
                  } else if (unref(form).action == "repass") {
                    _push3(`<!--[-->${ssrInterpolate(_ctx.$t("common.edit.save"))}<!--]-->`);
                  } else {
                    _push3(`<!---->`);
                  }
                } else {
                  return [
                    unref(form).action == "login" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                      createTextVNode(toDisplayString(_ctx.$t("common.login.action.login")), 1)
                    ], 64)) : unref(form).action == "signup" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                      createTextVNode(toDisplayString(_ctx.$t("common.login.action.signup")), 1)
                    ], 64)) : unref(form).action == "forget" ? (openBlock(), createBlock(Fragment, { key: 2 }, [
                      createTextVNode(toDisplayString(_ctx.$t("common.login.action.next")), 1)
                    ], 64)) : unref(form).action == "repass" ? (openBlock(), createBlock(Fragment, { key: 3 }, [
                      createTextVNode(toDisplayString(_ctx.$t("common.edit.save")), 1)
                    ], 64)) : createCommentVNode("", true)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if (unref(form).action != "repass") {
              _push2(`<div class="flex justify-between -mt-2" data-v-d0efaa0e${_scopeId}>`);
              if (unref(form).action == "forget") {
                _push2(ssrRenderComponent(_component_el_button, {
                  text: "",
                  class: "w-fit !text-[var(--el-color-primary)] !p-1 !h-6 mr-1",
                  onClick: ($event) => unref(form).action = "signup",
                  disabled: unref(form).submitLocked
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`${ssrInterpolate(_ctx.$t("common.login.action.signup"))}`);
                    } else {
                      return [
                        createTextVNode(toDisplayString(_ctx.$t("common.login.action.signup")), 1)
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else {
                _push2(ssrRenderComponent(_component_el_button, {
                  text: "",
                  class: "w-fit !text-[var(--el-color-primary)] !p-1 !h-6",
                  disabled: unref(form).submitLocked,
                  onClick: ($event) => unref(form).action = "forget"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`${ssrInterpolate(_ctx.$t("common.login.forget"))}`);
                    } else {
                      return [
                        createTextVNode(toDisplayString(_ctx.$t("common.login.forget")), 1)
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              }
              _push2(`<div class="flex text-xs items-center" data-v-d0efaa0e${_scopeId}>`);
              if (unref(form).action == "login") {
                _push2(`<!--[-->${ssrInterpolate(_ctx.$t("common.login.not"))}<!--]-->`);
              } else {
                _push2(`<!--[-->${ssrInterpolate(_ctx.$t("common.login.has"))}<!--]-->`);
              }
              _push2(ssrRenderComponent(_component_el_button, {
                text: "",
                class: "w-fit !text-[var(--el-color-primary)] !p-1 !h-6 ml-1",
                onClick: ($event) => unref(form).action == "login" ? unref(form).action = "signup" : unref(form).action = "login",
                disabled: unref(form).submitLocked
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    if (unref(form).action == "login") {
                      _push3(`<!--[-->${ssrInterpolate(_ctx.$t("common.login.action.signup"))}<!--]-->`);
                    } else {
                      _push3(`<!--[-->${ssrInterpolate(_ctx.$t("common.login.action.login"))}<!--]-->`);
                    }
                  } else {
                    return [
                      unref(form).action == "login" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                        createTextVNode(toDisplayString(_ctx.$t("common.login.action.signup")), 1)
                      ], 64)) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                        createTextVNode(toDisplayString(_ctx.$t("common.login.action.login")), 1)
                      ], 64))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div></div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              withDirectives(createVNode(_component_el_form_item, null, {
                default: withCtx(() => [
                  unref(registerBox)?.login_type?.includes("phone") && unref(registerBox)?.login_type?.includes("email") ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: `flex ${!unref(registerBox).social_open ? "justify-start" : "justify-center"} gap-3 w-full mb-3`
                  }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(registerBox)?.login_type, (type) => {
                      return openBlock(), createBlock(_component_el_button, {
                        class: `flex !font-600 ${unref(form).type == type ? "!text-[var(--el-color-primary)]" : ""}`,
                        link: "",
                        onClick: ($event) => switchType(type),
                        key: type
                      }, {
                        default: withCtx(() => [
                          unref(form).action == "signup" ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("common.login.type." + type)), 1)) : unref(form).action == "forget" ? (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("common.login.type.use" + type)), 1)) : (openBlock(), createBlock("span", { key: 2 }, toDisplayString(_ctx.$t("common.login.type.login" + type)), 1))
                        ]),
                        _: 2
                      }, 1032, ["class", "onClick"]);
                    }), 128))
                  ], 2)) : createCommentVNode("", true),
                  createVNode(_component_el_input, {
                    size: "large",
                    id: unref(form).type == "phone" ? "phone" : "email",
                    name: unref(form).type == "phone" ? "phone" : "email",
                    modelValue: unref(form).phoneOrEmail,
                    "onUpdate:modelValue": ($event) => unref(form).phoneOrEmail = $event,
                    class: "shadow rounded",
                    placeholder: unref(form).type == "phone" ? _ctx.$t("common.login.type.phonePlaceholder") : _ctx.$t("common.login.type.emailPlaceholder"),
                    disabled: unref(form).submitLocked
                  }, createSlots({ _: 2 }, [
                    unref(form).type == "phone" ? {
                      name: "prepend",
                      fn: withCtx(() => [
                        createVNode(_component_CommonFormCountryDialCodes, {
                          ref_key: "countryDialCodes",
                          ref: countryDialCodes
                        }, null, 512)
                      ]),
                      key: "0"
                    } : void 0
                  ]), 1032, ["id", "name", "modelValue", "onUpdate:modelValue", "placeholder", "disabled"])
                ]),
                _: 1
              }, 512), [
                [vShow, unref(form).action != "repass"]
              ]),
              unref(form).action == "signup" || unref(form).action == "forget" ? (openBlock(), createBlock(_component_el_form_item, { key: 0 }, {
                default: withCtx(() => [
                  createVNode(_component_el_input, {
                    modelValue: unref(form).verificationInput,
                    "onUpdate:modelValue": ($event) => unref(form).verificationInput = $event,
                    size: "large",
                    class: "shadow rounded",
                    disabled: unref(form).submitLocked
                  }, {
                    append: withCtx(() => [
                      createVNode(_component_el_button, {
                        size: "small",
                        disabled: unref(form).getCodeLocked,
                        class: "!text-[12px] !h-full",
                        onClick: ($event) => unref(captcha).show = true
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode")), 1)
                        ]),
                        _: 1
                      }, 8, ["disabled", "onClick"])
                    ]),
                    _: 1
                  }, 8, ["modelValue", "onUpdate:modelValue", "disabled"])
                ]),
                _: 1
              })) : createCommentVNode("", true),
              unref(form).action == "forget" ? (openBlock(), createBlock("div", {
                key: 1,
                class: "bg-gradient-to-br border-1 from-[--el-color-info-light-10] to-[--el-color-info-light-10] p-2 rounded text-xs"
              }, toDisplayString(_ctx.$t("common.login.forgetTip", [
                unref(form).type == "email" ? _ctx.$t("common.login.type.emailPlaceholder") : _ctx.$t("common.login.type.phonePlaceholder")
              ])), 1)) : createCommentVNode("", true),
              unref(form).action == "repass" ? (openBlock(), createBlock("div", {
                key: 2,
                class: "items-center border-1 text-[--el-color-success-dark-2] p-2 rounded text-xs flex"
              }, [
                createVNode("i", { class: "i-ph-check-circle w-6 h-6 mr-2" }),
                createVNode("span", { class: "flex" }, toDisplayString(_ctx.$t("common.login.verifySuccessTip", [
                  unref(form).type == "email" ? _ctx.$t("common.login.type.emailPlaceholder") : _ctx.$t("common.login.type.phonePlaceholder")
                ])), 1)
              ])) : createCommentVNode("", true),
              unref(form).action != "forget" ? (openBlock(), createBlock(_component_el_form_item, { key: 3 }, {
                default: withCtx(() => [
                  createVNode(_component_el_input, {
                    size: "large",
                    modelValue: unref(form).password,
                    "onUpdate:modelValue": ($event) => unref(form).password = $event,
                    class: "shadow rounded",
                    type: "password",
                    "show-password": "",
                    placeholder: unref(form).action == "repass" ? _ctx.$t("common.login.type.newPasswordPlaceholder") : _ctx.$t("common.login.type.passwordPlaceholder"),
                    disabled: unref(form).submitLocked
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "disabled"]),
                  unref(form).action == "repass" ? (openBlock(), createBlock(_component_el_input, {
                    key: 0,
                    size: "large",
                    modelValue: unref(form).rePassword,
                    "onUpdate:modelValue": ($event) => unref(form).rePassword = $event,
                    class: "shadow rounded mt-3",
                    type: "password",
                    "show-password": "",
                    placeholder: _ctx.$t("common.login.type.rePasswordPlaceholder"),
                    disabled: unref(form).submitLocked
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "disabled"])) : createCommentVNode("", true)
                ]),
                _: 1
              })) : createCommentVNode("", true),
              createVNode("div", null, [
                unref(form).action == "signup" ? (openBlock(), createBlock(_component_el_checkbox, {
                  key: 0,
                  modelValue: unref(form).protocol,
                  "onUpdate:modelValue": ($event) => unref(form).protocol = $event,
                  class: "ml-1",
                  style: { "--el-checkbox-input-border": "1px solid #ccc", "--el-checkbox-font-size": "13px" },
                  disabled: unref(form).submitLocked
                }, {
                  default: withCtx(() => [
                    createVNode("div", { class: "text-xs @md:text-sm flex flex-wrap items-start" }, [
                      createVNode("span", { class: "mr-1" }, toDisplayString(_ctx.$t("common.login.protocol.label")), 1),
                      createVNode(_component_Blink, {
                        to: unref(registerBox)?.user_agreement_url,
                        class: "text-[var(--el-color-primary)] mr-1"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("common.login.protocol.service")), 1)
                        ]),
                        _: 1
                      }, 8, ["to"]),
                      createVNode("span", { class: "mr-1" }, toDisplayString(_ctx.$t("common.login.protocol.and")), 1),
                      createVNode(_component_Blink, {
                        to: unref(registerBox)?.privacy_policy_url,
                        class: "text-[var(--el-color-primary)] mr-1"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("common.login.protocol.privacy")), 1)
                        ]),
                        _: 1
                      }, 8, ["to"])
                    ])
                  ]),
                  _: 1
                }, 8, ["modelValue", "onUpdate:modelValue", "disabled"])) : createCommentVNode("", true)
              ]),
              createVNode(_component_el_button, {
                size: "large",
                type: "primary",
                class: "w-full -mt-2",
                style: { "--el-font-size-base": "16px" },
                onClick: ($event) => unref(form).submit(),
                loading: unref(form).submitLocked,
                disabled: !unref(form).protocol && unref(form).action == "signup"
              }, {
                default: withCtx(() => [
                  unref(form).action == "login" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                    createTextVNode(toDisplayString(_ctx.$t("common.login.action.login")), 1)
                  ], 64)) : unref(form).action == "signup" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                    createTextVNode(toDisplayString(_ctx.$t("common.login.action.signup")), 1)
                  ], 64)) : unref(form).action == "forget" ? (openBlock(), createBlock(Fragment, { key: 2 }, [
                    createTextVNode(toDisplayString(_ctx.$t("common.login.action.next")), 1)
                  ], 64)) : unref(form).action == "repass" ? (openBlock(), createBlock(Fragment, { key: 3 }, [
                    createTextVNode(toDisplayString(_ctx.$t("common.edit.save")), 1)
                  ], 64)) : createCommentVNode("", true)
                ]),
                _: 1
              }, 8, ["onClick", "loading", "disabled"]),
              unref(form).action != "repass" ? (openBlock(), createBlock("div", {
                key: 4,
                class: "flex justify-between -mt-2"
              }, [
                unref(form).action == "forget" ? (openBlock(), createBlock(_component_el_button, {
                  key: 0,
                  text: "",
                  class: "w-fit !text-[var(--el-color-primary)] !p-1 !h-6 mr-1",
                  onClick: ($event) => unref(form).action = "signup",
                  disabled: unref(form).submitLocked
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("common.login.action.signup")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick", "disabled"])) : (openBlock(), createBlock(_component_el_button, {
                  key: 1,
                  text: "",
                  class: "w-fit !text-[var(--el-color-primary)] !p-1 !h-6",
                  disabled: unref(form).submitLocked,
                  onClick: ($event) => unref(form).action = "forget"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("common.login.forget")), 1)
                  ]),
                  _: 1
                }, 8, ["disabled", "onClick"])),
                createVNode("div", { class: "flex text-xs items-center" }, [
                  unref(form).action == "login" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                    createTextVNode(toDisplayString(_ctx.$t("common.login.not")), 1)
                  ], 64)) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                    createTextVNode(toDisplayString(_ctx.$t("common.login.has")), 1)
                  ], 64)),
                  createVNode(_component_el_button, {
                    text: "",
                    class: "w-fit !text-[var(--el-color-primary)] !p-1 !h-6 ml-1",
                    onClick: ($event) => unref(form).action == "login" ? unref(form).action = "signup" : unref(form).action = "login",
                    disabled: unref(form).submitLocked
                  }, {
                    default: withCtx(() => [
                      unref(form).action == "login" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                        createTextVNode(toDisplayString(_ctx.$t("common.login.action.signup")), 1)
                      ], 64)) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                        createTextVNode(toDisplayString(_ctx.$t("common.login.action.login")), 1)
                      ], 64))
                    ]),
                    _: 1
                  }, 8, ["onClick", "disabled"])
                ])
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div>`);
      _push(ssrRenderComponent(_component_CommonFormCaptcha, {
        ref_key: "captcha",
        ref: captcha,
        phoneOrEmail: unref(form).type == "phone" ? (unref(countryDialCodes)?.countryDialCodes?.picked[1] ?? "") + " " + unref(form).phoneOrEmail : unref(form).phoneOrEmail,
        action: unref(form).action,
        onCaptchaSuccess: ($event) => unref(form).doAction.getCode()
      }, null, _parent));
      _push(ssrRenderComponent(_component_CommonFormLoginSocial, {
        ref_key: "loginSocial",
        ref: loginSocial
      }, null, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/loginForm.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_2 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-d0efaa0e"]]);

export { __nuxt_component_2 as default };
