import _sfc_main$1 from './creditIcon-eOdkwofx.mjs';
import { inject, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate } from 'vue/server-renderer';
import { j as actionStore } from './server.mjs';
import './svgIcon-BpIUCf-e.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonTopicFormMark",
  __ssrInlineRender: true,
  props: ["item", "action"],
  setup(__props) {
    const pageState = inject("pageState");
    const actions = actionStore();
    const bountyValue = (bounty) => {
      if (bounty.type == "money") {
        try {
          const value = JSON.parse(bounty.value);
          return value[actions.currency.iso];
        } catch (error) {
          return bounty.value;
        }
      }
      return bounty.value;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommonCreditIcon = _sfc_main$1;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: `flex items-center gap-1 child-load ${unref(pageState).loginDataReady ? "child-load-success" : ""}`
      }, _attrs))}>`);
      if (__props.item?.node?.topicContent?.bounty) {
        _push(`<span class="text-[11px] flex items-center py-0.7 rounded-sm leading-none gq-gs gap-1 border-1 px-1"><span class="text-[11px] border-r pr-1 flex items-center"><i class="i-ph-currency-circle-dollar-light"></i>悬赏</span>`);
        if (__props.item?.node?.topicContent?.bounty?.type == "credit") {
          _push(ssrRenderComponent(_component_CommonCreditIcon, { class: "flex text-[var(--el-color-primary)]" }, null, _parent));
        } else {
          _push(`<span class="text-[var(--el-color-primary)]">${ssrInterpolate(__props.action.currency?.symbol)}</span>`);
        }
        _push(`<span class="text-[var(--el-color-primary)]">${ssrInterpolate(bountyValue(__props.item?.node?.topicContent?.bounty))}</span></span>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.item?.node?.topicContent?.vote) {
        _push(`<span class="text-[11px] flex items-center py-0.7 rounded-sm leading-none gq-gs gap-1 border-1 px-1"><span class="text-[11px] flex items-center border-r pr-1">`);
        if (__props.item?.node?.topicContent?.vote?.type != "pk") {
          _push(`<i class="i-ph-chart-bar-light"></i>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.item?.node?.topicContent?.vote?.type == "pk") {
          _push(`<i class="i-ph-boxing-glove-light"></i>`);
        } else {
          _push(`<!---->`);
        }
        _push(` 投票 </span>`);
        if (__props.item?.node?.topicContent?.vote?.type == "radio") {
          _push(`<span class="flex text-[var(--el-color-primary)]">单选</span>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.item?.node?.topicContent?.vote?.type == "checkbox") {
          _push(`<span class="flex text-[var(--el-color-primary)]">多选</span>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.item?.node?.topicContent?.vote?.type == "pk") {
          _push(`<span class="flex text-[var(--el-color-primary)]">PK</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</span>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.item?.node?.topicContent?.role?.type && __props.item?.node?.topicContent?.role?.type != "public") {
        _push(`<span class="text-[11px] flex items-center py-0.7 rounded-sm leading-none gq-gs gap-1 border-1 px-1"><span class="text-[11px] border-r pr-1 flex items-center"><i class="i-ph-lock-key-light"></i>私密</span>`);
        if (__props.item?.node?.topicContent?.role?.type == "money") {
          _push(`<span class="flex text-[var(--el-color-primary)]">${ssrInterpolate(unref(actions).currency?.symbol)}${ssrInterpolate(bountyValue(__props.item?.node?.topicContent?.role))}</span>`);
        } else if (__props.item?.node?.topicContent?.role?.type == "credit") {
          _push(`<span class="flex items-center text-[var(--el-color-primary)]">`);
          _push(ssrRenderComponent(_component_CommonCreditIcon, null, null, _parent));
          _push(`${ssrInterpolate(bountyValue(__props.item?.node?.topicContent?.role))}</span>`);
        } else {
          _push(`<span class="flex text-[var(--el-color-primary)]">${ssrInterpolate(_ctx.$t(`page.community.roles.${__props.item?.node?.topicContent?.role?.type}.label`))}</span>`);
        }
        _push(`</span>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.item?.node?.isSticky) {
        _push(`<span class="text-[11px] flex items-center py-0.7 border-[var(--el-color-danger-light-9)] text-[var(--el-color-danger)] rounded-sm leading-none gq-gs gap-1 border-1 px-1"><span class="text-[11px] flex items-center"><i class="i-ph-arrow-fat-lines-up-light"></i>${ssrInterpolate(_ctx.$t("common.sticky.label"))}</span></span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/form/mark.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
