import { E as ElDialog } from './index-awVc4A7-.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import _sfc_main$1 from './upload-ByS8vTmr.mjs';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { E as ElProgress } from './progress-CBrKLnJJ.mjs';
import { v as vLoading } from './directive-BPPM1aUC.mjs';
import { a as useI18n, g as getServerSettings, v as viewerStore, r as useRequest, E as ElMessage, e as useUtils } from './server.mjs';
import { useSSRContext, ref, reactive, watch, mergeProps, unref, withCtx, createVNode, createTextVNode, toDisplayString, openBlock, createBlock, Fragment, renderList, createCommentVNode, withModifiers, withDirectives, vShow } from 'vue';
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttrs, ssrGetDirectiveProps, ssrRenderList, ssrRenderClass, ssrRenderAttr } from 'vue/server-renderer';
import { a as audioStore } from './audio-CfS8Ng0x.mjs';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './use-dialog-7J0bwlna.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import 'lodash-unified';
import './aria-BhThsKez.mjs';
import './event-BZTOGHfp.mjs';
import '@vue/shared';
import './vnode-l2ZP2UQa.mjs';
import './index-Di0Jlzch.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './index-DRiwogtD.mjs';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import './index-Bp-nwGzu.mjs';
import 'nanoid';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonEditorMediaLibrary",
  __ssrInlineRender: true,
  props: ["editor", "where", "limit", "settings"],
  emits: ["insertMedia"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const audio = audioStore();
    const { t } = useI18n();
    const settingsStore = getServerSettings();
    const locked = ref(false);
    const viewer = viewerStore();
    const emits = __emit;
    const insertMedia = (data, type) => {
      emits("insertMedia", data, type);
    };
    const libraryBox = reactive({
      show: false,
      type: "image",
      tabs: "upload",
      locked: false,
      multiple: false,
      accept: {
        image: settingsStore?.file_mimes?.image,
        video: settingsStore?.file_mimes?.video,
        audio: settingsStore?.file_mimes?.audio,
        attachment: settingsStore?.file_mimes?.attachment
      },
      limit: props.limit || 10,
      simply: false,
      loadingLock: false,
      videoEmbedUrl: "",
      videoIframeCode: "",
      videoEmbedUrl: "",
      library: [],
      pageInfo: {},
      picked: [],
      externalUrl: "",
      externalTitle: "",
      attachmentMetas: {
        fileSize: "",
        unzipPassword: "",
        extractionCode: ""
      },
      error: (id) => {
        locked.value = false;
        libraryBox.library = libraryBox.library.filter(
          (item, index) => {
            return item.node.id != id;
          }
        );
        libraryBox.picked = [];
      },
      onConfirm: (index) => {
        if (libraryBox.picked.length + 1 > props.limit) {
          if (props.limit == 1) {
            libraryBox.picked.shift();
          } else {
            if (!libraryBox.picked.includes(index)) {
              return;
            }
          }
        }
        if (!libraryBox.picked.includes(index)) {
          libraryBox.picked.push(index);
        } else {
          libraryBox.picked.splice(libraryBox.picked.indexOf(index), 1);
        }
      },
      delete: async () => {
        if (!confirm(t("common.edit.deleteMsg"))) {
          return;
        }
        libraryBox.picked.map((index) => {
          return libraryBox.library[index].node.databaseId;
        });
        const res = await useRequest("/api/request", {});
        if (res?.gqDeleteMedias?.success) {
          libraryBox.library = libraryBox.library.filter(
            (item, index) => {
              return !libraryBox.picked.includes(index);
            }
          );
          libraryBox.picked = [];
        }
      },
      tabSwitch: (tab) => {
        libraryBox.tabs = tab;
      },
      complete: (data) => {
        for (let i = 0; i < data.length; i++) {
          let index = libraryBox.library.findIndex(
            (item) => item.node.id == data[i].nanoid
          );
          if (index != -1) {
            libraryBox.library[index].node = data[i].sourceUrl || data[i].mediaItem;
            libraryBox.picked.push(index);
          }
        }
        locked.value = false;
      },
      handleClose: () => {
        if (locked.value) {
          ElMessage.warning(t("common.editor.library.disabledClose"));
          return false;
        }
        libraryBox.externalUrl = "";
        libraryBox.externalTitle = "";
        libraryBox.attachmentMetas = {
          fileSize: "",
          unzipPassword: "",
          extractionCode: ""
        };
        libraryBox.show = false;
      },
      progress: (data) => {
        Object.keys(data).forEach((key) => {
          let index = libraryBox.library.findIndex(
            (item) => item.node.id == key
          );
          if (index != -1 && libraryBox.library[index]) {
            libraryBox.library[index].node.progress = parseFloat(
              (data[key] || 1).toFixed(2)
            );
          }
        });
      },
      selected: (data) => {
        if (locked.value) return;
        locked.value = true;
        libraryBox.tabs = "library";
        const outputArray = data.map((item) => ({
          cursor: "",
          node: {
            id: item.id,
            altText: "",
            progress: 1,
            caption: null,
            mimeType: item.file.type,
            title: item.file.name.replace(/\.mp3$/, ""),
            // 去掉文件名的 ".mp3" 扩展名
            sourceUrl: item.blob,
            mediaItemUrl: item.blob
          }
        }));
        libraryBox.library = outputArray.concat(libraryBox.library);
      },
      insertGallery: () => {
        let data = {
          type: "gallery",
          attrs: {
            class: "wp-block-gallery",
            columns: 4
          },
          content: []
        };
        libraryBox.picked.map((index) => {
          data.content.push({
            type: "image",
            attrs: {
              src: libraryBox.library[index].node.sourceUrl,
              title: libraryBox.library[index].node.title,
              alt: libraryBox.library[index].node.caption,
              caption: libraryBox.library[index].node.caption,
              width: libraryBox.library[index].node.mediaDetails?.width || 0,
              height: libraryBox.library[index].node.mediaDetails?.height || 0
            }
          });
        });
        props.editor.commands.insertContent(data);
        libraryBox.picked = [];
      },
      insertImages: () => {
        if (props.where == "comment") {
          let list = libraryBox.library.filter((item, index) => {
            return libraryBox.picked.includes(index);
          });
          insertMedia(list, libraryBox.type);
          libraryBox.picked = [];
          return;
        }
        const data = libraryBox.picked.map((index) => {
          return libraryBox.library[index].node;
        });
        handleInsertMedia(data, libraryBox.type);
        libraryBox.picked = [];
      },
      insertFileUrl: () => {
        if (!libraryBox.externalUrl) return;
        let content = "";
        try {
          if (libraryBox.type == "video") {
            content = `<figure class="wp-block-video"><video src="${libraryBox.externalUrl}"></video><figcaption class="wp-element-caption"></figcaption></figure>`;
          }
          if (libraryBox.type == "audio") {
            content = `<audio data-title="${libraryBox.externalTitle}" src="${libraryBox.externalUrl}"></audio>`;
          }
          if (libraryBox.type == "attachment") {
            content = `<attachment href="${libraryBox.externalUrl}" data-title="${libraryBox.externalTitle}" data-file-size="${libraryBox.attachmentMetas.fileSize}" data-unzip-password="${libraryBox.attachmentMetas.unzipPassword}" data-extraction-code="${libraryBox.attachmentMetas.extractionCode}" data-ext="${libraryBox.attachmentMetas.ext}"></attachment>`;
          }
          props.editor.commands.insertContent(content);
          libraryBox.show = false;
          libraryBox.externalUrl = "";
        } catch (error) {
          console.error(error);
          ElMessage.error(t("common.editor.library.insertFail"));
        }
      },
      insertIframeCode: () => {
        if (!libraryBox.videoIframeCode) return;
        try {
          props.editor.commands.insertContent(
            `<figure class="wp-block-iframe">${libraryBox.videoIframeCode}<figcaption class="wp-element-caption"></figcaption></figure>`
          );
          libraryBox.show = false;
          libraryBox.videoIframeCode = "";
        } catch (error) {
          ElMessage.error(t("common.editor.library.insertFail"));
        }
      },
      getEmbed: async () => {
        if (libraryBox.locked) return;
        libraryBox.locked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              url: libraryBox.videoEmbedUrl
            }
          }
        });
        if (res?.guaqi?.utils?.embed) {
          let iframe = JSON.parse(res.guaqi.utils.embed);
          let attributes = {};
          if (iframe.html) {
            const regex = /(\w+)=["']?([^"'\s>]+)["']?/g;
            let match;
            while ((match = regex.exec(iframe.html)) !== null) {
              attributes[match[1]] = match[2];
            }
            props.editor.commands.insertContent({
              type: "iframe",
              attrs: attributes
            });
            libraryBox.show = false;
            libraryBox.videoEmbedUrl = "";
          } else {
            ElMessage.error(t("common.editor.library.insertFail"));
          }
        } else {
          ElMessage.error(t("common.editor.library.insertFail"));
        }
        libraryBox.locked = false;
      },
      playAudio: (item) => {
        if (audio.playing && item.mediaItemUrl == audio.src) {
          audio.playing = false;
          return;
        }
        audio.setData({
          thumb: "",
          src: item.mediaItemUrl,
          title: item.title,
          time: ""
        });
        setTimeout(() => {
          audio.playing = true;
        }, 100);
      },
      audioPause: () => {
        audio.playing = false;
      }
    });
    watch(
      () => libraryBox.show,
      (val) => {
        if (val) {
          getLibrary();
        }
      }
    );
    const getLibrary = async (more) => {
      if (libraryBox.loadingLock) return;
      libraryBox.loadingLock = true;
      ({
        data: {
          mimeTypeIN: '["' + libraryBox.accept[libraryBox.type].mime.join('","') + '"]'
        }
      });
      if (more) {
        libraryBox.pageInfo.endCursor;
      }
      const res = await useRequest("/api/request", {});
      if (res?.mediaItems?.edges) {
        libraryBox.library = more ? [...libraryBox.library, ...res.mediaItems.edges] : res.mediaItems.edges;
        libraryBox.pageInfo = res.mediaItems.pageInfo;
      }
      libraryBox.loadingLock = false;
    };
    __expose({
      libraryBox
    });
    const handleInsertMedia = async (media, type) => {
      let list = [];
      media.forEach((item, i) => {
        let data = "";
        if (type == "attachment") {
          const ext = useUtils.getFileExtension(item.mediaItemUrl);
          const size = item.fileSize ? useUtils.isNumeric(item.fileSize) ? useUtils.nFormatter(item.fileSize, true) : item.fileSize : "";
          data = {
            type: "attachment",
            attrs: {
              src: item.mediaItemUrl,
              title: item.title,
              fileSize: size,
              unzipPassword: "",
              extractionCode: "",
              ext
            }
          };
          list.push(data);
        }
        if (type == "image") {
          data = {
            type: "image",
            attrs: {
              src: item.sourceUrl,
              title: item.title,
              alt: item.caption,
              caption: item.caption,
              width: item.mediaDetails?.width || 0,
              height: item.mediaDetails?.height || 0
            }
          };
          list.push(data);
        }
        if (type == "video") {
          data = {
            type: "video",
            attrs: {
              src: item.mediaItemUrl,
              title: item.title,
              width: item.mediaDetails?.width || 0,
              height: item.mediaDetails?.height || 0
            }
          };
          list.push(data);
        }
        if (type == "audio") {
          data = {
            type: "audio",
            attrs: {
              src: item.mediaItemUrl,
              title: item.title
            }
          };
          list.push(data);
        }
      });
      props.editor.commands.insertContent(list);
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_dialog = ElDialog;
      const _component_el_button = ElButton;
      const _component_el_input = ElInput;
      const _component_CommonFormUpload = _sfc_main$1;
      const _component_el_scrollbar = ElScrollbar;
      const _component_el_progress = ElProgress;
      const _directive_loading = vLoading;
      _push(ssrRenderComponent(_component_el_dialog, mergeProps({
        modelValue: unref(libraryBox).show,
        "onUpdate:modelValue": ($event) => unref(libraryBox).show = $event,
        title: _ctx.$t("common.editor." + unref(libraryBox).type),
        width: "502",
        "before-close": unref(libraryBox).handleClose,
        "lock-scroll": false,
        "append-to-body": "",
        "close-on-click-modal": false
      }, _attrs), {
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(libraryBox).tabs == "library") {
              _push2(`<div class="dialog-footer flex items-center justify-between" data-v-a94f0029${_scopeId}>`);
              _push2(ssrRenderComponent(_component_el_button, {
                text: "",
                link: "",
                type: "primary",
                onClick: unref(libraryBox).delete,
                disabled: unref(libraryBox).picked.length == 0
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("common.editor.library.delete"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("common.editor.library.delete")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`<div class="flex items-center gap-4" data-v-a94f0029${_scopeId}>`);
              if (unref(libraryBox).type == "image" && __props.where != "comment") {
                _push2(ssrRenderComponent(_component_el_button, {
                  type: "primary",
                  plain: "",
                  onClick: ($event) => {
                    unref(libraryBox).show = false;
                    unref(libraryBox).insertGallery();
                  },
                  disabled: unref(libraryBox).picked.length < 2
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`<i class="i-ph-images h-6 w-6 mr-0.5" data-v-a94f0029${_scopeId2}></i> ${ssrInterpolate(_ctx.$t("common.editor.library.insertGallery"))}`);
                    } else {
                      return [
                        createVNode("i", { class: "i-ph-images h-6 w-6 mr-0.5" }),
                        createTextVNode(" " + toDisplayString(_ctx.$t("common.editor.library.insertGallery")), 1)
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(ssrRenderComponent(_component_el_button, {
                type: "primary",
                onClick: ($event) => {
                  unref(libraryBox).show = false;
                  unref(libraryBox).insertImages();
                },
                disabled: unref(libraryBox).picked.length == 0
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("common.editor.library.insert"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("common.editor.library.insert")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div></div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              unref(libraryBox).tabs == "library" ? (openBlock(), createBlock("div", {
                key: 0,
                class: "dialog-footer flex items-center justify-between"
              }, [
                createVNode(_component_el_button, {
                  text: "",
                  link: "",
                  type: "primary",
                  onClick: unref(libraryBox).delete,
                  disabled: unref(libraryBox).picked.length == 0
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("common.editor.library.delete")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick", "disabled"]),
                createVNode("div", { class: "flex items-center gap-4" }, [
                  unref(libraryBox).type == "image" && __props.where != "comment" ? (openBlock(), createBlock(_component_el_button, {
                    key: 0,
                    type: "primary",
                    plain: "",
                    onClick: ($event) => {
                      unref(libraryBox).show = false;
                      unref(libraryBox).insertGallery();
                    },
                    disabled: unref(libraryBox).picked.length < 2
                  }, {
                    default: withCtx(() => [
                      createVNode("i", { class: "i-ph-images h-6 w-6 mr-0.5" }),
                      createTextVNode(" " + toDisplayString(_ctx.$t("common.editor.library.insertGallery")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick", "disabled"])) : createCommentVNode("", true),
                  createVNode(_component_el_button, {
                    type: "primary",
                    onClick: ($event) => {
                      unref(libraryBox).show = false;
                      unref(libraryBox).insertImages();
                    },
                    disabled: unref(libraryBox).picked.length == 0
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("common.editor.library.insert")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick", "disabled"])
                ])
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center gap-2 flex-wrap" data-v-a94f0029${_scopeId}>`);
            if (unref(libraryBox).type == "video") {
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                plain: "",
                disabled: unref(locked),
                type: unref(libraryBox).tabs == "embed" && unref(libraryBox).type == "video" ? "primary" : "",
                style: { "--el-button-hover-bg-color": "var(--el-fill-color-blank)", "--el-button-hover-text-color": "var(--el-color-primary)" },
                onClick: ($event) => unref(libraryBox).tabSwitch("embed"),
                class: "!m-0"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<i class="i-ph-video mr-1" data-v-a94f0029${_scopeId2}></i> ${ssrInterpolate(_ctx.$t("common.editor.library.embed"))}`);
                  } else {
                    return [
                      createVNode("i", { class: "i-ph-video mr-1" }),
                      createTextVNode(" " + toDisplayString(_ctx.$t("common.editor.library.embed")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            if (unref(libraryBox).type == "video" || unref(libraryBox).type == "audio" || unref(libraryBox).type == "attachment") {
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                plain: "",
                disabled: unref(locked),
                type: unref(libraryBox).tabs == "external" && (unref(libraryBox).type == "video" || unref(libraryBox).type == "audio" || unref(libraryBox).type == "attachment") ? "primary" : "",
                style: { "--el-button-hover-bg-color": "var(--el-fill-color-blank)", "--el-button-hover-text-color": "var(--el-color-primary)" },
                onClick: ($event) => unref(libraryBox).tabSwitch("external"),
                class: "!m-0"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<i class="i-ph-file-cloud mr-1" data-v-a94f0029${_scopeId2}></i> ${ssrInterpolate(_ctx.$t("common.editor.library.external"))}`);
                  } else {
                    return [
                      createVNode("i", { class: "i-ph-file-cloud mr-1" }),
                      createTextVNode(" " + toDisplayString(_ctx.$t("common.editor.library.external")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(_component_el_button, {
              size: "small",
              plain: "",
              type: unref(libraryBox).tabs == "upload" ? "primary" : "",
              disabled: unref(locked),
              style: { "--el-button-hover-bg-color": "var(--el-fill-color-blank)", "--el-button-hover-text-color": "var(--el-color-primary)" },
              onClick: ($event) => unref(libraryBox).tabSwitch("upload"),
              class: "!m-0"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<i class="i-ph-arrow-fat-lines-up mr-1" data-v-a94f0029${_scopeId2}></i> ${ssrInterpolate(_ctx.$t("common.uploadFile.upload"))}`);
                } else {
                  return [
                    createVNode("i", { class: "i-ph-arrow-fat-lines-up mr-1" }),
                    createTextVNode(" " + toDisplayString(_ctx.$t("common.uploadFile.upload")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_el_button, {
              size: "small",
              plain: "",
              type: unref(libraryBox).tabs == "library" ? "primary" : "",
              disabled: unref(locked),
              style: { "--el-button-hover-bg-color": "var(--el-fill-color-blank)", "--el-button-hover-text-color": "var(--el-color-primary)" },
              onClick: ($event) => unref(libraryBox).tabSwitch("library"),
              class: "!m-0"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<i class="i-ph-files mr-1" data-v-a94f0029${_scopeId2}></i> ${ssrInterpolate(_ctx.$t("common.editor.library." + unref(libraryBox).type))}`);
                } else {
                  return [
                    createVNode("i", { class: "i-ph-files mr-1" }),
                    createTextVNode(" " + toDisplayString(_ctx.$t("common.editor.library." + unref(libraryBox).type)), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div><div class="w-full p-5 relative mt-4 rounded border-dashed border-2 border-[--el-border-color-light]" style="${ssrRenderStyle(unref(libraryBox).tabs == "embed" ? null : { display: "none" })}" data-v-a94f0029${_scopeId}><div class="flex items-start flex-col gap-2 w-[100%]" data-v-a94f0029${_scopeId}><div data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.embedUrl"))}:</div>`);
            _push2(ssrRenderComponent(_component_el_input, {
              type: "text",
              modelValue: unref(libraryBox).videoEmbedUrl,
              "onUpdate:modelValue": ($event) => unref(libraryBox).videoEmbedUrl = $event,
              size: "large",
              style: { "--el-border-color": "var(--el-border-color-dark)" }
            }, null, _parent2, _scopeId));
            _push2(`<div class="text-xs" data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.embedSupport", ["Youtube, Bilibili"]))}</div><div class="w-full mt-3" data-v-a94f0029${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              size: "large",
              onClick: unref(libraryBox).getEmbed,
              loading: unref(libraryBox).locked,
              class: "!w-full"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("common.editor.library.insert"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("common.editor.library.insert")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div></div><div class="w-full p-5 relative mt-4 rounded border-dashed border-2 border-[--el-border-color-light]" style="${ssrRenderStyle(unref(libraryBox).tabs == "external" ? null : { display: "none" })}" data-v-a94f0029${_scopeId}><div class="flex items-start flex-col gap-4 w-[100%]" data-v-a94f0029${_scopeId}>`);
            if (unref(libraryBox).type !== "video") {
              _push2(`<div class="w-full" data-v-a94f0029${_scopeId}><div class="mb-2" data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.externalTitle"))} <b class="text-red" data-v-a94f0029${_scopeId}>*</b> : </div>`);
              _push2(ssrRenderComponent(_component_el_input, {
                type: "text",
                modelValue: unref(libraryBox).externalTitle,
                "onUpdate:modelValue": ($event) => unref(libraryBox).externalTitle = $event,
                size: "large",
                style: { "--el-border-color": "var(--el-border-color-dark)" }
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="w-full" data-v-a94f0029${_scopeId}><div class="mb-2" data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.externalUrl"))} <b class="text-red" data-v-a94f0029${_scopeId}>*</b> : </div>`);
            _push2(ssrRenderComponent(_component_el_input, {
              type: "text",
              modelValue: unref(libraryBox).externalUrl,
              "onUpdate:modelValue": ($event) => unref(libraryBox).externalUrl = $event,
              size: "large",
              style: { "--el-border-color": "var(--el-border-color-dark)" }
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (unref(libraryBox).type !== "attachment") {
              _push2(`<div class="text-xs" data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.externalSupport", [
                unref(libraryBox).accept[unref(libraryBox).type].ext.join(", .")
              ]))}</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(libraryBox).type == "attachment") {
              _push2(`<div class="flex gap-2 jusitfy-around" data-v-a94f0029${_scopeId}><label data-v-a94f0029${_scopeId}><div class="text-xs mb-2" data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.attachmentInput.fileSize"))}: </div>`);
              _push2(ssrRenderComponent(_component_el_input, {
                type: "text",
                modelValue: unref(libraryBox).attachmentMetas.fileSize,
                "onUpdate:modelValue": ($event) => unref(libraryBox).attachmentMetas.fileSize = $event,
                style: { "--el-border-color": "var(--el-border-color-dark)" }
              }, null, _parent2, _scopeId));
              _push2(`</label><label data-v-a94f0029${_scopeId}><div class="text-xs mb-2" data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.unzipPassword"))}:</div>`);
              _push2(ssrRenderComponent(_component_el_input, {
                type: "text",
                modelValue: unref(libraryBox).attachmentMetas.unzipPassword,
                "onUpdate:modelValue": ($event) => unref(libraryBox).attachmentMetas.unzipPassword = $event,
                style: { "--el-border-color": "var(--el-border-color-dark)" }
              }, null, _parent2, _scopeId));
              _push2(`</label><label data-v-a94f0029${_scopeId}><div class="text-xs mb-2" data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.extractionCode"))}:</div>`);
              _push2(ssrRenderComponent(_component_el_input, {
                type: "text",
                modelValue: unref(libraryBox).attachmentMetas.extractionCode,
                "onUpdate:modelValue": ($event) => unref(libraryBox).attachmentMetas.extractionCode = $event,
                style: { "--el-border-color": "var(--el-border-color-dark)" }
              }, null, _parent2, _scopeId));
              _push2(`</label></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="w-full mt-3" data-v-a94f0029${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              size: "large",
              onClick: unref(libraryBox).insertFileUrl,
              loading: unref(libraryBox).locked,
              class: "!w-full"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("common.editor.library.insert"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("common.editor.library.insert")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div></div><div class="w-full p-5 relative mt-4 rounded border-dashed border-2 border-[--el-border-color-light]" style="${ssrRenderStyle(unref(libraryBox).tabs == "iframe" ? null : { display: "none" })}" data-v-a94f0029${_scopeId}><div class="flex items-start flex-col gap-2 w-[100%]" data-v-a94f0029${_scopeId}><div data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.iframeCode"))}</div>`);
            _push2(ssrRenderComponent(_component_el_input, {
              type: "textarea",
              resize: "none",
              rows: 4,
              modelValue: unref(libraryBox).videoIframeCode,
              "onUpdate:modelValue": ($event) => unref(libraryBox).videoIframeCode = $event,
              size: "large",
              style: { "--el-border-color": "var(--el-border-color-dark)" }
            }, null, _parent2, _scopeId));
            _push2(`<div class="text-xs" data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.iframeSupport"))}</div><div class="w-full mt-3" data-v-a94f0029${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              size: "large",
              onClick: unref(libraryBox).insertIframeCode,
              loading: unref(libraryBox).locked,
              class: "!w-full"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("common.editor.library.insert"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("common.editor.library.insert")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div></div><div class="w-full p-5 flex items-center justify-center relative h-100 mt-4 rounded border-dashed border-2 border-[--el-border-color-light]" style="${ssrRenderStyle(unref(libraryBox).tabs == "upload" ? null : { display: "none" })}" data-v-a94f0029${_scopeId}>`);
            if (unref(viewer).data?.gqRoles?.media?.[unref(libraryBox).type]?.can) {
              _push2(ssrRenderComponent(_component_CommonFormUpload, {
                showIcon: false,
                showProgress: false,
                multiple: true,
                accept: unref(libraryBox).accept[unref(libraryBox).type].ext.map((ext) => `.${ext}`).join(","),
                onUploadComplete: unref(libraryBox).complete,
                onUploadProgress: unref(libraryBox).progress,
                onFilesSelected: unref(libraryBox).selected,
                onUploadError: unref(libraryBox).error,
                class: "!absolute inset-0 !w-full !h-full flex-col gap-2"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="flex opacity-80" data-v-a94f0029${_scopeId2}><i class="i-ph-plus-light w-12 h-12" data-v-a94f0029${_scopeId2}></i></div><div class="mt-5" data-v-a94f0029${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.library.select", [
                      unref(settingsStore)?.max_file_size
                    ]))}</div><div class="text-xs opacity-80 max-w-[80%] text-center" data-v-a94f0029${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.library.support", [
                      "." + unref(libraryBox).accept[unref(libraryBox).type].ext.join(", .")
                    ]))}</div>`);
                  } else {
                    return [
                      createVNode("div", { class: "flex opacity-80" }, [
                        createVNode("i", { class: "i-ph-plus-light w-12 h-12" })
                      ]),
                      createVNode("div", { class: "mt-5" }, toDisplayString(_ctx.$t("common.editor.library.select", [
                        unref(settingsStore)?.max_file_size
                      ])), 1),
                      createVNode("div", { class: "text-xs opacity-80 max-w-[80%] text-center" }, toDisplayString(_ctx.$t("common.editor.library.support", [
                        "." + unref(libraryBox).accept[unref(libraryBox).type].ext.join(", .")
                      ])), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<div class="absolute inset-0 flex items-center justify-center" data-v-a94f0029${_scopeId}>`);
              if (unref(viewer).data?.gqRoles?.media?.[unref(libraryBox).type]?.max <= unref(viewer).data?.gqRoles?.media?.[unref(libraryBox).type]?.count && unref(viewer).data?.gqRoles?.media?.[unref(libraryBox).type]?.count != 0) {
                _push2(`<span data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.noUploadToday", [unref(viewer).data?.gqRoles?.media?.[unref(libraryBox).type]?.count, unref(libraryBox).type]))}</span>`);
              } else {
                _push2(`<span data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.noUpload"))}</span>`);
              }
              _push2(`</div>`);
            }
            _push2(`</div><div${ssrRenderAttrs(mergeProps({
              class: "h-100 mt-4",
              style: unref(libraryBox).tabs == "library" ? null : { display: "none" }
            }, ssrGetDirectiveProps(_ctx, _directive_loading, unref(libraryBox).loadingLock)))} data-v-a94f0029${_scopeId}>`);
            if (unref(libraryBox).library.length > 0) {
              _push2(`<div data-v-a94f0029${_scopeId}>`);
              _push2(ssrRenderComponent(_component_el_scrollbar, { class: "!h-100" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="grid grid-cols-4 gap-2" data-v-a94f0029${_scopeId2}><!--[-->`);
                    ssrRenderList(unref(libraryBox).library, (item, index) => {
                      _push3(`<div class="${ssrRenderClass(`cursor-pointer relative border-1 h-0 pt-[calc(100%-0.5rem)] hover:bg-[--el-color-primary-light-9] rounded bg-[--el-color-info-light-10] relative ${unref(libraryBox).picked.includes(index) ? "picked" : ""}`)}" data-v-a94f0029${_scopeId2}>`);
                      if (item.node?.progress > 0 && item.node?.progress < 100) {
                        _push3(`<div class="absolute w-full h-full bg-[--el-color-info-light-5] top-0 left-0 z-2" data-v-a94f0029${_scopeId2}></div>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      if (item.node?.progress > 0 && item.node?.progress < 100) {
                        _push3(ssrRenderComponent(_component_el_progress, {
                          "text-inside": true,
                          "stroke-width": 10,
                          percentage: item.node.progress,
                          striped: "",
                          "striped-flow": "",
                          class: "!absolute inset-0 w-[80%] z-2 mx-auto",
                          color: "var(--el-color-success)"
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(libraryBox).type == "image") {
                        _push3(`<img${ssrRenderAttr("src", item.node.sourceUrl)} class="w-[calc(100%-0.5rem)] h-[calc(100%-0.5rem)] object-cover top-1 left-1 absolute rounded" object="cover" data-v-a94f0029${_scopeId2}>`);
                      } else if (unref(libraryBox).type == "audio" || unref(libraryBox).type == "video") {
                        _push3(`<div class="flex flex-col absolute w-full h-full inset-0 bg-[--el-color-info] overflow-hidden rounded" data-v-a94f0029${_scopeId2}><div class="relative w-full h-full flex items-center justify-center" data-v-a94f0029${_scopeId2}>`);
                        if (unref(libraryBox).type == "video") {
                          _push3(`<video preload="metadata"${ssrRenderAttr("src", item.node.mediaItemUrl)} class="h-full w-full absolute object-cover rounded" object="cover" data-v-a94f0029${_scopeId2}></video>`);
                        } else {
                          _push3(ssrRenderComponent(_component_el_button, {
                            circle: "",
                            onClick: ($event) => !unref(locked) ? unref(libraryBox).playAudio(item.node) : ""
                          }, {
                            default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                              if (_push4) {
                                if (unref(audio).src == item.node.mediaItemUrl && unref(audio).playing) {
                                  _push4(`<i class="i-ph-pause-fill" data-v-a94f0029${_scopeId3}></i>`);
                                } else {
                                  _push4(`<i class="i-ph-play-fill shadow-md" data-v-a94f0029${_scopeId3}></i>`);
                                }
                              } else {
                                return [
                                  unref(audio).src == item.node.mediaItemUrl && unref(audio).playing ? (openBlock(), createBlock("i", {
                                    key: 0,
                                    class: "i-ph-pause-fill"
                                  })) : (openBlock(), createBlock("i", {
                                    key: 1,
                                    class: "i-ph-play-fill shadow-md"
                                  }))
                                ];
                              }
                            }),
                            _: 2
                          }, _parent3, _scopeId2));
                        }
                        _push3(`</div><div class="w-full bottom-0 left-0 text-xs bg-[--el-color-info-light-10] border-t p-2 overflow-hidden" data-v-a94f0029${_scopeId2}><span class="line-clamp-1" data-v-a94f0029${_scopeId2}>${ssrInterpolate(item.node.title)}</span></div></div>`);
                      } else if (unref(libraryBox).type == "attachment") {
                        _push3(`<div class="flex flex-col absolute w-full h-full inset-0 bg-[--el-color-info] overflow-hidden overflow-hidden rounded" data-v-a94f0029${_scopeId2}><div class="relative w-full h-full flex items-center justify-center" data-v-a94f0029${_scopeId2}><span class="shadow-lg bg-white px-2 rounded capitalize" data-v-a94f0029${_scopeId2}>${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).getFileExtension(item.node.mediaItemUrl))}</span></div><div class="w-full bottom-0 left-0 text-xs bg-[--el-color-info-light-10] border-t p-2 overflow-hidden" data-v-a94f0029${_scopeId2}><span class="line-clamp-1" data-v-a94f0029${_scopeId2}>${ssrInterpolate(item.node.title)}</span></div></div>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      if (unref(libraryBox).picked.includes(index)) {
                        _push3(`<span class="absolute flex items-center justify-center top-3 right-3 w-5 h-5 rounded-full bg-[--el-color-primary] text-white text-xs font-600 border" data-v-a94f0029${_scopeId2}><i class="i-ph-check-bold" data-v-a94f0029${_scopeId2}></i></span>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`</div>`);
                    });
                    _push3(`<!--]--></div><div class="text-center mt-3" data-v-a94f0029${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_el_button, {
                      type: "primary",
                      text: "",
                      bg: "",
                      onClick: ($event) => getLibrary(true),
                      loading: unref(libraryBox).loadingLock,
                      disabled: !unref(libraryBox).pageInfo.hasNextPage,
                      class: "mb-5"
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          if (unref(libraryBox).loadingLock) {
                            _push4(`<!--[-->${ssrInterpolate(_ctx.$t("page.modules.post.loading"))}<!--]-->`);
                          } else if (!unref(libraryBox).pageInfo.hasNextPage) {
                            _push4(`<!--[-->${ssrInterpolate(_ctx.$t("page.modules.post.noMore"))}<!--]-->`);
                          } else {
                            _push4(`<!--[-->${ssrInterpolate(_ctx.$t("page.modules.post.loadMoreButton"))}<!--]-->`);
                          }
                        } else {
                          return [
                            unref(libraryBox).loadingLock ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                              createTextVNode(toDisplayString(_ctx.$t("page.modules.post.loading")), 1)
                            ], 64)) : !unref(libraryBox).pageInfo.hasNextPage ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                              createTextVNode(toDisplayString(_ctx.$t("page.modules.post.noMore")), 1)
                            ], 64)) : (openBlock(), createBlock(Fragment, { key: 2 }, [
                              createTextVNode(toDisplayString(_ctx.$t("page.modules.post.loadMoreButton")), 1)
                            ], 64))
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`</div>`);
                  } else {
                    return [
                      createVNode("div", { class: "grid grid-cols-4 gap-2" }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(libraryBox).library, (item, index) => {
                          return openBlock(), createBlock("div", {
                            key: index,
                            class: `cursor-pointer relative border-1 h-0 pt-[calc(100%-0.5rem)] hover:bg-[--el-color-primary-light-9] rounded bg-[--el-color-info-light-10] relative ${unref(libraryBox).picked.includes(index) ? "picked" : ""}`,
                            onClick: ($event) => !unref(locked) ? unref(libraryBox).onConfirm(index) : ""
                          }, [
                            item.node?.progress > 0 && item.node?.progress < 100 ? (openBlock(), createBlock("div", {
                              key: 0,
                              class: "absolute w-full h-full bg-[--el-color-info-light-5] top-0 left-0 z-2"
                            })) : createCommentVNode("", true),
                            item.node?.progress > 0 && item.node?.progress < 100 ? (openBlock(), createBlock(_component_el_progress, {
                              key: 1,
                              "text-inside": true,
                              "stroke-width": 10,
                              percentage: item.node.progress,
                              striped: "",
                              "striped-flow": "",
                              class: "!absolute inset-0 w-[80%] z-2 mx-auto",
                              color: "var(--el-color-success)"
                            }, null, 8, ["percentage"])) : createCommentVNode("", true),
                            unref(libraryBox).type == "image" ? (openBlock(), createBlock("img", {
                              key: 2,
                              src: item.node.sourceUrl,
                              class: "w-[calc(100%-0.5rem)] h-[calc(100%-0.5rem)] object-cover top-1 left-1 absolute rounded",
                              object: "cover"
                            }, null, 8, ["src"])) : unref(libraryBox).type == "audio" || unref(libraryBox).type == "video" ? (openBlock(), createBlock("div", {
                              key: 3,
                              class: "flex flex-col absolute w-full h-full inset-0 bg-[--el-color-info] overflow-hidden rounded"
                            }, [
                              createVNode("div", { class: "relative w-full h-full flex items-center justify-center" }, [
                                unref(libraryBox).type == "video" ? (openBlock(), createBlock("video", {
                                  key: 0,
                                  preload: "metadata",
                                  src: item.node.mediaItemUrl,
                                  class: "h-full w-full absolute object-cover rounded",
                                  object: "cover"
                                }, null, 8, ["src"])) : (openBlock(), createBlock(_component_el_button, {
                                  key: 1,
                                  circle: "",
                                  onClick: withModifiers(($event) => !unref(locked) ? unref(libraryBox).playAudio(item.node) : "", ["stop"])
                                }, {
                                  default: withCtx(() => [
                                    unref(audio).src == item.node.mediaItemUrl && unref(audio).playing ? (openBlock(), createBlock("i", {
                                      key: 0,
                                      class: "i-ph-pause-fill"
                                    })) : (openBlock(), createBlock("i", {
                                      key: 1,
                                      class: "i-ph-play-fill shadow-md"
                                    }))
                                  ]),
                                  _: 2
                                }, 1032, ["onClick"]))
                              ]),
                              createVNode("div", { class: "w-full bottom-0 left-0 text-xs bg-[--el-color-info-light-10] border-t p-2 overflow-hidden" }, [
                                createVNode("span", { class: "line-clamp-1" }, toDisplayString(item.node.title), 1)
                              ])
                            ])) : unref(libraryBox).type == "attachment" ? (openBlock(), createBlock("div", {
                              key: 4,
                              class: "flex flex-col absolute w-full h-full inset-0 bg-[--el-color-info] overflow-hidden overflow-hidden rounded"
                            }, [
                              createVNode("div", { class: "relative w-full h-full flex items-center justify-center" }, [
                                createVNode("span", { class: "shadow-lg bg-white px-2 rounded capitalize" }, toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).getFileExtension(item.node.mediaItemUrl)), 1)
                              ]),
                              createVNode("div", { class: "w-full bottom-0 left-0 text-xs bg-[--el-color-info-light-10] border-t p-2 overflow-hidden" }, [
                                createVNode("span", { class: "line-clamp-1" }, toDisplayString(item.node.title), 1)
                              ])
                            ])) : createCommentVNode("", true),
                            unref(libraryBox).picked.includes(index) ? (openBlock(), createBlock("span", {
                              key: 5,
                              class: "absolute flex items-center justify-center top-3 right-3 w-5 h-5 rounded-full bg-[--el-color-primary] text-white text-xs font-600 border"
                            }, [
                              createVNode("i", { class: "i-ph-check-bold" })
                            ])) : createCommentVNode("", true)
                          ], 10, ["onClick"]);
                        }), 128))
                      ]),
                      createVNode("div", { class: "text-center mt-3" }, [
                        createVNode(_component_el_button, {
                          type: "primary",
                          text: "",
                          bg: "",
                          onClick: ($event) => getLibrary(true),
                          loading: unref(libraryBox).loadingLock,
                          disabled: !unref(libraryBox).pageInfo.hasNextPage,
                          class: "mb-5"
                        }, {
                          default: withCtx(() => [
                            unref(libraryBox).loadingLock ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                              createTextVNode(toDisplayString(_ctx.$t("page.modules.post.loading")), 1)
                            ], 64)) : !unref(libraryBox).pageInfo.hasNextPage ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                              createTextVNode(toDisplayString(_ctx.$t("page.modules.post.noMore")), 1)
                            ], 64)) : (openBlock(), createBlock(Fragment, { key: 2 }, [
                              createTextVNode(toDisplayString(_ctx.$t("page.modules.post.loadMoreButton")), 1)
                            ], 64))
                          ]),
                          _: 1
                        }, 8, ["onClick", "loading", "disabled"])
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<div class="flex items-center justify-center h-full flex-col gap-3 relative" data-v-a94f0029${_scopeId}><div class="flex items-center justify-center" data-v-a94f0029${_scopeId}><i class="i-ph-image w-10 h-10 opacity-80" data-v-a94f0029${_scopeId}></i></div><div class="text-xs opacity-80" data-v-a94f0029${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.empty"))}</div></div>`);
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center gap-2 flex-wrap" }, [
                unref(libraryBox).type == "video" ? (openBlock(), createBlock(_component_el_button, {
                  key: 0,
                  size: "small",
                  plain: "",
                  disabled: unref(locked),
                  type: unref(libraryBox).tabs == "embed" && unref(libraryBox).type == "video" ? "primary" : "",
                  style: { "--el-button-hover-bg-color": "var(--el-fill-color-blank)", "--el-button-hover-text-color": "var(--el-color-primary)" },
                  onClick: ($event) => unref(libraryBox).tabSwitch("embed"),
                  class: "!m-0"
                }, {
                  default: withCtx(() => [
                    createVNode("i", { class: "i-ph-video mr-1" }),
                    createTextVNode(" " + toDisplayString(_ctx.$t("common.editor.library.embed")), 1)
                  ]),
                  _: 1
                }, 8, ["disabled", "type", "onClick"])) : createCommentVNode("", true),
                unref(libraryBox).type == "video" || unref(libraryBox).type == "audio" || unref(libraryBox).type == "attachment" ? (openBlock(), createBlock(_component_el_button, {
                  key: 1,
                  size: "small",
                  plain: "",
                  disabled: unref(locked),
                  type: unref(libraryBox).tabs == "external" && (unref(libraryBox).type == "video" || unref(libraryBox).type == "audio" || unref(libraryBox).type == "attachment") ? "primary" : "",
                  style: { "--el-button-hover-bg-color": "var(--el-fill-color-blank)", "--el-button-hover-text-color": "var(--el-color-primary)" },
                  onClick: ($event) => unref(libraryBox).tabSwitch("external"),
                  class: "!m-0"
                }, {
                  default: withCtx(() => [
                    createVNode("i", { class: "i-ph-file-cloud mr-1" }),
                    createTextVNode(" " + toDisplayString(_ctx.$t("common.editor.library.external")), 1)
                  ]),
                  _: 1
                }, 8, ["disabled", "type", "onClick"])) : createCommentVNode("", true),
                createVNode(_component_el_button, {
                  size: "small",
                  plain: "",
                  type: unref(libraryBox).tabs == "upload" ? "primary" : "",
                  disabled: unref(locked),
                  style: { "--el-button-hover-bg-color": "var(--el-fill-color-blank)", "--el-button-hover-text-color": "var(--el-color-primary)" },
                  onClick: ($event) => unref(libraryBox).tabSwitch("upload"),
                  class: "!m-0"
                }, {
                  default: withCtx(() => [
                    createVNode("i", { class: "i-ph-arrow-fat-lines-up mr-1" }),
                    createTextVNode(" " + toDisplayString(_ctx.$t("common.uploadFile.upload")), 1)
                  ]),
                  _: 1
                }, 8, ["type", "disabled", "onClick"]),
                createVNode(_component_el_button, {
                  size: "small",
                  plain: "",
                  type: unref(libraryBox).tabs == "library" ? "primary" : "",
                  disabled: unref(locked),
                  style: { "--el-button-hover-bg-color": "var(--el-fill-color-blank)", "--el-button-hover-text-color": "var(--el-color-primary)" },
                  onClick: ($event) => unref(libraryBox).tabSwitch("library"),
                  class: "!m-0"
                }, {
                  default: withCtx(() => [
                    createVNode("i", { class: "i-ph-files mr-1" }),
                    createTextVNode(" " + toDisplayString(_ctx.$t("common.editor.library." + unref(libraryBox).type)), 1)
                  ]),
                  _: 1
                }, 8, ["type", "disabled", "onClick"])
              ]),
              withDirectives(createVNode("div", { class: "w-full p-5 relative mt-4 rounded border-dashed border-2 border-[--el-border-color-light]" }, [
                createVNode("div", { class: "flex items-start flex-col gap-2 w-[100%]" }, [
                  createVNode("div", null, toDisplayString(_ctx.$t("common.editor.library.embedUrl")) + ":", 1),
                  createVNode(_component_el_input, {
                    type: "text",
                    modelValue: unref(libraryBox).videoEmbedUrl,
                    "onUpdate:modelValue": ($event) => unref(libraryBox).videoEmbedUrl = $event,
                    size: "large",
                    style: { "--el-border-color": "var(--el-border-color-dark)" }
                  }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                  createVNode("div", { class: "text-xs" }, toDisplayString(_ctx.$t("common.editor.library.embedSupport", ["Youtube, Bilibili"])), 1),
                  createVNode("div", { class: "w-full mt-3" }, [
                    createVNode(_component_el_button, {
                      type: "primary",
                      size: "large",
                      onClick: unref(libraryBox).getEmbed,
                      loading: unref(libraryBox).locked,
                      class: "!w-full"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("common.editor.library.insert")), 1)
                      ]),
                      _: 1
                    }, 8, ["onClick", "loading"])
                  ])
                ])
              ], 512), [
                [vShow, unref(libraryBox).tabs == "embed"]
              ]),
              withDirectives(createVNode("div", { class: "w-full p-5 relative mt-4 rounded border-dashed border-2 border-[--el-border-color-light]" }, [
                createVNode("div", { class: "flex items-start flex-col gap-4 w-[100%]" }, [
                  unref(libraryBox).type !== "video" ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "w-full"
                  }, [
                    createVNode("div", { class: "mb-2" }, [
                      createTextVNode(toDisplayString(_ctx.$t("common.editor.library.externalTitle")) + " ", 1),
                      createVNode("b", { class: "text-red" }, "*"),
                      createTextVNode(" : ")
                    ]),
                    createVNode(_component_el_input, {
                      type: "text",
                      modelValue: unref(libraryBox).externalTitle,
                      "onUpdate:modelValue": ($event) => unref(libraryBox).externalTitle = $event,
                      size: "large",
                      style: { "--el-border-color": "var(--el-border-color-dark)" }
                    }, null, 8, ["modelValue", "onUpdate:modelValue"])
                  ])) : createCommentVNode("", true),
                  createVNode("div", { class: "w-full" }, [
                    createVNode("div", { class: "mb-2" }, [
                      createTextVNode(toDisplayString(_ctx.$t("common.editor.library.externalUrl")) + " ", 1),
                      createVNode("b", { class: "text-red" }, "*"),
                      createTextVNode(" : ")
                    ]),
                    createVNode(_component_el_input, {
                      type: "text",
                      modelValue: unref(libraryBox).externalUrl,
                      "onUpdate:modelValue": ($event) => unref(libraryBox).externalUrl = $event,
                      size: "large",
                      style: { "--el-border-color": "var(--el-border-color-dark)" }
                    }, null, 8, ["modelValue", "onUpdate:modelValue"])
                  ]),
                  unref(libraryBox).type !== "attachment" ? (openBlock(), createBlock("div", {
                    key: 1,
                    class: "text-xs"
                  }, toDisplayString(_ctx.$t("common.editor.library.externalSupport", [
                    unref(libraryBox).accept[unref(libraryBox).type].ext.join(", .")
                  ])), 1)) : createCommentVNode("", true),
                  unref(libraryBox).type == "attachment" ? (openBlock(), createBlock("div", {
                    key: 2,
                    class: "flex gap-2 jusitfy-around"
                  }, [
                    createVNode("label", null, [
                      createVNode("div", { class: "text-xs mb-2" }, toDisplayString(_ctx.$t("common.editor.library.attachmentInput.fileSize")) + ": ", 1),
                      createVNode(_component_el_input, {
                        type: "text",
                        modelValue: unref(libraryBox).attachmentMetas.fileSize,
                        "onUpdate:modelValue": ($event) => unref(libraryBox).attachmentMetas.fileSize = $event,
                        style: { "--el-border-color": "var(--el-border-color-dark)" }
                      }, null, 8, ["modelValue", "onUpdate:modelValue"])
                    ]),
                    createVNode("label", null, [
                      createVNode("div", { class: "text-xs mb-2" }, toDisplayString(_ctx.$t("common.unzipPassword")) + ":", 1),
                      createVNode(_component_el_input, {
                        type: "text",
                        modelValue: unref(libraryBox).attachmentMetas.unzipPassword,
                        "onUpdate:modelValue": ($event) => unref(libraryBox).attachmentMetas.unzipPassword = $event,
                        style: { "--el-border-color": "var(--el-border-color-dark)" }
                      }, null, 8, ["modelValue", "onUpdate:modelValue"])
                    ]),
                    createVNode("label", null, [
                      createVNode("div", { class: "text-xs mb-2" }, toDisplayString(_ctx.$t("common.extractionCode")) + ":", 1),
                      createVNode(_component_el_input, {
                        type: "text",
                        modelValue: unref(libraryBox).attachmentMetas.extractionCode,
                        "onUpdate:modelValue": ($event) => unref(libraryBox).attachmentMetas.extractionCode = $event,
                        style: { "--el-border-color": "var(--el-border-color-dark)" }
                      }, null, 8, ["modelValue", "onUpdate:modelValue"])
                    ])
                  ])) : createCommentVNode("", true),
                  createVNode("div", { class: "w-full mt-3" }, [
                    createVNode(_component_el_button, {
                      type: "primary",
                      size: "large",
                      onClick: unref(libraryBox).insertFileUrl,
                      loading: unref(libraryBox).locked,
                      class: "!w-full"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("common.editor.library.insert")), 1)
                      ]),
                      _: 1
                    }, 8, ["onClick", "loading"])
                  ])
                ])
              ], 512), [
                [vShow, unref(libraryBox).tabs == "external"]
              ]),
              withDirectives(createVNode("div", { class: "w-full p-5 relative mt-4 rounded border-dashed border-2 border-[--el-border-color-light]" }, [
                createVNode("div", { class: "flex items-start flex-col gap-2 w-[100%]" }, [
                  createVNode("div", null, toDisplayString(_ctx.$t("common.editor.library.iframeCode")), 1),
                  createVNode(_component_el_input, {
                    type: "textarea",
                    resize: "none",
                    rows: 4,
                    modelValue: unref(libraryBox).videoIframeCode,
                    "onUpdate:modelValue": ($event) => unref(libraryBox).videoIframeCode = $event,
                    size: "large",
                    style: { "--el-border-color": "var(--el-border-color-dark)" }
                  }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                  createVNode("div", { class: "text-xs" }, toDisplayString(_ctx.$t("common.editor.library.iframeSupport")), 1),
                  createVNode("div", { class: "w-full mt-3" }, [
                    createVNode(_component_el_button, {
                      type: "primary",
                      size: "large",
                      onClick: unref(libraryBox).insertIframeCode,
                      loading: unref(libraryBox).locked,
                      class: "!w-full"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("common.editor.library.insert")), 1)
                      ]),
                      _: 1
                    }, 8, ["onClick", "loading"])
                  ])
                ])
              ], 512), [
                [vShow, unref(libraryBox).tabs == "iframe"]
              ]),
              withDirectives(createVNode("div", { class: "w-full p-5 flex items-center justify-center relative h-100 mt-4 rounded border-dashed border-2 border-[--el-border-color-light]" }, [
                unref(viewer).data?.gqRoles?.media?.[unref(libraryBox).type]?.can ? (openBlock(), createBlock(_component_CommonFormUpload, {
                  key: 0,
                  showIcon: false,
                  showProgress: false,
                  multiple: true,
                  accept: unref(libraryBox).accept[unref(libraryBox).type].ext.map((ext) => `.${ext}`).join(","),
                  onUploadComplete: unref(libraryBox).complete,
                  onUploadProgress: unref(libraryBox).progress,
                  onFilesSelected: unref(libraryBox).selected,
                  onUploadError: unref(libraryBox).error,
                  class: "!absolute inset-0 !w-full !h-full flex-col gap-2"
                }, {
                  default: withCtx(() => [
                    createVNode("div", { class: "flex opacity-80" }, [
                      createVNode("i", { class: "i-ph-plus-light w-12 h-12" })
                    ]),
                    createVNode("div", { class: "mt-5" }, toDisplayString(_ctx.$t("common.editor.library.select", [
                      unref(settingsStore)?.max_file_size
                    ])), 1),
                    createVNode("div", { class: "text-xs opacity-80 max-w-[80%] text-center" }, toDisplayString(_ctx.$t("common.editor.library.support", [
                      "." + unref(libraryBox).accept[unref(libraryBox).type].ext.join(", .")
                    ])), 1)
                  ]),
                  _: 1
                }, 8, ["accept", "onUploadComplete", "onUploadProgress", "onFilesSelected", "onUploadError"])) : (openBlock(), createBlock("div", {
                  key: 1,
                  class: "absolute inset-0 flex items-center justify-center"
                }, [
                  unref(viewer).data?.gqRoles?.media?.[unref(libraryBox).type]?.max <= unref(viewer).data?.gqRoles?.media?.[unref(libraryBox).type]?.count && unref(viewer).data?.gqRoles?.media?.[unref(libraryBox).type]?.count != 0 ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("common.editor.library.noUploadToday", [unref(viewer).data?.gqRoles?.media?.[unref(libraryBox).type]?.count, unref(libraryBox).type])), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("common.editor.library.noUpload")), 1))
                ]))
              ], 512), [
                [vShow, unref(libraryBox).tabs == "upload"]
              ]),
              withDirectives((openBlock(), createBlock("div", { class: "h-100 mt-4" }, [
                unref(libraryBox).library.length > 0 ? (openBlock(), createBlock("div", { key: 0 }, [
                  createVNode(_component_el_scrollbar, { class: "!h-100" }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "grid grid-cols-4 gap-2" }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(libraryBox).library, (item, index) => {
                          return openBlock(), createBlock("div", {
                            key: index,
                            class: `cursor-pointer relative border-1 h-0 pt-[calc(100%-0.5rem)] hover:bg-[--el-color-primary-light-9] rounded bg-[--el-color-info-light-10] relative ${unref(libraryBox).picked.includes(index) ? "picked" : ""}`,
                            onClick: ($event) => !unref(locked) ? unref(libraryBox).onConfirm(index) : ""
                          }, [
                            item.node?.progress > 0 && item.node?.progress < 100 ? (openBlock(), createBlock("div", {
                              key: 0,
                              class: "absolute w-full h-full bg-[--el-color-info-light-5] top-0 left-0 z-2"
                            })) : createCommentVNode("", true),
                            item.node?.progress > 0 && item.node?.progress < 100 ? (openBlock(), createBlock(_component_el_progress, {
                              key: 1,
                              "text-inside": true,
                              "stroke-width": 10,
                              percentage: item.node.progress,
                              striped: "",
                              "striped-flow": "",
                              class: "!absolute inset-0 w-[80%] z-2 mx-auto",
                              color: "var(--el-color-success)"
                            }, null, 8, ["percentage"])) : createCommentVNode("", true),
                            unref(libraryBox).type == "image" ? (openBlock(), createBlock("img", {
                              key: 2,
                              src: item.node.sourceUrl,
                              class: "w-[calc(100%-0.5rem)] h-[calc(100%-0.5rem)] object-cover top-1 left-1 absolute rounded",
                              object: "cover"
                            }, null, 8, ["src"])) : unref(libraryBox).type == "audio" || unref(libraryBox).type == "video" ? (openBlock(), createBlock("div", {
                              key: 3,
                              class: "flex flex-col absolute w-full h-full inset-0 bg-[--el-color-info] overflow-hidden rounded"
                            }, [
                              createVNode("div", { class: "relative w-full h-full flex items-center justify-center" }, [
                                unref(libraryBox).type == "video" ? (openBlock(), createBlock("video", {
                                  key: 0,
                                  preload: "metadata",
                                  src: item.node.mediaItemUrl,
                                  class: "h-full w-full absolute object-cover rounded",
                                  object: "cover"
                                }, null, 8, ["src"])) : (openBlock(), createBlock(_component_el_button, {
                                  key: 1,
                                  circle: "",
                                  onClick: withModifiers(($event) => !unref(locked) ? unref(libraryBox).playAudio(item.node) : "", ["stop"])
                                }, {
                                  default: withCtx(() => [
                                    unref(audio).src == item.node.mediaItemUrl && unref(audio).playing ? (openBlock(), createBlock("i", {
                                      key: 0,
                                      class: "i-ph-pause-fill"
                                    })) : (openBlock(), createBlock("i", {
                                      key: 1,
                                      class: "i-ph-play-fill shadow-md"
                                    }))
                                  ]),
                                  _: 2
                                }, 1032, ["onClick"]))
                              ]),
                              createVNode("div", { class: "w-full bottom-0 left-0 text-xs bg-[--el-color-info-light-10] border-t p-2 overflow-hidden" }, [
                                createVNode("span", { class: "line-clamp-1" }, toDisplayString(item.node.title), 1)
                              ])
                            ])) : unref(libraryBox).type == "attachment" ? (openBlock(), createBlock("div", {
                              key: 4,
                              class: "flex flex-col absolute w-full h-full inset-0 bg-[--el-color-info] overflow-hidden overflow-hidden rounded"
                            }, [
                              createVNode("div", { class: "relative w-full h-full flex items-center justify-center" }, [
                                createVNode("span", { class: "shadow-lg bg-white px-2 rounded capitalize" }, toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).getFileExtension(item.node.mediaItemUrl)), 1)
                              ]),
                              createVNode("div", { class: "w-full bottom-0 left-0 text-xs bg-[--el-color-info-light-10] border-t p-2 overflow-hidden" }, [
                                createVNode("span", { class: "line-clamp-1" }, toDisplayString(item.node.title), 1)
                              ])
                            ])) : createCommentVNode("", true),
                            unref(libraryBox).picked.includes(index) ? (openBlock(), createBlock("span", {
                              key: 5,
                              class: "absolute flex items-center justify-center top-3 right-3 w-5 h-5 rounded-full bg-[--el-color-primary] text-white text-xs font-600 border"
                            }, [
                              createVNode("i", { class: "i-ph-check-bold" })
                            ])) : createCommentVNode("", true)
                          ], 10, ["onClick"]);
                        }), 128))
                      ]),
                      createVNode("div", { class: "text-center mt-3" }, [
                        createVNode(_component_el_button, {
                          type: "primary",
                          text: "",
                          bg: "",
                          onClick: ($event) => getLibrary(true),
                          loading: unref(libraryBox).loadingLock,
                          disabled: !unref(libraryBox).pageInfo.hasNextPage,
                          class: "mb-5"
                        }, {
                          default: withCtx(() => [
                            unref(libraryBox).loadingLock ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                              createTextVNode(toDisplayString(_ctx.$t("page.modules.post.loading")), 1)
                            ], 64)) : !unref(libraryBox).pageInfo.hasNextPage ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                              createTextVNode(toDisplayString(_ctx.$t("page.modules.post.noMore")), 1)
                            ], 64)) : (openBlock(), createBlock(Fragment, { key: 2 }, [
                              createTextVNode(toDisplayString(_ctx.$t("page.modules.post.loadMoreButton")), 1)
                            ], 64))
                          ]),
                          _: 1
                        }, 8, ["onClick", "loading", "disabled"])
                      ])
                    ]),
                    _: 1
                  })
                ])) : (openBlock(), createBlock("div", {
                  key: 1,
                  class: "flex items-center justify-center h-full flex-col gap-3 relative"
                }, [
                  createVNode("div", { class: "flex items-center justify-center" }, [
                    createVNode("i", { class: "i-ph-image w-10 h-10 opacity-80" })
                  ]),
                  createVNode("div", { class: "text-xs opacity-80" }, toDisplayString(_ctx.$t("common.editor.library.empty")), 1)
                ]))
              ])), [
                [vShow, unref(libraryBox).tabs == "library"],
                [_directive_loading, unref(libraryBox).loadingLock]
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/editor/mediaLibrary.client.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const mediaLibrary_client = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-a94f0029"]]);

export { mediaLibrary_client as default };
