import { g as getServerSettings, a as useI18n, v as viewerStore, k as deviceStore, j as actionStore, x as __nuxt_component_0$1, e as useUtils, w as isLogin } from './server.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import _sfc_main$1 from './svgIcon-BpIUCf-e.mjs';
import _sfc_main$2 from './creditIcon-eOdkwofx.mjs';
import { useSSRContext, ref, computed, watch, unref, withCtx, openBlock, createBlock, toDisplayString } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderStyle, ssrRenderList, ssrRenderClass } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';

const _sfc_main = {
  __name: "ModulesAccountMembership",
  __ssrInlineRender: true,
  setup(__props) {
    const settingsStore = getServerSettings();
    const picked = ref(0);
    const { t, locale } = useI18n();
    const viewer = viewerStore();
    const device = deviceStore();
    const action = actionStore();
    const payRef = ref(null);
    const vipList = computed(() => {
      return settingsStore?.level?.vip.filter(
        (item) => item.money[action.currency.iso] > 0
      );
    });
    const myVip = computed(() => {
      const index = vipList.value.findIndex(
        (item) => item.key == viewer.data?.gqVIP
      );
      return vipList.value[index];
    });
    const pickedItem = computed(() => {
      return vipList.value[picked.value];
    });
    const iconStr = `<i class="gq-custom-icon" style="margin-left:5px;width:1rem;height:1rem;--un-icon: url('${settingsStore?.credit?.symbol.replace(
      /'/g,
      "\\'"
    )}');"></i>`;
    const price = (item) => {
      if (!item) {
        return 0;
      }
      const salePrice = item.salePrice[action.currency.iso];
      if (!salePrice || salePrice == "0") {
        return item.money[action.currency.iso];
      }
      const saleRange = item.saleRange;
      if (!saleRange.to) {
        return salePrice;
      }
      const currentTime = new Date(useUtils.getCurrentTime());
      const saleTime = new Date(saleRange.to);
      if (currentTime >= saleTime) {
        return item.money[action.currency.iso];
      }
      return salePrice;
    };
    const buy = (item) => {
      if (!isLogin.value) {
        action.showLogin = true;
        return;
      }
      let title = "";
      if (pickedItem.value.key == viewer.data?.gqVIP) {
        title = t("page.account.membership.renew", [pickedItem.value.name[locale.value]]);
      } else {
        title = t("page.account.membership.joinMembership") + "「" + item.name[locale.value] + "」";
      }
      payRef.value.state.show({
        title,
        thumb: item.thumb?.sourceUrl || "",
        postId: item.databaseId,
        args: {
          payType: "money",
          title: t("page.account.membership.joinMembership") + item.name[locale.value],
          vipKey: item.key
        },
        count: 0,
        payment: "money",
        type: "vip",
        finalPrice: price(item),
        price: item.money[action.currency.iso],
        credit: item.credit
      });
    };
    settingsStore?.level?.vip.map((item) => {
      return {
        group: item.name[locale.value],
        directMessages: item.roles?.includes("directMessages"),
        article: item.roles?.includes("article"),
        comment: item.roles?.includes("comment"),
        topic: item.roles?.includes("topic"),
        promotion: item.roles?.includes("promotion")
      };
    });
    [
      {
        name: "directMessages",
        label: t("page.account.membership.directMessages")
      },
      // {
      //   name: "article",
      //   label: t("page.account.membership.article"),
      // },
      {
        name: "comment",
        label: t("page.account.membership.comment")
      },
      // {
      //   name: "topic",
      //   label: t("page.account.membership.topic"),
      // },
      {
        name: "promotion",
        label: t("page.account.membership.promotion")
      }
    ];
    const discount = (item) => {
      if (!item) {
        return 0;
      }
      if (price(item) == item.money[action.currency.iso]) {
        return 0;
      }
      return (item.salePrice[action.currency.iso] / item.money[action.currency.iso] * 10).toFixed(1);
    };
    const off = (item) => {
      if (!item) {
        return 0;
      }
      if (price(item) == item.money[action.currency.iso]) {
        return 0;
      }
      const money = item.money[action.currency.iso];
      const salePrice = item.salePrice[action.currency.iso];
      return ((money - salePrice) / money * 100).toFixed(1) + "%";
    };
    watch(() => action.loginAction, async () => {
      await viewer.getViewer();
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      const _component_el_button = ElButton;
      const _component_CommonSvgIcon = _sfc_main$1;
      const _component_CommonCreditIcon = _sfc_main$2;
      _push(`<div${ssrRenderAttrs(_attrs)} data-v-815ba3d6><div class="relative text-[--el-color-white] flex justify-between items-center @md:mb-6 mb-3 rounded-lg p-4 vip-info-box overflow-hidden xyz-in" data-v-815ba3d6><div class="flex flex-col gap-0.5" data-v-815ba3d6><div class="flex flex-col gap-0.5" data-v-815ba3d6>${ssrInterpolate(unref(myVip)?.name?.[_ctx.$i18n.locale] || "Become VIP")}</div><div class="text-xs opacity-80" data-v-815ba3d6>`);
      if (unref(viewer).data?.gqVipExpired) {
        _push(`<span data-v-815ba3d6>${ssrInterpolate(_ctx.$t("page.account.membership.myMembership.endTime", [
          unref(viewer).data?.gqVipExpired
        ]))}</span>`);
      } else if (!unref(viewer).data?.gqVIP) {
        _push(`<span data-v-815ba3d6>${ssrInterpolate(_ctx.$t("page.account.membership.myMembership.joinInfo"))}</span>`);
      } else {
        _push(`<span data-v-815ba3d6>${ssrInterpolate(_ctx.$t("page.account.membership.myMembership.forever"))}</span>`);
      }
      _push(`</div></div>`);
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`</div><div class="gap-2 @md:gap-4 auto-grid xyz-in" style="${ssrRenderStyle(`${unref(device).isMobile ? "--gq-grid-min-width: 96px" : "--gq-grid-min-width: 120px"}`)}" data-v-815ba3d6><!--[-->`);
      ssrRenderList(unref(vipList), (item, i) => {
        _push(`<div style="${ssrRenderStyle(`--gq-vip-color:${item.color || "var(--el-color-primary)"};--xyz-index:${i + 1};`)}" class="${ssrRenderClass(`${unref(picked) == i ? "border-color-[--el-color-primary]" : "border-color-[--el-border-color]"} select-none xyz-in cursor-pointer border-2 pb-0 rounded-lg relative rounded-rt-3xl ${item.featured ? "bg-gradient-to-br to-[--el-color-primary-light-9] from-[--el-bg-color-overlay]" : ""}`)}" data-v-815ba3d6><div class="${ssrRenderClass(`absolute border-2 flex  max-w-27
                    items-center text-xs bg-[--el-bg-color-overlay] gap-0.5 py-0.3 left-4 -top-2 
                    ${unref(picked) == i ? "border-color-[--el-color-primary] text-[--el-color-primary]" : "border-color-[--el-border-color]"} 
                    px-2 rounded ${item.suggestions[_ctx.$i18n.locale] ? "opacity-100" : "opacity-0"}`)}" data-v-815ba3d6><span class="line-clamp-1" data-v-815ba3d6>${ssrInterpolate(item.suggestions[_ctx.$i18n.locale])}</span></div><div class="flex absolute right-0 top-0" data-v-815ba3d6>`);
        _push(ssrRenderComponent(_component_CommonSvgIcon, {
          d: item.icon,
          class: "w-20 h-20 opacity-3"
        }, null, _parent));
        _push(`</div><div class="pt-7 p-4 flex flex-col justify-between" data-v-815ba3d6><div class="text-sm flex flex-col" data-v-815ba3d6><b class="${ssrRenderClass(`${unref(picked) == i ? "text-[--el-color-primary]" : ""} leading-none`)}" data-v-815ba3d6>${ssrInterpolate(item.name?.[_ctx.$i18n.locale])}</b><span class="text-[10px] mt-0.4 ml-0.5" data-v-815ba3d6>`);
        if (parseInt(item.expiration)) {
          _push(`<span data-v-815ba3d6>${ssrInterpolate(_ctx.$t("page.account.membership.days", [item.expiration]))}</span>`);
        } else {
          _push(`<span data-v-815ba3d6>${ssrInterpolate(_ctx.$t("page.account.membership.forever"))}</span>`);
        }
        _push(`</span></div><div class="${ssrRenderClass(`ml-0.4 mt-3 text-xs ${price(item) !== item.money[unref(action).currency.iso] ? "" : "opacity-0"}`)}" data-v-815ba3d6><del class="font-600 opacity-40 italic" data-v-815ba3d6>${ssrInterpolate(unref(action).currency.symbol + item.money[unref(action).currency.iso])}</del></div><div class="text-[26px] relative leading-none w-fit" data-v-815ba3d6><span class="${ssrRenderClass(`text-base ${unref(picked) == i ? "text-[--el-color-primary]" : ""}`)}" data-v-815ba3d6>${ssrInterpolate(unref(action).currency.symbol)}</span><span class="${ssrRenderClass(`${unref(picked) == i ? "text-[--el-color-primary]" : ""}`)}" data-v-815ba3d6>${ssrInterpolate(price(item))}</span>`);
        if (discount(item) != 0) {
          _push(`<span class="italic flex flex-col font-normal text-[10px] p-0.5 whitespace-nowrap text-[--el-color-danger] rounded-md" data-v-815ba3d6>${ssrInterpolate(_ctx.$t("page.account.membership.off", [
            _ctx.$i18n.locale.includes("zh-") ? discount(item) : off(item)
          ]))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="${ssrRenderClass(`text-[11px] px-1.2 mt-0.4 ${price(item) !== item.money[unref(action).currency.iso] && item.saleRange.to ? "opacity-70" : "opacity-0"}`)}" data-v-815ba3d6>${ssrInterpolate(_ctx.$t("page.account.membership.endAt", [
          ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).timeAgo(item.saleRange.to || 0)
        ]))}</div></div><div class="${ssrRenderClass(`${item.credit ? "opacity-100" : "opacity-0"} border-t ${item.featured ? "border-color-[--el-color-primary-light-8]" : ""} ${unref(picked) == i ? "text-[--el-color-primary]" : ""} py-2 px-4 gap-1 items-center flex text-xs`)}" data-v-815ba3d6><span data-v-815ba3d6>${ssrInterpolate(_ctx.$t("page.account.membership.gift"))}</span><span class="flex items-center" data-v-815ba3d6>`);
        _push(ssrRenderComponent(_component_CommonCreditIcon, { class: "w-3 h-3" }, null, _parent));
        _push(`<span data-v-815ba3d6>${ssrInterpolate(item.credit)}</span></span></div></div>`);
      });
      _push(`<!--]--></div><div class="mt-6 text-sm flex vip-info xyz-in" data-v-815ba3d6><i class="i-ph-confetti mr-2 text-[--el-color-danger] mt-0.5" data-v-815ba3d6></i><div class="flex flex-wrap whitespace-wrap flex-1" data-v-815ba3d6><span data-v-815ba3d6>${ssrInterpolate(unref(pickedItem)?.name?.[_ctx.$i18n.locale] || "VIP")}</span><b data-v-815ba3d6>/</b>`);
      if (parseInt(unref(pickedItem)?.expiration || 0)) {
        _push(`<span data-v-815ba3d6>${_ctx.$t("page.account.membership.info.get", [
          unref(pickedItem)?.expiration || 0
        ]) ?? ""}</span>`);
      } else {
        _push(`<span data-v-815ba3d6>${ssrInterpolate(_ctx.$t("page.account.membership.giftTime"))}</span>`);
      }
      if (unref(pickedItem)?.credit) {
        _push(`<span class="flex items-center gap-0.5" data-v-815ba3d6>${`<b>/</b>${_ctx.$t("page.account.membership.info.credit", [
          iconStr + unref(pickedItem)?.credit
        ])}` ?? ""}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (price(unref(pickedItem)) != unref(pickedItem)?.money[unref(action).currency.iso]) {
        _push(`<span data-v-815ba3d6><b data-v-815ba3d6>/</b> ${ssrInterpolate(_ctx.$t("page.account.membership.info.off", [
          _ctx.$i18n.locale.includes("zh-") ? discount(unref(pickedItem)) : off(unref(pickedItem))
        ]))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(pickedItem)?.saleRange?.to) {
        _push(`<span data-v-815ba3d6><b data-v-815ba3d6>/</b> ${ssrInterpolate(_ctx.$t("page.account.membership.info.limit", [
          ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).timeAgo(unref(pickedItem)?.saleRange?.to || 0)
        ]))}</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="mt-6 xyz-in" data-v-815ba3d6>`);
      _push(ssrRenderComponent(_component_el_button, {
        class: "w-full",
        bg: "",
        type: "primary",
        plain: "",
        size: "large",
        onClick: ($event) => buy(unref(pickedItem))
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(pickedItem)?.key && unref(pickedItem)?.key == unref(viewer).data?.gqVIP) {
              _push2(`<span data-v-815ba3d6${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.membership.renew", [unref(pickedItem)?.name?.[_ctx.$i18n.locale] || "VIP"]))}</span>`);
            } else {
              _push2(`<span data-v-815ba3d6${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.membership.join"))} 「${ssrInterpolate(unref(pickedItem)?.name?.[_ctx.$i18n.locale] || "VIP")}」 </span>`);
            }
          } else {
            return [
              unref(pickedItem)?.key && unref(pickedItem)?.key == unref(viewer).data?.gqVIP ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("page.account.membership.renew", [unref(pickedItem)?.name?.[_ctx.$i18n.locale] || "VIP"])), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("page.account.membership.join")) + " 「" + toDisplayString(unref(pickedItem)?.name?.[_ctx.$i18n.locale] || "VIP") + "」 ", 1))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="mt-4 border-1 rounded-lg xyz-in" data-v-815ba3d6>`);
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/account/membership.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const membership = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-815ba3d6"]]);

export { membership as default };
