import _sfc_main$1 from './blink-DRvWMg-X.mjs';
import _sfc_main$2 from './svgIcon-BpIUCf-e.mjs';
import { useSSRContext, ref, computed, watch, nextTick, mergeProps, unref, withCtx, createVNode, openBlock, createBlock, createCommentVNode, createTextVNode, toDisplayString } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrRenderClass, ssrInterpolate, ssrRenderStyle } from 'vue/server-renderer';
import { d as useRoute, $ as useLocalePath, a as useI18n } from './server.mjs';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './nuxt-link-Dd6LuEo9.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "HeaderMenu1",
  __ssrInlineRender: true,
  props: ["data", "getHeaderStyle", "showCarouselBg"],
  setup(__props) {
    const props = __props;
    const activeMenu = ref(null);
    const route = useRoute();
    const localePath = useLocalePath();
    const { locale } = useI18n();
    const subMenus = (menu) => {
      const type = menu.type;
      const sub = menu.sub;
      if (type == "text" || type == "group") {
        if (sub?.list?.length > 0) {
          return true;
        }
      }
      if (type == "html") {
        if (sub?.html) {
          return true;
        }
      }
      return false;
    };
    const subMenu = computed(() => {
      if (activeMenu.value === null)
        return {
          show: false,
          type: "text",
          list: [],
          columns: []
        };
      const sub = props.getHeaderStyle.menus[activeMenu.value]?.sub;
      let type = props.getHeaderStyle.menus[activeMenu.value].type;
      if (type !== "html") {
        type = sub?.list?.[0]?.type;
        if (!type) {
          type = "text";
        }
      }
      if (type == "text" || type == "group") {
        if (sub?.list?.length > 0) {
          if (type == "text") {
            return {
              show: true,
              type: props.getHeaderStyle.menus[activeMenu.value].type,
              list: sub.list,
              columns: []
            };
          } else {
            let columns = [];
            sub?.list?.forEach((item) => {
              const groupName = item.groupName?.[locale.value];
              if (groupName) {
                if (!columns[groupName]) {
                  columns[groupName] = [];
                }
                columns[groupName].push(item);
              }
            });
            return {
              show: true,
              type,
              list: [],
              columns: { ...columns }
            };
          }
        }
        return {
          show: false,
          type: "text",
          list: [],
          columns: []
        };
      }
      if (type == "html") {
        return {
          show: true,
          type: "html",
          list: [],
          columns: [],
          html: sub.html
        };
      }
      return null;
    });
    const transitionName = ref("content-fade");
    const contentWrapperRef = ref(null);
    const contentWrapperHeight = ref(null);
    watch(activeMenu, (newVal, oldVal) => {
      if (newVal !== null) {
        const oldMenu = props.getHeaderStyle.menus[oldVal];
        const newMenu = props.getHeaderStyle.menus[newVal];
        if (oldVal === null || !subMenus(oldMenu) || !subMenus(newMenu)) {
          transitionName.value = "content-fade";
        } else {
          transitionName.value = newVal > oldVal ? "content-slide-right" : "content-slide-left";
          const el = contentWrapperRef.value;
          const oldHeight = el ? el.offsetHeight : null;
          nextTick(() => {
            if (oldHeight == null) return;
            const wrapper = contentWrapperRef.value;
            if (!wrapper) return;
            const newHeight = wrapper.scrollHeight;
            if (oldHeight === newHeight) return;
            contentWrapperHeight.value = oldHeight;
            requestAnimationFrame(() => {
              contentWrapperHeight.value = newHeight;
            });
          });
        }
      } else {
        contentWrapperHeight.value = null;
      }
    });
    const isOpen = computed(() => activeMenu.value !== null && subMenu.value?.show);
    const lastSubMenuRef = ref(null);
    const lastActiveMenuIndex = ref(null);
    watch(
      () => subMenu.value,
      (val) => {
        if (val?.show) lastSubMenuRef.value = val;
      },
      { immediate: true }
    );
    watch(activeMenu, (val) => {
      if (val !== null) lastActiveMenuIndex.value = val;
    });
    const displaySubMenu = computed(
      () => isOpen.value ? subMenu.value : lastSubMenuRef.value
    );
    function isActive(path) {
      const fullPath = localePath(path);
      const homePath = localePath("/");
      if (fullPath === homePath) {
        return route.path === homePath;
      }
      const currentPath = route.path;
      return currentPath === fullPath || currentPath.startsWith(fullPath + "/");
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Blink = _sfc_main$1;
      const _component_CommonSvgIcon = _sfc_main$2;
      _push(`<nav${ssrRenderAttrs(mergeProps({ class: "relative h-full w-full" }, _attrs))} data-v-8a675e6f><ul class="flex items-center relative z-50 text-[0.9rem] h-full text-[--el-text-color-regular]" data-v-8a675e6f><!--[-->`);
      ssrRenderList(__props.getHeaderStyle.menus ?? [], (menu, i) => {
        _push(`<li class="h-full group/menu px-1" data-v-8a675e6f>`);
        _push(ssrRenderComponent(_component_Blink, {
          class: [
            "h-full flex items-center relative",
            unref(activeMenu) === i || isActive(menu.link) ? "text-[--el-color-primary]" : ""
          ],
          to: menu.link
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="${ssrRenderClass(`rounded-full border-1 border-transparent px-2.5 flex items-center py-1 group-hover/menu:bg-gradient-to-br group-hover/menu:from-transparent group-hover/menu:to-[--el-border-color] group-hover/menu:border-[--el-border-color] ${unref(activeMenu) === i || isActive(menu.link) ? "bg-gradient-to-br from-transparent to-[--el-border-color] !border-[--el-border-color]" : ""}`)}" data-v-8a675e6f${_scopeId}>`);
              if (menu.icon) {
                _push2(`<span class="flex mr-1" data-v-8a675e6f${_scopeId}>`);
                _push2(ssrRenderComponent(_component_CommonSvgIcon, {
                  d: menu.icon
                }, null, _parent2, _scopeId));
                _push2(`</span>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(` ${ssrInterpolate(menu.name?.[_ctx.$i18n.locale])}`);
              if (subMenus(menu)) {
                _push2(`<i class="${ssrRenderClass(`i-ph-caret-down-bold w-2.5 h-2.5 ml-1 -mr-[2px] ${unref(activeMenu) === i ? "rotate-180" : ""} transition-transform duration-200`)}" data-v-8a675e6f${_scopeId}></i>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</span>`);
              if (menu.tipsType !== "none" && menu.tipsText?.[_ctx.$i18n.locale]) {
                _push2(`<span class="${ssrRenderClass(`menu-tips ${menu.tipsType}-tips`)}" data-v-8a675e6f${_scopeId}>${ssrInterpolate(menu.tipsText?.[_ctx.$i18n.locale])}</span>`);
              } else {
                _push2(`<!---->`);
              }
            } else {
              return [
                createVNode("span", {
                  class: `rounded-full border-1 border-transparent px-2.5 flex items-center py-1 group-hover/menu:bg-gradient-to-br group-hover/menu:from-transparent group-hover/menu:to-[--el-border-color] group-hover/menu:border-[--el-border-color] ${unref(activeMenu) === i || isActive(menu.link) ? "bg-gradient-to-br from-transparent to-[--el-border-color] !border-[--el-border-color]" : ""}`
                }, [
                  menu.icon ? (openBlock(), createBlock("span", {
                    key: 0,
                    class: "flex mr-1"
                  }, [
                    createVNode(_component_CommonSvgIcon, {
                      d: menu.icon
                    }, null, 8, ["d"])
                  ])) : createCommentVNode("", true),
                  createTextVNode(" " + toDisplayString(menu.name?.[_ctx.$i18n.locale]), 1),
                  subMenus(menu) ? (openBlock(), createBlock("i", {
                    key: 1,
                    class: `i-ph-caret-down-bold w-2.5 h-2.5 ml-1 -mr-[2px] ${unref(activeMenu) === i ? "rotate-180" : ""} transition-transform duration-200`
                  }, null, 2)) : createCommentVNode("", true)
                ], 2),
                menu.tipsType !== "none" && menu.tipsText?.[_ctx.$i18n.locale] ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: `menu-tips ${menu.tipsType}-tips`
                }, toDisplayString(menu.tipsText?.[_ctx.$i18n.locale]), 3)) : createCommentVNode("", true)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
      });
      _push(`<!--]--></ul><div class="dropdown-perspective" data-v-8a675e6f><div class="absolute overflow-hidden -mt-1 w-full flex text-[--el-text-color-primary]" style="${ssrRenderStyle(unref(isOpen) ? null : { display: "none" })}" data-v-8a675e6f><div class="bg-[--el-bg-color] rounded-lg shadow-md overflow-hidden border-1" style="${ssrRenderStyle({
        width: "min(100%, 760px)",
        ...unref(contentWrapperHeight) != null && {
          height: unref(contentWrapperHeight) + "px",
          transition: "height 0.2s cubic-bezier(0.16, 1, 0.3, 1)"
        }
      })}" data-v-8a675e6f><!--[-->`);
      if (unref(displaySubMenu)?.show) {
        _push(`<div class="content-start" data-v-8a675e6f>`);
        if (unref(displaySubMenu).type == "text") {
          _push(`<div class="flex flex-wrap p-4" data-v-8a675e6f><!--[-->`);
          ssrRenderList(unref(displaySubMenu).list, (item, ti) => {
            _push(`<div class="w-1/3" data-v-8a675e6f>`);
            _push(ssrRenderComponent(_component_Blink, {
              to: item.link || "#",
              class: `group flex ${item.description?.[_ctx.$i18n.locale] ? "items-start" : "items-center"} ${isActive(item.link) ? "menu-bg text-[--el-color-primary]" : ""} flex gap-2 group/item hover:bg-gradient-to-br hover:from-transparent hover:to-[--el-border-color] rounded p-2 `
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  if (item.icon) {
                    _push2(`<span class="item-icon" data-v-8a675e6f${_scopeId}>`);
                    _push2(ssrRenderComponent(_component_CommonSvgIcon, {
                      d: item.icon
                    }, null, _parent2, _scopeId));
                    _push2(`</span>`);
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`<div class="flex flex-col flex-1 relative" data-v-8a675e6f${_scopeId}><div class="${ssrRenderClass(`text-sm group-hover/item:text-[--el-color-primary] group-hover/item:font-bold relative flex  justify-between`)}" data-v-8a675e6f${_scopeId}><span class="line-clamp-1" data-v-8a675e6f${_scopeId}>${ssrInterpolate(item.name?.[_ctx.$i18n.locale])}</span>`);
                  if (item.tipsType !== "none" && item.tipsText?.[_ctx.$i18n.locale]) {
                    _push2(`<span class="${ssrRenderClass(`menu-tips-inline ${item.tipsType}-tips`)}" data-v-8a675e6f${_scopeId}>${ssrInterpolate(item.tipsText?.[_ctx.$i18n.locale])}</span>`);
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`</div><span class="text-xs opacity-70 line-clamp-1 group-hover/item:text-[--el-color-primary]" data-v-8a675e6f${_scopeId}>${ssrInterpolate(item.description?.[_ctx.$i18n.locale])}</span></div>`);
                } else {
                  return [
                    item.icon ? (openBlock(), createBlock("span", {
                      key: 0,
                      class: "item-icon"
                    }, [
                      createVNode(_component_CommonSvgIcon, {
                        d: item.icon
                      }, null, 8, ["d"])
                    ])) : createCommentVNode("", true),
                    createVNode("div", { class: "flex flex-col flex-1 relative" }, [
                      createVNode("div", { class: `text-sm group-hover/item:text-[--el-color-primary] group-hover/item:font-bold relative flex  justify-between` }, [
                        createVNode("span", { class: "line-clamp-1" }, toDisplayString(item.name?.[_ctx.$i18n.locale]), 1),
                        item.tipsType !== "none" && item.tipsText?.[_ctx.$i18n.locale] ? (openBlock(), createBlock("span", {
                          key: 0,
                          class: `menu-tips-inline ${item.tipsType}-tips`
                        }, toDisplayString(item.tipsText?.[_ctx.$i18n.locale]), 3)) : createCommentVNode("", true)
                      ]),
                      createVNode("span", { class: "text-xs opacity-70 line-clamp-1 group-hover/item:text-[--el-color-primary]" }, toDisplayString(item.description?.[_ctx.$i18n.locale]), 1)
                    ])
                  ];
                }
              }),
              _: 2
            }, _parent));
            _push(`</div>`);
          });
          _push(`<!--]--></div>`);
        } else if (unref(displaySubMenu).type == "group") {
          _push(`<div class="flex flex-wrap p-4" style="${ssrRenderStyle({ "--auto-grid-min-item-size": "100px" })}" data-v-8a675e6f><!--[-->`);
          ssrRenderList(unref(displaySubMenu).columns, (item, key, i) => {
            _push(`<div class="w-1/3" data-v-8a675e6f><h3 class="text-sm opacity-70 p-2 ml-1" data-v-8a675e6f>${ssrInterpolate(key)}</h3><div class="flex flex-col" data-v-8a675e6f><!--[-->`);
            ssrRenderList(item, (item2) => {
              _push(`<div data-v-8a675e6f>`);
              _push(ssrRenderComponent(_component_Blink, {
                to: item2.link || "#",
                class: `group flex ${isActive(item2.link) ? "menu-bg text-[--el-color-primary]" : ""} ${item2.description?.[_ctx.$i18n.locale] ? "items-start" : "items-center"} flex gap-2 p-2 hover:bg-gradient-to-br hover:from-transparent hover:to-[--el-border-color] rounded group/item`
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    if (item2.icon) {
                      _push2(`<span class="item-icon" data-v-8a675e6f${_scopeId}>`);
                      _push2(ssrRenderComponent(_component_CommonSvgIcon, {
                        d: item2.icon
                      }, null, _parent2, _scopeId));
                      _push2(`</span>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`<div class="flex flex-col flex-1" data-v-8a675e6f${_scopeId}><div class="flex items-center justify-between" data-v-8a675e6f${_scopeId}><span class="line-clamp-1 text-sm group-hover/item:text-[--el-color-primary] group-hover/item:font-bold" data-v-8a675e6f${_scopeId}>${ssrInterpolate(item2.name?.[_ctx.$i18n.locale])}</span>`);
                    if (item2.tipsType !== "none" && item2.tipsText?.[_ctx.$i18n.locale]) {
                      _push2(`<span class="${ssrRenderClass(`menu-tips-inline ${item2.tipsType}-tips`)}" data-v-8a675e6f${_scopeId}>${ssrInterpolate(item2.tipsText?.[_ctx.$i18n.locale])}</span>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`</div><span class="text-xs opacity-70 line-clamp-1" data-v-8a675e6f${_scopeId}>${ssrInterpolate(item2.description?.[_ctx.$i18n.locale])}</span></div>`);
                  } else {
                    return [
                      item2.icon ? (openBlock(), createBlock("span", {
                        key: 0,
                        class: "item-icon"
                      }, [
                        createVNode(_component_CommonSvgIcon, {
                          d: item2.icon
                        }, null, 8, ["d"])
                      ])) : createCommentVNode("", true),
                      createVNode("div", { class: "flex flex-col flex-1" }, [
                        createVNode("div", { class: "flex items-center justify-between" }, [
                          createVNode("span", { class: "line-clamp-1 text-sm group-hover/item:text-[--el-color-primary] group-hover/item:font-bold" }, toDisplayString(item2.name?.[_ctx.$i18n.locale]), 1),
                          item2.tipsType !== "none" && item2.tipsText?.[_ctx.$i18n.locale] ? (openBlock(), createBlock("span", {
                            key: 0,
                            class: `menu-tips-inline ${item2.tipsType}-tips`
                          }, toDisplayString(item2.tipsText?.[_ctx.$i18n.locale]), 3)) : createCommentVNode("", true)
                        ]),
                        createVNode("span", { class: "text-xs opacity-70 line-clamp-1" }, toDisplayString(item2.description?.[_ctx.$i18n.locale]), 1)
                      ])
                    ];
                  }
                }),
                _: 2
              }, _parent));
              _push(`</div>`);
            });
            _push(`<!--]--></div></div>`);
          });
          _push(`<!--]--></div>`);
        } else if (unref(displaySubMenu).type == "html") {
          _push(`<div data-v-8a675e6f>${unref(displaySubMenu).html?.[_ctx.$i18n.locale] ?? ""}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      }
      _push(`<!--]--></div></div></div></nav>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/header/menu1.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_2 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-8a675e6f"]]);

export { __nuxt_component_2 as default };
