import { a0 as buildProps, P as withInstall, C as useNamespace, e as useUtils } from './server.mjs';
import { useSSRContext, defineComponent, computed, provide, openBlock, createBlock, resolveDynamicComponent, normalizeStyle, normalizeClass, withCtx, renderSlot, mergeProps, createVNode, toDisplayString, Fragment, renderList, unref } from 'vue';
import _sfc_main$2 from './blink-DRvWMg-X.mjs';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrRenderStyle, ssrInterpolate } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';
import './nuxt-link-Dd6LuEo9.mjs';

const rowContextKey = /* @__PURE__ */ Symbol("rowContextKey");
const RowJustify = [
  "start",
  "center",
  "end",
  "space-around",
  "space-between",
  "space-evenly"
];
const RowAlign = ["top", "middle", "bottom"];
const rowProps = buildProps({
  /**
   * @description custom element tag
   */
  tag: {
    type: String,
    default: "div"
  },
  /**
   * @description grid spacing
   */
  gutter: {
    type: Number,
    default: 0
  },
  /**
   * @description horizontal alignment of flex layout
   */
  justify: {
    type: String,
    values: RowJustify,
    default: "start"
  },
  /**
   * @description vertical alignment of flex layout
   */
  align: {
    type: String,
    values: RowAlign
  }
});
var _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElRow"
  },
  __name: "row",
  props: rowProps,
  setup(__props) {
    const props = __props;
    const ns = useNamespace("row");
    const gutter = computed(() => props.gutter);
    provide(rowContextKey, {
      gutter
    });
    const style = computed(() => {
      const styles = {};
      if (!props.gutter) {
        return styles;
      }
      styles.marginRight = styles.marginLeft = `-${props.gutter / 2}px`;
      return styles;
    });
    const rowKls = computed(() => [
      ns.b(),
      ns.is(`justify-${props.justify}`, props.justify !== "start"),
      ns.is(`align-${props.align}`, !!props.align)
    ]);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(__props.tag), {
        class: normalizeClass(rowKls.value),
        style: normalizeStyle(style.value)
      }, {
        default: withCtx(() => [
          renderSlot(_ctx.$slots, "default")
        ]),
        _: 3
        /* FORWARDED */
      }, 8, ["class", "style"]);
    };
  }
});
const ElRow = withInstall(_sfc_main$1);
const _sfc_main = {
  __name: "ModulesCommonPostComponentsMetas",
  __ssrInlineRender: true,
  props: ["item", "settings"],
  setup(__props) {
    const props = __props;
    const inc = (type) => {
      return props.settings.attrsPicked.includes(type);
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_row = ElRow;
      const _component_Blink = _sfc_main$2;
      if (__props.item?.node?.tags?.nodes?.length > 0 || inc("views") || inc("commentCount") || inc("collectionCount") || inc("likeCount")) {
        _push(`<div${ssrRenderAttrs(mergeProps({
          class: "flex items-center justify-between",
          style: `--gq-meta-fontSize:${__props.settings.meta.fontSize}px;font-size:var(--gq-meta-fontSize)`
        }, _attrs))} data-v-90c92247>`);
        if (inc("tags") && __props.item?.node?.tags?.nodes?.length > 0) {
          _push(ssrRenderComponent(_component_el_row, { class: "flex gap-2 flex-nowrap tag-list mr-2" }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<!--[-->`);
                ssrRenderList(__props.item?.node?.tags?.nodes.slice(0, __props.settings.tags.count), (tag, i) => {
                  _push2(ssrRenderComponent(_component_Blink, {
                    to: tag.gqSlug,
                    key: tag,
                    class: "mr-2 gq-gs opacity-50"
                  }, {
                    default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                      if (_push3) {
                        _push3(`<i class="i-ph-hash-duotone text-[var(--el-color-primary)] inline-block" style="${ssrRenderStyle({ "transform": "scale(0.8)", "vertical-align": "sub" })}" data-v-90c92247${_scopeId2}></i><b class="font-normal" data-v-90c92247${_scopeId2}>${ssrInterpolate(tag.name)}</b>`);
                      } else {
                        return [
                          createVNode("i", {
                            class: "i-ph-hash-duotone text-[var(--el-color-primary)] inline-block",
                            style: { "transform": "scale(0.8)", "vertical-align": "sub" }
                          }),
                          createVNode("b", { class: "font-normal" }, toDisplayString(tag.name), 1)
                        ];
                      }
                    }),
                    _: 2
                  }, _parent2, _scopeId));
                });
                _push2(`<!--]-->`);
              } else {
                return [
                  (openBlock(true), createBlock(Fragment, null, renderList(__props.item?.node?.tags?.nodes.slice(0, __props.settings.tags.count), (tag, i) => {
                    return openBlock(), createBlock(_component_Blink, {
                      to: tag.gqSlug,
                      key: tag,
                      class: "mr-2 gq-gs opacity-50"
                    }, {
                      default: withCtx(() => [
                        createVNode("i", {
                          class: "i-ph-hash-duotone text-[var(--el-color-primary)] inline-block",
                          style: { "transform": "scale(0.8)", "vertical-align": "sub" }
                        }),
                        createVNode("b", { class: "font-normal" }, toDisplayString(tag.name), 1)
                      ]),
                      _: 2
                    }, 1032, ["to"]);
                  }), 128))
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        if (inc("views") || inc("commentCount") || inc("collectionCount") || inc("likeCount")) {
          _push(`<div class="flex items-center gap-2 opacity-50 text-[calc(var(--gq-meta-fontSize)*0.9)]" data-v-90c92247>`);
          if (inc("views")) {
            _push(`<span class="flex items-center gap-.3 gq-gs" data-v-90c92247><i class="i-ph-fire-simple" data-v-90c92247></i><span data-v-90c92247>${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(__props.item?.node?.viewsCache))}</span></span>`);
          } else {
            _push(`<!---->`);
          }
          if (inc("commentCount")) {
            _push(`<span class="flex items-center gap-.3 gq-gs" data-v-90c92247><i class="i-ph-chat-teardrop" data-v-90c92247></i> ${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(__props.item?.node?.commentCount))}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (inc("collectionCount")) {
            _push(`<span class="flex items-center gap-.3 gq-gs" data-v-90c92247><i class="i-ph-star" data-v-90c92247></i><span data-v-90c92247>${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(__props.item?.node?.collectionCount))}</span></span>`);
          } else {
            _push(`<!---->`);
          }
          if (inc("likeCount")) {
            _push(`<span class="flex items-center gap-.3 gq-gs" data-v-90c92247><i class="i-ph-heart" data-v-90c92247></i><span data-v-90c92247>${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(__props.item?.node?.likeCount))}</span></span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/post/components/metas.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_8 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-90c92247"]]);

export { __nuxt_component_8 as default };
