import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import __nuxt_component_2 from './waveform-CcdD4iaE.mjs';
import { _ as __nuxt_component_4$1 } from './Image-BE6Y-a3S.mjs';
import { aL as onClickOutside } from './server.mjs';
import { useSSRContext, ref, watch, mergeProps, unref, withCtx, createVNode, openBlock, createBlock, Fragment, renderList, toDisplayString, withModifiers } from 'vue';
import { ssrRenderAttrs, ssrRenderClass, ssrInterpolate, ssrRenderComponent, ssrRenderList } from 'vue/server-renderer';
import { a as audioStore } from './audio-CfS8Ng0x.mjs';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './index-ChPMoinw.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './image-viewer-DG2qIWb8.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-Di0Jlzch.mjs';
import './index-BKB3Djp4.mjs';

const _sfc_main = {
  __name: "CommonMobilePlayer",
  __ssrInlineRender: true,
  emits: ["update:openList"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const playerTrack = ref(null);
    onClickOutside(playerTrack, () => {
      openList.value = false;
    });
    const audio = audioStore();
    const audioBox = ref(null);
    const openList = ref(false);
    const emits = __emit;
    watch(
      () => openList.value,
      (val) => {
        emits("update:openList", val);
      }
    );
    const playSelect = (i) => {
      audio.picked = i;
      localStorage.setItem("audioPicked", i);
      audio.src = audio.list[i].src;
      audio.title = audio.list[i].title;
      audio.thumb = audio.list[i].thumb;
      setTimeout(() => {
        audio.playing = true;
      }, 100);
    };
    const nextOrPrev = (type) => {
      if (audio.list.length === 0) return;
      if (audio.picked === -1) {
        audio.picked = 0;
        localStorage.setItem("audioPicked", 0);
        if (!audio.list[0]) return;
        audio.src = audio.list[0].src;
        audio.title = audio.list[0].title;
        audio.thumb = audio.list[0].thumb;
        audio.playing = true;
        return;
      }
      if (type === "next") {
        if (audio.picked === audio.list.length - 1) {
          audio.picked = 0;
          localStorage.setItem("audioPicked", 0);
        } else {
          audio.picked++;
          localStorage.setItem("audioPicked", audio.picked);
        }
      } else {
        if (audio.picked === 0) {
          audio.picked = audio.list.length - 1;
        } else {
          audio.picked--;
          localStorage.setItem("audioPicked", audio.picked);
        }
      }
      audio.setData({
        src: audio.list[audio.picked].src,
        thumb: audio.list[audio.picked].thumb,
        title: audio.list[audio.picked].title
      });
      setTimeout(() => {
        audio.playing = true;
      }, 100);
    };
    const deleteItem = (i) => {
      audio.list.splice(i, 1);
      localStorage.setItem("audioPlayList", JSON.stringify(audio.list));
      if (audio.picked === i) {
        localStorage.setItem("audioPicked", 0);
        audio.picked = null;
        audio.playing = false;
      }
    };
    const play = (val) => {
      if (val) {
        if (!audioBox.value.src.includes(audio.src)) {
          audioBox.value.src = audio.src;
          if (!audio.thumb) {
            audio.thumb = "/audio/default.jpg";
          }
        }
        audio.picked = audio.list.findIndex((item) => item.src === audio.src);
        localStorage.setItem("audioPicked", audio.picked);
        setTimeout(() => {
          audioBox.value.play();
        }, 50);
      } else {
        audioBox.value.pause();
      }
      localStorage.setItem("audioPlayList", JSON.stringify(audio.list));
      localStorage.setItem("audioPicked", audio.picked);
    };
    watch(
      () => audio.src,
      (val) => {
        if (!val) return;
        if (audio.playing) {
          audio.playing = false;
          setTimeout(() => {
            audio.playing = true;
          }, 10);
        }
      }
    );
    watch(
      () => audio.playing,
      (val) => {
        play(val);
      }
    );
    const close = () => {
      audio.playing = false;
      openList.value = false;
      audio.src = "";
    };
    __expose({
      openList,
      audio
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      const _component_el_scrollbar = ElScrollbar;
      const _component_ModulesSingleAudioWaveform = __nuxt_component_2;
      const _component_Image = __nuxt_component_4$1;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "w-full absolute bottom-14 mobile-player right-0",
        ref_key: "playerTrack",
        ref: playerTrack
      }, _attrs, {
        style: unref(audio).src ? null : { display: "none" }
      }))} data-v-701bcee0><div class="${ssrRenderClass(`player-track  ${unref(openList) ? "track-playing" : ""} ${unref(audio).playing ? "playing" : ""} transition-all bg-[--el-bg-color] w-[96%] mx-auto shadow-[0_-4px_6px_-1px_rgba(0,0,0,0.1)] duration-300 rounded-t-lg overflow-hidden ${unref(openList) ? "translate-y-0 opacity-100 visible" : "translate-y-50 opacity-0 invisible"}`)}" data-v-701bcee0><div class="p-2 px-3 flex items-center justify-between text-sm border-b" data-v-701bcee0><span class="font-600" data-v-701bcee0>${ssrInterpolate(_ctx.$t("page.article.video.playList"))}</span>`);
      _push(ssrRenderComponent(_component_el_button, {
        text: "",
        circle: "",
        class: "!m-0 !w6 !h-6 !p-0",
        onClick: ($event) => openList.value = !unref(openList)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-caret-circle-down-fill" data-v-701bcee0${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-caret-circle-down-fill" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_component_el_scrollbar, { height: "186px" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<ul class="flex flex-col divide-y-1" data-v-701bcee0${_scopeId}><!--[-->`);
            ssrRenderList(unref(audio).list, (item, i) => {
              _push2(`<li class="${ssrRenderClass(`group/list flex items-center justify-between p-2 px-4 cursor-pointer ${unref(audio).picked == i ? "bg-[--el-color-info-light-10] text-[--el-color-primary]" : ""}`)}" data-v-701bcee0${_scopeId}><div class="line-clamp-1 flex-1" data-v-701bcee0${_scopeId}>${ssrInterpolate(item.title || _ctx.$t("common.untitled"))}</div><div class="flex text-sm" data-v-701bcee0${_scopeId}><i class="i-ph-x-circle" data-v-701bcee0${_scopeId}></i></div></li>`);
            });
            _push2(`<!--]--></ul>`);
          } else {
            return [
              createVNode("ul", { class: "flex flex-col divide-y-1" }, [
                (openBlock(true), createBlock(Fragment, null, renderList(unref(audio).list, (item, i) => {
                  return openBlock(), createBlock("li", {
                    key: i,
                    class: `group/list flex items-center justify-between p-2 px-4 cursor-pointer ${unref(audio).picked == i ? "bg-[--el-color-info-light-10] text-[--el-color-primary]" : ""}`,
                    onClick: ($event) => playSelect(i)
                  }, [
                    createVNode("div", { class: "line-clamp-1 flex-1" }, toDisplayString(item.title || _ctx.$t("common.untitled")), 1),
                    createVNode("div", {
                      class: "flex text-sm",
                      onClick: withModifiers(($event) => deleteItem(i), ["stop"])
                    }, [
                      createVNode("i", { class: "i-ph-x-circle" })
                    ], 8, ["onClick"])
                  ], 10, ["onClick"]);
                }), 128))
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="flex items-center bg-[--el-bg-color] px-4 audio-box gap-2 relative h-14 justify-between border-t shadow-[0_-4px_6px_-1px_rgba(0,0,0,0.1)]" data-v-701bcee0><div class="flex gap-2 items-center flex-1" data-v-701bcee0>`);
      _push(ssrRenderComponent(_component_el_button, {
        circle: "",
        text: "",
        size: "small",
        class: "!m-0 !p-0",
        onClick: ($event) => nextOrPrev("prev")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-caret-double-left-fill" data-v-701bcee0${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-caret-double-left-fill" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="w-full" data-v-701bcee0>`);
      _push(ssrRenderComponent(_component_ModulesSingleAudioWaveform, {
        audio: {
          thumb: unref(audio)?.thumb,
          src: unref(audio).src,
          name: unref(audio).title
        },
        settings: { attrsPicked: ["waves", "duration"] },
        key: unref(audio).src
      }, null, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_component_el_button, {
        circle: "",
        text: "",
        size: "small",
        class: "!m-0 !p-0",
        onClick: ($event) => nextOrPrev("next")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-caret-double-right-fill" data-v-701bcee0${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-caret-double-right-fill" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="${ssrRenderClass(`rounded-full relative w-9 h-9 mx-2 text-white thumb-box ${unref(audio).playing ? "playing" : ""}`)}" data-v-701bcee0><div class="${ssrRenderClass(` rounded-full w-full h-full`)}" data-v-701bcee0>`);
      if (unref(audio).thumb) {
        _push(ssrRenderComponent(_component_Image, {
          src: unref(audio).thumb || "/audio/default.jpg",
          class: `rounded-full w-full h-full audio-thumb ${unref(audio).playing ? "thumb-ani" : ""}`
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="absolute inset-0 flex items-center justify-center z-1 text-xs" data-v-701bcee0>`);
      if (!unref(audio).playing) {
        _push(`<i class="i-ph-play-fill" data-v-701bcee0></i>`);
      } else {
        _push(`<i class="i-ph-pause-fill" data-v-701bcee0></i>`);
      }
      _push(`</div></div></div><div class="flex gap-2 items-center -mr-2" data-v-701bcee0>`);
      _push(ssrRenderComponent(_component_el_button, {
        type: unref(openList) ? "primary" : "default",
        text: "",
        circle: "",
        class: "!m-0 !w6 !h-6 !p-0",
        onClick: ($event) => openList.value = !unref(openList)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-list-heart-fill" data-v-701bcee0${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-list-heart-fill" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        text: "",
        circle: "",
        class: "!m-0 !w6 !h-6 !p-0",
        onClick: close
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-x-circle" data-v-701bcee0${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-x-circle" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div><audio id="audioBox" data-v-701bcee0></audio></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/mobilePlayer.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_4 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-701bcee0"]]);

export { __nuxt_component_4 as default };
