import { useSSRContext, mergeProps } from 'vue';
import { ssrRenderAttrs, ssrRenderSlot } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';

const _sfc_main = {
  __name: "CommonModuleBox",
  __ssrInlineRender: true,
  props: {
    type: {
      type: String,
      default: ""
    },
    id: {
      type: String,
      default: ""
    },
    index: {
      type: Number,
      default: 0
    },
    settings: {
      type: Object,
      default: () => ({
        animation: false,
        animationIndex: "",
        backgroundCSS: "",
        padding: {
          top: 4,
          right: 4,
          bottom: 4,
          left: 4
        },
        margin: {
          top: 0,
          right: 0,
          bottom: 0,
          left: 0
        },
        radius: {
          topLeft: "small",
          topRight: "small",
          bottomRight: "small",
          bottomLeft: "small"
        }
      })
    }
  },
  setup(__props) {
    const props = __props;
    const moduleClass = () => {
      let _class = "";
      if (props.type == "common.module.post" || props.type == "common.module.topic" || props.type == "common.module.carousel" || props.type == "article.single.comment" || props.type == "page.single.comment" || props.type == "community.single.comment" || props.type == "community.answer.comment" || props.type == "doc.single.comment" || props.type == "shop.single.comment" || props.type == "article.single.category" || props.type == "common.module.topicInfo" || props.type == "common.module.membership" || props.type == "common.module.shop") {
        _class += "!bg-transparent !p-0";
      }
      if (props.type == "common.module.form") {
        _class += " !p-0";
      }
      if (props.type == "article.archive.filter" || props.type == "common.module.postFilter") {
        _class += "z-2";
      }
      return _class;
    };
    const _value = (path) => {
      return props.settings[path[0]]?.[path[1]] ?? props.settings[path[0]];
    };
    const radius = (type) => {
      switch (type) {
        case "base":
          return "4px";
        case "small":
          return "2px";
        case "round":
          return "20px";
        case "circle":
          return "100%";
        default:
          return "none";
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: __props.id,
        class: `container-box ${_value(["animation"]) ? "xyz-in " : ""}
    module ${__props.type.replaceAll(".", "-")} ${moduleClass()}
    ${_value(["border", "right"]) ? "border-r " : ""}
    ${_value(["border", "left"]) ? "border-l " : ""}
    ${_value(["border", "top"]) ? "border-t " : ""}
    ${_value(["border", "bottom"]) ? "border-b " : ""}`,
        style: `
    --tpt:${_value(["padding", "top"]) * 0.25}rem;
    --tpr: ${_value(["padding", "right"]) * 0.25}rem;
    --tpb: ${_value(["padding", "bottom"]) * 0.25}rem;
    --tpl: ${_value(["padding", "left"]) * 0.25}rem;
    --tmt:${_value(["margin", "top"]) * 0.25}rem;
    --tmr:${_value(["margin", "right"]) * 0.25}rem;
    --tmb: ${_value(["margin", "bottom"]) * 0.25}rem;
    --tml: ${_value(["margin", "left"]) * 0.25}rem;
    --trtl:${radius(_value(["radius", "topLeft"]))};
    --trtr:${radius(_value(["radius", "topRight"]))};
    --trbr: ${radius(_value(["radius", "bottomRight"]))};
    --trbl:${radius(_value(["radius", "bottomLeft"]))};
    --tbg:${_ctx.$colorMode.preference == "dark" && _value(["backgroundCSS"]) ? "var(--el-bg-color)" : _value(["backgroundCSS"])};
    --xyz-index:${!_value(["animationIndex"]) ? __props.index : _value(["animationIndex"])};`
      }, _attrs))} data-v-1d9a137a>`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/moduleBox.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_7 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-1d9a137a"]]);

export { __nuxt_component_7 as default };
