import { d as useRoute, j as actionStore, g as getServerSettings, v as viewerStore, a as useI18n, e as useUtils, r as useRequest, x as __nuxt_component_0$1 } from './server.mjs';
import { useSSRContext, ref, computed, reactive } from 'vue';
import { ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonFormMoneyPay",
  __ssrInlineRender: true,
  props: ["data", "show"],
  emits: ["success"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const route = useRoute();
    const waitingRef = ref(null);
    const emits = __emit;
    const action = actionStore();
    const serverSettings = getServerSettings();
    const viewer = viewerStore();
    const { t, locale } = useI18n();
    const couponSelect = ref(null);
    const finalPrice = computed(() => {
      const finalPrice2 = useUtils.sub(
        state.data?.finalPrice,
        state.pickCoupon != null ? state.pickCoupon.faceValue : 0
      );
      if (finalPrice2 < 0) {
        return 0;
      }
      return finalPrice2;
    });
    computed(() => {
      return useUtils.sub(state.data?.price, state.data?.finalPrice);
    });
    computed(() => {
      return state.data?.price;
    });
    const payMethods = serverSettings.payGateways;
    computed(() => {
      return state.pickCoupon.faceValue;
    });
    const state = reactive({
      data: props.data,
      show: props.show,
      coupons: null,
      pickCoupon: null,
      payLocked: false,
      timer: null,
      orderInfo: null,
      count: 0,
      couponList: {
        show: false,
        action: "utils.getPostCoupons",
        args: {
          postId: 0
        }
      },
      payUrl: "",
      showCouponList: () => {
        state.couponList.args.postId = state.data?.postId;
        couponSelect.value.state.show();
      },
      handleRecharge: () => {
        state.show = false;
        useUtils.navigateTo("/account/wealth", "_blank");
      },
      payMethods: {
        CNY: [],
        USD: [],
        EUR: []
      },
      payMethod: "",
      selectPayMethod: (item) => {
        if (finalPrice.value <= 0) {
          state.payMethod = "balance";
        } else {
          state.payMethod = item;
        }
        state.buildPay();
      },
      pickedCoupon: (coupon2) => {
        state.pickCoupon = coupon2;
        if (finalPrice.value <= 0) {
          state.payMethod = "balance";
        }
        if (state.payMethod != "balance") {
          state.buildPay();
        }
      },
      cancelCoupon: () => {
        state.pickCoupon = null;
        if (state.payMethod != "balance") {
          state.buildPay();
        }
      },
      buildPay: async () => {
        if (state.payLocked) {
          return;
        }
        state.payLocked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              postId: state.data?.postId,
              currency: action.currency.iso,
              payment: state.payMethod,
              slug: route.fullPath,
              finalPrice: state.data?.finalPrice,
              type: state.data?.type,
              args: JSON.stringify(state.data.args),
              couponCode: state.pickCoupon !== null ? state.pickCoupon.code : null
            }
          }
        });
        if (res?.gqPay?.success) {
          state.orderInfo = JSON.parse(res.gqPay.data);
          if (state.orderInfo.jumpType == "formPost") {
            state.payUrl = state.orderInfo.result;
          }
        } else {
          state.payLocked = false;
          throw new Error("支付失败");
        }
        state.payLocked = false;
      },
      pay: async () => {
        if (state.payMethod == "balance") {
          try {
            await state.buildPay();
            state.balancePayResult();
          } catch (error) {
            console.error(error);
          }
        } else if (state.orderInfo.jumpType == "scan") {
          state.scanPayResult();
        } else {
          state.jumpToPayPage();
        }
      },
      scanPayResult: (data) => {
        action.qrcode.show = true;
        action.qrcode.data = {
          qrcode: state.orderInfo.qrcode,
          description: t("common.moneyPay.scanPay", [
            payMethods[state.payMethod].name[locale.value] ?? ""
          ]),
          icon: payMethods[state.payMethod].icon,
          amount: finalPrice.value,
          symbol: action.currency.symbol
        };
        state.checkPayResult();
      },
      balancePayResult: () => {
        state.show = false;
        action.success.data = {
          finalPrice: finalPrice.value,
          symbol: action.currency.symbol,
          data: state.data,
          coupon: state.pickCoupon,
          currency: action.currency.iso,
          payment: state.payMethod
        };
        action.success.show = true;
        emits("success", true);
        state.pickCoupon = null;
      },
      showWaiting: () => {
        state.show = false;
        waitingRef.value.state.data = {
          finalPrice: finalPrice.value,
          symbol: action.currency.symbol,
          orderId: state.orderInfo.orderId,
          data: state.data,
          currency: action.currency.iso,
          coupon: state.pickCoupon,
          payment: state.payMethod,
          status: "waiting"
        };
        waitingRef.value.state.show = true;
        state.checkPayResult();
      },
      jumpToPayPage: () => {
        state.showWaiting();
        if (state.orderInfo.jumpType == "formHtml") {
          state.submitForm(state.orderInfo.result);
        }
      },
      //创建一个轮询，检查是否支付完毕
      checkPayResult: async () => {
        const res = await useRequest("/api/request", {
          body: {
            data: {
              orderId: state.orderInfo.orderId
            }
          }
        });
        if (!waitingRef.value.state.show && !action.qrcode.show) {
          state.count = 0;
          clearTimeout(state.timer);
          return;
        }
        if (!res?.gqPayCheck) {
          state.payLocked = false;
          state.count = 0;
          clearTimeout(state.timer);
          return;
        }
        if (res?.gqPayCheck?.success) {
          action.qrcode.show = false;
          waitingRef.value.state.show = false;
          state.balancePayResult();
          state.count = 0;
          clearTimeout(state.timer);
        } else {
          if (state.count > 80) {
            action.qrcode.show = false;
            waitingRef.value.state.data.status = "failed";
            state.count = 0;
            clearTimeout(state.timer);
          } else {
            state.count++;
            state.timer = setTimeout(() => state.checkPayResult(), 2e3);
          }
        }
      },
      submitForm: (html) => {
        const tempDiv = (void 0).createElement("div");
        tempDiv.innerHTML = html;
        const form = tempDiv.querySelector("form");
        if (form) {
          form.setAttribute("target", "_blank");
          (void 0).body.appendChild(form);
          form.submit();
        } else {
          console.error("未找到表单元素");
        }
      }
    });
    const payMethodsObj = {};
    for (let key in payMethods) {
      for (let currency of payMethods[key].currencies) {
        if (!payMethodsObj[currency]) {
          payMethodsObj[currency] = [];
        }
        if (!payMethodsObj[currency].includes(key)) {
          payMethodsObj[currency].push(key);
        }
      }
    }
    state.payMethods = payMethodsObj;
    state.payMethod = state.data?.type == "recharge" || !viewer.data.databaseId ? payMethodsObj[action.currency.iso]?.[0] : "balance";
    __expose({
      state
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(ssrRenderComponent(_component_ClientOnly, _attrs, {}, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/moneyPay.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const moneyPay = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-481528ca"]]);

export { moneyPay as default };
