import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElAvatar } from './index-R6EFYpWa.mjs';
import _sfc_main$1 from './timeAgo-D7-A3XOx.mjs';
import { E as ElEmpty } from './index-Dbj2uCwz.mjs';
import { j as actionStore, v as viewerStore, a as useI18n, w as isLogin, r as useRequest, e as useUtils } from './server.mjs';
import { reactive, toRaw, watch, mergeProps, unref, withCtx, createVNode, createTextVNode, toDisplayString, openBlock, createBlock, Fragment, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderList, ssrRenderStyle } from 'vue/server-renderer';
import { E as ElMessageBox } from './index-LpZkIxNc.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-ChPMoinw.mjs';
import './vnode-l2ZP2UQa.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesAccountNotification",
  __ssrInlineRender: true,
  setup(__props) {
    const action = actionStore();
    const viewer = viewerStore();
    const { t } = useI18n();
    const jsondecodeContent = (content) => {
      if (!content) return "";
      try {
        return JSON.parse(content);
      } catch (error) {
        return content;
      }
    };
    const state = reactive({
      list: null,
      loading: false,
      getMessageList: async (flush = false) => {
        if (!isLogin.value) return;
        if (state.loading) return;
        state.loading = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              userId: viewer.data.databaseId,
              after: flush === true ? null : state.list?.pageInfo?.endCursor || ""
            }
          }
        });
        if (res.guaqi?.utils?.getPrivateMessageUsers) {
          if (state.list?.edges && flush !== true) {
            state.list.edges = [
              ...toRaw(state.list.edges),
              ...res.guaqi.utils.getPrivateMessageUsers.edges
            ];
            state.list.pageInfo = res.guaqi.utils.getPrivateMessageUsers.pageInfo;
          } else {
            state.list = res.guaqi.utils.getPrivateMessageUsers;
          }
        }
        state.loading = false;
      },
      readMessage: (item) => {
        if (item.type == "message") {
          action.pmBox.show = true;
          action.pmBox.to = item.from;
        }
        if (item.type == "notification") {
          action.notification.visible = true;
          action.notification.title = t("page.account.notification.system");
          action.notification.content = item.content;
          action.notification.id = item.id;
          action.notification.toId = item.toId;
        }
        action.notificationRead = item.id;
      },
      allRead: async () => {
        if (!isLogin.value) return;
        const confirm = await ElMessageBox.confirm(
          "确定将全部消息标记为已读吗？",
          "提示",
          {
            confirmButtonText: "确定",
            cancelButtonText: "取消",
            type: "warning",
            customStyle: {
              marginTop: "-40%"
              // 直接设置样式
            }
          }
        ).catch(() => {
          return;
        });
        if (confirm !== "confirm") return;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              userId: viewer.data.databaseId
            }
          }
        });
        if (res?.gqNotificationReadAll.success) {
          state.list?.edges.forEach((item) => {
            item.node.read = 1;
          });
          viewer.data.gqNotification = 0;
        }
      },
      sendMessage: () => {
        action.pmBox.show = true;
      }
    });
    watch(
      () => action.privateMessage,
      (val) => {
        if (val.to.databaseId == viewer.data.databaseId) {
          const index = state.list.edges.findIndex(
            (item) => item.node.from.databaseId == val.from.databaseId
          );
          if (index === -1) {
            state.list.edges.unshift({
              node: {
                to: val.to,
                from: val.from,
                read: 0,
                content: val.msg,
                createdAt: useUtils.getCurrentTime(),
                type: "message"
              }
            });
          } else {
            state.list.edges[index].node.read = 0;
          }
        }
      }
    );
    const init = () => {
      state.getMessageList(true);
    };
    watch(
      () => action.notificationRead,
      (val) => {
        if (val) {
          if (state.list?.edges?.find((item) => item.node.id == val) !== void 0) {
            state.list.edges.find((item) => item.node.id == val).node.read = 1;
          }
        }
      }
    );
    watch(
      () => action.loginAction,
      (val) => {
        state.list = {};
        state.list.edges = [];
        state.list.pageInfo = {};
        state.list = null;
        init();
      }
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      const _component_el_avatar = ElAvatar;
      const _component_TimeAgo = _sfc_main$1;
      const _component_el_empty = ElEmpty;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: `child-load ${unref(state).list?.edges?.length > 0 ? "child-load-success" : ""}`
      }, _attrs))}><div class="flex justify-between items-center xyz-in"><h1 class="ml-4 font-600 xyz-in">${ssrInterpolate(_ctx.$t("page.account.notification.title"))}</h1><div class="flex items-center gap-4 ml-auto"><div>`);
      _push(ssrRenderComponent(_component_el_button, {
        size: "small",
        link: "",
        onClick: unref(state).allRead
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-broom"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("page.account.notification.allRead"))}`);
          } else {
            return [
              createVNode("i", { class: "i-ph-broom" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("page.account.notification.allRead")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div>`);
      _push(ssrRenderComponent(_component_el_button, {
        size: "small",
        plain: "",
        type: "primary",
        onClick: ($event) => ("isLogin" in _ctx ? _ctx.isLogin : unref(isLogin)) ? unref(state).sendMessage() : unref(action).showLogin = true
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-chat-circle-text mr-1"${_scopeId}></i> ${ssrInterpolate(_ctx.$t("page.account.notification.sendMessage"))}`);
          } else {
            return [
              createVNode("i", { class: "i-ph-chat-circle-text mr-1" }),
              createTextVNode(" " + toDisplayString(_ctx.$t("page.account.notification.sendMessage")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div><div class="mt-4 flex flex-col divide-y border-1 rounded-md xyz-in"><!--[-->`);
      ssrRenderList(unref(state).list?.edges || 5, (item, index) => {
        _push(`<div class="p-2.5 hover:bg-[--el-color-info-light-10] flex items-center gap-2 justify-between cursor-pointer transition-all duration-300 xyz-nested" style="${ssrRenderStyle(`--xyz-index:${index % 16};`)}"><div class="relative">`);
        if (item?.node?.type == "message") {
          _push(`<div class="flex items-center justify-center w-9.3 h-9.3 rounded bg-[--el-border-color-light]">`);
          _push(ssrRenderComponent(_component_el_avatar, {
            src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item?.node?.from?.avatar?.url),
            shape: "square",
            size: 37
          }, null, _parent));
          _push(`</div>`);
        } else if (item?.node?.type == "notification") {
          _push(`<div class="flex items-center justify-center w-9.3 h-9.3 rounded bg-[--el-border-color-light]"><i class="i-ph-bell-simple-ringing text-lg"></i></div>`);
        } else {
          _push(`<div class="flex items-center justify-center w-9.3 h-9.3 rounded bg-[--el-border-color-light] gq-gs"><i class="i-ph-bell-simple-ringing text-lg"></i></div>`);
        }
        if (item?.node?.read == 0) {
          _push(`<div class="absolute !w-3 !h-3 bg-[--el-color-danger] rounded-full border-2 border-[--el-bg-color] -right-1 -top-1"></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="flex flex-col gap-0.5 flex-1"><div class="flex items-center gap-1 text-xs opacity-70">`);
        if (item?.node?.type == "message") {
          _push(`<span>${ssrInterpolate(_ctx.$t("page.account.notification.from", [item?.node?.from?.name]))}</span>`);
        } else if (item?.node?.type == "notification") {
          _push(`<span>${ssrInterpolate(_ctx.$t("page.account.notification.system"))}</span>`);
        } else if (item?.node?.type == "ticket") {
          _push(`<span class="gq-gs">${ssrInterpolate(_ctx.$t("page.account.notification.ticket"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="text-[13px]">`);
        if (jsondecodeContent(item?.node?.content)?.type == "report") {
          _push(`<div>${ssrInterpolate(jsondecodeContent(item?.node?.content)?.content)}</div>`);
        } else if (jsondecodeContent(item?.node?.content)?.type == "system") {
          _push(`<div>${ssrInterpolate(jsondecodeContent(item?.node?.content)?.title)}</div>`);
        } else if (jsondecodeContent(item?.node?.content)?.type == "mention") {
          _push(`<div>`);
          if (jsondecodeContent(item?.node?.content)?.content_type == "comment") {
            _push(`<span>有人 @ 你了，快去看看吧</span>`);
          } else if (jsondecodeContent(item?.node?.content)?.content_type == "reply") {
            _push(`<span>有人在评论中回复你了，快去看看吧</span>`);
          } else {
            _push(`<span>有人在文章中 @ 你了，快去看看吧</span>`);
          }
          _push(`</div>`);
        } else if (jsondecodeContent(item?.node?.content)?.type == "promotion") {
          _push(`<div><span> 您获得了推广提成！ </span></div>`);
        } else {
          _push(`<span class="gq-gs line-clamp-1">${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).stripHtml(item?.node?.content) || "This is a long notification content")}</span>`);
        }
        _push(`</div></div>`);
        _push(ssrRenderComponent(_component_TimeAgo, {
          date: item.node?.createdAt,
          class: "gq-gs text-xs opacity-80"
        }, null, _parent));
        _push(`</div>`);
      });
      _push(`<!--]-->`);
      if (unref(state).list?.edges?.length == 0) {
        _push(`<div class="p-2.5 text-center text-xs opacity-70">`);
        _push(ssrRenderComponent(_component_el_empty, {
          description: _ctx.$t("page.account.notification.noMessage")
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(state).list?.edges?.length > 0) {
        _push(`<div class="p-2.5 text-center text-xs opacity-70 xyz-nested" style="${ssrRenderStyle(`--xyz-index:${unref(state).list?.edges?.length};`)}">`);
        _push(ssrRenderComponent(_component_el_button, {
          size: "small",
          text: "",
          type: "primary",
          onClick: unref(state).getMessageList,
          disabled: unref(state).loading || !unref(state).list?.pageInfo?.hasNextPage,
          loading: unref(state).loading
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (unref(state).list?.pageInfo?.hasNextPage) {
                _push2(`<!--[-->${ssrInterpolate(_ctx.$t("page.account.notification.more"))}<!--]-->`);
              } else {
                _push2(`<!--[-->${ssrInterpolate(_ctx.$t("page.account.notification.noMore"))}<!--]-->`);
              }
            } else {
              return [
                unref(state).list?.pageInfo?.hasNextPage ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                  createTextVNode(toDisplayString(_ctx.$t("page.account.notification.more")), 1)
                ], 64)) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                  createTextVNode(toDisplayString(_ctx.$t("page.account.notification.noMore")), 1)
                ], 64))
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/account/notification.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
