import _sfc_main$1 from './blink-DRvWMg-X.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { a as useI18n, g as getServerSettings, b as useSeoMeta, d as useRoute, n as navigateTo$1, e as useUtils } from './server.mjs';
import { ref, withAsyncContext, mergeProps, unref, withCtx, createTextVNode, toDisplayString, createVNode, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './nuxt-link-Dd6LuEo9.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "notify",
  __ssrInlineRender: true,
  async setup(__props) {
    let __temp, __restore;
    const { t } = useI18n();
    const settingsStore = getServerSettings();
    useSeoMeta({
      title: () => t("page.notify.title"),
      ogTitle: () => t("page.notify.title")
    });
    const route = useRoute();
    const post = route.query;
    const data = ref(null);
    if (Object.keys(post).length == 0) {
      [__temp, __restore] = withAsyncContext(() => navigateTo$1("/404")), await __temp, __restore();
    }
    const locked = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Blink = _sfc_main$1;
      const _component_el_button = ElButton;
      _push(`<main${ssrRenderAttrs(mergeProps({
        class: `flex justify-center mt-4 ${unref(locked) && unref(data)?.order_status && unref(data)?.order_status != "unpaid" ? "load-success" : ""}`
      }, _attrs))} data-v-0d195733><article class="w-full max-w-xs bg-[--el-bg-color] h-full overflow-hidden rounded-md shadow p-4" data-v-0d195733><div class="flex justify-center mb-2 text-center" data-v-0d195733>`);
      if (!unref(locked)) {
        _push(`<i class="i-ph-coffee-thin text-5xl text-[var(--el-color-success)]" data-v-0d195733></i>`);
      } else if (unref(data)?.order_status && unref(data)?.order_status != "unpaid") {
        _push(`<i class="i-ph-check-circle-thin text-5xl text-[var(--el-color-success)]" data-v-0d195733></i>`);
      } else {
        _push(`<i class="i-ph-x-circle-thin text-5xl text-[var(--el-color-danger)]" data-v-0d195733></i>`);
      }
      _push(`</div><h1 class="text-lg font-600 mb-1 text-center" data-v-0d195733>`);
      if (!unref(locked)) {
        _push(`<span data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.confirming"))}</span>`);
      } else if (unref(data)?.order_status && unref(data)?.order_status != "unpaid") {
        _push(`<span data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.success"))}</span>`);
      } else {
        _push(`<span data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.failed"))}</span>`);
      }
      _push(`</h1><div class="opacity-50 mb-4 text-sm text-center" data-v-0d195733>`);
      if (!unref(locked)) {
        _push(`<p data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.confirmingDesc"))}</p>`);
      } else if (unref(data)?.order_status && unref(data)?.order_status != "unpaid") {
        _push(`<p data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.desc"))}</p>`);
      } else {
        _push(`<p data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.failedDesc"))}</p>`);
      }
      _push(`</div><div class="w-full border-1 rounded-md text-sm divide-y grid grid-cols-2 overflow-hidden" data-v-0d195733><div class="item col-span-2" data-v-0d195733><span class="opacity-50" data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.productTitle"))}：</span>`);
      _push(ssrRenderComponent(_component_Blink, {
        class: "text-sm text-[--el-color-primary] gq-gs",
        to: unref(data)?.slug
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(unref(data)?.product_type || "My Goods")}`);
          } else {
            return [
              createTextVNode(toDisplayString(unref(data)?.product_type || "My Goods"), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="item col-span-2" data-v-0d195733><span class="opacity-50" data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.orderId"))}：</span><span class="text-sm gq-gs" data-v-0d195733>${ssrInterpolate(unref(data)?.order_id || "123456678")}</span></div><div class="item" data-v-0d195733><span class="opacity-50" data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.orderCount"))}：</span><span class="text-sm gq-gs" data-v-0d195733>${ssrInterpolate(unref(data)?.count || 1)}</span></div><div class="item" data-v-0d195733><span class="opacity-50" data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.amount"))}：</span><span class="text-sm gq-gs" data-v-0d195733>${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).isoToSymbol(
        unref(data)?.currency || "CNY",
        unref(settingsStore).currency
      ) + ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(data)?.final_amount || 0, unref(data)?.currency))}</span></div><div class="item" data-v-0d195733><span class="opacity-50" data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.currency"))}：</span><span class="text-sm gq-gs" data-v-0d195733>${ssrInterpolate(unref(data)?.currency || "CNY")}</span></div><div class="item" data-v-0d195733><span class="opacity-50" data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.status"))}：</span><span class="text-sm gq-gs" data-v-0d195733>${ssrInterpolate(_ctx.$t("page.account.orders.status." + (unref(data)?.order_status || "unpaid")))}</span></div><div class="item" data-v-0d195733><span class="opacity-50" data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.paymentMethod"))}：</span><span class="text-sm gq-gs" data-v-0d195733>${ssrInterpolate(unref(data)?.payment_method || "alipay")}</span></div><div class="item" data-v-0d195733><span class="opacity-50" data-v-0d195733>${ssrInterpolate(_ctx.$t("page.notify.orderDate"))}：</span><span class="text-sm gq-gs" data-v-0d195733>${ssrInterpolate(unref(data)?.created_at || "2023-01-01")}</span></div></div><div class="flex justify-between mt-4 gap-2" data-v-0d195733>`);
      _push(ssrRenderComponent(_component_el_button, {
        type: "primary",
        size: "small",
        plain: "",
        onClick: ($event) => ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).navigateTo("/")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-house mr-1" data-v-0d195733${_scopeId}></i>${ssrInterpolate(_ctx.$t("page.notify.home"))}`);
          } else {
            return [
              createVNode("i", { class: "i-ph-house mr-1" }),
              createTextVNode(toDisplayString(_ctx.$t("page.notify.home")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        type: "primary",
        size: "small",
        plain: "",
        onClick: ($event) => ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).navigateTo(unref(data)?.slug || "/")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-handbag mr-1" data-v-0d195733${_scopeId}></i>${ssrInterpolate(_ctx.$t("page.notify.continueShopping"))}`);
          } else {
            return [
              createVNode("i", { class: "i-ph-handbag mr-1" }),
              createTextVNode(toDisplayString(_ctx.$t("page.notify.continueShopping")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        type: "primary",
        size: "small",
        plain: "",
        onClick: ($event) => ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).navigateTo("/account/orders")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-clipboard-text mr-1" data-v-0d195733${_scopeId}></i>${ssrInterpolate(_ctx.$t("page.notify.orders"))}`);
          } else {
            return [
              createVNode("i", { class: "i-ph-clipboard-text mr-1" }),
              createTextVNode(toDisplayString(_ctx.$t("page.notify.orders")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></article></main>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/pages/notify.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const notify = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-0d195733"]]);

export { notify as default };
