import _sfc_main$1 from './creditIcon-eOdkwofx.mjs';
import { j as actionStore, e as useUtils, x as __nuxt_component_0$1, w as isLogin } from './server.mjs';
import { ref, computed, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderClass, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import './svgIcon-BpIUCf-e.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonFormPay",
  __ssrInlineRender: true,
  props: [
    "settings",
    "formData",
    "id",
    "verifyKey",
    "type",
    "title",
    "size",
    "disabled"
  ],
  emits: ["update:formData"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const action = actionStore();
    const payRef = ref(null);
    const hasPaid = ref({
      money: false,
      credit: false
    });
    const currentPay = ref(null);
    const payMoney = computed(() => {
      if (props.settings?.payMoney?.dynamic_array?.length > 0) {
        for (let i = 0; i < props.settings?.payMoney?.dynamic_array?.length; i++) {
          if (props.settings?.payMoney?.dynamic_array?.[i]?.condition && useUtils.checkCondition(
            props.settings?.payMoney?.dynamic_array?.[i]?.condition,
            props.formData
          )) {
            return props.settings?.payMoney?.dynamic_array[i];
          }
        }
      }
      return props.settings?.payMoney;
    });
    const pay = () => {
      const type = props.settings.pay_type;
      if (!isLogin.value && type == "credit") {
        action.showLogin = true;
        return;
      }
      currentPay.value = type;
      payRef.value.state.show({
        title: props.title,
        thumb: "",
        postId: props.id,
        args: {
          key: props.verifyKey,
          type: props.type,
          formData: props.formData
        },
        payment: type,
        count: 0,
        type: "form",
        finalPrice: type == "money" ? payMoney.value?.final[action.currency.iso] : props.settings.payCredit,
        price: type == "money" ? payMoney.value?.price[action.currency.iso] : props.settings.payCredit
      });
    };
    __expose({
      pay
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommonCreditIcon = _sfc_main$1;
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="gap-2">`);
      if (__props.settings.pay_type == "money" && unref(payMoney)?.final) {
        _push(`<div class="${ssrRenderClass(`flex items-center justify-between bg-[--el-color-info-light-10] border-1 ${__props.size == "small" ? "p-2" : "p-3"} rounded-md`)}"><div><div class="flex gap-1 items-baseline"><div class="text-2xl flex items-baseline leading-none"><span class="opacity-70 mr-1">${ssrInterpolate(unref(action).currency.symbol)}</span> ${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(payMoney)?.final[unref(action).currency.iso] || 0, unref(action).currency.iso))}</div>`);
        if (unref(payMoney)?.final[unref(action).currency.iso] == unref(payMoney)?.salePrice[unref(action).currency.iso]) {
          _push(`<div class="text-xs flex flex-col items-baseline leading-none opacity-80 ml-2"><span class="decoration-line-through">${ssrInterpolate(unref(action).currency.symbol)}${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(payMoney)?.price[unref(action).currency.iso] || 0, unref(action).currency.iso))}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        if (unref(payMoney).saleRange.from) {
          _push(`<div class="text-xs leading-none mt-2">`);
          if (unref(payMoney).saleRange.to) {
            _push(`<span class="text-[--el-color-warning-dark-2]">${ssrInterpolate(_ctx.$t("page.modules.form.pay.expire", [unref(payMoney).saleRange.to]))}</span>`);
          } else {
            _push(`<span class="text-[--el-color-warning-dark-2]">${ssrInterpolate(_ctx.$t("page.modules.form.pay.forever"))}</span>`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        if (__props.settings.moneyPaid || unref(hasPaid).money) {
          _push(`<span class="flex items-center text-xs gap-1 text-[--el-color-success-dark-2]"><i class="i-ph-check-circle-duotone"></i> ${ssrInterpolate(_ctx.$t("page.modules.form.pay.paid"))}</span>`);
        } else {
          _push(`<span class="flex"><i class="i-ph-scroll-thin w-7 h-7 opacity-40"></i></span>`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.settings.pay_type == "credit" && __props.settings.payCredit) {
        _push(`<div class="${ssrRenderClass(`border-1  ${__props.size == "small" ? "p-2" : "p-3"} rounded-md flex items-center justify-between bg-[--el-color-info-light-10]`)}"><div><div class="flex text-2xl items-baseline leading-none">`);
        _push(ssrRenderComponent(_component_CommonCreditIcon, { class: "w-3 h-3 opacity-70 mr-1" }, null, _parent));
        _push(` ${ssrInterpolate(__props.settings.payCredit)}</div>`);
        if (__props.settings.creditPaid || unref(hasPaid).credit) {
          _push(`<span class="flex items-center text-xs gap-1 text-[--el-color-success-dark-2]"><i class="i-ph-check-circle-duotone"></i> ${ssrInterpolate(_ctx.$t("page.modules.form.pay.paid"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><span class="flex"><i class="i-ph-scroll-thin w-10 h-10 opacity-40"></i></span></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/form/pay.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
