import { shallowRef, reactive, createVNode, resolveDynamicComponent, unref, mergeProps, useSSRContext } from 'vue';
import { ssrRenderVNode } from 'vue/server-renderer';
import { l as loadComponent } from './server.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonPay",
  __ssrInlineRender: true,
  emits: ["success"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const currentComponent = shallowRef(null);
    const _loadComponent = (payment) => {
      return loadComponent("common/form", payment == "credit" ? "creditPay" : "moneyPay");
    };
    const emits = __emit;
    const success = (data) => {
      emits("success", data);
    };
    const state = reactive({
      data: {},
      showAction: false,
      show: async (data) => {
        currentComponent.value = _loadComponent(data.payment);
        state.data = data;
        state.showAction = true;
      }
    });
    __expose({
      state
    });
    return (_ctx, _push, _parent, _attrs) => {
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(unref(currentComponent)), mergeProps({
        data: unref(state).data,
        show: unref(state).showAction,
        onSuccess: success
      }, _attrs), null), _parent);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/pay.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
