import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { useSSRContext, ref, watch, mergeProps, unref, withCtx, createVNode, openBlock, createBlock, Fragment, renderList, toDisplayString, withModifiers } from 'vue';
import { ssrRenderAttrs, ssrRenderClass, ssrInterpolate, ssrRenderComponent, ssrRenderList, ssrRenderStyle } from 'vue/server-renderer';
import { a as audioStore } from './audio-CfS8Ng0x.mjs';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './server.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';
import './index-DRiwogtD.mjs';
import './index-ChPMoinw.mjs';
import './style-h263bamF.mjs';
import './image-viewer-DG2qIWb8.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-CRbm0e05.mjs';
import './index-Di0Jlzch.mjs';
import './index-BKB3Djp4.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';

Array(16).fill(0);
const _sfc_main = {
  __name: "CommonPlayer",
  __ssrInlineRender: true,
  setup(__props) {
    const audio = audioStore();
    const audioBox = ref(null);
    ref(null);
    const openList = ref(false);
    ref(null);
    ref(null);
    ref(null);
    ref(null);
    ref(null);
    ref(null);
    const playSelect = (i) => {
      audio.picked = i;
      localStorage.setItem("audioPicked", i);
      audio.src = audio.list[i].src;
      audio.title = audio.list[i].title;
      audio.thumb = audio.list[i].thumb;
      setTimeout(() => {
        audio.playing = true;
      }, 100);
    };
    const nextOrPrev = (type) => {
      if (audio.list.length === 0) return;
      if (audio.picked === -1) {
        audio.picked = 0;
        localStorage.setItem("audioPicked", 0);
        if (!audio.list[0]) return;
        audio.src = audio.list[0].src;
        audio.title = audio.list[0].title;
        audio.thumb = audio.list[0].thumb;
        setTimeout(() => {
          audio.playing = true;
        }, 100);
        return;
      }
      if (type === "next") {
        if (audio.picked === audio.list.length - 1) {
          audio.picked = 0;
          localStorage.setItem("audioPicked", 0);
        } else {
          audio.picked++;
          localStorage.setItem("audioPicked", audio.picked);
        }
      } else {
        if (audio.picked === 0) {
          audio.picked = audio.list.length - 1;
        } else {
          audio.picked--;
          localStorage.setItem("audioPicked", audio.picked);
        }
      }
      audio.setData({
        src: audio.list[audio.picked].src,
        thumb: audio.list[audio.picked].thumb,
        title: audio.list[audio.picked].title
      });
      setTimeout(() => {
        audio.playing = true;
      }, 100);
    };
    const deleteItem = (i) => {
      audio.list.splice(i, 1);
      localStorage.setItem("audioPlayList", JSON.stringify(audio.list));
      if (audio.picked === i) {
        localStorage.setItem("audioPicked", 0);
        audio.picked = null;
        audio.playing = false;
      }
    };
    const play = (val) => {
      if (val) {
        if (!audioBox.value.src.includes(audio.src)) {
          audioBox.value.src = audio.src;
          if (!audio.thumb) {
            audio.thumb = "/audio/default.jpg";
          }
        }
        audio.picked = audio.list.findIndex((item) => item.src === audio.src);
        localStorage.setItem("audioPicked", audio.picked);
        if (audio.list[audio.picked]) {
          audioBox.value.currentTime = audio.list[audio.picked].currentTime || 0;
        }
        setTimeout(() => {
          audioBox.value.play();
        }, 50);
      } else {
        audioBox.value.pause();
      }
      localStorage.setItem("audioPlayList", JSON.stringify(audio.list));
      localStorage.setItem("audioPicked", audio.picked);
    };
    watch(
      () => audio.src,
      (val) => {
        if (!val) return;
        if (audio.playing) {
          audio.playing = false;
          setTimeout(() => {
            audio.playing = true;
          }, 10);
        }
      }
    );
    watch(
      () => audio.playing,
      (val) => {
        if (val) {
          play(val);
        } else {
          audioBox.value.pause();
        }
      }
    );
    const close = () => {
      audio.playing = false;
      openList.value = false;
      audio.src = "";
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_scrollbar = ElScrollbar;
      const _component_Image = __nuxt_component_4;
      const _component_el_button = ElButton;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full absolute bottom-0 right-16 w-64" }, _attrs, {
        style: unref(audio).src ? null : { display: "none" }
      }))} data-v-a30e0037><div class="${ssrRenderClass(`player-track overflow-hidden ${unref(openList) ? "track-playing" : ""} ${unref(audio).playing ? "playing" : ""}`)}" data-v-a30e0037><div class="w-[90%] bg-[var(--el-bg-color)] mx-auto border-1 rounded-xl relative shadow-lg player-track-in" data-v-a30e0037><div class="flex justify-between items-center py-2 px-2 opacity-70" data-v-a30e0037><div class="flex text-sm items-center gap-1 overflow-hidden" data-v-a30e0037><span class="line-clamp-1 flex-1" data-v-a30e0037>${ssrInterpolate(unref(audio).title || _ctx.$t("common.untitled"))}</span></div><div class="ml-2 flex justify-end gap-2 cursor-pointer" data-v-a30e0037><div class="flex" data-v-a30e0037><i class="i-ph-list-heart" data-v-a30e0037></i></div></div></div><div class="${ssrRenderClass(`duration-700 translate-opacity border-t text-sm ${unref(openList) ? "opacity-100" : "opacity-0"}`)}" data-v-a30e0037>`);
      _push(ssrRenderComponent(_component_el_scrollbar, { height: "186px" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<ul class="flex flex-col divide-y-1" data-v-a30e0037${_scopeId}><!--[-->`);
            ssrRenderList(unref(audio).list, (item, i) => {
              _push2(`<li class="${ssrRenderClass(`group/list flex items-center justify-between hover:bg-[--el-color-info-light-10] p-2 px-4 cursor-pointer ${unref(audio).picked == i ? "bg-[--el-color-info-light-10] text-[--el-color-primary]" : ""}`)}" data-v-a30e0037${_scopeId}><div class="line-clamp-1 flex-1" data-v-a30e0037${_scopeId}>${ssrInterpolate(item.title || _ctx.$t("common.untitled"))}</div><div class="hidden group-hover/list:flex" data-v-a30e0037${_scopeId}><i class="i-ph-x-circle" data-v-a30e0037${_scopeId}></i></div></li>`);
            });
            _push2(`<!--]--></ul>`);
          } else {
            return [
              createVNode("ul", { class: "flex flex-col divide-y-1" }, [
                (openBlock(true), createBlock(Fragment, null, renderList(unref(audio).list, (item, i) => {
                  return openBlock(), createBlock("li", {
                    key: i,
                    class: `group/list flex items-center justify-between hover:bg-[--el-color-info-light-10] p-2 px-4 cursor-pointer ${unref(audio).picked == i ? "bg-[--el-color-info-light-10] text-[--el-color-primary]" : ""}`,
                    onClick: ($event) => playSelect(i)
                  }, [
                    createVNode("div", { class: "line-clamp-1 flex-1" }, toDisplayString(item.title || _ctx.$t("common.untitled")), 1),
                    createVNode("div", {
                      class: "hidden group-hover/list:flex",
                      onClick: withModifiers(($event) => deleteItem(i), ["stop"])
                    }, [
                      createVNode("i", { class: "i-ph-x-circle" })
                    ], 8, ["onClick"])
                  ], 10, ["onClick"]);
                }), 128))
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div><div class="flex items-center border-1 bg-[--el-bg-color] rounded px-5 audio-box gap-5 relative h-20 group/player" data-v-a30e0037><canvas height="18" width="164" class="${ssrRenderClass(`absolute right-5.2 translate-opacity duration-300 pointer-events-none -top-6.7 ${unref(audio).playing ? "opacity-40" : "opacity-0"}`)}" data-v-a30e0037></canvas><div class="${ssrRenderClass(`rounded-full relative w-13 shadow-lg h-13 thumb-box ${unref(audio).playing ? "playing" : ""}`)}" data-v-a30e0037><div class="${ssrRenderClass(`audio-thumb ${unref(audio).playing ? "thumb-ani" : ""} rounded-full w-full h-full`)}" data-v-a30e0037>`);
      if (unref(audio).thumb) {
        _push(ssrRenderComponent(_component_Image, {
          src: unref(audio).thumb || "/audio/default.jpg",
          class: "rounded-full w-full h-full"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div><div class="flex flex-col" data-v-a30e0037><div class="flex gap-6 items-center" data-v-a30e0037>`);
      _push(ssrRenderComponent(_component_el_button, {
        circle: "",
        bg: "",
        text: "",
        class: "m-0",
        onClick: ($event) => nextOrPrev("prev")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-caret-double-left-fill" data-v-a30e0037${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-caret-double-left-fill" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        circle: "",
        bg: "",
        text: "",
        onClick: ($event) => unref(audio).playing = !unref(audio).playing,
        class: "flex cursor-pointer !m-0"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (!unref(audio).playing) {
              _push2(`<i class="i-ph-play-fill" data-v-a30e0037${_scopeId}></i>`);
            } else {
              _push2(`<i class="i-ph-pause-fill" data-v-a30e0037${_scopeId}></i>`);
            }
          } else {
            return [
              !unref(audio).playing ? (openBlock(), createBlock("i", {
                key: 0,
                class: "i-ph-play-fill"
              })) : (openBlock(), createBlock("i", {
                key: 1,
                class: "i-ph-pause-fill"
              }))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        circle: "",
        bg: "",
        text: "",
        class: "!m-0",
        onClick: ($event) => nextOrPrev("next")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-caret-double-right-fill" data-v-a30e0037${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-caret-double-right-fill" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="flex items-center w-full flex-col cursor-pointer progressContainer" data-v-a30e0037><div id="track-time" class="active flex justify-between w-full text-[10px] opacity-50 pointer-events-none" data-v-a30e0037><span id="current-time" data-v-a30e0037>00:00</span><span id="track-length" data-v-a30e0037>00:00</span></div><div class="bg-[--el-text-color-placeholder] w-full h-1 rounded-md relative pointer-events-none" data-v-a30e0037><span id="ins-time" class="absolute bg-[--el-text-color-primary] text-white -top-5 text-[10px] px-1 rounded-md hidden -translate-x-3.5" style="${ssrRenderStyle({ "left": "0px" })}" data-v-a30e0037>00:00</span><span id="seek-bar" class="bg-red absolute inset-0 rounded-md" style="${ssrRenderStyle({ "width": "0px" })}" data-v-a30e0037></span><span id="s-hover" class="absolute inset-0 bg-[--el-color-error-light-5] rounded-md" style="${ssrRenderStyle({ "width": "0px" })}" data-v-a30e0037></span></div></div></div>`);
      _push(ssrRenderComponent(_component_el_button, {
        circle: "",
        text: "",
        bg: "",
        class: "!m-0 !p-1 !w-6 !h-6 absolute -right-2 -top-2 border-1 !hidden group-hover/player:!block",
        onClick: close
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-x" data-v-a30e0037${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-x" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><audio id="audioBox" data-v-a30e0037></audio></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/player.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const player = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-a30e0037"]]);

export { player as default };
