import { E as ElButton } from './index-DYnTqrQe.mjs';
import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import __nuxt_component_2 from './waveform-CcdD4iaE.mjs';
import { a as useI18n } from './server.mjs';
import { useSSRContext, computed, mergeProps, withCtx, createVNode, createTextVNode, unref } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderList } from 'vue/server-renderer';
import { a as audioStore } from './audio-CfS8Ng0x.mjs';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import 'lodash-unified';
import './image-viewer-DG2qIWb8.mjs';
import './index-ChPMoinw.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-Di0Jlzch.mjs';
import './index-BKB3Djp4.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonFormPodcast",
  __ssrInlineRender: true,
  props: ["podcast"],
  setup(__props) {
    const props = __props;
    const audio = audioStore();
    const isPlaying = computed(() => {
      return props.podcast.some((item) => item.audio === audio.src);
    });
    const playIndex = computed(() => {
      const index = props.podcast.findIndex((item) => item?.audio === audio.src);
      return index == -1 ? 0 : index;
    });
    const { locale } = useI18n();
    const handlePlay = (item) => {
      {
        for (let i = 0; i < props.podcast.length; i++) {
          audio.setData({
            thumb: props.podcast[i]?.image,
            src: props.podcast[i].audio,
            name: props.podcast[i].title[locale.value],
            duration: props.podcast[i].duration
          });
        }
        setTimeout(() => {
          audio.picked = 0;
        }, 100);
        setTimeout(() => {
          localStorage.setItem("audioPicked", 0);
          audio.src = audio.list[0].src;
          audio.title = audio.list[0].title;
          audio.thumb = audio.list[0].thumb;
          audio.playing = true;
        }, 200);
        return;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      const _component_Image = __nuxt_component_4;
      const _component_ModulesSingleAudioWaveform = __nuxt_component_2;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "podcast text-sm" }, _attrs))} data-v-b922a49e><div class="absolute top-[calc(var(--tpt)*0.7)] right-[var(--tpr)] overflow-hidden" data-v-b922a49e>`);
      _push(ssrRenderComponent(_component_el_button, {
        type: "primary",
        class: "!text-[--el-color-primary]",
        link: "",
        size: "small",
        onClick: ($event) => handlePlay()
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-list-heart mr-1" data-v-b922a49e${_scopeId}></i>播放全部 `);
          } else {
            return [
              createVNode("i", { class: "i-ph-list-heart mr-1" }),
              createTextVNode("播放全部 ")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="block @md:hidden cursor-pointer" data-v-b922a49e><div class="relative h-0 pt-full overflow-hidden mr-[--tpr] ml-[--tpl] mt-[--tpt] mb-[--tpb] rounded-md" data-v-b922a49e>`);
      _push(ssrRenderComponent(_component_Image, {
        src: __props.podcast?.length > 0 ? __props.podcast[unref(playIndex)]?.image : "",
        alt: __props.podcast?.length > 0 ? __props.podcast[unref(playIndex)]?.title[_ctx.$i18n.locale] : "",
        class: "h-full w-full !absolute top-0 left-0",
        fit: "cover"
      }, null, _parent));
      if (unref(isPlaying)) {
        _push(`<div class="absolute top-3 left-3 bg-[--el-color-primary] text-white px-2 py-0.7 rounded-md text-[11px] flex items-center gap-1" data-v-b922a49e><span class="relative flex h-2 w-2" data-v-b922a49e><span class="absolute inline-flex h-full w-full rounded-full bg-white animate-ping opacity-75" data-v-b922a49e></span><span class="relative inline-flex rounded-full h-2 w-2 bg-white" data-v-b922a49e></span></span>正在播放 </div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="absolute inset-0 bg-gradient-to-t from-black/70 via-black/20 to-transparent" data-v-b922a49e></div><div class="absolute bottom-3 left-3 text-white text-xs" data-v-b922a49e><span class="text-[--el-color-white] opacity-75" data-v-b922a49e>EPISODE ${ssrInterpolate(unref(playIndex) + 1 + "/" + props.podcast.length)}</span><div class="line-clamp-1 text-sm" data-v-b922a49e>${ssrInterpolate(__props.podcast?.length > 0 ? __props.podcast[unref(playIndex)]?.title[_ctx.$i18n.locale] : "")}</div></div><span class="absolute right-[50%] top-[50%] translate-x-[50%] translate-y-[-50%] flex text-white" data-v-b922a49e>`);
      if (__props.podcast[unref(playIndex)]?.audio === unref(audio).src && unref(audio).playing) {
        _push(`<i class="i-ph-pause-fill" data-v-b922a49e></i>`);
      } else {
        _push(`<i class="i-ph-play-fill w-6 h-6" data-v-b922a49e></i>`);
      }
      _push(`</span></div></div><div class="auto-grid divide-y overflow-hidden border-t" style="${ssrRenderStyle({ "--gq-grid-min-width": "220px" })}" data-v-b922a49e><!--[-->`);
      ssrRenderList(__props.podcast, (item, i) => {
        _push(`<div class="podcast-item flex items-center gap-2 pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.7)] pb-[calc(var(--tpl)*0.7)] cursor-pointer -mt-[1px]" data-v-b922a49e><div class="relative w-10 h-10 overflow-hidden rounded-md gq-gs" data-v-b922a49e>`);
        _push(ssrRenderComponent(_component_Image, {
          src: item.image,
          alt: item.title[_ctx.$i18n.locale],
          class: "h-full w-full",
          fit: "cover"
        }, null, _parent));
        _push(`<span class="absolute top-0 left-0 w-full h-full bg-black/20" data-v-b922a49e></span><span class="absolute right-[50%] top-[50%] translate-x-[50%] translate-y-[-50%] flex text-white" data-v-b922a49e>`);
        if (item.audio === unref(audio).src && unref(audio).playing) {
          _push(`<i class="i-ph-pause-fill" data-v-b922a49e></i>`);
        } else {
          _push(`<i class="i-ph-play-fill" data-v-b922a49e></i>`);
        }
        _push(`</span></div><div class="w-full flex-1 flex flex-col gap-1" data-v-b922a49e><div class="flex items-center gap-2 @md:text-sm text-xs mr-6" data-v-b922a49e><span class="line-clamp-1" data-v-b922a49e>${ssrInterpolate(item.title[_ctx.$i18n.locale])}</span></div><div class="bg-[--el-color-info-light-10] p-1 rounded" data-v-b922a49e>`);
        _push(ssrRenderComponent(_component_ModulesSingleAudioWaveform, {
          audio: {
            thumb: item?.image,
            src: item.audio,
            name: item.title[_ctx.$i18n.locale],
            duration: item.duration
          },
          onClick: () => {
          },
          settings: { attrsPicked: ["waves", "duration"] }
        }, null, _parent));
        _push(`</div></div></div>`);
      });
      _push(`<!--]--></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/form/podcast.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const podcast = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-b922a49e"]]);

export { podcast as default };
