import { E as ElButton } from './index-DYnTqrQe.mjs';
import { defineComponent, getCurrentInstance, ref, computed, h, inject, reactive, watch, provide, Fragment, useSSRContext, isRef, unref, watchEffect, mergeProps, withCtx, createTextVNode, toDisplayString, createVNode, resolveComponent, openBlock, createBlock, createElementVNode, normalizeClass, renderSlot, createElementBlock, renderList, Comment, resolveDirective, normalizeStyle, withDirectives, createCommentVNode, vShow, toRefs, nextTick, isVNode, render } from 'vue';
import { debounce, isNull, merge, castArray, flatMap, get } from 'lodash-unified';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { u as useTooltipContentProps, E as ElTooltip } from './index-Cx5QSQzK.mjs';
import { isArray, isString, hasOwn, isFunction, isObject } from '@vue/shared';
import { F as arrow_up_default, G as arrow_down_default, D as useLocale, C as useNamespace, H as isPropAbsent, J as isClient$1, K as useSizeProp, P as withInstall, Q as withNoopInstall, y as isUndefined, a as useI18n, I as isElement, A as isBoolean$1, L as isNumber$1, B as getProp, M as arrow_right_default, r as useRequest, z as throwError, N as loading_default } from './server.mjs';
import { E as ElCheckboxGroup, a as ElCheckbox } from './index-VQeHi7JP.mjs';
import { E as ElIcon } from './index-CRbm0e05.mjs';
import { g as getEventCode, b as EVENT_CODE, _ as _export_sfc$1 } from './focus-trap.vue-9ChHxs3Q.mjs';
import { b as addClass, r as removeClass, h as hasClass } from './style-h263bamF.mjs';
import { b as useFormSize } from './use-form-item-Cr81A1TZ.mjs';
import normalizeWheel from 'normalize-wheel-es';
import _sfc_main$4 from './blink-DRvWMg-X.mjs';
import { E as ElAvatar } from './index-R6EFYpWa.mjs';
import _sfc_main$5 from './timeAgo-D7-A3XOx.mjs';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderList, ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-31HAFSrO.mjs';
import '@ctrl/tinycolor';
import './index-DRiwogtD.mjs';
import './index-ChPMoinw.mjs';
import '@popperjs/core';
import './aria-BhThsKez.mjs';
import './constants-hAKFmBbq.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './event-BZTOGHfp.mjs';
import './nuxt-link-Dd6LuEo9.mjs';
import './vnode-l2ZP2UQa.mjs';

const getCell = function(event) {
  var _a;
  return (_a = event.target) == null ? void 0 : _a.closest("td");
};
const orderBy = function(array, sortKey, reverse, sortMethod, sortBy) {
  if (!sortKey && !sortMethod && (!sortBy || isArray(sortBy) && !sortBy.length)) {
    return array;
  }
  if (isString(reverse)) {
    reverse = reverse === "descending" ? -1 : 1;
  } else {
    reverse = reverse && reverse < 0 ? -1 : 1;
  }
  const getKey = sortMethod ? null : function(value, index) {
    if (sortBy) {
      return flatMap(castArray(sortBy), (by) => {
        if (isString(by)) {
          return get(value, by);
        } else {
          return by(value, index, array);
        }
      });
    }
    if (sortKey !== "$key") {
      if (isObject(value) && "$value" in value) value = value.$value;
    }
    return [
      isObject(value) ? sortKey ? get(value, sortKey) : null : value
    ];
  };
  const compare = function(a, b) {
    var _a, _b, _c, _d, _e, _f;
    if (sortMethod) {
      return sortMethod(a.value, b.value);
    }
    for (let i = 0, len = (_b = (_a = a.key) == null ? void 0 : _a.length) != null ? _b : 0; i < len; i++) {
      if (((_c = a.key) == null ? void 0 : _c[i]) < ((_d = b.key) == null ? void 0 : _d[i])) {
        return -1;
      }
      if (((_e = a.key) == null ? void 0 : _e[i]) > ((_f = b.key) == null ? void 0 : _f[i])) {
        return 1;
      }
    }
    return 0;
  };
  return array.map((value, index) => {
    return {
      value,
      index,
      key: getKey ? getKey(value, index) : null
    };
  }).sort((a, b) => {
    let order = compare(a, b);
    if (!order) {
      order = a.index - b.index;
    }
    return order * +reverse;
  }).map((item) => item.value);
};
const getColumnById = function(table, columnId) {
  let column = null;
  table.columns.forEach((item) => {
    if (item.id === columnId) {
      column = item;
    }
  });
  return column;
};
const getColumnByKey = function(table, columnKey) {
  let column = null;
  for (let i = 0; i < table.columns.length; i++) {
    const item = table.columns[i];
    if (item.columnKey === columnKey) {
      column = item;
      break;
    }
  }
  if (!column)
    throwError("ElTable", `No column matching with column-key: ${columnKey}`);
  return column;
};
const getColumnByCell = function(table, cell, namespace) {
  const matches = (cell.className || "").match(
    new RegExp(`${namespace}-table_[^\\s]+`, "gm")
  );
  if (matches) {
    return getColumnById(table, matches[0]);
  }
  return null;
};
const getRowIdentity = (row, rowKey) => {
  if (!row) throw new Error("Row is required when get row identity");
  if (isString(rowKey)) {
    if (!rowKey.includes(".")) {
      return `${row[rowKey]}`;
    }
    const key = rowKey.split(".");
    let current = row;
    for (const element of key) {
      current = current[element];
    }
    return `${current}`;
  } else if (isFunction(rowKey)) {
    return rowKey.call(null, row);
  }
  return "";
};
const getKeysMap = function(array, rowKey, flatten = false, childrenKey = "children") {
  const data = array || [];
  const arrayMap = {};
  data.forEach((row, index) => {
    arrayMap[getRowIdentity(row, rowKey)] = { row, index };
    if (flatten) {
      const children = row[childrenKey];
      if (isArray(children)) {
        Object.assign(arrayMap, getKeysMap(children, rowKey, true, childrenKey));
      }
    }
  });
  return arrayMap;
};
function parseWidth(width) {
  if (width === "") return width;
  if (!isUndefined(width)) {
    width = Number.parseInt(width, 10);
    if (Number.isNaN(width)) {
      width = "";
    }
  }
  return width;
}
function parseMinWidth(minWidth) {
  if (minWidth === "") return minWidth;
  if (!isUndefined(minWidth)) {
    minWidth = parseWidth(minWidth);
    if (Number.isNaN(minWidth)) {
      minWidth = 80;
    }
  }
  return minWidth;
}
function toggleRowStatus(statusArr, row, newVal, tableTreeProps, selectable, rowIndex, rowKey) {
  let _rowIndex = rowIndex != null ? rowIndex : 0;
  let changed = false;
  const getIndex = () => {
    if (!rowKey) {
      return statusArr.indexOf(row);
    }
    const id = getRowIdentity(row, rowKey);
    return statusArr.findIndex((item) => getRowIdentity(item, rowKey) === id);
  };
  const index = getIndex();
  const included = index !== -1;
  const isRowSelectable = selectable == null ? void 0 : selectable.call(null, row, _rowIndex);
  const toggleStatus = (type) => {
    if (type === "add") {
      statusArr.push(row);
    } else {
      statusArr.splice(index, 1);
    }
    changed = true;
  };
  const getChildrenCount = (row2) => {
    let count = 0;
    const children = (tableTreeProps == null ? void 0 : tableTreeProps.children) && row2[tableTreeProps.children];
    if (children && isArray(children)) {
      count += children.length;
      children.forEach((item) => {
        count += getChildrenCount(item);
      });
    }
    return count;
  };
  if (!selectable || isRowSelectable) {
    if (isBoolean$1(newVal)) {
      if (newVal && !included) {
        toggleStatus("add");
      } else if (!newVal && included) {
        toggleStatus("remove");
      }
    } else {
      included ? toggleStatus("remove") : toggleStatus("add");
    }
  }
  if (!(tableTreeProps == null ? void 0 : tableTreeProps.checkStrictly) && (tableTreeProps == null ? void 0 : tableTreeProps.children) && isArray(row[tableTreeProps.children])) {
    row[tableTreeProps.children].forEach((item) => {
      const childChanged = toggleRowStatus(
        statusArr,
        item,
        newVal != null ? newVal : !included,
        tableTreeProps,
        selectable,
        _rowIndex + 1,
        rowKey
      );
      _rowIndex += getChildrenCount(item) + 1;
      if (childChanged) {
        changed = childChanged;
      }
    });
  }
  return changed;
}
function walkTreeNode(root, cb, childrenKey = "children", lazyKey = "hasChildren", lazy = false) {
  const isNil = (array) => !(isArray(array) && array.length);
  function _walker(parent, children, level) {
    cb(parent, children, level);
    children.forEach((item) => {
      if (item[lazyKey] && lazy) {
        cb(item, null, level + 1);
        return;
      }
      const children2 = item[childrenKey];
      if (!isNil(children2)) {
        _walker(item, children2, level + 1);
      }
    });
  }
  root.forEach((item) => {
    if (item[lazyKey] && lazy) {
      cb(item, null, 0);
      return;
    }
    const children = item[childrenKey];
    if (!isNil(children)) {
      _walker(item, children, 0);
    }
  });
}
const getTableOverflowTooltipProps = (props, innerText, row, column) => {
  const popperOptions = {
    strategy: "fixed",
    ...props.popperOptions
  };
  const tooltipFormatterContent = isFunction(column == null ? void 0 : column.tooltipFormatter) ? column.tooltipFormatter({
    row,
    column,
    cellValue: getProp(row, column.property).value
  }) : void 0;
  if (isVNode(tooltipFormatterContent)) {
    return {
      slotContent: tooltipFormatterContent,
      content: null,
      ...props,
      popperOptions
    };
  }
  return {
    slotContent: null,
    content: tooltipFormatterContent != null ? tooltipFormatterContent : innerText,
    ...props,
    popperOptions
  };
};
let removePopper = null;
function createTablePopper(props, popperContent, row, column, trigger, table) {
  var _a;
  const tableOverflowTooltipProps = getTableOverflowTooltipProps(
    props,
    popperContent,
    row,
    column
  );
  const mergedProps = {
    ...tableOverflowTooltipProps,
    slotContent: void 0
  };
  if ((removePopper == null ? void 0 : removePopper.trigger) === trigger) {
    const comp = (_a = removePopper.vm) == null ? void 0 : _a.component;
    merge(comp == null ? void 0 : comp.props, mergedProps);
    if (comp && tableOverflowTooltipProps.slotContent) {
      comp.slots.content = () => [tableOverflowTooltipProps.slotContent];
    }
    return;
  }
  removePopper == null ? void 0 : removePopper();
  const parentNode = table == null ? void 0 : table.refs.tableWrapper;
  const ns = parentNode == null ? void 0 : parentNode.dataset.prefix;
  const vm = createVNode(
    ElTooltip,
    {
      virtualTriggering: true,
      virtualRef: trigger,
      appendTo: parentNode,
      placement: "top",
      transition: "none",
      // Default does not require transition
      offset: 0,
      hideAfter: 0,
      ...mergedProps
    },
    tableOverflowTooltipProps.slotContent ? {
      content: () => tableOverflowTooltipProps.slotContent
    } : void 0
  );
  vm.appContext = { ...table.appContext, ...table };
  const container = (void 0).createElement("div");
  render(vm, container);
  vm.component.exposed.onOpen();
  const scrollContainer = parentNode == null ? void 0 : parentNode.querySelector(`.${ns}-scrollbar__wrap`);
  removePopper = () => {
    var _a2, _b;
    if ((_b = (_a2 = vm.component) == null ? void 0 : _a2.exposed) == null ? void 0 : _b.onClose) {
      vm.component.exposed.onClose();
    }
    render(null, container);
    const currentRemovePopper = removePopper;
    scrollContainer == null ? void 0 : scrollContainer.removeEventListener("scroll", currentRemovePopper);
    currentRemovePopper.trigger = void 0;
    currentRemovePopper.vm = void 0;
    removePopper = null;
  };
  removePopper.trigger = trigger != null ? trigger : void 0;
  removePopper.vm = vm;
  scrollContainer == null ? void 0 : scrollContainer.addEventListener("scroll", removePopper);
}
function getCurrentColumns(column) {
  if (column.children) {
    return flatMap(column.children, getCurrentColumns);
  } else {
    return [column];
  }
}
function getColSpan(colSpan, column) {
  return colSpan + column.colSpan;
}
const isFixedColumn = (index, fixed, store, realColumns) => {
  let start = 0;
  let after = index;
  const columns = store.states.columns.value;
  if (realColumns) {
    const curColumns = getCurrentColumns(realColumns[index]);
    const preColumns = columns.slice(0, columns.indexOf(curColumns[0]));
    start = preColumns.reduce(getColSpan, 0);
    after = start + curColumns.reduce(getColSpan, 0) - 1;
  } else {
    start = index;
  }
  let fixedLayout;
  switch (fixed) {
    case "left":
      if (after < store.states.fixedLeafColumnsLength.value) {
        fixedLayout = "left";
      }
      break;
    case "right":
      if (start >= columns.length - store.states.rightFixedLeafColumnsLength.value) {
        fixedLayout = "right";
      }
      break;
    default:
      if (after < store.states.fixedLeafColumnsLength.value) {
        fixedLayout = "left";
      } else if (start >= columns.length - store.states.rightFixedLeafColumnsLength.value) {
        fixedLayout = "right";
      }
  }
  return fixedLayout ? {
    direction: fixedLayout,
    start,
    after
  } : {};
};
const getFixedColumnsClass = (namespace, index, fixed, store, realColumns, offset = 0) => {
  const classes = [];
  const { direction, start, after } = isFixedColumn(
    index,
    fixed,
    store,
    realColumns
  );
  if (direction) {
    const isLeft = direction === "left";
    classes.push(`${namespace}-fixed-column--${direction}`);
    if (isLeft && after + offset === store.states.fixedLeafColumnsLength.value - 1) {
      classes.push("is-last-column");
    } else if (!isLeft && start - offset === store.states.columns.value.length - store.states.rightFixedLeafColumnsLength.value) {
      classes.push("is-first-column");
    }
  }
  return classes;
};
function getOffset(offset, column) {
  return offset + (isNull(column.realWidth) || Number.isNaN(column.realWidth) ? Number(column.width) : column.realWidth);
}
const getFixedColumnOffset = (index, fixed, store, realColumns) => {
  const {
    direction,
    start = 0,
    after = 0
  } = isFixedColumn(index, fixed, store, realColumns);
  if (!direction) {
    return;
  }
  const styles = {};
  const isLeft = direction === "left";
  const columns = store.states.columns.value;
  if (isLeft) {
    styles.left = columns.slice(0, start).reduce(getOffset, 0);
  } else {
    styles.right = columns.slice(after + 1).reverse().reduce(getOffset, 0);
  }
  return styles;
};
const ensurePosition = (style, key) => {
  if (!style) return;
  if (!Number.isNaN(style[key])) {
    style[key] = `${style[key]}px`;
  }
};
function ensureValidVNode(vnodes) {
  return vnodes.some((child) => {
    if (!isVNode(child)) return true;
    if (child.type === Comment) return false;
    if (child.type === Fragment && !ensureValidVNode(child.children)) {
      return false;
    }
    return true;
  }) ? vnodes : null;
}
function useExpand(watcherData) {
  const instance = getCurrentInstance();
  const defaultExpandAll = ref(false);
  const expandRows = ref([]);
  const canRowExpand = (row, index) => {
    var _a;
    const expandableFn = instance.store.states.rowExpandable.value;
    return (_a = expandableFn == null ? void 0 : expandableFn(row, index)) != null ? _a : true;
  };
  const updateExpandRows = () => {
    const data = watcherData.data.value || [];
    const rowKey = watcherData.rowKey.value;
    if (defaultExpandAll.value) {
      expandRows.value = instance.store.states.rowExpandable.value ? data.filter(canRowExpand) : data.slice();
    } else if (rowKey) {
      const expandRowsMap = getKeysMap(expandRows.value, rowKey);
      expandRows.value = data.filter((row, index) => {
        const rowId = getRowIdentity(row, rowKey);
        return !!expandRowsMap[rowId] && canRowExpand(row, index);
      });
    } else {
      expandRows.value = [];
    }
  };
  const toggleRowExpansion = (row, expanded) => {
    const dataArr = watcherData.data.value || [];
    const rowIndex = dataArr.indexOf(row);
    if (rowIndex > -1 && !canRowExpand(row, rowIndex)) return;
    const changed = toggleRowStatus(
      expandRows.value,
      row,
      expanded,
      void 0,
      void 0,
      void 0,
      watcherData.rowKey.value
    );
    if (changed) {
      instance.emit("expand-change", row, expandRows.value.slice());
    }
  };
  const setExpandRowKeys = (rowKeys) => {
    instance.store.assertRowKey();
    const data = watcherData.data.value || [];
    const rowKey = watcherData.rowKey.value;
    const keysMap = getKeysMap(data, rowKey);
    expandRows.value = rowKeys.reduce((prev, cur) => {
      const info = keysMap[cur];
      if (info && canRowExpand(info.row, info.index)) {
        prev.push(info.row);
      }
      return prev;
    }, []);
  };
  const isRowExpanded = (row) => {
    const rowKey = watcherData.rowKey.value;
    if (rowKey) {
      const expandMap = getKeysMap(expandRows.value, rowKey);
      return !!expandMap[getRowIdentity(row, rowKey)];
    }
    return expandRows.value.includes(row);
  };
  return {
    updateExpandRows,
    toggleRowExpansion,
    setExpandRowKeys,
    isRowExpanded,
    states: {
      expandRows,
      defaultExpandAll
    }
  };
}
function useCurrent(watcherData) {
  const instance = getCurrentInstance();
  const _currentRowKey = ref(null);
  const currentRow = ref(null);
  const setCurrentRowKey = (key) => {
    instance.store.assertRowKey();
    _currentRowKey.value = key;
    setCurrentRowByKey(key);
  };
  const restoreCurrentRowKey = () => {
    _currentRowKey.value = null;
  };
  const setCurrentRowByKey = (key) => {
    var _a;
    const { data, rowKey } = watcherData;
    const oldCurrentRow = currentRow.value;
    let _currentRow = null;
    if (rowKey.value) {
      _currentRow = (_a = (unref(data) || []).find(
        (item) => getRowIdentity(item, rowKey.value) === key
      )) != null ? _a : null;
    }
    currentRow.value = _currentRow != null ? _currentRow : null;
    instance.emit("current-change", currentRow.value, oldCurrentRow);
  };
  const updateCurrentRow = (_currentRow) => {
    const oldCurrentRow = currentRow.value;
    if (_currentRow && _currentRow !== oldCurrentRow) {
      currentRow.value = _currentRow;
      instance.emit("current-change", currentRow.value, oldCurrentRow);
      return;
    }
    if (!_currentRow && oldCurrentRow) {
      currentRow.value = null;
      instance.emit("current-change", null, oldCurrentRow);
    }
  };
  const updateCurrentRowData = () => {
    const rowKey = watcherData.rowKey.value;
    const data = watcherData.data.value || [];
    const oldCurrentRow = currentRow.value;
    if (oldCurrentRow && !data.includes(oldCurrentRow)) {
      if (rowKey) {
        const currentRowKey = getRowIdentity(oldCurrentRow, rowKey);
        setCurrentRowByKey(currentRowKey);
      } else {
        currentRow.value = null;
        instance.emit("current-change", null, oldCurrentRow);
      }
    } else if (_currentRowKey.value) {
      setCurrentRowByKey(_currentRowKey.value);
      restoreCurrentRowKey();
    }
  };
  return {
    setCurrentRowKey,
    restoreCurrentRowKey,
    setCurrentRowByKey,
    updateCurrentRow,
    updateCurrentRowData,
    states: {
      _currentRowKey,
      currentRow
    }
  };
}
function useTree(watcherData) {
  const expandRowKeys = ref([]);
  const treeData = ref({});
  const indent = ref(16);
  const lazy = ref(false);
  const lazyTreeNodeMap = ref({});
  const lazyColumnIdentifier = ref("hasChildren");
  const childrenColumnName = ref("children");
  const checkStrictly = ref(false);
  const instance = getCurrentInstance();
  const normalizedData = computed(() => {
    if (!watcherData.rowKey.value) return {};
    const data = watcherData.data.value || [];
    return normalize(data);
  });
  const normalizedLazyNode = computed(() => {
    const rowKey = watcherData.rowKey.value;
    const keys = Object.keys(lazyTreeNodeMap.value);
    const res = {};
    if (!keys.length) return res;
    keys.forEach((key) => {
      if (lazyTreeNodeMap.value[key].length) {
        const item = { children: [] };
        lazyTreeNodeMap.value[key].forEach((row) => {
          const currentRowKey = getRowIdentity(row, rowKey);
          item.children.push(currentRowKey);
          if (row[lazyColumnIdentifier.value] && !res[currentRowKey]) {
            res[currentRowKey] = { children: [] };
          }
        });
        res[key] = item;
      }
    });
    return res;
  });
  const normalize = (data) => {
    const rowKey = watcherData.rowKey.value;
    const res = {};
    walkTreeNode(
      data,
      (parent, children, level) => {
        const parentId = getRowIdentity(parent, rowKey);
        if (isArray(children)) {
          res[parentId] = {
            children: children.map((row) => getRowIdentity(row, rowKey)),
            level
          };
        } else if (lazy.value) {
          res[parentId] = {
            children: [],
            lazy: true,
            level
          };
        }
      },
      childrenColumnName.value,
      lazyColumnIdentifier.value,
      lazy.value
    );
    return res;
  };
  const updateTreeData = (ifChangeExpandRowKeys = false, ifExpandAll) => {
    var _a, _b;
    ifExpandAll || (ifExpandAll = (_a = instance.store) == null ? void 0 : _a.states.defaultExpandAll.value);
    const nested = normalizedData.value;
    const normalizedLazyNode_ = normalizedLazyNode.value;
    const keys = Object.keys(nested);
    const newTreeData = {};
    if (keys.length) {
      const oldTreeData = unref(treeData);
      const rootLazyRowKeys = [];
      const getExpanded = (oldValue, key) => {
        if (ifChangeExpandRowKeys) {
          if (expandRowKeys.value) {
            return ifExpandAll || expandRowKeys.value.includes(key);
          } else {
            return !!(ifExpandAll || (oldValue == null ? void 0 : oldValue.expanded));
          }
        } else {
          const included = ifExpandAll || expandRowKeys.value && expandRowKeys.value.includes(key);
          return !!((oldValue == null ? void 0 : oldValue.expanded) || included);
        }
      };
      keys.forEach((key) => {
        const oldValue = oldTreeData[key];
        const newValue = { ...nested[key] };
        newValue.expanded = getExpanded(oldValue, key);
        if (newValue.lazy) {
          const { loaded = false, loading = false } = oldValue || {};
          newValue.loaded = !!loaded;
          newValue.loading = !!loading;
          rootLazyRowKeys.push(key);
        }
        newTreeData[key] = newValue;
      });
      const lazyKeys = Object.keys(normalizedLazyNode_);
      if (lazy.value && lazyKeys.length && rootLazyRowKeys.length) {
        lazyKeys.forEach((key) => {
          var _a2;
          const oldValue = oldTreeData[key];
          const lazyNodeChildren = normalizedLazyNode_[key].children;
          if (rootLazyRowKeys.includes(key)) {
            if (((_a2 = newTreeData[key].children) == null ? void 0 : _a2.length) !== 0) {
              throw new Error("[ElTable]children must be an empty array.");
            }
            newTreeData[key].children = lazyNodeChildren;
          } else {
            const { loaded = false, loading = false } = oldValue || {};
            newTreeData[key] = {
              lazy: true,
              loaded: !!loaded,
              loading: !!loading,
              expanded: getExpanded(oldValue, key),
              children: lazyNodeChildren,
              level: void 0
            };
          }
        });
      }
    }
    treeData.value = newTreeData;
    (_b = instance.store) == null ? void 0 : _b.updateTableScrollY();
  };
  watch(
    () => expandRowKeys.value,
    () => {
      updateTreeData(true);
    }
  );
  watch(
    () => normalizedData.value,
    () => {
      updateTreeData();
    }
  );
  watch(
    () => normalizedLazyNode.value,
    () => {
      updateTreeData();
    }
  );
  const updateTreeExpandKeys = (value) => {
    expandRowKeys.value = value;
    updateTreeData();
  };
  const isUseLazy = (data) => {
    return lazy.value && data && "loaded" in data && !data.loaded;
  };
  const toggleTreeExpansion = (row, expanded) => {
    instance.store.assertRowKey();
    const rowKey = watcherData.rowKey.value;
    const id = getRowIdentity(row, rowKey);
    const data = id && treeData.value[id];
    if (id && data && "expanded" in data) {
      const oldExpanded = data.expanded;
      expanded = isUndefined(expanded) ? !data.expanded : expanded;
      treeData.value[id].expanded = expanded;
      if (oldExpanded !== expanded) {
        instance.emit("expand-change", row, expanded);
      }
      expanded && isUseLazy(data) && loadData(row, id, data);
      instance.store.updateTableScrollY();
    }
  };
  const loadOrToggle = (row) => {
    instance.store.assertRowKey();
    const rowKey = watcherData.rowKey.value;
    const id = getRowIdentity(row, rowKey);
    const data = treeData.value[id];
    if (isUseLazy(data)) {
      loadData(row, id, data);
    } else {
      toggleTreeExpansion(row, void 0);
    }
  };
  const loadData = (row, key, treeNode) => {
    const { load } = instance.props;
    if (load && !treeData.value[key].loaded) {
      treeData.value[key].loading = true;
      load(row, treeNode, (data) => {
        if (!isArray(data)) {
          throw new TypeError("[ElTable] data must be an array");
        }
        treeData.value[key].loading = false;
        treeData.value[key].loaded = true;
        treeData.value[key].expanded = true;
        if (data.length) {
          lazyTreeNodeMap.value[key] = data;
        }
        instance.emit("expand-change", row, true);
      });
    }
  };
  const updateKeyChildren = (key, data) => {
    const { lazy: lazy2, rowKey } = instance.props;
    if (!lazy2) return;
    if (!rowKey) throw new Error("[Table] rowKey is required in updateKeyChild");
    if (lazyTreeNodeMap.value[key]) {
      lazyTreeNodeMap.value[key] = data;
    }
  };
  return {
    loadData,
    loadOrToggle,
    toggleTreeExpansion,
    updateTreeExpandKeys,
    updateTreeData,
    updateKeyChildren,
    normalize,
    states: {
      expandRowKeys,
      treeData,
      indent,
      lazy,
      lazyTreeNodeMap,
      lazyColumnIdentifier,
      childrenColumnName,
      checkStrictly
    }
  };
}
const sortData = (data, states) => {
  const sortingColumn = states.sortingColumn;
  if (!sortingColumn || isString(sortingColumn.sortable)) {
    return data;
  }
  return orderBy(
    data,
    states.sortProp,
    states.sortOrder,
    sortingColumn.sortMethod,
    sortingColumn.sortBy
  );
};
const doFlattenColumns = (columns) => {
  const result = [];
  columns.forEach((column) => {
    if (column.children && column.children.length > 0) {
      result.push.apply(result, doFlattenColumns(column.children));
    } else {
      result.push(column);
    }
  });
  return result;
};
function useWatcher$1() {
  var _a;
  const instance = getCurrentInstance();
  const { size: tableSize } = toRefs((_a = instance.proxy) == null ? void 0 : _a.$props);
  const rowKey = ref(null);
  const data = ref([]);
  const _data = ref([]);
  const isComplex = ref(false);
  const _columns = ref([]);
  const originColumns = ref([]);
  const columns = ref([]);
  const fixedColumns = ref([]);
  const rightFixedColumns = ref([]);
  const leafColumns = ref([]);
  const fixedLeafColumns = ref([]);
  const rightFixedLeafColumns = ref([]);
  const updateOrderFns = [];
  const leafColumnsLength = ref(0);
  const fixedLeafColumnsLength = ref(0);
  const rightFixedLeafColumnsLength = ref(0);
  const isAllSelected = ref(false);
  const selection = ref([]);
  const reserveSelection = ref(false);
  const selectOnIndeterminate = ref(false);
  const selectable = ref(null);
  const rowExpandable = ref(null);
  const filters = ref({});
  const filteredData = ref(null);
  const sortingColumn = ref(null);
  const sortProp = ref(null);
  const sortOrder = ref(null);
  const hoverRow = ref(null);
  const selectedMap = computed(() => {
    return rowKey.value ? getKeysMap(selection.value, rowKey.value) : void 0;
  });
  watch(
    data,
    () => {
      var _a2;
      if (instance.state) {
        scheduleLayout(false);
        const needUpdateFixed = instance.props.tableLayout === "auto";
        if (needUpdateFixed) {
          (_a2 = instance.refs.tableHeaderRef) == null ? void 0 : _a2.updateFixedColumnStyle();
        }
      }
    },
    {
      deep: true
    }
  );
  const assertRowKey = () => {
    if (!rowKey.value) throw new Error("[ElTable] prop row-key is required");
  };
  const updateChildFixed = (column) => {
    var _a2;
    (_a2 = column.children) == null ? void 0 : _a2.forEach((childColumn) => {
      childColumn.fixed = column.fixed;
      updateChildFixed(childColumn);
    });
  };
  const updateColumns = () => {
    _columns.value.forEach((column) => {
      updateChildFixed(column);
    });
    fixedColumns.value = _columns.value.filter(
      (column) => [true, "left"].includes(column.fixed)
    );
    const selectColumn = _columns.value.find(
      (column) => column.type === "selection"
    );
    let selectColFixLeft;
    if (selectColumn && selectColumn.fixed !== "right" && !fixedColumns.value.includes(selectColumn)) {
      const selectColumnIndex = _columns.value.indexOf(selectColumn);
      if (selectColumnIndex === 0 && fixedColumns.value.length) {
        fixedColumns.value.unshift(selectColumn);
        selectColFixLeft = true;
      }
    }
    rightFixedColumns.value = _columns.value.filter(
      (column) => column.fixed === "right"
    );
    const notFixedColumns = _columns.value.filter(
      (column) => (selectColFixLeft ? column.type !== "selection" : true) && !column.fixed
    );
    originColumns.value = Array.from(fixedColumns.value).concat(notFixedColumns).concat(rightFixedColumns.value);
    const leafColumns2 = doFlattenColumns(notFixedColumns);
    const fixedLeafColumns2 = doFlattenColumns(fixedColumns.value);
    const rightFixedLeafColumns2 = doFlattenColumns(rightFixedColumns.value);
    leafColumnsLength.value = leafColumns2.length;
    fixedLeafColumnsLength.value = fixedLeafColumns2.length;
    rightFixedLeafColumnsLength.value = rightFixedLeafColumns2.length;
    columns.value = Array.from(fixedLeafColumns2).concat(leafColumns2).concat(rightFixedLeafColumns2);
    isComplex.value = fixedColumns.value.length > 0 || rightFixedColumns.value.length > 0;
  };
  const scheduleLayout = (needUpdateColumns, immediate = false) => {
    if (needUpdateColumns) {
      updateColumns();
    }
    if (immediate) {
      instance.state.doLayout();
    } else {
      instance.state.debouncedUpdateLayout();
    }
  };
  const isSelected = (row) => {
    if (selectedMap.value) {
      return !!selectedMap.value[getRowIdentity(row, rowKey.value)];
    } else {
      return selection.value.includes(row);
    }
  };
  const clearSelection = () => {
    isAllSelected.value = false;
    const oldSelection = selection.value;
    selection.value = [];
    if (oldSelection.length) {
      instance.emit("selection-change", []);
    }
  };
  const cleanSelection = () => {
    var _a2, _b;
    let deleted;
    if (rowKey.value) {
      deleted = [];
      const childrenKey = (_b = (_a2 = instance == null ? void 0 : instance.store) == null ? void 0 : _a2.states) == null ? void 0 : _b.childrenColumnName.value;
      const dataMap = getKeysMap(data.value, rowKey.value, true, childrenKey);
      for (const key in selectedMap.value) {
        if (hasOwn(selectedMap.value, key) && !dataMap[key]) {
          deleted.push(selectedMap.value[key].row);
        }
      }
    } else {
      deleted = selection.value.filter((item) => !data.value.includes(item));
    }
    if (deleted.length) {
      const newSelection = selection.value.filter(
        (item) => !deleted.includes(item)
      );
      selection.value = newSelection;
      instance.emit("selection-change", newSelection.slice());
    }
  };
  const getSelectionRows = () => {
    return (selection.value || []).slice();
  };
  const toggleRowSelection = (row, selected, emitChange = true, ignoreSelectable = false) => {
    var _a2, _b, _c, _d;
    const treeProps = {
      children: (_b = (_a2 = instance == null ? void 0 : instance.store) == null ? void 0 : _a2.states) == null ? void 0 : _b.childrenColumnName.value,
      checkStrictly: (_d = (_c = instance == null ? void 0 : instance.store) == null ? void 0 : _c.states) == null ? void 0 : _d.checkStrictly.value
    };
    const changed = toggleRowStatus(
      selection.value,
      row,
      selected,
      treeProps,
      ignoreSelectable ? void 0 : selectable.value,
      data.value.indexOf(row),
      rowKey.value
    );
    if (changed) {
      const newSelection = (selection.value || []).slice();
      if (emitChange) {
        instance.emit("select", newSelection, row);
      }
      instance.emit("selection-change", newSelection);
    }
  };
  const _toggleAllSelection = () => {
    var _a2, _b;
    const value = selectOnIndeterminate.value ? !isAllSelected.value : !(isAllSelected.value || selection.value.length);
    isAllSelected.value = value;
    let selectionChanged = false;
    let childrenCount = 0;
    const rowKey2 = (_b = (_a2 = instance == null ? void 0 : instance.store) == null ? void 0 : _a2.states) == null ? void 0 : _b.rowKey.value;
    const { childrenColumnName } = instance.store.states;
    const treeProps = {
      children: childrenColumnName.value,
      checkStrictly: false
      // Disable checkStrictly when selecting all
    };
    data.value.forEach((row, index) => {
      const rowIndex = index + childrenCount;
      if (toggleRowStatus(
        selection.value,
        row,
        value,
        treeProps,
        selectable.value,
        rowIndex,
        rowKey2
      )) {
        selectionChanged = true;
      }
      childrenCount += getChildrenCount(getRowIdentity(row, rowKey2));
    });
    if (selectionChanged) {
      instance.emit(
        "selection-change",
        selection.value ? selection.value.slice() : []
      );
    }
    instance.emit("select-all", (selection.value || []).slice());
  };
  const updateAllSelected = () => {
    var _a2;
    if (((_a2 = data.value) == null ? void 0 : _a2.length) === 0) {
      isAllSelected.value = false;
      return;
    }
    const { childrenColumnName } = instance.store.states;
    let rowIndex = 0;
    let selectedCount = 0;
    const checkSelectedStatus = (data2) => {
      var _a3;
      for (const row of data2) {
        const isRowSelectable = selectable.value && selectable.value.call(null, row, rowIndex);
        if (!isSelected(row)) {
          if (!selectable.value || isRowSelectable) {
            return false;
          }
        } else {
          selectedCount++;
        }
        rowIndex++;
        if (((_a3 = row[childrenColumnName.value]) == null ? void 0 : _a3.length) && !checkSelectedStatus(row[childrenColumnName.value])) {
          return false;
        }
      }
      return true;
    };
    const isAllSelected_ = checkSelectedStatus(data.value || []);
    isAllSelected.value = selectedCount === 0 ? false : isAllSelected_;
  };
  const getChildrenCount = (rowKey2) => {
    var _a2;
    if (!instance || !instance.store) return 0;
    const { treeData } = instance.store.states;
    let count = 0;
    const children = (_a2 = treeData.value[rowKey2]) == null ? void 0 : _a2.children;
    if (children) {
      count += children.length;
      children.forEach((childKey) => {
        count += getChildrenCount(childKey);
      });
    }
    return count;
  };
  const updateFilters = (column, values) => {
    const filters_ = {};
    castArray(column).forEach((col) => {
      filters.value[col.id] = values;
      filters_[col.columnKey || col.id] = values;
    });
    return filters_;
  };
  const updateSort = (column, prop, order) => {
    if (sortingColumn.value && sortingColumn.value !== column) {
      sortingColumn.value.order = null;
    }
    sortingColumn.value = column;
    sortProp.value = prop;
    sortOrder.value = order;
  };
  const execFilter = () => {
    let sourceData = unref(_data);
    Object.keys(filters.value).forEach((columnId) => {
      const values = filters.value[columnId];
      if (!values || values.length === 0) return;
      const column = getColumnById(
        {
          columns: columns.value
        },
        columnId
      );
      if (column && column.filterMethod) {
        sourceData = sourceData.filter((row) => {
          return values.some(
            (value) => column.filterMethod.call(null, value, row, column)
          );
        });
      }
    });
    filteredData.value = sourceData;
  };
  const execSort = () => {
    var _a2;
    data.value = sortData((_a2 = filteredData.value) != null ? _a2 : [], {
      sortingColumn: sortingColumn.value,
      sortProp: sortProp.value,
      sortOrder: sortOrder.value
    });
  };
  const execQuery = (ignore = void 0) => {
    if (!(ignore == null ? void 0 : ignore.filter)) {
      execFilter();
    }
    execSort();
  };
  const clearFilter = (columnKeys) => {
    const { tableHeaderRef } = instance.refs;
    if (!tableHeaderRef) return;
    const panels = Object.assign({}, tableHeaderRef.filterPanels);
    const keys = Object.keys(panels);
    if (!keys.length) return;
    if (isString(columnKeys)) {
      columnKeys = [columnKeys];
    }
    if (isArray(columnKeys)) {
      const columns_ = columnKeys.map(
        (key) => getColumnByKey(
          {
            columns: columns.value
          },
          key
        )
      );
      keys.forEach((key) => {
        const column = columns_.find((col) => col.id === key);
        if (column) {
          column.filteredValue = [];
        }
      });
      instance.store.commit("filterChange", {
        column: columns_,
        values: [],
        silent: true,
        multi: true
      });
    } else {
      keys.forEach((key) => {
        const column = columns.value.find((col) => col.id === key);
        if (column) {
          column.filteredValue = [];
        }
      });
      filters.value = {};
      instance.store.commit("filterChange", {
        column: {},
        values: [],
        silent: true
      });
    }
  };
  const clearSort = () => {
    if (!sortingColumn.value) return;
    updateSort(null, null, null);
    instance.store.commit("changeSortCondition", {
      silent: true
    });
  };
  const {
    setExpandRowKeys,
    toggleRowExpansion,
    updateExpandRows,
    states: expandStates,
    isRowExpanded
  } = useExpand({
    data,
    rowKey
  });
  const {
    updateTreeExpandKeys,
    toggleTreeExpansion,
    updateTreeData,
    updateKeyChildren,
    loadOrToggle,
    states: treeStates
  } = useTree({
    data,
    rowKey
  });
  const {
    updateCurrentRowData,
    updateCurrentRow,
    setCurrentRowKey,
    states: currentData
  } = useCurrent({
    data,
    rowKey
  });
  const setExpandRowKeysAdapter = (val) => {
    setExpandRowKeys(val);
    updateTreeExpandKeys(val);
  };
  const toggleRowExpansionAdapter = (row, expanded) => {
    const hasExpandColumn = columns.value.some(({ type }) => type === "expand");
    if (hasExpandColumn) {
      toggleRowExpansion(row, expanded);
    } else {
      toggleTreeExpansion(row, expanded);
    }
  };
  return {
    assertRowKey,
    updateColumns,
    scheduleLayout,
    isSelected,
    clearSelection,
    cleanSelection,
    getSelectionRows,
    toggleRowSelection,
    _toggleAllSelection,
    toggleAllSelection: null,
    updateAllSelected,
    updateFilters,
    updateCurrentRow,
    updateSort,
    execFilter,
    execSort,
    execQuery,
    clearFilter,
    clearSort,
    toggleRowExpansion,
    setExpandRowKeysAdapter,
    setCurrentRowKey,
    toggleRowExpansionAdapter,
    isRowExpanded,
    updateExpandRows,
    updateCurrentRowData,
    loadOrToggle,
    updateTreeData,
    updateKeyChildren,
    states: {
      tableSize,
      rowKey,
      data,
      _data,
      isComplex,
      _columns,
      originColumns,
      columns,
      fixedColumns,
      rightFixedColumns,
      leafColumns,
      fixedLeafColumns,
      rightFixedLeafColumns,
      updateOrderFns,
      leafColumnsLength,
      fixedLeafColumnsLength,
      rightFixedLeafColumnsLength,
      isAllSelected,
      selection,
      reserveSelection,
      selectOnIndeterminate,
      selectable,
      rowExpandable,
      filters,
      filteredData,
      sortingColumn,
      sortProp,
      sortOrder,
      hoverRow,
      ...expandStates,
      ...treeStates,
      ...currentData
    }
  };
}
function replaceColumn(array, column) {
  return array.map((item) => {
    var _a;
    if (item.id === column.id) {
      return column;
    } else if ((_a = item.children) == null ? void 0 : _a.length) {
      item.children = replaceColumn(item.children, column);
    }
    return item;
  });
}
function sortColumn(array) {
  array.forEach((item) => {
    var _a, _b;
    item.no = (_a = item.getColumnIndex) == null ? void 0 : _a.call(item);
    if ((_b = item.children) == null ? void 0 : _b.length) {
      sortColumn(item.children);
    }
  });
  array.sort((cur, pre) => cur.no - pre.no);
}
function useStore() {
  const instance = getCurrentInstance();
  const watcher = useWatcher$1();
  const ns = useNamespace("table");
  const { t } = useLocale();
  const mutations = {
    setData(states, data) {
      const dataInstanceChanged = unref(states._data) !== data;
      states.data.value = data;
      states._data.value = data;
      instance.store.execQuery();
      instance.store.updateCurrentRowData();
      instance.store.updateExpandRows();
      instance.store.updateTreeData(
        instance.store.states.defaultExpandAll.value
      );
      if (unref(states.reserveSelection)) {
        instance.store.assertRowKey();
      } else {
        if (dataInstanceChanged) {
          instance.store.clearSelection();
        } else {
          instance.store.cleanSelection();
        }
      }
      instance.store.updateAllSelected();
      if (instance.$ready) {
        instance.store.scheduleLayout();
      }
    },
    insertColumn(states, column, parent, updateColumnOrder) {
      var _a;
      const array = unref(states._columns);
      let newColumns = [];
      if (!parent) {
        array.push(column);
        newColumns = array;
      } else {
        if (parent && !parent.children) {
          parent.children = [];
        }
        (_a = parent.children) == null ? void 0 : _a.push(column);
        newColumns = replaceColumn(array, parent);
      }
      sortColumn(newColumns);
      states._columns.value = newColumns;
      states.updateOrderFns.push(updateColumnOrder);
      if (column.type === "selection") {
        states.selectable.value = column.selectable;
        states.reserveSelection.value = column.reserveSelection;
      }
      if (instance.$ready) {
        instance.store.updateColumns();
        instance.store.scheduleLayout();
      }
    },
    updateColumnOrder(states, column) {
      var _a;
      const newColumnIndex = (_a = column.getColumnIndex) == null ? void 0 : _a.call(column);
      if (newColumnIndex === column.no) return;
      sortColumn(states._columns.value);
      if (instance.$ready) {
        instance.store.updateColumns();
      }
    },
    removeColumn(states, column, parent, updateColumnOrder) {
      var _a;
      const array = unref(states._columns) || [];
      if (parent) {
        (_a = parent.children) == null ? void 0 : _a.splice(
          parent.children.findIndex((item) => item.id === column.id),
          1
        );
        nextTick(() => {
          var _a2;
          if (((_a2 = parent.children) == null ? void 0 : _a2.length) === 0) {
            delete parent.children;
          }
        });
        states._columns.value = replaceColumn(array, parent);
      } else {
        const index = array.indexOf(column);
        if (index > -1) {
          array.splice(index, 1);
          states._columns.value = array;
        }
      }
      const updateFnIndex = states.updateOrderFns.indexOf(updateColumnOrder);
      updateFnIndex > -1 && states.updateOrderFns.splice(updateFnIndex, 1);
      if (instance.$ready) {
        instance.store.updateColumns();
        instance.store.scheduleLayout();
      }
    },
    sort(states, options) {
      const { prop, order, init } = options;
      if (prop) {
        const column = unref(states.columns).find(
          (column2) => column2.property === prop
        );
        if (column) {
          column.order = order;
          instance.store.updateSort(column, prop, order);
          instance.store.commit("changeSortCondition", { init });
        }
      }
    },
    changeSortCondition(states, options) {
      const { sortingColumn, sortProp, sortOrder } = states;
      const columnValue = unref(sortingColumn), propValue = unref(sortProp), orderValue = unref(sortOrder);
      if (isNull(orderValue)) {
        states.sortingColumn.value = null;
        states.sortProp.value = null;
      }
      const ignore = { filter: true };
      instance.store.execQuery(ignore);
      if (!options || !(options.silent || options.init)) {
        instance.emit("sort-change", {
          column: columnValue,
          prop: propValue,
          order: orderValue
        });
      }
      instance.store.updateTableScrollY();
    },
    filterChange(_states, options) {
      const { column, values, silent } = options;
      const newFilters = instance.store.updateFilters(column, values);
      instance.store.execQuery();
      if (!silent) {
        instance.emit("filter-change", newFilters);
      }
      instance.store.updateTableScrollY();
    },
    toggleAllSelection() {
      var _a, _b;
      (_b = (_a = instance.store).toggleAllSelection) == null ? void 0 : _b.call(_a);
    },
    rowSelectedChanged(_states, row) {
      instance.store.toggleRowSelection(row);
      instance.store.updateAllSelected();
    },
    setHoverRow(states, row) {
      states.hoverRow.value = row;
    },
    setCurrentRow(_states, row) {
      instance.store.updateCurrentRow(row);
    }
  };
  const commit = function(name, ...args) {
    const mutations2 = instance.store.mutations;
    if (mutations2[name]) {
      mutations2[name].apply(instance, [
        instance.store.states,
        ...args
      ]);
    } else {
      throw new Error(`Action not found: ${name}`);
    }
  };
  const updateTableScrollY = function() {
    nextTick(() => instance.layout.updateScrollY.apply(instance.layout));
  };
  return {
    ns,
    t,
    ...watcher,
    mutations,
    commit,
    updateTableScrollY
  };
}
const InitialStateMap = {
  rowKey: "rowKey",
  defaultExpandAll: "defaultExpandAll",
  rowExpandable: "rowExpandable",
  selectOnIndeterminate: "selectOnIndeterminate",
  indent: "indent",
  lazy: "lazy",
  ["treeProps.hasChildren"]: {
    key: "lazyColumnIdentifier",
    default: "hasChildren"
  },
  ["treeProps.children"]: {
    key: "childrenColumnName",
    default: "children"
  },
  ["treeProps.checkStrictly"]: {
    key: "checkStrictly",
    default: false
  }
};
function createStore(table, props) {
  if (!table) {
    throw new Error("Table is required.");
  }
  const store = useStore();
  store.toggleAllSelection = debounce(store._toggleAllSelection, 10);
  Object.keys(InitialStateMap).forEach((key) => {
    handleValue(getArrKeysValue(props, key), key, store);
  });
  proxyTableProps(store, props);
  return store;
}
function proxyTableProps(store, props) {
  Object.keys(InitialStateMap).forEach((key) => {
    watch(
      () => getArrKeysValue(props, key),
      (value) => {
        handleValue(value, key, store);
      }
    );
  });
}
function handleValue(value, propsKey, store) {
  let newVal = value;
  let storeKey = InitialStateMap[propsKey];
  if (isObject(storeKey)) {
    newVal = newVal || storeKey.default;
    storeKey = storeKey.key;
  }
  store.states[storeKey].value = newVal;
}
function getArrKeysValue(props, key) {
  if (key.includes(".")) {
    const keyList = key.split(".");
    let value = props;
    keyList.forEach((k) => {
      value = value[k];
    });
    return value;
  } else {
    return props[key];
  }
}
var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
class TableLayout {
  constructor(options) {
    __publicField(this, "observers");
    __publicField(this, "table");
    __publicField(this, "store");
    __publicField(this, "columns");
    __publicField(this, "fit");
    __publicField(this, "showHeader");
    __publicField(this, "height");
    __publicField(this, "scrollX");
    __publicField(this, "scrollY");
    __publicField(this, "bodyWidth");
    __publicField(this, "fixedWidth");
    __publicField(this, "rightFixedWidth");
    __publicField(this, "tableHeight");
    __publicField(this, "headerHeight");
    __publicField(this, "appendHeight");
    __publicField(this, "footerHeight");
    __publicField(this, "gutterWidth");
    this.observers = [];
    this.table = null;
    this.store = null;
    this.columns = [];
    this.fit = true;
    this.showHeader = true;
    this.height = ref(null);
    this.scrollX = ref(false);
    this.scrollY = ref(false);
    this.bodyWidth = ref(null);
    this.fixedWidth = ref(null);
    this.rightFixedWidth = ref(null);
    this.gutterWidth = 0;
    for (const name in options) {
      if (hasOwn(options, name)) {
        if (isRef(this[name])) {
          this[name].value = options[name];
        } else {
          this[name] = options[name];
        }
      }
    }
    if (!this.table) {
      throw new Error("Table is required for Table Layout");
    }
    if (!this.store) {
      throw new Error("Store is required for Table Layout");
    }
  }
  updateScrollY() {
    const height = this.height.value;
    if (isNull(height)) return false;
    const scrollBarRef = this.table.refs.scrollBarRef;
    if (this.table.vnode.el && (scrollBarRef == null ? void 0 : scrollBarRef.wrapRef)) {
      let scrollY = true;
      const prevScrollY = this.scrollY.value;
      scrollY = scrollBarRef.wrapRef.scrollHeight > scrollBarRef.wrapRef.clientHeight;
      this.scrollY.value = scrollY;
      return prevScrollY !== scrollY;
    }
    return false;
  }
  setHeight(value, prop = "height") {
    return;
  }
  setMaxHeight(value) {
    this.setHeight(value, "max-height");
  }
  getFlattenColumns() {
    const flattenColumns = [];
    const columns = this.table.store.states.columns.value;
    columns.forEach((column) => {
      if (column.isColumnGroup) {
        flattenColumns.push.apply(flattenColumns, column.columns);
      } else {
        flattenColumns.push(column);
      }
    });
    return flattenColumns;
  }
  updateElsHeight() {
    this.updateScrollY();
    this.notifyObservers("scrollable");
  }
  headerDisplayNone(elm) {
    if (!elm) return true;
    let headerChild = elm;
    while (headerChild.tagName !== "DIV") {
      if (getComputedStyle(headerChild).display === "none") {
        return true;
      }
      headerChild = headerChild.parentElement;
    }
    return false;
  }
  updateColumnsWidth() {
    return;
  }
  addObserver(observer) {
    this.observers.push(observer);
  }
  removeObserver(observer) {
    const index = this.observers.indexOf(observer);
    if (index !== -1) {
      this.observers.splice(index, 1);
    }
  }
  notifyObservers(event) {
    const observers = this.observers;
    observers.forEach((observer) => {
      var _a, _b;
      switch (event) {
        case "columns":
          (_a = observer.state) == null ? void 0 : _a.onColumnsChange(this);
          break;
        case "scrollable":
          (_b = observer.state) == null ? void 0 : _b.onScrollableChange(this);
          break;
        default:
          throw new Error(`Table Layout don't have event ${event}.`);
      }
    });
  }
}
var _sfc_main$3 = defineComponent({
  name: "ElTableFilterPanel",
  components: {
    ElCheckbox,
    ElCheckboxGroup,
    ElScrollbar,
    ElTooltip,
    ElIcon,
    ArrowDown: arrow_down_default,
    ArrowUp: arrow_up_default
  },
  props: {
    placement: {
      type: String,
      default: "bottom-start"
    },
    store: {
      type: Object
    },
    column: {
      type: Object
    },
    upDataColumn: {
      type: Function
    },
    appendTo: useTooltipContentProps.appendTo
  },
  setup(props) {
    const instance = getCurrentInstance();
    const { t } = useLocale();
    const ns = useNamespace("table-filter");
    const parent = instance == null ? void 0 : instance.parent;
    if (props.column && !parent.filterPanels.value[props.column.id]) {
      parent.filterPanels.value[props.column.id] = instance;
    }
    const tooltipRef = ref(null);
    const rootRef = ref(null);
    const checkedIndex = ref(0);
    const filters = computed(() => {
      return props.column && props.column.filters;
    });
    const filterClassName = computed(() => {
      if (props.column && props.column.filterClassName) {
        return `${ns.b()} ${props.column.filterClassName}`;
      }
      return ns.b();
    });
    const filterValue = computed({
      get: () => {
        var _a;
        return (((_a = props.column) == null ? void 0 : _a.filteredValue) || [])[0];
      },
      set: (value) => {
        if (filteredValue.value) {
          if (!isPropAbsent(value)) {
            filteredValue.value.splice(0, 1, value);
          } else {
            filteredValue.value.splice(0, 1);
          }
        }
      }
    });
    const filteredValue = computed({
      get() {
        if (props.column) {
          return props.column.filteredValue || [];
        }
        return [];
      },
      set(value) {
        var _a;
        if (props.column) {
          (_a = props.upDataColumn) == null ? void 0 : _a.call(props, "filteredValue", value);
        }
      }
    });
    const multiple = computed(() => {
      if (props.column) {
        return props.column.filterMultiple;
      }
      return true;
    });
    const isActive = (filter) => {
      return filter.value === filterValue.value;
    };
    const hidden = () => {
      var _a;
      (_a = tooltipRef.value) == null ? void 0 : _a.onClose();
    };
    const handleConfirm = () => {
      confirmFilter(filteredValue.value);
      hidden();
    };
    const handleReset = () => {
      filteredValue.value = [];
      confirmFilter(filteredValue.value);
      hidden();
    };
    const handleSelect = (_filterValue, index) => {
      filterValue.value = _filterValue;
      checkedIndex.value = index;
      if (!isPropAbsent(_filterValue)) {
        confirmFilter(filteredValue.value);
      } else {
        confirmFilter([]);
      }
      hidden();
    };
    const confirmFilter = (filteredValue2) => {
      var _a, _b;
      (_a = props.store) == null ? void 0 : _a.commit("filterChange", {
        column: props.column,
        values: filteredValue2
      });
      (_b = props.store) == null ? void 0 : _b.updateAllSelected();
    };
    const handleShowTooltip = () => {
      var _a, _b;
      (_a = rootRef.value) == null ? void 0 : _a.focus();
      !multiple.value && initCheckedIndex();
      if (props.column) {
        (_b = props.upDataColumn) == null ? void 0 : _b.call(props, "filterOpened", true);
      }
    };
    const handleHideTooltip = () => {
      var _a;
      if (props.column) {
        (_a = props.upDataColumn) == null ? void 0 : _a.call(props, "filterOpened", false);
      }
    };
    const initCheckedIndex = () => {
      if (isPropAbsent(filterValue)) {
        checkedIndex.value = 0;
        return;
      }
      const idx = (filters.value || []).findIndex((item) => {
        return item.value === filterValue.value;
      });
      checkedIndex.value = idx >= 0 ? idx + 1 : 0;
    };
    const handleKeydown = (event) => {
      var _a, _b;
      const code = getEventCode(event);
      const len = (filters.value ? filters.value.length : 0) + 1;
      let index = checkedIndex.value;
      let isPreventDefault = true;
      switch (code) {
        case EVENT_CODE.down:
        case EVENT_CODE.right:
          index = (index + 1) % len;
          break;
        case EVENT_CODE.up:
        case EVENT_CODE.left:
          index = (index - 1 + len) % len;
          break;
        case EVENT_CODE.tab:
          hidden();
          isPreventDefault = false;
          break;
        case EVENT_CODE.enter:
        case EVENT_CODE.space:
          if (index === 0) {
            handleSelect(null, 0);
          } else {
            const item = (filters.value || [])[index - 1];
            item.value && handleSelect(item.value, index);
          }
          break;
        default:
          isPreventDefault = false;
          break;
      }
      isPreventDefault && event.preventDefault();
      checkedIndex.value = index;
      (_b = (_a = rootRef.value) == null ? void 0 : _a.querySelector(
        `.${ns.e("list-item")}:nth-child(${index + 1})`
      )) == null ? void 0 : _b.focus();
    };
    return {
      multiple,
      filterClassName,
      filteredValue,
      filterValue,
      filters,
      handleConfirm,
      handleReset,
      handleSelect,
      isPropAbsent,
      isActive,
      t,
      ns,
      tooltipRef,
      rootRef,
      checkedIndex,
      handleShowTooltip,
      handleHideTooltip,
      handleKeydown
    };
  }
});
const _hoisted_1$2 = ["disabled"];
const _hoisted_2$1 = ["tabindex", "aria-checked"];
const _hoisted_3 = ["tabindex", "aria-checked", "onClick"];
const _hoisted_4 = ["aria-label"];
function _sfc_render$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_checkbox = resolveComponent("el-checkbox");
  const _component_el_checkbox_group = resolveComponent("el-checkbox-group");
  const _component_el_scrollbar = resolveComponent("el-scrollbar");
  const _component_arrow_up = resolveComponent("arrow-up");
  const _component_arrow_down = resolveComponent("arrow-down");
  const _component_el_icon = resolveComponent("el-icon");
  const _component_el_tooltip = resolveComponent("el-tooltip");
  return openBlock(), createBlock(_component_el_tooltip, {
    ref: "tooltipRef",
    offset: 0,
    placement: _ctx.placement,
    "show-arrow": false,
    trigger: "click",
    role: "dialog",
    teleported: "",
    effect: "light",
    pure: "",
    loop: "",
    "popper-class": _ctx.filterClassName,
    persistent: "",
    "append-to": _ctx.appendTo,
    onShow: _ctx.handleShowTooltip,
    onHide: _ctx.handleHideTooltip
  }, {
    content: withCtx(() => [
      _ctx.multiple ? (openBlock(), createElementBlock(
        "div",
        {
          key: 0,
          ref: "rootRef",
          tabindex: "-1",
          class: normalizeClass(_ctx.ns.e("multiple"))
        },
        [
          createElementVNode(
            "div",
            {
              class: normalizeClass(_ctx.ns.e("content"))
            },
            [
              createVNode(_component_el_scrollbar, {
                "wrap-class": _ctx.ns.e("wrap")
              }, {
                default: withCtx(() => [
                  createVNode(_component_el_checkbox_group, {
                    modelValue: _ctx.filteredValue,
                    "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => _ctx.filteredValue = $event),
                    class: normalizeClass(_ctx.ns.e("checkbox-group"))
                  }, {
                    default: withCtx(() => [
                      (openBlock(true), createElementBlock(
                        Fragment,
                        null,
                        renderList(_ctx.filters, (filter) => {
                          return openBlock(), createBlock(_component_el_checkbox, {
                            key: filter.value,
                            value: filter.value
                          }, {
                            default: withCtx(() => [
                              createTextVNode(
                                toDisplayString(filter.text),
                                1
                                /* TEXT */
                              )
                            ]),
                            _: 2
                            /* DYNAMIC */
                          }, 1032, ["value"]);
                        }),
                        128
                        /* KEYED_FRAGMENT */
                      ))
                    ]),
                    _: 1
                    /* STABLE */
                  }, 8, ["modelValue", "class"])
                ]),
                _: 1
                /* STABLE */
              }, 8, ["wrap-class"])
            ],
            2
            /* CLASS */
          ),
          createElementVNode(
            "div",
            {
              class: normalizeClass(_ctx.ns.e("bottom"))
            },
            [
              createElementVNode("button", {
                class: normalizeClass(_ctx.ns.is("disabled", _ctx.filteredValue.length === 0)),
                disabled: _ctx.filteredValue.length === 0,
                type: "button",
                onClick: _cache[1] || (_cache[1] = (...args) => _ctx.handleConfirm && _ctx.handleConfirm(...args))
              }, toDisplayString(_ctx.t("el.table.confirmFilter")), 11, _hoisted_1$2),
              createElementVNode(
                "button",
                {
                  type: "button",
                  onClick: _cache[2] || (_cache[2] = (...args) => _ctx.handleReset && _ctx.handleReset(...args))
                },
                toDisplayString(_ctx.t("el.table.resetFilter")),
                1
                /* TEXT */
              )
            ],
            2
            /* CLASS */
          )
        ],
        2
        /* CLASS */
      )) : (openBlock(), createElementBlock(
        "ul",
        {
          key: 1,
          ref: "rootRef",
          tabindex: "-1",
          role: "radiogroup",
          class: normalizeClass(_ctx.ns.e("list")),
          onKeydown: _cache[4] || (_cache[4] = (...args) => _ctx.handleKeydown && _ctx.handleKeydown(...args))
        },
        [
          createElementVNode("li", {
            role: "radio",
            class: normalizeClass([
              _ctx.ns.e("list-item"),
              _ctx.ns.is("active", _ctx.isPropAbsent(_ctx.filterValue))
            ]),
            tabindex: _ctx.checkedIndex === 0 ? 0 : -1,
            "aria-checked": _ctx.isPropAbsent(_ctx.filterValue),
            onClick: _cache[3] || (_cache[3] = ($event) => _ctx.handleSelect(null, 0))
          }, toDisplayString(_ctx.t("el.table.clearFilter")), 11, _hoisted_2$1),
          (openBlock(true), createElementBlock(
            Fragment,
            null,
            renderList(_ctx.filters, (filter, idx) => {
              return openBlock(), createElementBlock("li", {
                key: filter.value,
                role: "radio",
                class: normalizeClass([_ctx.ns.e("list-item"), _ctx.ns.is("active", _ctx.isActive(filter))]),
                tabindex: _ctx.checkedIndex === idx + 1 ? 0 : -1,
                "aria-checked": _ctx.isActive(filter),
                onClick: ($event) => _ctx.handleSelect(filter.value, idx + 1)
              }, toDisplayString(filter.text), 11, _hoisted_3);
            }),
            128
            /* KEYED_FRAGMENT */
          ))
        ],
        34
        /* CLASS, NEED_HYDRATION */
      ))
    ]),
    default: withCtx(() => {
      var _a;
      return [
        createElementVNode("button", {
          type: "button",
          class: normalizeClass(`${_ctx.ns.namespace.value}-table__column-filter-trigger`),
          "aria-label": _ctx.t("el.table.filterLabel", { column: ((_a = _ctx.column) == null ? void 0 : _a.label) || "" })
        }, [
          createVNode(_component_el_icon, null, {
            default: withCtx(() => [
              renderSlot(_ctx.$slots, "filter-icon", {}, () => {
                var _a2;
                return [
                  ((_a2 = _ctx.column) == null ? void 0 : _a2.filterOpened) ? (openBlock(), createBlock(_component_arrow_up, { key: 0 })) : (openBlock(), createBlock(_component_arrow_down, { key: 1 }))
                ];
              })
            ]),
            _: 3
            /* FORWARDED */
          })
        ], 10, _hoisted_4)
      ];
    }),
    _: 3
    /* FORWARDED */
  }, 8, ["placement", "popper-class", "append-to", "onShow", "onHide"]);
}
var FilterPanel = /* @__PURE__ */ _export_sfc$1(_sfc_main$3, [["render", _sfc_render$1]]);
function useLayoutObserver(root) {
  getCurrentInstance();
  const tableLayout = computed(() => {
    const layout = root.layout;
    if (!layout) {
      throw new Error("Can not find table layout.");
    }
    return layout;
  });
  const onColumnsChange = (layout) => {
    var _a;
    const cols = ((_a = root.vnode.el) == null ? void 0 : _a.querySelectorAll("colgroup > col")) || [];
    if (!cols.length) return;
    const flattenColumns = layout.getFlattenColumns();
    const columnsMap = {};
    flattenColumns.forEach((column) => {
      columnsMap[column.id] = column;
    });
    for (let i = 0, j = cols.length; i < j; i++) {
      const col = cols[i];
      const name = col.getAttribute("name");
      const column = columnsMap[name];
      if (column) {
        col.setAttribute("width", column.realWidth || column.width);
      }
    }
  };
  const onScrollableChange = (layout) => {
    var _a, _b;
    const cols = ((_a = root.vnode.el) == null ? void 0 : _a.querySelectorAll("colgroup > col[name=gutter]")) || [];
    for (let i = 0, j = cols.length; i < j; i++) {
      const col = cols[i];
      col.setAttribute("width", layout.scrollY.value ? layout.gutterWidth : "0");
    }
    const ths = ((_b = root.vnode.el) == null ? void 0 : _b.querySelectorAll("th.gutter")) || [];
    for (let i = 0, j = ths.length; i < j; i++) {
      const th = ths[i];
      th.style.width = layout.scrollY.value ? `${layout.gutterWidth}px` : "0";
      th.style.display = layout.scrollY.value ? "" : "none";
    }
  };
  return {
    tableLayout: tableLayout.value,
    onColumnsChange,
    onScrollableChange
  };
}
const TABLE_INJECTION_KEY = /* @__PURE__ */ Symbol("ElTable");
function useEvent(props, emit) {
  getCurrentInstance();
  const parent = inject(TABLE_INJECTION_KEY);
  const handleFilterClick = (event) => {
    event.stopPropagation();
    return;
  };
  const handleHeaderClick = (event, column) => {
    if (!column.filters && column.sortable) {
      handleSortClick(event, column, false);
    } else if (column.filterable && !column.sortable) {
      handleFilterClick(event);
    }
    parent == null ? void 0 : parent.emit("header-click", column, event);
  };
  const handleHeaderContextMenu = (event, column) => {
    parent == null ? void 0 : parent.emit("header-contextmenu", column, event);
  };
  const draggingColumn = ref(null);
  const dragging = ref(false);
  ref();
  const handleMouseDown = (event, column) => {
    return;
  };
  const handleMouseMove = (event, column) => {
    var _a;
    if (!props.border || column.children && column.children.length > 0) return;
    const el = event.target;
    const target = isElement(el) ? el.closest("th") : null;
    if (!target) {
      return;
    }
    const isSortable = hasClass(target, "is-sortable");
    if (isSortable) {
      const cursor2 = dragging.value ? "col-resize" : "";
      target.style.cursor = cursor2;
      const caret = target.querySelector(".caret-wrapper");
      if (caret) {
        caret.style.cursor = cursor2;
      }
    }
    if (!column.resizable || dragging.value) {
      draggingColumn.value = null;
      return;
    }
    const rect = target.getBoundingClientRect();
    const isLastTh = ((_a = target.parentNode) == null ? void 0 : _a.lastElementChild) === target;
    const allowDrag = props.allowDragLastColumn || !isLastTh;
    const isResizeHandleActive = rect.width > 12 && rect.right - event.clientX < 8 && allowDrag;
    const cursor = isResizeHandleActive ? "col-resize" : "";
    (void 0).body.style.cursor = cursor;
    draggingColumn.value = isResizeHandleActive ? column : null;
    if (isSortable) {
      target.style.cursor = cursor;
    }
  };
  const handleMouseOut = () => {
    return;
  };
  const toggleOrder = ({ order, sortOrders }) => {
    if (order === "") return sortOrders[0];
    const index = sortOrders.indexOf(order || null);
    return sortOrders[index > sortOrders.length - 2 ? 0 : index + 1];
  };
  const handleSortClick = (event, column, givenOrder) => {
    var _a;
    event.stopPropagation();
    const order = column.order === givenOrder ? null : givenOrder || toggleOrder(column);
    const target = (_a = event.target) == null ? void 0 : _a.closest("th");
    if (target) {
      if (hasClass(target, "noclick")) {
        removeClass(target, "noclick");
        return;
      }
    }
    if (!column.sortable) return;
    const clickTarget = event.currentTarget;
    if (["ascending", "descending"].some(
      (str) => hasClass(clickTarget, str) && !column.sortOrders.includes(str)
    )) {
      return;
    }
    const states = props.store.states;
    let sortProp = states.sortProp.value;
    let sortOrder;
    const sortingColumn = states.sortingColumn.value;
    if (sortingColumn !== column || sortingColumn === column && isNull(sortingColumn.order)) {
      if (sortingColumn) {
        sortingColumn.order = null;
      }
      states.sortingColumn.value = column;
      sortProp = column.property;
    }
    if (!order) {
      sortOrder = column.order = null;
    } else {
      sortOrder = column.order = order;
    }
    states.sortProp.value = sortProp;
    states.sortOrder.value = sortOrder;
    parent == null ? void 0 : parent.store.commit("changeSortCondition");
  };
  return {
    handleHeaderClick,
    handleHeaderContextMenu,
    handleMouseDown,
    handleMouseMove,
    handleMouseOut,
    handleSortClick,
    handleFilterClick
  };
}
function useStyle$2(props) {
  const parent = inject(TABLE_INJECTION_KEY);
  const ns = useNamespace("table");
  const getHeaderRowStyle = (rowIndex) => {
    const headerRowStyle = parent == null ? void 0 : parent.props.headerRowStyle;
    if (isFunction(headerRowStyle)) {
      return headerRowStyle.call(null, { rowIndex });
    }
    return headerRowStyle;
  };
  const getHeaderRowClass = (rowIndex) => {
    const classes = [];
    const headerRowClassName = parent == null ? void 0 : parent.props.headerRowClassName;
    if (isString(headerRowClassName)) {
      classes.push(headerRowClassName);
    } else if (isFunction(headerRowClassName)) {
      classes.push(headerRowClassName.call(null, { rowIndex }));
    }
    return classes.join(" ");
  };
  const getHeaderCellStyle = (rowIndex, columnIndex, row, column) => {
    var _a;
    let headerCellStyles = (_a = parent == null ? void 0 : parent.props.headerCellStyle) != null ? _a : {};
    if (isFunction(headerCellStyles)) {
      headerCellStyles = headerCellStyles.call(null, {
        rowIndex,
        columnIndex,
        row,
        column
      });
    }
    const fixedStyle = getFixedColumnOffset(
      columnIndex,
      column.fixed,
      props.store,
      row
    );
    ensurePosition(fixedStyle, "left");
    ensurePosition(fixedStyle, "right");
    return Object.assign({}, headerCellStyles, fixedStyle);
  };
  const getHeaderCellClass = (rowIndex, columnIndex, row, column) => {
    const fixedClasses = getFixedColumnsClass(
      ns.b(),
      columnIndex,
      column.fixed,
      props.store,
      row
    );
    const classes = [
      column.id,
      column.order,
      column.headerAlign,
      column.className,
      column.labelClassName,
      ...fixedClasses
    ];
    if (!column.children) {
      classes.push("is-leaf");
    }
    if (column.sortable) {
      classes.push("is-sortable");
    }
    const headerCellClassName = parent == null ? void 0 : parent.props.headerCellClassName;
    if (isString(headerCellClassName)) {
      classes.push(headerCellClassName);
    } else if (isFunction(headerCellClassName)) {
      classes.push(
        headerCellClassName.call(null, {
          rowIndex,
          columnIndex,
          row,
          column
        })
      );
    }
    classes.push(ns.e("cell"));
    return classes.filter((className) => Boolean(className)).join(" ");
  };
  return {
    getHeaderRowStyle,
    getHeaderRowClass,
    getHeaderCellStyle,
    getHeaderCellClass
  };
}
const getAllColumns = (columns) => {
  const result = [];
  columns.forEach((column) => {
    if (column.children) {
      result.push(column);
      result.push.apply(result, getAllColumns(column.children));
    } else {
      result.push(column);
    }
  });
  return result;
};
const convertToRows = (originColumns) => {
  let maxLevel = 1;
  const traverse = (column, parent) => {
    if (parent) {
      column.level = parent.level + 1;
      if (maxLevel < column.level) {
        maxLevel = column.level;
      }
    }
    if (column.children) {
      let colSpan = 0;
      column.children.forEach((subColumn) => {
        traverse(subColumn, column);
        colSpan += subColumn.colSpan;
      });
      column.colSpan = colSpan;
    } else {
      column.colSpan = 1;
    }
  };
  originColumns.forEach((column) => {
    column.level = 1;
    traverse(column, void 0);
  });
  const rows = [];
  for (let i = 0; i < maxLevel; i++) {
    rows.push([]);
  }
  const allColumns = getAllColumns(originColumns);
  allColumns.forEach((column) => {
    if (!column.children) {
      column.rowSpan = maxLevel - column.level + 1;
    } else {
      column.rowSpan = 1;
      column.children.forEach((col) => col.isSubColumn = true);
    }
    rows[column.level - 1].push(column);
  });
  return rows;
};
function useUtils$1(props) {
  const parent = inject(TABLE_INJECTION_KEY);
  const columnRows = computed(() => {
    return convertToRows(props.store.states.originColumns.value);
  });
  const isGroup = computed(() => {
    const result = columnRows.value.length > 1;
    if (result && parent) {
      parent.state.isGroup.value = true;
    }
    return result;
  });
  const toggleAllSelection = (event) => {
    event.stopPropagation();
    parent == null ? void 0 : parent.store.commit("toggleAllSelection");
  };
  return {
    isGroup,
    toggleAllSelection,
    columnRows
  };
}
var TableHeader = defineComponent({
  name: "ElTableHeader",
  components: {
    ElCheckbox
  },
  props: {
    fixed: {
      type: String,
      default: ""
    },
    store: {
      required: true,
      type: Object
    },
    border: Boolean,
    defaultSort: {
      type: Object,
      default: () => {
        return {
          prop: "",
          order: ""
        };
      }
    },
    appendFilterPanelTo: {
      type: String
    },
    allowDragLastColumn: {
      type: Boolean
    }
  },
  setup(props, { emit }) {
    const instance = getCurrentInstance();
    const parent = inject(TABLE_INJECTION_KEY);
    const ns = useNamespace("table");
    const filterPanels = ref({});
    const { onColumnsChange, onScrollableChange } = useLayoutObserver(parent);
    const isTableLayoutAuto = (parent == null ? void 0 : parent.props.tableLayout) === "auto";
    const saveIndexSelection = reactive(/* @__PURE__ */ new Map());
    const theadRef = ref();
    const updateFixedColumnStyle = () => {
      setTimeout(() => {
        if (saveIndexSelection.size > 0) {
          saveIndexSelection.forEach((column, key) => {
            const el = theadRef.value.querySelector(
              `.${key.replace(/\s/g, ".")}`
            );
            if (el) {
              const width = el.getBoundingClientRect().width;
              column.width = width || column.width;
            }
          });
          saveIndexSelection.clear();
        }
      });
    };
    watch(saveIndexSelection, updateFixedColumnStyle);
    const {
      handleHeaderClick,
      handleHeaderContextMenu,
      handleMouseDown,
      handleMouseMove,
      handleMouseOut,
      handleSortClick,
      handleFilterClick
    } = useEvent(props);
    const {
      getHeaderRowStyle,
      getHeaderRowClass,
      getHeaderCellStyle,
      getHeaderCellClass
    } = useStyle$2(props);
    const { isGroup, toggleAllSelection, columnRows } = useUtils$1(
      props
    );
    const { t } = useLocale();
    instance.state = {
      onColumnsChange,
      onScrollableChange
    };
    instance.filterPanels = filterPanels;
    return {
      ns,
      t,
      filterPanels,
      onColumnsChange,
      onScrollableChange,
      columnRows,
      getHeaderRowClass,
      getHeaderRowStyle,
      getHeaderCellClass,
      getHeaderCellStyle,
      handleHeaderClick,
      handleHeaderContextMenu,
      handleMouseDown,
      handleMouseMove,
      handleMouseOut,
      handleSortClick,
      handleFilterClick,
      isGroup,
      toggleAllSelection,
      saveIndexSelection,
      isTableLayoutAuto,
      theadRef,
      updateFixedColumnStyle
    };
  },
  render() {
    const {
      ns,
      t,
      isGroup,
      columnRows,
      getHeaderCellStyle,
      getHeaderCellClass,
      getHeaderRowClass,
      getHeaderRowStyle,
      handleHeaderClick,
      handleHeaderContextMenu,
      handleMouseDown,
      handleMouseMove,
      handleSortClick,
      handleMouseOut,
      store,
      $parent,
      saveIndexSelection,
      isTableLayoutAuto
    } = this;
    let rowSpan = 1;
    return h(
      "thead",
      {
        ref: "theadRef",
        class: ns.is("group", isGroup)
      },
      columnRows.map(
        (subColumns, rowIndex) => h(
          "tr",
          {
            class: getHeaderRowClass(rowIndex),
            key: rowIndex,
            style: getHeaderRowStyle(rowIndex)
          },
          subColumns.map((column, cellIndex) => {
            if (column.rowSpan > rowSpan) {
              rowSpan = column.rowSpan;
            }
            const _class = getHeaderCellClass(
              rowIndex,
              cellIndex,
              subColumns,
              column
            );
            if (isTableLayoutAuto && column.fixed) {
              saveIndexSelection.set(_class, column);
            }
            return h(
              "th",
              {
                class: _class,
                colspan: column.colSpan,
                key: `${column.id}-thead`,
                rowspan: column.rowSpan,
                scope: column.colSpan > 1 ? "colgroup" : "col",
                ariaSort: column.sortable ? column.order : void 0,
                style: getHeaderCellStyle(
                  rowIndex,
                  cellIndex,
                  subColumns,
                  column
                ),
                onClick: ($event) => {
                  var _a;
                  if ((_a = $event.currentTarget) == null ? void 0 : _a.classList.contains(
                    "noclick"
                  )) {
                    return;
                  }
                  handleHeaderClick($event, column);
                },
                onContextmenu: ($event) => handleHeaderContextMenu($event, column),
                onMousedown: ($event) => handleMouseDown($event, column),
                onMousemove: ($event) => handleMouseMove($event, column),
                onMouseout: handleMouseOut
              },
              [
                h(
                  "div",
                  {
                    class: [
                      "cell",
                      column.filteredValue && column.filteredValue.length > 0 ? "highlight" : ""
                    ]
                  },
                  [
                    column.renderHeader ? column.renderHeader({
                      column,
                      $index: cellIndex,
                      store,
                      _self: $parent
                    }) : column.label,
                    column.sortable && h(
                      "button",
                      {
                        type: "button",
                        class: "caret-wrapper",
                        "aria-label": t("el.table.sortLabel", {
                          column: column.label || ""
                        }),
                        onClick: ($event) => handleSortClick($event, column)
                      },
                      [
                        h("i", {
                          onClick: ($event) => handleSortClick($event, column, "ascending"),
                          class: "sort-caret ascending"
                        }),
                        h("i", {
                          onClick: ($event) => handleSortClick($event, column, "descending"),
                          class: "sort-caret descending"
                        })
                      ]
                    ),
                    column.filterable && h(
                      FilterPanel,
                      {
                        store,
                        placement: column.filterPlacement || "bottom-start",
                        appendTo: $parent == null ? void 0 : $parent.appendFilterPanelTo,
                        column,
                        upDataColumn: (key, value) => {
                          column[key] = value;
                        }
                      },
                      {
                        "filter-icon": () => column.renderFilterIcon ? column.renderFilterIcon({
                          filterOpened: column.filterOpened
                        }) : null
                      }
                    )
                  ]
                )
              ]
            );
          })
        )
      )
    );
  }
});
function isGreaterThan(a, b, epsilon = 0.03) {
  return a - b > epsilon;
}
function useEvents(props) {
  const parent = inject(TABLE_INJECTION_KEY);
  const tooltipContent = ref("");
  const tooltipTrigger = ref(h("div"));
  const handleEvent = (event, row, name) => {
    var _a, _b, _c;
    const table = parent;
    const cell = getCell(event);
    let column = null;
    const namespace = (_a = table == null ? void 0 : table.vnode.el) == null ? void 0 : _a.dataset.prefix;
    if (cell) {
      column = getColumnByCell(
        {
          columns: (_c = (_b = props.store) == null ? void 0 : _b.states.columns.value) != null ? _c : []
        },
        cell,
        namespace
      );
      if (column) {
        table == null ? void 0 : table.emit(`cell-${name}`, row, column, cell, event);
      }
    }
    table == null ? void 0 : table.emit(`row-${name}`, row, column, event);
  };
  const handleDoubleClick = (event, row) => {
    handleEvent(event, row, "dblclick");
  };
  const handleClick = (event, row) => {
    var _a;
    (_a = props.store) == null ? void 0 : _a.commit("setCurrentRow", row);
    handleEvent(event, row, "click");
  };
  const handleContextMenu = (event, row) => {
    handleEvent(event, row, "contextmenu");
  };
  const handleMouseEnter = debounce((index) => {
    var _a;
    (_a = props.store) == null ? void 0 : _a.commit("setHoverRow", index);
  }, 30);
  const handleMouseLeave = debounce(() => {
    var _a;
    (_a = props.store) == null ? void 0 : _a.commit("setHoverRow", null);
  }, 30);
  const getPadding = (el) => {
    const style = (void 0).getComputedStyle(el, null);
    const paddingLeft = Number.parseInt(style.paddingLeft, 10) || 0;
    const paddingRight = Number.parseInt(style.paddingRight, 10) || 0;
    const paddingTop = Number.parseInt(style.paddingTop, 10) || 0;
    const paddingBottom = Number.parseInt(style.paddingBottom, 10) || 0;
    return {
      left: paddingLeft,
      right: paddingRight,
      top: paddingTop,
      bottom: paddingBottom
    };
  };
  const toggleRowClassByCell = (rowSpan, event, toggle) => {
    var _a;
    let node = (_a = event == null ? void 0 : event.target) == null ? void 0 : _a.parentNode;
    while (rowSpan > 1) {
      node = node == null ? void 0 : node.nextSibling;
      if (!node || node.nodeName !== "TR") break;
      toggle(node, "hover-row hover-fixed-row");
      rowSpan--;
    }
  };
  const handleCellMouseEnter = (event, row, tooltipOptions) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i;
    if (!parent) return;
    const table = parent;
    const cell = getCell(event);
    const namespace = (_a = table == null ? void 0 : table.vnode.el) == null ? void 0 : _a.dataset.prefix;
    let column = null;
    if (cell) {
      column = getColumnByCell(
        {
          columns: (_c = (_b = props.store) == null ? void 0 : _b.states.columns.value) != null ? _c : []
        },
        cell,
        namespace
      );
      if (!column) {
        return;
      }
      if (cell.rowSpan > 1) {
        toggleRowClassByCell(cell.rowSpan, event, addClass);
      }
      const hoverState = table.hoverState = {
        cell,
        column,
        row
      };
      table == null ? void 0 : table.emit(
        "cell-mouse-enter",
        hoverState.row,
        hoverState.column,
        hoverState.cell,
        event
      );
    }
    if (!tooltipOptions) {
      if (((_d = removePopper) == null ? void 0 : _d.trigger) === cell) {
        (_e = removePopper) == null ? void 0 : _e();
      }
      return;
    }
    const cellChild = event.target.querySelector(
      ".cell"
    );
    if (!(hasClass(cellChild, `${namespace}-tooltip`) && cellChild.childNodes.length && ((_f = cellChild.textContent) == null ? void 0 : _f.trim()))) {
      return;
    }
    const range = (void 0).createRange();
    range.setStart(cellChild, 0);
    range.setEnd(cellChild, cellChild.childNodes.length);
    const { width: rangeWidth, height: rangeHeight } = range.getBoundingClientRect();
    const { width: cellChildWidth, height: cellChildHeight } = cellChild.getBoundingClientRect();
    const { top, left, right, bottom } = getPadding(cellChild);
    const horizontalPadding = left + right;
    const verticalPadding = top + bottom;
    if (isGreaterThan(rangeWidth + horizontalPadding, cellChildWidth) || isGreaterThan(rangeHeight + verticalPadding, cellChildHeight) || // When using a high-resolution screen, it is possible that a returns cellChild.scrollWidth value of 1921 and
    // cellChildWidth returns a value of 1920.994140625. #16856 #16673
    isGreaterThan(cellChild.scrollWidth, cellChildWidth)) {
      createTablePopper(
        tooltipOptions,
        (_g = (cell == null ? void 0 : cell.innerText) || (cell == null ? void 0 : cell.textContent)) != null ? _g : "",
        row,
        column,
        cell,
        table
      );
    } else if (((_h = removePopper) == null ? void 0 : _h.trigger) === cell) {
      (_i = removePopper) == null ? void 0 : _i();
    }
  };
  const handleCellMouseLeave = (event) => {
    const cell = getCell(event);
    if (!cell) return;
    if (cell.rowSpan > 1) {
      toggleRowClassByCell(cell.rowSpan, event, removeClass);
    }
    const oldHoverState = parent == null ? void 0 : parent.hoverState;
    parent == null ? void 0 : parent.emit(
      "cell-mouse-leave",
      oldHoverState == null ? void 0 : oldHoverState.row,
      oldHoverState == null ? void 0 : oldHoverState.column,
      oldHoverState == null ? void 0 : oldHoverState.cell,
      event
    );
  };
  return {
    handleDoubleClick,
    handleClick,
    handleContextMenu,
    handleMouseEnter,
    handleMouseLeave,
    handleCellMouseEnter,
    handleCellMouseLeave,
    tooltipContent,
    tooltipTrigger
  };
}
function useStyles(props) {
  const parent = inject(TABLE_INJECTION_KEY);
  const ns = useNamespace("table");
  const getRowStyle = (row, rowIndex) => {
    const rowStyle = parent == null ? void 0 : parent.props.rowStyle;
    if (isFunction(rowStyle)) {
      return rowStyle.call(null, {
        row,
        rowIndex
      });
    }
    return rowStyle || null;
  };
  const getRowClass = (row, rowIndex, displayIndex) => {
    var _a;
    const classes = [ns.e("row")];
    if ((parent == null ? void 0 : parent.props.highlightCurrentRow) && row === ((_a = props.store) == null ? void 0 : _a.states.currentRow.value)) {
      classes.push("current-row");
    }
    if (props.stripe && displayIndex % 2 === 1) {
      classes.push(ns.em("row", "striped"));
    }
    const rowClassName = parent == null ? void 0 : parent.props.rowClassName;
    if (isString(rowClassName)) {
      classes.push(rowClassName);
    } else if (isFunction(rowClassName)) {
      classes.push(
        rowClassName.call(null, {
          row,
          rowIndex
        })
      );
    }
    return classes;
  };
  const getCellStyle = (rowIndex, columnIndex, row, column) => {
    const cellStyle = parent == null ? void 0 : parent.props.cellStyle;
    let cellStyles = cellStyle != null ? cellStyle : {};
    if (isFunction(cellStyle)) {
      cellStyles = cellStyle.call(null, {
        rowIndex,
        columnIndex,
        row,
        column
      });
    }
    const fixedStyle = getFixedColumnOffset(
      columnIndex,
      props == null ? void 0 : props.fixed,
      props.store
    );
    ensurePosition(fixedStyle, "left");
    ensurePosition(fixedStyle, "right");
    return Object.assign({}, cellStyles, fixedStyle);
  };
  const getCellClass = (rowIndex, columnIndex, row, column, offset) => {
    const fixedClasses = getFixedColumnsClass(
      ns.b(),
      columnIndex,
      props == null ? void 0 : props.fixed,
      props.store,
      void 0,
      offset
    );
    const classes = [column.id, column.align, column.className, ...fixedClasses];
    const cellClassName = parent == null ? void 0 : parent.props.cellClassName;
    if (isString(cellClassName)) {
      classes.push(cellClassName);
    } else if (isFunction(cellClassName)) {
      classes.push(
        cellClassName.call(null, {
          rowIndex,
          columnIndex,
          row,
          column
        })
      );
    }
    classes.push(ns.e("cell"));
    return classes.filter((className) => Boolean(className)).join(" ");
  };
  const getSpan = (row, column, rowIndex, columnIndex) => {
    let rowspan = 1;
    let colspan = 1;
    const fn = parent == null ? void 0 : parent.props.spanMethod;
    if (isFunction(fn)) {
      const result = fn({
        row,
        column,
        rowIndex,
        columnIndex
      });
      if (isArray(result)) {
        rowspan = result[0];
        colspan = result[1];
      } else if (isObject(result)) {
        rowspan = result.rowspan;
        colspan = result.colspan;
      }
    }
    return { rowspan, colspan };
  };
  const getColspanRealWidth = (columns, colspan, index) => {
    if (colspan < 1) {
      return columns[index].realWidth;
    }
    const widthArr = columns.map(({ realWidth, width }) => realWidth || width).slice(index, index + colspan);
    return Number(
      widthArr.reduce((acc, width) => Number(acc) + Number(width), -1)
    );
  };
  return {
    getRowStyle,
    getRowClass,
    getCellStyle,
    getCellClass,
    getSpan,
    getColspanRealWidth
  };
}
const _hoisted_1$1 = ["colspan", "rowspan"];
var _sfc_main$2 = /* @__PURE__ */ defineComponent({
  ...{
    name: "TableTdWrapper"
  },
  __name: "td-wrapper",
  props: {
    colspan: {
      type: Number,
      default: 1
    },
    rowspan: {
      type: Number,
      default: 1
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("td", {
        colspan: __props.colspan,
        rowspan: __props.rowspan
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 8, _hoisted_1$1);
    };
  }
});
function useRender$1(props) {
  const parent = inject(TABLE_INJECTION_KEY);
  const ns = useNamespace("table");
  const {
    handleDoubleClick,
    handleClick,
    handleContextMenu,
    handleMouseEnter,
    handleMouseLeave,
    handleCellMouseEnter,
    handleCellMouseLeave,
    tooltipContent,
    tooltipTrigger
  } = useEvents(props);
  const {
    getRowStyle,
    getRowClass,
    getCellStyle,
    getCellClass,
    getSpan,
    getColspanRealWidth
  } = useStyles(props);
  let displayIndex = -1;
  const firstDefaultColumnIndex = computed(() => {
    var _a;
    return (_a = props.store) == null ? void 0 : _a.states.columns.value.findIndex(
      ({ type }) => type === "default"
    );
  });
  const getKeyOfRow = (row, index) => {
    var _a;
    const rowKey = (_a = parent == null ? void 0 : parent.props) == null ? void 0 : _a.rowKey;
    if (rowKey) {
      return getRowIdentity(row, rowKey);
    }
    return index;
  };
  const rowRender = (row, $index, treeRowData, expanded = false) => {
    const { tooltipEffect, tooltipOptions, store } = props;
    const { indent, columns } = store.states;
    const rowClasses = [];
    let display = true;
    if (treeRowData) {
      rowClasses.push(ns.em("row", `level-${treeRowData.level}`));
      display = !!treeRowData.display;
    }
    if ($index === 0) {
      displayIndex = -1;
    }
    if (props.stripe && display) {
      displayIndex++;
    }
    rowClasses.push(...getRowClass(row, $index, displayIndex));
    const displayStyle = display ? null : { display: "none" };
    return h(
      "tr",
      {
        style: [displayStyle, getRowStyle(row, $index)],
        class: rowClasses,
        key: getKeyOfRow(row, $index),
        onDblclick: ($event) => handleDoubleClick($event, row),
        onClick: ($event) => handleClick($event, row),
        onContextmenu: ($event) => handleContextMenu($event, row),
        onMouseenter: () => handleMouseEnter($index),
        onMouseleave: handleMouseLeave
      },
      columns.value.map((column, cellIndex) => {
        const { rowspan, colspan } = getSpan(row, column, $index, cellIndex);
        if (!rowspan || !colspan) {
          return null;
        }
        const columnData = Object.assign({}, column);
        columnData.realWidth = getColspanRealWidth(
          columns.value,
          colspan,
          cellIndex
        );
        const data = {
          store,
          _self: props.context || parent,
          column: columnData,
          row,
          $index,
          cellIndex,
          expanded
        };
        if (cellIndex === firstDefaultColumnIndex.value && treeRowData) {
          data.treeNode = {
            indent: treeRowData.level && treeRowData.level * indent.value,
            level: treeRowData.level
          };
          if (isBoolean$1(treeRowData.expanded)) {
            data.treeNode.expanded = treeRowData.expanded;
            if ("loading" in treeRowData) {
              data.treeNode.loading = treeRowData.loading;
            }
            if ("noLazyChildren" in treeRowData) {
              data.treeNode.noLazyChildren = treeRowData.noLazyChildren;
            }
          }
        }
        const baseKey = `${getKeyOfRow(row, $index)},${cellIndex}`;
        const patchKey = columnData.columnKey || columnData.rawColumnKey || "";
        const mergedTooltipOptions = column.showOverflowTooltip && merge(
          {
            effect: tooltipEffect
          },
          tooltipOptions,
          column.showOverflowTooltip
        );
        return h(
          _sfc_main$2,
          {
            style: getCellStyle($index, cellIndex, row, column),
            class: getCellClass($index, cellIndex, row, column, colspan - 1),
            key: `${patchKey}${baseKey}`,
            rowspan,
            colspan,
            onMouseenter: ($event) => handleCellMouseEnter(
              $event,
              row,
              mergedTooltipOptions
            ),
            onMouseleave: handleCellMouseLeave
          },
          {
            default: () => cellChildren(cellIndex, column, data)
          }
        );
      })
    );
  };
  const cellChildren = (_cellIndex, column, data) => {
    return column.renderCell(data);
  };
  const wrappedRowRender = (row, $index) => {
    const store = props.store;
    const { isRowExpanded, assertRowKey } = store;
    const { treeData, lazyTreeNodeMap, childrenColumnName, rowKey } = store.states;
    const columns = store.states.columns.value;
    const hasExpandColumn = columns.some(({ type }) => type === "expand");
    if (hasExpandColumn) {
      const expanded = isRowExpanded(row);
      const tr = rowRender(row, $index, void 0, expanded);
      const renderExpanded = parent == null ? void 0 : parent.renderExpanded;
      if (!renderExpanded) {
        console.error("[Element Error]renderExpanded is required.");
        return tr;
      }
      const rows = [[tr]];
      if (parent.props.preserveExpandedContent || expanded) {
        rows[0].push(
          h(
            "tr",
            {
              key: `expanded-row__${tr.key}`,
              style: { display: expanded ? "" : "none" }
            },
            [
              h(
                "td",
                {
                  colspan: columns.length,
                  class: `${ns.e("cell")} ${ns.e("expanded-cell")}`
                },
                [renderExpanded({ row, $index, store, expanded })]
              )
            ]
          )
        );
      }
      return rows;
    } else if (Object.keys(treeData.value).length) {
      assertRowKey();
      const key = getRowIdentity(row, rowKey.value);
      let cur = treeData.value[key];
      let treeRowData = null;
      if (cur) {
        treeRowData = {
          expanded: cur.expanded,
          level: cur.level,
          display: true,
          noLazyChildren: void 0,
          loading: void 0
        };
        if (isBoolean$1(cur.lazy)) {
          if (treeRowData && isBoolean$1(cur.loaded) && cur.loaded) {
            treeRowData.noLazyChildren = !(cur.children && cur.children.length);
          }
          treeRowData.loading = cur.loading;
        }
      }
      const tmp = [rowRender(row, $index, treeRowData != null ? treeRowData : void 0)];
      if (cur) {
        let i = 0;
        const traverse = (children, parent2) => {
          if (!(children && children.length && parent2)) return;
          children.forEach((node) => {
            const innerTreeRowData = {
              display: parent2.display && parent2.expanded,
              level: parent2.level + 1,
              expanded: false,
              noLazyChildren: false,
              loading: false
            };
            const childKey = getRowIdentity(node, rowKey.value);
            if (isPropAbsent(childKey)) {
              throw new Error("For nested data item, row-key is required.");
            }
            cur = { ...treeData.value[childKey] };
            if (cur) {
              innerTreeRowData.expanded = cur.expanded;
              cur.level = cur.level || innerTreeRowData.level;
              cur.display = !!(cur.expanded && innerTreeRowData.display);
              if (isBoolean$1(cur.lazy)) {
                if (isBoolean$1(cur.loaded) && cur.loaded) {
                  innerTreeRowData.noLazyChildren = !(cur.children && cur.children.length);
                }
                innerTreeRowData.loading = cur.loading;
              }
            }
            i++;
            tmp.push(rowRender(node, $index + i, innerTreeRowData));
            if (cur) {
              const nodes2 = lazyTreeNodeMap.value[childKey] || node[childrenColumnName.value];
              traverse(nodes2, cur);
            }
          });
        };
        cur.display = true;
        const nodes = lazyTreeNodeMap.value[key] || row[childrenColumnName.value];
        traverse(nodes, cur);
      }
      return tmp;
    } else {
      return rowRender(row, $index, void 0);
    }
  };
  return {
    wrappedRowRender,
    tooltipContent,
    tooltipTrigger
  };
}
const defaultProps$2 = {
  store: {
    required: true,
    type: Object
  },
  stripe: Boolean,
  tooltipEffect: String,
  tooltipOptions: {
    type: Object
  },
  context: {
    default: () => ({}),
    type: Object
  },
  rowClassName: [String, Function],
  rowStyle: [Object, Function],
  fixed: {
    type: String,
    default: ""
  },
  highlight: Boolean
};
var TableBody = defineComponent({
  name: "ElTableBody",
  props: defaultProps$2,
  setup(props) {
    var _a;
    const instance = getCurrentInstance();
    const parent = inject(TABLE_INJECTION_KEY);
    const ns = useNamespace("table");
    const { wrappedRowRender, tooltipContent, tooltipTrigger } = useRender$1(props);
    const { onColumnsChange, onScrollableChange } = useLayoutObserver(parent);
    const hoveredCellList = [];
    watch((_a = props.store) == null ? void 0 : _a.states.hoverRow, (newVal, oldVal) => {
      var _a2, _b;
      const el = instance == null ? void 0 : instance.vnode.el;
      const rows = Array.from((el == null ? void 0 : el.children) || []).filter(
        (e) => e == null ? void 0 : e.classList.contains(`${ns.e("row")}`)
      );
      let rowNum = newVal;
      const childNodes = (_a2 = rows[rowNum]) == null ? void 0 : _a2.childNodes;
      if (childNodes == null ? void 0 : childNodes.length) {
        let control = 0;
        const indexes = Array.from(childNodes).reduce((acc, item, index) => {
          var _a3, _b2;
          if (((_a3 = childNodes[index]) == null ? void 0 : _a3.colSpan) > 1) {
            control = (_b2 = childNodes[index]) == null ? void 0 : _b2.colSpan;
          }
          if (item.nodeName !== "TD" && control === 0) {
            acc.push(index);
          }
          control > 0 && control--;
          return acc;
        }, []);
        indexes.forEach((rowIndex) => {
          var _a3;
          rowNum = newVal;
          while (rowNum > 0) {
            const preChildNodes = (_a3 = rows[rowNum - 1]) == null ? void 0 : _a3.childNodes;
            if (preChildNodes[rowIndex] && preChildNodes[rowIndex].nodeName === "TD" && preChildNodes[rowIndex].rowSpan > 1) {
              addClass(preChildNodes[rowIndex], "hover-cell");
              hoveredCellList.push(preChildNodes[rowIndex]);
              break;
            }
            rowNum--;
          }
        });
      } else {
        hoveredCellList.forEach((item) => removeClass(item, "hover-cell"));
        hoveredCellList.length = 0;
      }
      if (!((_b = props.store) == null ? void 0 : _b.states.isComplex.value) || !isClient$1) return;
    });
    return {
      ns,
      onColumnsChange,
      onScrollableChange,
      wrappedRowRender,
      tooltipContent,
      tooltipTrigger
    };
  },
  render() {
    const { wrappedRowRender, store } = this;
    const data = (store == null ? void 0 : store.states.data.value) || [];
    return h("tbody", { tabIndex: -1 }, [
      data.reduce((acc, row) => {
        return acc.concat(wrappedRowRender(row, acc.length));
      }, [])
    ]);
  }
});
function useMapState() {
  const table = inject(TABLE_INJECTION_KEY);
  const store = table == null ? void 0 : table.store;
  const leftFixedLeafCount = computed(() => {
    var _a;
    return (_a = store == null ? void 0 : store.states.fixedLeafColumnsLength.value) != null ? _a : 0;
  });
  const rightFixedLeafCount = computed(() => {
    var _a;
    return (_a = store == null ? void 0 : store.states.rightFixedColumns.value.length) != null ? _a : 0;
  });
  const columnsCount = computed(() => {
    var _a;
    return (_a = store == null ? void 0 : store.states.columns.value.length) != null ? _a : 0;
  });
  const leftFixedCount = computed(() => {
    var _a;
    return (_a = store == null ? void 0 : store.states.fixedColumns.value.length) != null ? _a : 0;
  });
  const rightFixedCount = computed(() => {
    var _a;
    return (_a = store == null ? void 0 : store.states.rightFixedColumns.value.length) != null ? _a : 0;
  });
  return {
    leftFixedLeafCount,
    rightFixedLeafCount,
    columnsCount,
    leftFixedCount,
    rightFixedCount,
    columns: computed(() => {
      var _a;
      return (_a = store == null ? void 0 : store.states.columns.value) != null ? _a : [];
    })
  };
}
function useStyle$1(props) {
  const { columns } = useMapState();
  const ns = useNamespace("table");
  const getCellClasses = (columns2, cellIndex) => {
    const column = columns2[cellIndex];
    const classes = [
      ns.e("cell"),
      column.id,
      column.align,
      column.labelClassName,
      ...getFixedColumnsClass(ns.b(), cellIndex, column.fixed, props.store)
    ];
    if (column.className) {
      classes.push(column.className);
    }
    if (!column.children) {
      classes.push(ns.is("leaf"));
    }
    return classes;
  };
  const getCellStyles = (column, cellIndex) => {
    const fixedStyle = getFixedColumnOffset(
      cellIndex,
      column.fixed,
      props.store
    );
    ensurePosition(fixedStyle, "left");
    ensurePosition(fixedStyle, "right");
    return fixedStyle;
  };
  return {
    getCellClasses,
    getCellStyles,
    columns
  };
}
var TableFooter = defineComponent({
  name: "ElTableFooter",
  props: {
    fixed: {
      type: String,
      default: ""
    },
    store: {
      required: true,
      type: Object
    },
    summaryMethod: Function,
    sumText: String,
    border: Boolean,
    defaultSort: {
      type: Object,
      default: () => {
        return {
          prop: "",
          order: ""
        };
      }
    }
  },
  setup(props) {
    const parent = inject(TABLE_INJECTION_KEY);
    const ns = useNamespace("table");
    const { getCellClasses, getCellStyles, columns } = useStyle$1(
      props
    );
    const { onScrollableChange, onColumnsChange } = useLayoutObserver(parent);
    return {
      ns,
      onScrollableChange,
      onColumnsChange,
      getCellClasses,
      getCellStyles,
      columns
    };
  },
  render() {
    const { columns, getCellStyles, getCellClasses, summaryMethod, sumText } = this;
    const data = this.store.states.data.value;
    let sums = [];
    if (summaryMethod) {
      sums = summaryMethod({
        columns,
        data
      });
    } else {
      columns.forEach((column, index) => {
        if (index === 0) {
          sums[index] = sumText;
          return;
        }
        const values = data.map((item) => Number(item[column.property]));
        const precisions = [];
        let notNumber = true;
        values.forEach((value) => {
          if (!Number.isNaN(+value)) {
            notNumber = false;
            const decimal = `${value}`.split(".")[1];
            precisions.push(decimal ? decimal.length : 0);
          }
        });
        const precision = Math.max.apply(null, precisions);
        if (!notNumber) {
          sums[index] = values.reduce((prev, curr) => {
            const value = Number(curr);
            if (!Number.isNaN(+value)) {
              return Number.parseFloat(
                (prev + curr).toFixed(Math.min(precision, 20))
              );
            } else {
              return prev;
            }
          }, 0);
        } else {
          sums[index] = "";
        }
      });
    }
    return h(
      h("tfoot", [
        h("tr", {}, [
          ...columns.map(
            (column, cellIndex) => h(
              "td",
              {
                key: cellIndex,
                colspan: column.colSpan,
                rowspan: column.rowSpan,
                class: getCellClasses(columns, cellIndex),
                style: getCellStyles(column, cellIndex)
              },
              [
                h(
                  "div",
                  {
                    class: ["cell", column.labelClassName]
                  },
                  [sums[cellIndex]]
                )
              ]
            )
          )
        ])
      ])
    );
  }
});
function useUtils(store) {
  const setCurrentRow = (row) => {
    store.commit("setCurrentRow", row);
  };
  const getSelectionRows = () => {
    return store.getSelectionRows();
  };
  const toggleRowSelection = (row, selected, ignoreSelectable = true) => {
    store.toggleRowSelection(row, selected, false, ignoreSelectable);
    store.updateAllSelected();
  };
  const clearSelection = () => {
    store.clearSelection();
  };
  const clearFilter = (columnKeys) => {
    store.clearFilter(columnKeys);
  };
  const toggleAllSelection = () => {
    store.commit("toggleAllSelection");
  };
  const toggleRowExpansion = (row, expanded) => {
    store.toggleRowExpansionAdapter(row, expanded);
  };
  const clearSort = () => {
    store.clearSort();
  };
  const sort = (prop, order) => {
    store.commit("sort", { prop, order });
  };
  const updateKeyChildren = (key, data) => {
    store.updateKeyChildren(key, data);
  };
  return {
    setCurrentRow,
    getSelectionRows,
    toggleRowSelection,
    clearSelection,
    clearFilter,
    toggleAllSelection,
    toggleRowExpansion,
    clearSort,
    sort,
    updateKeyChildren
  };
}
function useStyle(props, layout, store, table) {
  const isHidden = ref(false);
  const renderExpanded = ref(null);
  const resizeProxyVisible = ref(false);
  const setDragVisible = (visible) => {
    resizeProxyVisible.value = visible;
  };
  const resizeState = ref({
    width: null,
    height: null,
    headerHeight: null
  });
  const isGroup = ref(false);
  const scrollbarViewStyle = {
    display: "inline-block",
    verticalAlign: "middle"
  };
  const tableWidth = ref();
  ref(0);
  const bodyScrollHeight = ref(0);
  const headerScrollHeight = ref(0);
  const footerScrollHeight = ref(0);
  ref(0);
  watch(
    () => props.height,
    (value) => {
      layout.setHeight(value != null ? value : null);
    },
    { immediate: true }
  );
  watch(
    () => props.maxHeight,
    (value) => {
      layout.setMaxHeight(value != null ? value : null);
    },
    { immediate: true }
  );
  watch(
    () => [props.currentRowKey, store.states.rowKey],
    ([currentRowKey, rowKey]) => {
      if (!unref(rowKey) || !unref(currentRowKey)) return;
      store.setCurrentRowKey(`${currentRowKey}`);
    },
    {
      immediate: true
    }
  );
  watch(
    () => props.data,
    (data) => {
      table.store.commit("setData", data);
    },
    {
      immediate: true,
      deep: true
    }
  );
  watchEffect(() => {
    if (props.expandRowKeys) {
      store.setExpandRowKeysAdapter(props.expandRowKeys);
    }
  });
  const handleMouseLeave = () => {
    table.store.commit("setHoverRow", null);
    if (table.hoverState) table.hoverState = null;
  };
  const handleHeaderFooterMousewheel = (_event, data) => {
    const { pixelX, pixelY } = data;
    if (Math.abs(pixelX) >= Math.abs(pixelY)) {
      table.refs.bodyWrapper.scrollLeft += data.pixelX / 5;
    }
  };
  const shouldUpdateHeight = computed(() => {
    return props.height || props.maxHeight || store.states.fixedColumns.value.length > 0 || store.states.rightFixedColumns.value.length > 0;
  });
  const tableBodyStyles = computed(() => {
    return {
      width: layout.bodyWidth.value ? `${layout.bodyWidth.value}px` : ""
    };
  });
  const doLayout = () => {
    if (shouldUpdateHeight.value) {
      layout.updateElsHeight();
    }
    layout.updateColumnsWidth();
    return;
  };
  const tableSize = useFormSize();
  const bodyWidth = computed(() => {
    const { bodyWidth: bodyWidth_, scrollY, gutterWidth } = layout;
    return bodyWidth_.value ? `${bodyWidth_.value - (scrollY.value ? gutterWidth : 0)}px` : "";
  });
  const tableLayout = computed(() => {
    if (props.maxHeight) return "fixed";
    return props.tableLayout;
  });
  const emptyBlockStyle = computed(() => {
    if (props.data && props.data.length) return;
    let height = "100%";
    if (props.height && bodyScrollHeight.value) {
      height = `${bodyScrollHeight.value}px`;
    }
    const width = tableWidth.value;
    return {
      width: width ? `${width}px` : "",
      height
    };
  });
  const scrollbarStyle = computed(() => {
    if (props.height) {
      return {
        height: "100%"
      };
    }
    if (props.maxHeight) {
      if (!Number.isNaN(Number(props.maxHeight))) {
        return {
          maxHeight: `${+props.maxHeight - headerScrollHeight.value - footerScrollHeight.value}px`
        };
      } else {
        return {
          maxHeight: `calc(${props.maxHeight} - ${headerScrollHeight.value + footerScrollHeight.value}px)`
        };
      }
    }
    return {};
  });
  return {
    isHidden,
    renderExpanded,
    setDragVisible,
    isGroup,
    handleMouseLeave,
    handleHeaderFooterMousewheel,
    tableSize,
    emptyBlockStyle,
    resizeProxyVisible,
    bodyWidth,
    resizeState,
    doLayout,
    tableBodyStyles,
    tableLayout,
    scrollbarViewStyle,
    scrollbarStyle
  };
}
var defaultProps$1 = {
  /**
   * @description table data
   */
  data: {
    type: Array,
    default: () => []
  },
  /**
   * @description size of Table
   */
  size: useSizeProp,
  width: [String, Number],
  /**
   * @description table's height. By default it has an `auto` height. If its value is a number, the height is measured in pixels; if its value is a string, the value will be assigned to element's style.height, the height is affected by external styles
   */
  height: [String, Number],
  /**
   * @description table's max-height. The legal value is a number or the height in px
   */
  maxHeight: [String, Number],
  /**
   * @description whether width of column automatically fits its container
   */
  fit: {
    type: Boolean,
    default: true
  },
  /**
   * @description whether Table is striped
   */
  stripe: Boolean,
  /**
   * @description whether Table has vertical border
   */
  border: Boolean,
  /**
   * @description key of row data, used for optimizing rendering. Required if `reserve-selection` is on or display tree data. When its type is String, multi-level access is supported, e.g. `user.info.id`, but `user.info[0].id` is not supported, in which case `Function` should be used
   */
  rowKey: [String, Function],
  /**
   * @description whether Table header is visible
   */
  showHeader: {
    type: Boolean,
    default: true
  },
  /**
   * @description whether to display a summary row
   */
  showSummary: Boolean,
  /**
   * @description displayed text for the first column of summary row
   */
  sumText: String,
  /**
   * @description custom summary method
   */
  summaryMethod: Function,
  /**
   * @description function that returns custom class names for a row, or a string assigning class names for every row
   */
  rowClassName: [String, Function],
  /**
   * @description function that returns custom style for a row, or an object assigning custom style for every row
   */
  rowStyle: [Object, Function],
  /**
   * @description function that returns custom class names for a cell, or a string assigning class names for every cell
   */
  cellClassName: [String, Function],
  /**
   * @description function that returns custom style for a cell, or an object assigning custom style for every cell
   */
  cellStyle: [Object, Function],
  /**
   * @description function that returns custom class names for a row in table header, or a string assigning class names for every row in table header
   */
  headerRowClassName: [String, Function],
  /**
   * @description function that returns custom style for a row in table header, or an object assigning custom style for every row in table header
   */
  headerRowStyle: [Object, Function],
  /**
   * @description function that returns custom class names for a cell in table header, or a string assigning class names for every cell in table header
   */
  headerCellClassName: [String, Function],
  /**
   * @description function that returns custom style for a cell in table header, or an object assigning custom style for every cell in table header
   */
  headerCellStyle: [Object, Function],
  /**
   * @description whether current row is highlighted
   */
  highlightCurrentRow: Boolean,
  /**
   * @description key of current row, a set only prop
   */
  currentRowKey: [String, Number],
  /**
   * @description displayed text when data is empty. You can customize this area with `#empty`
   */
  emptyText: String,
  /**
   * @description set expanded rows by this prop, prop's value is the keys of expand rows, you should set row-key before using this prop
   */
  expandRowKeys: Array,
  /**
   * @description whether expand all rows by default, works when the table has a column type="expand" or contains tree structure data
   */
  defaultExpandAll: Boolean,
  /**
   * @description enable expandable rows, works when the table has a column type="expand"
   */
  rowExpandable: {
    type: Function
  },
  /**
   * @description set the default sort column and order. property `prop` is used to set default sort column, property `order` is used to set default sort order
   */
  defaultSort: Object,
  /**
   * @description the `effect` of the overflow tooltip
   */
  tooltipEffect: String,
  /**
   * @description the options for the overflow tooltip, [see the following tooltip component](tooltip.html#attributes)
   */
  tooltipOptions: Object,
  /**
   * @description method that returns rowspan and colspan
   */
  spanMethod: Function,
  /**
   * @description controls the behavior of master checkbox in multi-select tables when only some rows are selected (but not all). If true, all rows will be selected, else deselected
   */
  selectOnIndeterminate: {
    type: Boolean,
    default: true
  },
  /**
   * @description horizontal indentation of tree data
   */
  indent: {
    type: Number,
    default: 16
  },
  /**
   * @description configuration for rendering nested data
   */
  treeProps: {
    type: Object,
    default: () => {
      return {
        hasChildren: "hasChildren",
        children: "children",
        checkStrictly: false
      };
    }
  },
  /**
   * @description whether to lazy loading data
   */
  lazy: Boolean,
  /**
   * @description method for loading child row data, only works when `lazy` is true
   */
  load: Function,
  style: {
    type: [String, Object, Array],
    default: () => ({})
  },
  className: {
    type: String,
    default: ""
  },
  /**
   * @description sets the algorithm used to lay out table cells, rows, and columns
   */
  tableLayout: {
    type: String,
    default: "fixed"
  },
  /**
   * @description always show scrollbar
   */
  scrollbarAlwaysOn: Boolean,
  /**
   * @description ensure main axis minimum-size doesn't follow the content
   */
  flexible: Boolean,
  /**
   * @description whether to hide extra content and show them in a tooltip when hovering on the cell.It will affect all the table columns
   */
  showOverflowTooltip: [Boolean, Object],
  /**
   * @description function that formats cell tooltip content, works when `show-overflow-tooltip` is `true`
   */
  tooltipFormatter: Function,
  appendFilterPanelTo: String,
  scrollbarTabindex: {
    type: [Number, String],
    default: void 0
  },
  /**
   * @description whether to allow drag the last column
   */
  allowDragLastColumn: {
    type: Boolean,
    default: true
  },
  /**
   * @description whether to preserve expanded row content in DOM when collapsed
   */
  preserveExpandedContent: Boolean,
  /**
   * @description whether to use native scrollbars
   */
  nativeScrollbar: Boolean
};
function hColgroup(props) {
  const isAuto = props.tableLayout === "auto";
  let columns = props.columns || [];
  if (isAuto) {
    if (columns.every(({ width }) => isUndefined(width))) {
      columns = [];
    }
  }
  const getPropsData = (column) => {
    const propsData = {
      key: `${props.tableLayout}_${column.id}`,
      style: {},
      name: void 0
    };
    if (isAuto) {
      propsData.style = {
        width: `${column.width}px`
      };
    } else {
      propsData.name = column.id;
    }
    return propsData;
  };
  return h(
    "colgroup",
    {},
    columns.map((column) => h("col", getPropsData(column)))
  );
}
hColgroup.props = ["columns", "tableLayout"];
const useScrollbar = () => {
  const scrollBarRef = ref();
  const scrollTo = (options, yCoord) => {
    const scrollbar = scrollBarRef.value;
    if (scrollbar) {
      scrollbar.scrollTo(options, yCoord);
    }
  };
  const setScrollPosition = (position, offset) => {
    const scrollbar = scrollBarRef.value;
    if (scrollbar && isNumber$1(offset) && ["Top", "Left"].includes(position)) {
      scrollbar[`setScroll${position}`](offset);
    }
  };
  const setScrollTop = (top) => setScrollPosition("Top", top);
  const setScrollLeft = (left) => setScrollPosition("Left", left);
  return {
    scrollBarRef,
    scrollTo,
    setScrollTop,
    setScrollLeft
  };
};
const SCOPE = "_Mousewheel";
const mousewheel = function(element, callback) {
  if (element && element.addEventListener) {
    removeWheelHandler(element);
    const fn = function(event) {
      const normalized = normalizeWheel(event);
      callback && Reflect.apply(callback, this, [event, normalized]);
    };
    element[SCOPE] = { wheelHandler: fn };
    element.addEventListener("wheel", fn, { passive: true });
  }
};
const removeWheelHandler = (element) => {
  var _a;
  if ((_a = element[SCOPE]) == null ? void 0 : _a.wheelHandler) {
    element.removeEventListener("wheel", element[SCOPE].wheelHandler);
    element[SCOPE] = null;
  }
};
const Mousewheel = {
  beforeMount(el, binding) {
    mousewheel(el, binding.value);
  },
  unmounted(el) {
    removeWheelHandler(el);
  },
  updated(el, binding) {
    if (binding.value !== binding.oldValue) {
      mousewheel(el, binding.value);
    }
  }
};
let tableIdSeed = 1;
var _sfc_main$1 = defineComponent({
  name: "ElTable",
  directives: {
    Mousewheel
  },
  components: {
    TableHeader,
    TableBody,
    TableFooter,
    ElScrollbar,
    hColgroup
  },
  props: defaultProps$1,
  emits: [
    "select",
    "select-all",
    "selection-change",
    "cell-mouse-enter",
    "cell-mouse-leave",
    "cell-contextmenu",
    "cell-click",
    "cell-dblclick",
    "row-click",
    "row-contextmenu",
    "row-dblclick",
    "header-click",
    "header-contextmenu",
    "sort-change",
    "filter-change",
    "current-change",
    "header-dragend",
    "expand-change",
    "scroll"
  ],
  setup(props) {
    const { t } = useLocale();
    const ns = useNamespace("table");
    const table = getCurrentInstance();
    provide(TABLE_INJECTION_KEY, table);
    const store = createStore(table, props);
    table.store = store;
    const layout = new TableLayout({
      store: table.store,
      table,
      fit: props.fit,
      showHeader: props.showHeader
    });
    table.layout = layout;
    const isEmpty = computed(() => (store.states.data.value || []).length === 0);
    const {
      setCurrentRow,
      getSelectionRows,
      toggleRowSelection,
      clearSelection,
      clearFilter,
      toggleAllSelection,
      toggleRowExpansion,
      clearSort,
      sort,
      updateKeyChildren
    } = useUtils(store);
    const {
      isHidden,
      renderExpanded,
      setDragVisible,
      isGroup,
      handleMouseLeave,
      handleHeaderFooterMousewheel,
      tableSize,
      emptyBlockStyle,
      resizeProxyVisible,
      bodyWidth,
      resizeState,
      doLayout,
      tableBodyStyles,
      tableLayout,
      scrollbarViewStyle,
      scrollbarStyle
    } = useStyle(props, layout, store, table);
    const { scrollBarRef, scrollTo, setScrollLeft, setScrollTop } = useScrollbar();
    const debouncedUpdateLayout = debounce(doLayout, 50);
    const tableId = `${ns.namespace.value}-table_${tableIdSeed++}`;
    table.tableId = tableId;
    table.state = {
      isGroup,
      resizeState,
      doLayout,
      debouncedUpdateLayout
    };
    const computedSumText = computed(
      () => {
        var _a;
        return (_a = props.sumText) != null ? _a : t("el.table.sumText");
      }
    );
    const computedEmptyText = computed(() => {
      var _a;
      return (_a = props.emptyText) != null ? _a : t("el.table.emptyText");
    });
    const columns = computed(() => {
      return convertToRows(store.states.originColumns.value)[0];
    });
    return {
      ns,
      layout,
      store,
      columns,
      handleHeaderFooterMousewheel,
      handleMouseLeave,
      tableId,
      tableSize,
      isHidden,
      isEmpty,
      renderExpanded,
      resizeProxyVisible,
      resizeState,
      isGroup,
      bodyWidth,
      tableBodyStyles,
      emptyBlockStyle,
      debouncedUpdateLayout,
      /**
       * @description used in single selection Table, set a certain row selected. If called without any parameter, it will clear selection
       */
      setCurrentRow,
      /**
       * @description returns the currently selected rows
       */
      getSelectionRows,
      /**
       * @description used in multiple selection Table, toggle if a certain row is selected. With the second parameter, you can directly set if this row is selected
       */
      toggleRowSelection,
      /**
       * @description used in multiple selection Table, clear user selection
       */
      clearSelection,
      /**
       * @description clear filters of the columns whose `columnKey` are passed in. If no params, clear all filters
       */
      clearFilter,
      /**
       * @description used in multiple selection Table, toggle select all and deselect all
       */
      toggleAllSelection,
      /**
       * @description used in expandable Table or tree Table, toggle if a certain row is expanded. With the second parameter, you can directly set if this row is expanded or collapsed
       */
      toggleRowExpansion,
      /**
       * @description clear sorting, restore data to the original order
       */
      clearSort,
      /**
       * @description refresh the layout of Table. When the visibility of Table changes, you may need to call this method to get a correct layout
       */
      doLayout,
      /**
       * @description sort Table manually. Property `prop` is used to set sort column, property `order` is used to set sort order
       */
      sort,
      /**
       * @description used in lazy Table, must set `rowKey`, update key children
       */
      updateKeyChildren,
      t,
      setDragVisible,
      context: table,
      computedSumText,
      computedEmptyText,
      tableLayout,
      scrollbarViewStyle,
      scrollbarStyle,
      scrollBarRef,
      /**
       * @description scrolls to a particular set of coordinates
       */
      scrollTo,
      /**
       * @description set horizontal scroll position
       */
      setScrollLeft,
      /**
       * @description set vertical scroll position
       */
      setScrollTop,
      /**
       * @description whether to allow drag the last column
       */
      allowDragLastColumn: props.allowDragLastColumn
    };
  }
});
const _hoisted_1 = ["data-prefix"];
const _hoisted_2 = {
  ref: "hiddenColumns",
  class: "hidden-columns"
};
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_hColgroup = resolveComponent("hColgroup");
  const _component_table_header = resolveComponent("table-header");
  const _component_table_body = resolveComponent("table-body");
  const _component_table_footer = resolveComponent("table-footer");
  const _component_el_scrollbar = resolveComponent("el-scrollbar");
  const _directive_mousewheel = resolveDirective("mousewheel");
  return openBlock(), createElementBlock("div", {
    ref: "tableWrapper",
    class: normalizeClass([
      {
        [_ctx.ns.m("fit")]: _ctx.fit,
        [_ctx.ns.m("striped")]: _ctx.stripe,
        [_ctx.ns.m("border")]: _ctx.border || _ctx.isGroup,
        [_ctx.ns.m("hidden")]: _ctx.isHidden,
        [_ctx.ns.m("group")]: _ctx.isGroup,
        [_ctx.ns.m("fluid-height")]: _ctx.maxHeight,
        [_ctx.ns.m("scrollable-x")]: _ctx.layout.scrollX.value,
        [_ctx.ns.m("scrollable-y")]: _ctx.layout.scrollY.value,
        [_ctx.ns.m("enable-row-hover")]: !_ctx.store.states.isComplex.value,
        [_ctx.ns.m("enable-row-transition")]: (_ctx.store.states.data.value || []).length !== 0 && (_ctx.store.states.data.value || []).length < 100,
        "has-footer": _ctx.showSummary
      },
      _ctx.ns.m(_ctx.tableSize),
      _ctx.className,
      _ctx.ns.b(),
      _ctx.ns.m(`layout-${_ctx.tableLayout}`)
    ]),
    style: normalizeStyle(_ctx.style),
    "data-prefix": _ctx.ns.namespace.value,
    onMouseleave: _cache[1] || (_cache[1] = (...args) => _ctx.handleMouseLeave && _ctx.handleMouseLeave(...args))
  }, [
    createElementVNode(
      "div",
      {
        ref: "tableInnerWrapper",
        class: normalizeClass(_ctx.ns.e("inner-wrapper"))
      },
      [
        createElementVNode(
          "div",
          _hoisted_2,
          [
            renderSlot(_ctx.$slots, "default")
          ],
          512
          /* NEED_PATCH */
        ),
        _ctx.showHeader && _ctx.tableLayout === "fixed" ? withDirectives((openBlock(), createElementBlock(
          "div",
          {
            key: 0,
            ref: "headerWrapper",
            class: normalizeClass(_ctx.ns.e("header-wrapper"))
          },
          [
            createElementVNode(
              "table",
              {
                ref: "tableHeader",
                class: normalizeClass(_ctx.ns.e("header")),
                style: normalizeStyle(_ctx.tableBodyStyles),
                border: "0",
                cellpadding: "0",
                cellspacing: "0"
              },
              [
                createVNode(_component_hColgroup, {
                  columns: _ctx.store.states.columns.value,
                  "table-layout": _ctx.tableLayout
                }, null, 8, ["columns", "table-layout"]),
                createVNode(_component_table_header, {
                  ref: "tableHeaderRef",
                  border: _ctx.border,
                  "default-sort": _ctx.defaultSort,
                  store: _ctx.store,
                  "append-filter-panel-to": _ctx.appendFilterPanelTo,
                  "allow-drag-last-column": _ctx.allowDragLastColumn,
                  onSetDragVisible: _ctx.setDragVisible
                }, null, 8, ["border", "default-sort", "store", "append-filter-panel-to", "allow-drag-last-column", "onSetDragVisible"])
              ],
              6
              /* CLASS, STYLE */
            )
          ],
          2
          /* CLASS */
        )), [
          [_directive_mousewheel, _ctx.handleHeaderFooterMousewheel]
        ]) : createCommentVNode("v-if", true),
        createElementVNode(
          "div",
          {
            ref: "bodyWrapper",
            class: normalizeClass(_ctx.ns.e("body-wrapper"))
          },
          [
            createVNode(_component_el_scrollbar, {
              ref: "scrollBarRef",
              "view-style": _ctx.scrollbarViewStyle,
              "wrap-style": _ctx.scrollbarStyle,
              always: _ctx.scrollbarAlwaysOn,
              tabindex: _ctx.scrollbarTabindex,
              native: _ctx.nativeScrollbar,
              onScroll: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("scroll", $event))
            }, {
              default: withCtx(() => [
                createElementVNode(
                  "table",
                  {
                    ref: "tableBody",
                    class: normalizeClass(_ctx.ns.e("body")),
                    cellspacing: "0",
                    cellpadding: "0",
                    border: "0",
                    style: normalizeStyle({
                      width: _ctx.bodyWidth,
                      tableLayout: _ctx.tableLayout
                    })
                  },
                  [
                    createVNode(_component_hColgroup, {
                      columns: _ctx.store.states.columns.value,
                      "table-layout": _ctx.tableLayout
                    }, null, 8, ["columns", "table-layout"]),
                    _ctx.showHeader && _ctx.tableLayout === "auto" ? (openBlock(), createBlock(_component_table_header, {
                      key: 0,
                      ref: "tableHeaderRef",
                      class: normalizeClass(_ctx.ns.e("body-header")),
                      border: _ctx.border,
                      "default-sort": _ctx.defaultSort,
                      store: _ctx.store,
                      "append-filter-panel-to": _ctx.appendFilterPanelTo,
                      onSetDragVisible: _ctx.setDragVisible
                    }, null, 8, ["class", "border", "default-sort", "store", "append-filter-panel-to", "onSetDragVisible"])) : createCommentVNode("v-if", true),
                    createVNode(_component_table_body, {
                      context: _ctx.context,
                      highlight: _ctx.highlightCurrentRow,
                      "row-class-name": _ctx.rowClassName,
                      "tooltip-effect": _ctx.tooltipEffect,
                      "tooltip-options": _ctx.tooltipOptions,
                      "row-style": _ctx.rowStyle,
                      store: _ctx.store,
                      stripe: _ctx.stripe
                    }, null, 8, ["context", "highlight", "row-class-name", "tooltip-effect", "tooltip-options", "row-style", "store", "stripe"]),
                    _ctx.showSummary && _ctx.tableLayout === "auto" ? (openBlock(), createBlock(_component_table_footer, {
                      key: 1,
                      class: normalizeClass(_ctx.ns.e("body-footer")),
                      border: _ctx.border,
                      "default-sort": _ctx.defaultSort,
                      store: _ctx.store,
                      "sum-text": _ctx.computedSumText,
                      "summary-method": _ctx.summaryMethod
                    }, null, 8, ["class", "border", "default-sort", "store", "sum-text", "summary-method"])) : createCommentVNode("v-if", true)
                  ],
                  6
                  /* CLASS, STYLE */
                ),
                _ctx.isEmpty ? (openBlock(), createElementBlock(
                  "div",
                  {
                    key: 0,
                    ref: "emptyBlock",
                    style: normalizeStyle(_ctx.emptyBlockStyle),
                    class: normalizeClass(_ctx.ns.e("empty-block"))
                  },
                  [
                    createElementVNode(
                      "span",
                      {
                        class: normalizeClass(_ctx.ns.e("empty-text"))
                      },
                      [
                        renderSlot(_ctx.$slots, "empty", {}, () => [
                          createTextVNode(
                            toDisplayString(_ctx.computedEmptyText),
                            1
                            /* TEXT */
                          )
                        ])
                      ],
                      2
                      /* CLASS */
                    )
                  ],
                  6
                  /* CLASS, STYLE */
                )) : createCommentVNode("v-if", true),
                _ctx.$slots.append ? (openBlock(), createElementBlock(
                  "div",
                  {
                    key: 1,
                    ref: "appendWrapper",
                    class: normalizeClass(_ctx.ns.e("append-wrapper"))
                  },
                  [
                    renderSlot(_ctx.$slots, "append")
                  ],
                  2
                  /* CLASS */
                )) : createCommentVNode("v-if", true)
              ]),
              _: 3
              /* FORWARDED */
            }, 8, ["view-style", "wrap-style", "always", "tabindex", "native"])
          ],
          2
          /* CLASS */
        ),
        _ctx.showSummary && _ctx.tableLayout === "fixed" ? withDirectives((openBlock(), createElementBlock(
          "div",
          {
            key: 1,
            ref: "footerWrapper",
            class: normalizeClass(_ctx.ns.e("footer-wrapper"))
          },
          [
            createElementVNode(
              "table",
              {
                class: normalizeClass(_ctx.ns.e("footer")),
                cellspacing: "0",
                cellpadding: "0",
                border: "0",
                style: normalizeStyle(_ctx.tableBodyStyles)
              },
              [
                createVNode(_component_hColgroup, {
                  columns: _ctx.store.states.columns.value,
                  "table-layout": _ctx.tableLayout
                }, null, 8, ["columns", "table-layout"]),
                createVNode(_component_table_footer, {
                  border: _ctx.border,
                  "default-sort": _ctx.defaultSort,
                  store: _ctx.store,
                  "sum-text": _ctx.computedSumText,
                  "summary-method": _ctx.summaryMethod
                }, null, 8, ["border", "default-sort", "store", "sum-text", "summary-method"])
              ],
              6
              /* CLASS, STYLE */
            )
          ],
          2
          /* CLASS */
        )), [
          [vShow, !_ctx.isEmpty],
          [_directive_mousewheel, _ctx.handleHeaderFooterMousewheel]
        ]) : createCommentVNode("v-if", true),
        _ctx.border || _ctx.isGroup ? (openBlock(), createElementBlock(
          "div",
          {
            key: 2,
            class: normalizeClass(_ctx.ns.e("border-left-patch"))
          },
          null,
          2
          /* CLASS */
        )) : createCommentVNode("v-if", true)
      ],
      2
      /* CLASS */
    ),
    withDirectives(createElementVNode(
      "div",
      {
        ref: "resizeProxy",
        class: normalizeClass(_ctx.ns.e("column-resize-proxy"))
      },
      null,
      2
      /* CLASS */
    ), [
      [vShow, _ctx.resizeProxyVisible]
    ])
  ], 46, _hoisted_1);
}
var Table = /* @__PURE__ */ _export_sfc$1(_sfc_main$1, [["render", _sfc_render]]);
const defaultClassNames = {
  selection: "table-column--selection",
  expand: "table__expand-column"
};
const getDefaultClassName = (type) => {
  return defaultClassNames[type] || "";
};
const cellForced = {
  selection: {
    renderHeader({ store }) {
      var _a;
      function isDisabled() {
        return store.states.data.value && store.states.data.value.length === 0;
      }
      return h(ElCheckbox, {
        disabled: isDisabled(),
        size: store.states.tableSize.value,
        indeterminate: store.states.selection.value.length > 0 && !store.states.isAllSelected.value,
        "onUpdate:modelValue": (_a = store.toggleAllSelection) != null ? _a : void 0,
        modelValue: store.states.isAllSelected.value,
        ariaLabel: store.t("el.table.selectAllLabel")
      });
    },
    renderCell({
      row,
      column,
      store,
      $index
    }) {
      return h(ElCheckbox, {
        disabled: column.selectable ? !column.selectable.call(null, row, $index) : false,
        size: store.states.tableSize.value,
        onChange: () => {
          store.commit("rowSelectedChanged", row);
        },
        onClick: (event) => event.stopPropagation(),
        modelValue: store.isSelected(row),
        ariaLabel: store.t("el.table.selectRowLabel")
      });
    },
    sortable: false,
    resizable: false
  },
  index: {
    renderHeader({
      column
    }) {
      return column.label || "#";
    },
    renderCell({
      column,
      $index
    }) {
      let i = $index + 1;
      const index = column.index;
      if (isNumber$1(index)) {
        i = $index + index;
      } else if (isFunction(index)) {
        i = index($index);
      }
      return h("div", {}, [i]);
    },
    sortable: false
  },
  expand: {
    renderHeader({
      column
    }) {
      return column.label || "";
    },
    renderCell({
      column,
      row,
      store,
      expanded,
      $index
    }) {
      var _a, _b, _c;
      const { ns } = store;
      const classes = [ns.e("expand-icon")];
      if (!column.renderExpand && expanded) {
        classes.push(ns.em("expand-icon", "expanded"));
      }
      const callback = function(e) {
        e.stopPropagation();
        store.toggleRowExpansion(row);
      };
      const isRowExpandable = (_c = (_b = (_a = store.states.rowExpandable).value) == null ? void 0 : _b.call(_a, row, $index)) != null ? _c : true;
      if (!isRowExpandable) {
        classes.push(ns.is("disabled"));
      }
      return h(
        "button",
        {
          type: "button",
          disabled: !isRowExpandable,
          "aria-label": store.t(
            expanded ? "el.table.collapseRowLabel" : "el.table.expandRowLabel"
          ),
          "aria-expanded": expanded,
          class: classes,
          onClick: callback
        },
        {
          default: () => {
            if (column.renderExpand) {
              return [
                column.renderExpand({
                  expanded,
                  expandable: isRowExpandable
                })
              ];
            }
            return [
              h(ElIcon, null, {
                default: () => {
                  return [h(arrow_right_default)];
                }
              })
            ];
          }
        }
      );
    },
    sortable: false,
    resizable: false
  }
};
function defaultRenderCell({
  row,
  column,
  $index
}) {
  var _a;
  const property = column.property;
  const value = property && getProp(row, property).value;
  if (column && column.formatter) {
    return column.formatter(row, column, value, $index);
  }
  return ((_a = value == null ? void 0 : value.toString) == null ? void 0 : _a.call(value)) || "";
}
function treeCellPrefix({
  row,
  treeNode,
  store
}, createPlaceholder = false) {
  const { ns } = store;
  if (!treeNode) {
    if (createPlaceholder) {
      return [
        h("span", {
          class: ns.e("placeholder")
        })
      ];
    }
    return null;
  }
  const ele = [];
  const callback = function(e) {
    e.stopPropagation();
    if (treeNode.loading) {
      return;
    }
    store.loadOrToggle(row);
  };
  if (treeNode.indent) {
    ele.push(
      h("span", {
        class: ns.e("indent"),
        style: { "padding-left": `${treeNode.indent}px` }
      })
    );
  }
  if (isBoolean$1(treeNode.expanded) && !treeNode.noLazyChildren) {
    const expandClasses = [
      ns.e("expand-icon"),
      treeNode.expanded ? ns.em("expand-icon", "expanded") : ""
    ];
    let icon = arrow_right_default;
    if (treeNode.loading) {
      icon = loading_default;
    }
    ele.push(
      h(
        "button",
        {
          type: "button",
          "aria-label": store.t(
            treeNode.expanded ? "el.table.collapseRowLabel" : "el.table.expandRowLabel"
          ),
          "aria-expanded": treeNode.expanded,
          class: expandClasses,
          onClick: callback
        },
        {
          default: () => {
            return [
              h(
                ElIcon,
                { class: ns.is("loading", treeNode.loading) },
                {
                  default: () => [h(icon)]
                }
              )
            ];
          }
        }
      )
    );
  } else {
    ele.push(
      h("span", {
        class: ns.e("placeholder")
      })
    );
  }
  return ele;
}
function getAllAliases(props, aliases) {
  return props.reduce((prev, cur) => {
    prev[cur] = cur;
    return prev;
  }, aliases);
}
function useWatcher(owner, props_) {
  const instance = getCurrentInstance();
  const registerComplexWatchers = () => {
    const props = ["fixed"];
    const aliases = {
      realWidth: "width",
      realMinWidth: "minWidth"
    };
    const allAliases = getAllAliases(props, aliases);
    Object.keys(allAliases).forEach((key) => {
      const columnKey = aliases[key];
      if (hasOwn(props_, columnKey)) {
        watch(
          () => props_[columnKey],
          (newVal) => {
            let value = newVal;
            if (columnKey === "width" && key === "realWidth") {
              value = parseWidth(newVal);
            }
            if (columnKey === "minWidth" && key === "realMinWidth") {
              value = parseMinWidth(newVal);
            }
            instance.columnConfig.value[columnKey] = value;
            instance.columnConfig.value[key] = value;
            const updateColumns = columnKey === "fixed";
            owner.value.store.scheduleLayout(updateColumns);
          }
        );
      }
    });
  };
  const registerNormalWatchers = () => {
    const props = [
      "label",
      "filters",
      "filterMultiple",
      "filteredValue",
      "sortable",
      "index",
      "formatter",
      "className",
      "labelClassName",
      "filterClassName",
      "showOverflowTooltip",
      "tooltipFormatter",
      "resizable"
    ];
    const parentProps = ["showOverflowTooltip"];
    const aliases = {
      property: "prop",
      align: "realAlign",
      headerAlign: "realHeaderAlign"
    };
    const allAliases = getAllAliases(props, aliases);
    Object.keys(allAliases).forEach((key) => {
      const columnKey = aliases[key];
      if (hasOwn(props_, columnKey)) {
        watch(
          () => props_[columnKey],
          (newVal) => {
            instance.columnConfig.value[key] = newVal;
            if (key === "filters" || key === "filterMethod") {
              instance.columnConfig.value["filterable"] = !!(instance.columnConfig.value["filters"] || instance.columnConfig.value["filterMethod"]);
            }
          }
        );
      }
    });
    parentProps.forEach((key) => {
      if (hasOwn(owner.value.props, key)) {
        watch(
          () => owner.value.props[key],
          (newVal) => {
            if (instance.columnConfig.value.type === "selection") return;
            if (!isUndefined(props_[key])) return;
            instance.columnConfig.value[key] = newVal;
          }
        );
      }
    });
  };
  return {
    registerComplexWatchers,
    registerNormalWatchers
  };
}
function useRender(props, slots, owner) {
  const instance = getCurrentInstance();
  const columnId = ref("");
  const isSubColumn = ref(false);
  const realAlign = ref();
  const realHeaderAlign = ref();
  const ns = useNamespace("table");
  watchEffect(() => {
    realAlign.value = props.align ? `is-${props.align}` : null;
    realAlign.value;
  });
  watchEffect(() => {
    realHeaderAlign.value = props.headerAlign ? `is-${props.headerAlign}` : realAlign.value;
    realHeaderAlign.value;
  });
  const columnOrTableParent = computed(() => {
    let parent = instance.vnode.vParent || instance.parent;
    while (parent && !parent.tableId && !parent.columnId) {
      parent = parent.vnode.vParent || parent.parent;
    }
    return parent;
  });
  const hasTreeColumn = computed(() => {
    const { store } = instance.parent;
    if (!store) return false;
    const { treeData } = store.states;
    const treeDataValue = treeData.value;
    return treeDataValue && Object.keys(treeDataValue).length > 0;
  });
  const realWidth = ref(parseWidth(props.width));
  const realMinWidth = ref(parseMinWidth(props.minWidth));
  const setColumnWidth = (column) => {
    if (realWidth.value) column.width = realWidth.value;
    if (realMinWidth.value) {
      column.minWidth = realMinWidth.value;
    }
    if (!realWidth.value && realMinWidth.value) {
      column.width = void 0;
    }
    if (!column.minWidth) {
      column.minWidth = 80;
    }
    column.realWidth = Number(
      isUndefined(column.width) ? column.minWidth : column.width
    );
    return column;
  };
  const setColumnForcedProps = (column) => {
    const type = column.type;
    const source = cellForced[type] || {};
    Object.keys(source).forEach((prop) => {
      const value = source[prop];
      if (prop !== "className" && !isUndefined(value)) {
        column[prop] = value;
      }
    });
    const className = getDefaultClassName(type);
    if (className) {
      const forceClass = `${unref(ns.namespace)}-${className}`;
      column.className = column.className ? `${column.className} ${forceClass}` : forceClass;
    }
    return column;
  };
  const checkSubColumn = (children) => {
    if (isArray(children)) {
      children.forEach((child) => check(child));
    } else {
      check(children);
    }
    function check(item) {
      var _a;
      if (((_a = item == null ? void 0 : item.type) == null ? void 0 : _a.name) === "ElTableColumn") {
        item.vParent = instance;
      }
    }
  };
  const setColumnRenders = (column) => {
    if (props.renderHeader) ; else if (column.type !== "selection") {
      column.renderHeader = (scope) => {
        instance.columnConfig.value["label"];
        if (slots.header) {
          const slotResult = slots.header(scope);
          if (ensureValidVNode(slotResult)) {
            return h(Fragment, slotResult);
          }
        }
        return createTextVNode(column.label);
      };
    }
    if (slots["filter-icon"]) {
      column.renderFilterIcon = (scope) => {
        return renderSlot(slots, "filter-icon", scope);
      };
    }
    if (slots.expand) {
      column.renderExpand = (scope) => {
        return renderSlot(slots, "expand", scope);
      };
    }
    let originRenderCell = column.renderCell;
    if (column.type === "expand") {
      column.renderCell = (data) => h(
        "div",
        {
          class: "cell"
        },
        [originRenderCell(data)]
      );
      owner.value.renderExpanded = (row) => {
        return slots.default ? slots.default(row) : slots.default;
      };
    } else {
      originRenderCell = originRenderCell || defaultRenderCell;
      column.renderCell = (data) => {
        let children = null;
        if (slots.default) {
          const vnodes = slots.default(data);
          children = vnodes.some((v) => v.type !== Comment) ? vnodes : originRenderCell(data);
        } else {
          children = originRenderCell(data);
        }
        const { columns } = owner.value.store.states;
        const firstUserColumnIndex = columns.value.findIndex(
          (item) => item.type === "default"
        );
        const shouldCreatePlaceholder = hasTreeColumn.value && data.cellIndex === firstUserColumnIndex;
        const prefix = treeCellPrefix(data, shouldCreatePlaceholder);
        const props2 = {
          class: "cell",
          style: {}
        };
        if (column.showOverflowTooltip) {
          props2.class = `${props2.class} ${unref(ns.namespace)}-tooltip`;
          props2.style = {
            width: `${(data.column.realWidth || Number(data.column.width)) - 1}px`
          };
        }
        checkSubColumn(children);
        return h("div", props2, [prefix, children]);
      };
    }
    return column;
  };
  const getPropsData = (...propsKey) => {
    return propsKey.reduce(
      (prev, cur) => {
        if (isArray(cur)) {
          cur.forEach((key) => {
            prev[key] = props[key];
          });
        }
        return prev;
      },
      {}
    );
  };
  const getColumnElIndex = (children, child) => {
    return Array.prototype.indexOf.call(children, child);
  };
  const updateColumnOrder = () => {
    owner.value.store.commit("updateColumnOrder", instance.columnConfig.value);
  };
  return {
    columnId,
    realAlign,
    isSubColumn,
    realHeaderAlign,
    columnOrTableParent,
    setColumnWidth,
    setColumnForcedProps,
    setColumnRenders,
    getPropsData,
    getColumnElIndex,
    updateColumnOrder
  };
}
var defaultProps = {
  /**
   * @description type of the column. If set to `selection`, the column will display checkbox. If set to `index`, the column will display index of the row (staring from 1). If set to `expand`, the column will display expand icon
   */
  type: {
    type: String,
    default: "default"
  },
  /**
   * @description column label
   */
  label: String,
  /**
   * @description class name of cells in the column
   */
  className: String,
  /**
   * @description class name of the label of this column
   */
  labelClassName: String,
  /**
   * @description
   */
  property: String,
  /**
   * @description field name. You can also use its alias: `property`
   */
  prop: String,
  /**
   * @description column width
   */
  width: {
    type: [String, Number],
    default: ""
  },
  /**
   * @description column minimum width. Columns with `width` has a fixed width, while columns with `min-width` has a width that is distributed in proportion
   */
  minWidth: {
    type: [String, Number],
    default: ""
  },
  /**
   * @description render function for table header of this column
   */
  renderHeader: Function,
  /**
   * @description whether column can be sorted. Remote sorting can be done by setting this attribute to 'custom' and listening to the `sort-change` event of Table
   */
  sortable: {
    type: [Boolean, String],
    default: false
  },
  /**
   * @description sorting method, works when `sortable` is `true`. Should return a number, just like Array.sort
   */
  sortMethod: Function,
  /**
   * @description specify which property to sort by, works when `sortable` is `true` and `sort-method` is `undefined`. If set to an Array, the column will sequentially sort by the next property if the previous one is equal
   */
  sortBy: [String, Function, Array],
  /**
   * @description whether column width can be resized, works when `border` of `el-table` is `true`
   */
  resizable: {
    type: Boolean,
    default: true
  },
  /**
   * @description column's key. If you need to use the filter-change event, you need this attribute to identify which column is being filtered
   */
  columnKey: String,
  /**
   * @description alignment, the value should be 'left' \/ 'center' \/ 'right'
   */
  align: String,
  /**
   * @description alignment of the table header. If omitted, the value of the above `align` attribute will be applied, the value should be 'left' \/ 'center' \/ 'right'
   */
  headerAlign: String,
  /**
   * @description whether to hide extra content and show them in a tooltip when hovering on the cell
   */
  showOverflowTooltip: {
    type: [Boolean, Object],
    default: void 0
  },
  /**
   * @description function that formats cell tooltip content, works when `show-overflow-tooltip` is `true`
   */
  tooltipFormatter: Function,
  /**
   * @description whether column is fixed at left / right. Will be fixed at left if `true`
   */
  fixed: [Boolean, String],
  /**
   * @description function that formats cell content
   */
  formatter: Function,
  /**
   * @description function that determines if a certain row can be selected, works when `type` is 'selection'
   */
  selectable: Function,
  /**
   * @description whether to reserve selection after data refreshing, works when `type` is 'selection'. Note that `row-key` is required for this to work
   */
  reserveSelection: Boolean,
  /**
   * @description data filtering method. If `filter-multiple` is on, this method will be called multiple times for each row, and a row will display if one of the calls returns `true`
   */
  filterMethod: Function,
  /**
   * @description filter value for selected data, might be useful when table header is rendered with `render-header`
   */
  filteredValue: Array,
  /**
   * @description an array of data filtering options. For each element in this array, `text` and `value` are required
   */
  filters: Array,
  /**
   * @description placement for the filter dropdown
   */
  filterPlacement: String,
  /**
   * @description whether data filtering supports multiple options
   */
  filterMultiple: {
    type: Boolean,
    default: true
  },
  /**
   * @description className for the filter dropdown
   */
  filterClassName: String,
  /**
   * @description customize indices for each row, works on columns with `type=index`
   */
  index: [Number, Function],
  /**
   * @description the order of the sorting strategies used when sorting the data, works when `sortable` is `true`. Accepts an array, as the user clicks on the header, the column is sorted in order of the elements in the array
   */
  sortOrders: {
    type: Array,
    default: () => {
      return ["ascending", "descending", null];
    },
    validator: (val) => {
      return val.every(
        (order) => ["ascending", "descending", null].includes(order)
      );
    }
  }
};
let columnIdSeed = 1;
var ElTableColumn$1 = defineComponent({
  name: "ElTableColumn",
  components: {
    ElCheckbox
  },
  props: defaultProps,
  setup(props, { slots }) {
    const instance = getCurrentInstance();
    const columnConfig = ref({});
    const owner = computed(() => {
      let parent2 = instance.parent;
      while (parent2 && !parent2.tableId) {
        parent2 = parent2.parent;
      }
      return parent2;
    });
    useWatcher(
      owner,
      props
    );
    const {
      columnId,
      columnOrTableParent
    } = useRender(props, slots, owner);
    const parent = columnOrTableParent.value;
    columnId.value = `${"tableId" in parent && parent.tableId || "columnId" in parent && parent.columnId}_column_${columnIdSeed++}`;
    instance.columnId = columnId.value;
    instance.columnConfig = columnConfig;
    return;
  },
  render() {
    var _a, _b, _c;
    try {
      const renderDefault = (_b = (_a = this.$slots).default) == null ? void 0 : _b.call(_a, {
        row: {},
        column: {},
        $index: -1
      });
      const children = [];
      if (isArray(renderDefault)) {
        for (const childNode of renderDefault) {
          if (((_c = childNode.type) == null ? void 0 : _c.name) === "ElTableColumn" || childNode.shapeFlag & 2) {
            children.push(childNode);
          } else if (childNode.type === Fragment && isArray(childNode.children)) {
            childNode.children.forEach((vnode2) => {
              if ((vnode2 == null ? void 0 : vnode2.patchFlag) !== 1024 && !isString(vnode2 == null ? void 0 : vnode2.children)) {
                children.push(vnode2);
              }
            });
          }
        }
      }
      const vnode = h("div", children);
      return vnode;
    } catch (e) {
      return h("div", []);
    }
  }
});
const ElTable = withInstall(Table, {
  TableColumn: ElTableColumn$1
});
const ElTableColumn = withNoopInstall(ElTableColumn$1);
const _sfc_main = {
  __name: "CustomPostList",
  __ssrInlineRender: true,
  props: ["data", "settings", "id", "archive"],
  setup(__props) {
    const props = __props;
    const { locale } = useI18n();
    const ready = ref(false);
    const opts = computed(() => {
      try {
        return JSON.parse(props.settings?.["settingsData"]);
      } catch (error) {
        return {};
      }
    });
    const langs = {
      title: {
        "zh-hans": "项目名称",
        en: "Project Name",
        es: "Nombre del Proyecto"
      },
      date: {
        "zh-hans": "时间",
        en: "Date",
        es: "Fecha"
      }
    };
    const tableColName = (key) => {
      const index = opts.value.keys.findIndex((item2) => item2.key === key);
      if (index === -1) {
        return null;
      }
      const item = opts.value.keys[index];
      if (item.name) {
        return item.name;
      }
      return null;
    };
    const locked = ref(false);
    const catPicked = ref(null);
    watch(
      () => props.data?.menu,
      (newVal) => {
        if (newVal?.nodes?.length > 0) {
          catPicked.value = newVal?.nodes[0]?.databaseId;
        }
      },
      {
        immediate: true
      }
    );
    const categorySelect = async (id) => {
      catPicked.value = id;
      await getData(null, id);
    };
    const pageAction = async (direction) => {
      await getData(direction);
    };
    const getData = async (direction = null, category = null) => {
      if (locked.value) {
        return;
      }
      locked.value = true;
      let before = "";
      let after = "";
      if (!category && direction === "forward") {
        before = `last: ${opts.value.first}, before: "${props.data?.list?.pageInfo?.startCursor}",`;
      }
      if (!category && direction === "next") {
        after = `first: ${opts.value.first}, after: "${props.data?.list?.pageInfo?.endCursor}",`;
      }
      if (!before && !after) {
        after = `first: ${opts.value.first}`;
      }
      const res = await useRequest("/api/request", {
        body: {
          queryStr: `{
        guaqi {
            common {
            module {
                post {
                list( ${before}${after} where: {lang: "${locale.value}", categoryIn: [${catPicked.value}], orderby: {field: ${opts.value.orderby}, order: ${opts.value.order}}}) {
                    edges {
                    node {
                        title
                        dateGmt
                        gqSlug
                        myPrefixType
                        myPrefixAmount
                        myPrefixTask
                        myPrefixTitle
                        myPrefixIcon
                    }
                    }
                    pageInfo {
                        endCursor
                        hasNextPage
                        hasPreviousPage
                        startCursor
                    }
                }
                }
            }
            }
        }
        }`
        }
      });
      locked.value = false;
      if (res?.guaqi?.common?.module?.post?.list) {
        props.data.list = res.guaqi.common.module.post.list;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      const _component_el_table = ElTable;
      const _component_el_table_column = ElTableColumn;
      const _component_Blink = _sfc_main$4;
      const _component_el_avatar = ElAvatar;
      const _component_TimeAgo = _sfc_main$5;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "custom-html" }, _attrs))} data-v-c584d53d><div class="mb-2 flex items-center justify-between gap-2" data-v-c584d53d><div class="line-clamp-1" data-v-c584d53d>${ssrInterpolate(unref(opts).title[_ctx.$i18n.locale])}</div><div class="text-sm text-gray-500" data-v-c584d53d><!--[-->`);
      ssrRenderList(__props.data?.menu?.nodes, (item) => {
        _push(ssrRenderComponent(_component_el_button, {
          text: "",
          bg: "",
          size: "small",
          class: {
            "!bg-[var(--el-color-primary-light-9)] !text-[--el-color-primary-dark-2]": unref(catPicked) === item.databaseId
          },
          key: item.databaseId,
          onClick: ($event) => categorySelect(item.databaseId)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(item.name)}`);
            } else {
              return [
                createTextVNode(toDisplayString(item.name), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div></div><div class="border-1 rounded overflow-hidden min-h-50" data-v-c584d53d>`);
      if (__props.data?.list?.edges && unref(ready)) {
        _push(ssrRenderComponent(_component_el_table, {
          data: __props.data?.list?.edges || [],
          "scrollbar-always-on": false,
          style: { "--el-table-tr-bg-color": "var(--tbg)", "--el-table-bg-color": "var(--tbg)" },
          fit: "",
          flexible: "",
          "table-layout": "fixed",
          size: "small",
          "empty-text": "---"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_el_table_column, {
                fixed: "",
                prop: "title",
                key: "title-fixed",
                label: langs?.title?.[unref(locale)],
                width: "150"
              }, {
                default: withCtx(({ row }, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_Blink, {
                      to: row?.node?.gqSlug,
                      class: "flex items-center gap-2"
                    }, {
                      default: withCtx((_2, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_el_avatar, {
                            src: row?.node?.myPrefixIcon,
                            size: "small"
                          }, null, _parent4, _scopeId3));
                          _push4(`<div class="line-clamp-1 flex-1" data-v-c584d53d${_scopeId3}>${ssrInterpolate(row?.node?.myPrefixTitle)}</div>`);
                        } else {
                          return [
                            createVNode(_component_el_avatar, {
                              src: row?.node?.myPrefixIcon,
                              size: "small"
                            }, null, 8, ["src"]),
                            createVNode("div", { class: "line-clamp-1 flex-1" }, toDisplayString(row?.node?.myPrefixTitle), 1)
                          ];
                        }
                      }),
                      _: 2
                    }, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_Blink, {
                        to: row?.node?.gqSlug,
                        class: "flex items-center gap-2"
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_el_avatar, {
                            src: row?.node?.myPrefixIcon,
                            size: "small"
                          }, null, 8, ["src"]),
                          createVNode("div", { class: "line-clamp-1 flex-1" }, toDisplayString(row?.node?.myPrefixTitle), 1)
                        ]),
                        _: 2
                      }, 1032, ["to"])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_table_column, {
                prop: "myPrefixType",
                key: "myPrefixType-normal",
                label: tableColName("myPrefixType")?.[unref(locale)] || "Type"
              }, {
                default: withCtx(({ row }, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="line-clamp-1" data-v-c584d53d${_scopeId2}>${ssrInterpolate(row?.node?.myPrefixType || "--")}</div>`);
                  } else {
                    return [
                      createVNode("div", { class: "line-clamp-1" }, toDisplayString(row?.node?.myPrefixType || "--"), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_table_column, {
                prop: "myPrefixAmount",
                key: "myPrefixAmount-normal",
                label: tableColName("myPrefixAmount")?.[unref(locale)] || "Amount"
              }, {
                default: withCtx(({ row }, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="line-clamp-1" data-v-c584d53d${_scopeId2}>${ssrInterpolate(row?.node?.myPrefixAmount || "--")}</div>`);
                  } else {
                    return [
                      createVNode("div", { class: "line-clamp-1" }, toDisplayString(row?.node?.myPrefixAmount || "--"), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_table_column, {
                prop: "myPrefixTask",
                key: "myPrefixTask-normal",
                label: tableColName("myPrefixTask")?.[unref(locale)] || "Task"
              }, {
                default: withCtx(({ row }, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="line-clamp-1" data-v-c584d53d${_scopeId2}>${ssrInterpolate(row?.node?.myPrefixTask || "--")}</div>`);
                  } else {
                    return [
                      createVNode("div", { class: "line-clamp-1" }, toDisplayString(row?.node?.myPrefixTask || "--"), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_table_column, {
                prop: "dateGmt",
                key: "dateGmt-normal",
                label: langs?.date?.[unref(locale)]
              }, {
                default: withCtx(({ row }, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_TimeAgo, {
                      date: row?.node?.dateGmt
                    }, null, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_TimeAgo, {
                        date: row?.node?.dateGmt
                      }, null, 8, ["date"])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_el_table_column, {
                  fixed: "",
                  prop: "title",
                  key: "title-fixed",
                  label: langs?.title?.[unref(locale)],
                  width: "150"
                }, {
                  default: withCtx(({ row }) => [
                    createVNode(_component_Blink, {
                      to: row?.node?.gqSlug,
                      class: "flex items-center gap-2"
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_el_avatar, {
                          src: row?.node?.myPrefixIcon,
                          size: "small"
                        }, null, 8, ["src"]),
                        createVNode("div", { class: "line-clamp-1 flex-1" }, toDisplayString(row?.node?.myPrefixTitle), 1)
                      ]),
                      _: 2
                    }, 1032, ["to"])
                  ]),
                  _: 1
                }, 8, ["label"]),
                createVNode(_component_el_table_column, {
                  prop: "myPrefixType",
                  key: "myPrefixType-normal",
                  label: tableColName("myPrefixType")?.[unref(locale)] || "Type"
                }, {
                  default: withCtx(({ row }) => [
                    createVNode("div", { class: "line-clamp-1" }, toDisplayString(row?.node?.myPrefixType || "--"), 1)
                  ]),
                  _: 1
                }, 8, ["label"]),
                createVNode(_component_el_table_column, {
                  prop: "myPrefixAmount",
                  key: "myPrefixAmount-normal",
                  label: tableColName("myPrefixAmount")?.[unref(locale)] || "Amount"
                }, {
                  default: withCtx(({ row }) => [
                    createVNode("div", { class: "line-clamp-1" }, toDisplayString(row?.node?.myPrefixAmount || "--"), 1)
                  ]),
                  _: 1
                }, 8, ["label"]),
                createVNode(_component_el_table_column, {
                  prop: "myPrefixTask",
                  key: "myPrefixTask-normal",
                  label: tableColName("myPrefixTask")?.[unref(locale)] || "Task"
                }, {
                  default: withCtx(({ row }) => [
                    createVNode("div", { class: "line-clamp-1" }, toDisplayString(row?.node?.myPrefixTask || "--"), 1)
                  ]),
                  _: 1
                }, 8, ["label"]),
                createVNode(_component_el_table_column, {
                  prop: "dateGmt",
                  key: "dateGmt-normal",
                  label: langs?.date?.[unref(locale)]
                }, {
                  default: withCtx(({ row }) => [
                    createVNode(_component_TimeAgo, {
                      date: row?.node?.dateGmt
                    }, null, 8, ["date"])
                  ]),
                  _: 1
                }, 8, ["label"])
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flex items-center justify-center py-2" data-v-c584d53d>`);
      _push(ssrRenderComponent(_component_el_button, {
        text: "",
        bg: "",
        circle: "",
        size: "small",
        onClick: ($event) => pageAction("forward"),
        disabled: !__props.data?.list?.pageInfo?.hasPreviousPage || unref(locked)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-caret-left" data-v-c584d53d${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-caret-left" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        text: "",
        bg: "",
        circle: "",
        size: "small",
        onClick: ($event) => pageAction("next"),
        disabled: !__props.data?.list?.pageInfo?.hasNextPage || unref(locked)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-caret-right" data-v-c584d53d${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-caret-right" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/custom/app/components/custom/postList.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const postList = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-c584d53d"]]);

export { postList as default };
