import { mergeProps, createVNode, resolveDynamicComponent, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderVNode } from 'vue/server-renderer';
import { l as loadComponent } from './server.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesSingleContentRechText",
  __ssrInlineRender: true,
  props: ["content", "link", "isModal"],
  setup(__props) {
    const compMap = {
      audio: loadComponent("modules/common/topic", "audio"),
      video: loadComponent("modules/common/topic", "video"),
      file: loadComponent("modules/common/topic", "file"),
      form: loadComponent("modules/common/form", "formInner")
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "entry-content markdown-body single-content" }, _attrs))}>`);
      if (!__props.content) {
        _push(`<div class="min-h-30"></div>`);
      } else if (typeof __props.content === "string") {
        _push(`<div>${__props.content ?? ""}</div>`);
      } else {
        _push(`<!--[-->`);
        ssrRenderList(__props.content, (b, idx) => {
          _push(`<!--[-->`);
          if (b.type === "paragraph") {
            _push(`<div>${b.html ?? ""}</div>`);
          } else {
            _push(`<!---->`);
          }
          if (b.type === "code") {
            _push(`<div>${b.html ?? ""}</div>`);
          } else {
            ssrRenderVNode(_push, createVNode(resolveDynamicComponent(compMap[b.type]), mergeProps({ ref_for: true }, b, { class: "my-2" }), null), _parent);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]-->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/single/content/rechText.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
