import { E as ElDialog } from './index-awVc4A7-.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import { E as ElRadioGroup, a as ElRadio } from './index-CCMOIr7X.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { j as actionStore, g as getServerSettings, v as viewerStore, a as useI18n, x as __nuxt_component_0$1 } from './server.mjs';
import { useSSRContext, ref, computed, reactive, unref, withCtx, createTextVNode, toDisplayString, createVNode, openBlock, createBlock, Fragment, renderList } from 'vue';
import { ssrRenderComponent, ssrInterpolate, ssrRenderList } from 'vue/server-renderer';
import NumberFlow from '@number-flow/vue';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './use-dialog-7J0bwlna.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import 'lodash-unified';
import './aria-BhThsKez.mjs';
import './event-BZTOGHfp.mjs';
import '@vue/shared';
import './vnode-l2ZP2UQa.mjs';
import './index-Di0Jlzch.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './index-DRiwogtD.mjs';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import './index-Bp-nwGzu.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesAccountWealthRecharge",
  __ssrInlineRender: true,
  emits: ["success"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const action = actionStore();
    const settingsStore = getServerSettings();
    const viewer = viewerStore();
    const payRef = ref(null);
    const { t } = useI18n();
    const emits = __emit;
    const rechargePreset = computed(() => {
      let r = settingsStore?.wealth_settings?.balance?.recharge_preset[action.currency.iso];
      if (!r) {
        return [];
      }
      return r.split(",");
    });
    const state = reactive({
      show: false,
      amount: rechargePreset.value[0],
      success: (type) => {
        state.show = false;
        emits("success", "recharge");
      },
      pay: () => {
        if (state.amount == 0) {
          return;
        }
        state.show = false;
        payRef.value.state.show({
          title: t("page.account.wealth.recharge"),
          thumb: "",
          postId: 0,
          args: {
            index: 0,
            roleIndex: 0
          },
          count: 0,
          expiredAt: "",
          payment: "money",
          type: "recharge",
          finalPrice: state.amount,
          price: state.amount
        });
      }
    });
    __expose({
      state
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_dialog = ElDialog;
      const _component_el_input = ElInput;
      const _component_el_radio_group = ElRadioGroup;
      const _component_el_radio = ElRadio;
      const _component_el_button = ElButton;
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_el_dialog, {
        modelValue: unref(state).show,
        "onUpdate:modelValue": ($event) => unref(state).show = $event,
        title: _ctx.$t("page.account.wealth.recharge"),
        width: "280",
        "lock-scroll": false,
        "append-to-body": true,
        "modal-class": unref(action).moneyPay.show ? "hidden-overlay" : ""
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div data-v-0ef03187${_scopeId}><div class="flex justify-center items-baseline text-[--el-color-primary] mb-6" data-v-0ef03187${_scopeId}><span class="text-lg font-600" data-v-0ef03187${_scopeId}>${ssrInterpolate(unref(action).currency.symbol)}</span>`);
            if (unref(settingsStore).wealth_settings.balance.can_self_recharge != 0) {
              _push2(ssrRenderComponent(_component_el_input, {
                modelValue: unref(state).amount,
                "onUpdate:modelValue": ($event) => unref(state).amount = $event,
                size: "large",
                "controls-position": "none",
                class: "!text-5xl !p-0 !w-fit border-b !h-12 border-[--el-border-color-dark] !pl-1 hide-spinners",
                style: { "--el-input-border-color": "transparent", "--el-input-hover-border-color": "transparent", "--el-input-focus-border-color": "transparent", "--el-input-text-color": "--el-color-primary" }
              }, null, _parent2, _scopeId));
            } else {
              _push2(`<span class="text-5xl ml-1" data-v-0ef03187${_scopeId}>${ssrInterpolate(unref(state).amount)}</span>`);
            }
            _push2(`</div>`);
            _push2(ssrRenderComponent(_component_el_radio_group, {
              modelValue: unref(state).amount,
              "onUpdate:modelValue": ($event) => unref(state).amount = $event,
              class: "!grid grid-cols-3 gap-2",
              style: { "--el-border": "1px solid var(--el-border-color-dark)" },
              size: "large"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<!--[-->`);
                  ssrRenderList(unref(rechargePreset), (item, i) => {
                    _push3(ssrRenderComponent(_component_el_radio, {
                      key: i,
                      value: item,
                      border: "",
                      class: "!m-0 bg-[--el-color-info-light-10]"
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(unref(action).currency.symbol)} `);
                          _push4(ssrRenderComponent(unref(NumberFlow), {
                            value: item,
                            format: {
                              minimumFractionDigits: 2,
                              maximumFractionDigits: 2,
                              useGrouping: false
                            }
                          }, null, _parent4, _scopeId3));
                        } else {
                          return [
                            createTextVNode(toDisplayString(unref(action).currency.symbol) + " ", 1),
                            createVNode(unref(NumberFlow), {
                              value: item,
                              format: {
                                minimumFractionDigits: 2,
                                maximumFractionDigits: 2,
                                useGrouping: false
                              }
                            }, null, 8, ["value"])
                          ];
                        }
                      }),
                      _: 2
                    }, _parent3, _scopeId2));
                  });
                  _push3(`<!--]-->`);
                } else {
                  return [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(rechargePreset), (item, i) => {
                      return openBlock(), createBlock(_component_el_radio, {
                        key: i,
                        value: item,
                        border: "",
                        class: "!m-0 bg-[--el-color-info-light-10]"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(unref(action).currency.symbol) + " ", 1),
                          createVNode(unref(NumberFlow), {
                            value: item,
                            format: {
                              minimumFractionDigits: 2,
                              maximumFractionDigits: 2,
                              useGrouping: false
                            }
                          }, null, 8, ["value"])
                        ]),
                        _: 2
                      }, 1032, ["value"]);
                    }), 128))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`<div class="text-xs text-[--el-color-danger-dark-2] mt-4 border-1 border-[--el-color-danger-light-7] rounded p-2 bg-[--el-color-danger-light-9]" data-v-0ef03187${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.wealth.rechargeBox.balance"))}${ssrInterpolate(unref(action).currency.symbol + (unref(viewer).data?.gqMoney[unref(action).currency.iso] || 0))}</div>`);
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              class: "mt-4 w-full",
              onClick: unref(state).pay,
              disabled: unref(state).amount == 0
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("common.edit.ok"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("common.edit.ok")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", null, [
                createVNode("div", { class: "flex justify-center items-baseline text-[--el-color-primary] mb-6" }, [
                  createVNode("span", { class: "text-lg font-600" }, toDisplayString(unref(action).currency.symbol), 1),
                  unref(settingsStore).wealth_settings.balance.can_self_recharge != 0 ? (openBlock(), createBlock(_component_el_input, {
                    key: 0,
                    modelValue: unref(state).amount,
                    "onUpdate:modelValue": ($event) => unref(state).amount = $event,
                    size: "large",
                    "controls-position": "none",
                    class: "!text-5xl !p-0 !w-fit border-b !h-12 border-[--el-border-color-dark] !pl-1 hide-spinners",
                    style: { "--el-input-border-color": "transparent", "--el-input-hover-border-color": "transparent", "--el-input-focus-border-color": "transparent", "--el-input-text-color": "--el-color-primary" }
                  }, null, 8, ["modelValue", "onUpdate:modelValue"])) : (openBlock(), createBlock("span", {
                    key: 1,
                    class: "text-5xl ml-1"
                  }, toDisplayString(unref(state).amount), 1))
                ]),
                createVNode(_component_el_radio_group, {
                  modelValue: unref(state).amount,
                  "onUpdate:modelValue": ($event) => unref(state).amount = $event,
                  class: "!grid grid-cols-3 gap-2",
                  style: { "--el-border": "1px solid var(--el-border-color-dark)" },
                  size: "large"
                }, {
                  default: withCtx(() => [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(rechargePreset), (item, i) => {
                      return openBlock(), createBlock(_component_el_radio, {
                        key: i,
                        value: item,
                        border: "",
                        class: "!m-0 bg-[--el-color-info-light-10]"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(unref(action).currency.symbol) + " ", 1),
                          createVNode(unref(NumberFlow), {
                            value: item,
                            format: {
                              minimumFractionDigits: 2,
                              maximumFractionDigits: 2,
                              useGrouping: false
                            }
                          }, null, 8, ["value"])
                        ]),
                        _: 2
                      }, 1032, ["value"]);
                    }), 128))
                  ]),
                  _: 1
                }, 8, ["modelValue", "onUpdate:modelValue"]),
                createVNode("div", { class: "text-xs text-[--el-color-danger-dark-2] mt-4 border-1 border-[--el-color-danger-light-7] rounded p-2 bg-[--el-color-danger-light-9]" }, toDisplayString(_ctx.$t("page.account.wealth.rechargeBox.balance")) + toDisplayString(unref(action).currency.symbol + (unref(viewer).data?.gqMoney[unref(action).currency.iso] || 0)), 1),
                createVNode(_component_el_button, {
                  type: "primary",
                  class: "mt-4 w-full",
                  onClick: unref(state).pay,
                  disabled: unref(state).amount == 0
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("common.edit.ok")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick", "disabled"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/account/wealth/recharge.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_7 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-0ef03187"]]);

export { __nuxt_component_7 as default };
