import { useSSRContext, ref, mergeProps, unref } from 'vue';
import { ssrRenderAttrs, ssrRenderSlotInner, ssrRenderList, ssrRenderClass } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import { s as useIntervalFn } from './server.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonReviewCarousel",
  __ssrInlineRender: true,
  props: {
    items: { type: Array, required: true },
    duration: { type: Number, default: 4e3 },
    showDots: { type: Boolean, default: true },
    infinite: { type: Boolean, default: true }
  },
  setup(__props) {
    const props = __props;
    const active = ref(0);
    const { pause, resume } = useIntervalFn(() => {
      const next = active.value + 1;
      if (props.infinite) {
        active.value = next >= props.items.length ? 0 : next;
      } else {
        if (next < props.items.length) active.value = next;
        else pause();
      }
    }, props.duration, { immediate: true });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<section${ssrRenderAttrs(mergeProps({ class: "carousel" }, _attrs))} data-v-ba3b2f3c>`);
      ssrRenderSlotInner(_ctx.$slots, "default", {
        item: __props.items[unref(active)],
        index: unref(active),
        key: unref(active)
      }, null, _push, _parent, null, true);
      if (__props.showDots) {
        _push(`<div class="dots" data-v-ba3b2f3c><!--[-->`);
        ssrRenderList(__props.items, (_, idx) => {
          _push(`<span class="${ssrRenderClass({ active: idx === unref(active) })}" data-v-ba3b2f3c></span>`);
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</section>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/reviewCarousel.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const reviewCarousel = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-ba3b2f3c"]]);

export { reviewCarousel as default };
