import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import _sfc_main$1 from './creditIcon-eOdkwofx.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { g as getServerSettings, v as viewerStore, d as useRoute, j as actionStore, a as useI18n, w as isLogin, e as useUtils, E as ElMessage, r as useRequest, aM as getLoginData, x as __nuxt_component_0$1 } from './server.mjs';
import _sfc_main$2 from './blink-DRvWMg-X.mjs';
import { useSSRContext, computed, ref, reactive, unref, withCtx, createVNode, createTextVNode, toDisplayString, openBlock, createBlock, Fragment, createCommentVNode } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrInterpolate, ssrRenderClass, ssrRenderStyle, ssrRenderAttr } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import 'lodash-unified';
import './image-viewer-DG2qIWb8.mjs';
import './index-ChPMoinw.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-Di0Jlzch.mjs';
import './index-BKB3Djp4.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './svgIcon-BpIUCf-e.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './nuxt-link-Dd6LuEo9.mjs';

const _sfc_main = {
  __name: "CommonFormRoleBox",
  __ssrInlineRender: true,
  props: ["bestRole", "roles", "item", "args", "index"],
  emits: ["success"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const settingsStore = getServerSettings();
    const viewer = viewerStore();
    const emits = __emit;
    const priceFormat = (price, iso) => useUtils.priceFormat(price, iso);
    const route = useRoute();
    const postId = computed(() => parseInt(route.params.page?.split(".")?.[0] || route.meta.pageSettings?.id || route.params.name?.[1]?.split(".")?.[0]));
    const payRef = ref(null);
    const action = actionStore();
    const { t, locale } = useI18n();
    const state = reactive({
      rolePicked: props.bestRole,
      currentRole: computed(() => {
        return props.roles?.[state.rolePicked ?? 0] ?? {};
      }),
      downloadButtonIndex: 0,
      pickedRole: (ri) => {
        state.rolePicked = ri;
      },
      reload: () => {
        getLoginData(action.pageData[route.path]);
        emits("success");
      },
      countDownload: async () => {
        const res = await useRequest("/api/request", {
          body: {
            data: {
              postId: postId.value,
              index: props.index ?? 0,
              type: props.args.type
            }
          }
        });
        if (res?.gqCountAdd?.success) {
          props.item.count++;
        }
      },
      copy: (text) => {
        if (text) {
          (void 0).clipboard.writeText(text);
          ElMessage.success(t("common.edit.copied"));
        }
      },
      showPay: (item) => {
        if (item?.role == "comment") {
          let commentForm = (void 0).querySelector(".comment-form-in .el-textarea__inner");
          if (commentForm) {
            commentForm.focus();
          }
          return;
        }
        if (item?.level != "guest" && item?.level != "all" && !isLogin.value) {
          action.showLogin = true;
          return;
        }
        if (!isLogin.value && item.role == "credit") {
          action.showLogin = true;
          return;
        }
        if (viewer.data.gqLevel !== item.level && viewer.data.gqVIP !== item.level && item.level != "lv" && item.level != "all" && item.level != "vip" && item.level != "guest") {
          useUtils.navigateTo("/account/membership", "_blank");
          return;
        }
        if (item?.role == "qrcode") {
          return;
        }
        if (item.role == "credit" || item.role == "money") {
          payRef.value.state.show({
            title: props.args.title,
            thumb: props.args.thumb[0],
            postId: postId.value,
            args: {
              index: props.args.args.index,
              roleIndex: state.rolePicked ?? 0
            },
            payment: item.role,
            count: props.args.count,
            expiredAt: expiredAt(),
            type: props.args.type,
            finalPrice: item.role == "credit" ? props.roles[state.rolePicked].finalCredit : priceFormat(props.roles[state.rolePicked].finalPrice, action.currency.iso),
            price: item.role == "credit" ? props.roles[state.rolePicked].credit : priceFormat(props.roles[state.rolePicked].price, action.currency.iso)
          });
          return;
        }
        if (item?.allow) {
          const url = props.args.urls[state.downloadButtonIndex]?.url;
          if (url) {
            (void 0).open(url, "_blank");
          }
          return;
        }
      }
    });
    const roleName = (level) => {
      const allText = ["all", "guest", "other", "vip", "lv"];
      if (allText.includes(level)) {
        return t("common.roles." + level);
      }
      const text = useUtils.levelStr(level, settingsStore);
      if (!text) return "Unknown";
      return text.name?.[locale.value] ?? "Unknown";
    };
    const roleType = (r) => {
      if (r?.role == "free" || r?.role == "money" && priceFormat(r?.finalPrice, action.currency.iso) == 0 || r?.role == "credit" && r?.finalCredit == 0) {
        return t("common.roles.free");
      }
      if (r.role == "money") {
        let str = "<span>" + action.currency.symbol + priceFormat(r?.finalPrice, action.currency.iso) + "</span>";
        return str;
      }
      if (r.role == "credit") {
        let str = "<span>" + r?.finalCredit + "</span>";
        return str;
      }
      if (r?.role == "comment") {
        return t("page.article.resource.comment");
      }
      if (r?.role == "login") {
        return t("page.article.resource.login");
      }
      if (r?.role == "qrcode") {
        return t("page.article.resource.qrcode");
      }
    };
    const discount = (r) => {
      if (r.role == "credit") {
        return ((r.credit - r.finalCredit) / r.credit * 100).toFixed(0);
      }
      return ((priceFormat(r.price, action.currency.iso) - priceFormat(r.finalPrice, action.currency.iso)) / priceFormat(r.price, action.currency.iso) * 100).toFixed(0);
    };
    const expiredAt = () => {
      if (state.currentRole?.role == "credit") {
        return state.currentRole?.saleRange?.to && state.currentRole?.finalCredit < state.currentRole?.credit && state.currentRole?.finalCredit > 0 ? state.currentRole.saleRange.to : null;
      }
      return state.currentRole?.saleRange?.to && priceFormat(state.currentRole?.finalPrice, action.currency.iso) < priceFormat(state.currentRole?.price, action.currency.iso) && priceFormat(state.currentRole?.finalPrice, action.currency.iso) > 0 ? state.currentRole.saleRange.to : null;
    };
    const showChangeButton = (role) => {
      if (role.level == "all") return false;
      if (role.level == "vip") {
        return viewer.data?.gqVIP ? false : true;
      }
      if (role.level == "guest") return false;
      if (role.level == "lv") {
        return viewer.data?.gqLevel ? false : true;
      }
      if (viewer.data?.gqVIP == role.level) return false;
      if (viewer.data?.gqLevel == role.level) return false;
      return true;
    };
    const currentUserRoleText = () => {
      const item = state.currentRole;
      let name = roleName(item.level);
      if (item?.level == "all") {
        name = t("common.roles.all");
      }
      if (item?.level == "guest") {
        name = t("common.roles.guest");
      }
      if (item?.level == "other") {
        name = t("common.roles.other");
      }
      if (item?.level == "vip") {
        name = t("common.roles.vip");
      }
      if (item?.level == "lv") {
        name = t("common.roles.lv");
      }
      if (name) {
        name = "<span >「" + name + "」</span>";
      }
      if (item?.role == "free") {
        return name + t("page.article.rolesInfo.disallow.free." + props.args.type);
      }
      if (item?.role == "comment") {
        return name + t("page.article.rolesInfo.disallow.comment." + props.args.type);
      }
      if (item?.role == "money") {
        return name + '<span class="flex items-center">' + t("page.article.rolesInfo.disallow.money." + props.args.type, [
          action.currency.symbol + "" + priceFormat(item?.finalPrice, action.currency.iso)
        ]) + "</span>";
      }
      if (item?.role == "credit") {
        return name + '<span class="flex items-center">' + t("page.article.rolesInfo.disallow.credit." + props.args.type, [
          `<i class="gq-custom-icon" style="margin-left:5px;--un-icon: url('${settingsStore?.credit?.symbol.replace(
            /'/g,
            "\\'"
          )}');"></i> ${item.finalCredit}`
        ]) + "</span>";
      }
      if (item?.role == "login") {
        return name + t("page.article.rolesInfo.disallow.login." + props.args.type);
      }
      if (item?.role == "qrcode") {
        return name + t("page.article.rolesInfo.disallow.qrcode." + props.args.type);
      }
    };
    const button = (role) => {
      if (role.role == "free" || role.allow) {
        return t("page.article.resource.download");
      }
      if (role.role == "comment") {
        return t("common.comment.comment");
      }
      if (role.role == "login") {
        return t("common.login.action.login");
      }
      if (role.role == "qrcode") {
        return t("page.article.resource.showQrcode");
      }
      if (role.role == "level") {
        return t("common.roles.changeRole");
      }
      if (role.role == "vip") {
        return t("common.roles.changeRole");
      }
      if (role.role == "limit") {
        return t("common.contact.contact");
      }
      if (role.role == "money") {
        return t("common.pay.pay");
      }
      if (role.role == "credit") {
        return t("common.pay.exchange");
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Image = __nuxt_component_4;
      const _component_CommonCreditIcon = _sfc_main$1;
      const _component_el_button = ElButton;
      const _component_ClientOnly = __nuxt_component_0$1;
      const _component_Blink = _sfc_main$2;
      _push(`<div${ssrRenderAttrs(_attrs)} data-v-305056ed>`);
      if (__props.args.type != "resource") {
        _push(`<div data-v-305056ed><div class="grid grid-cols-[repeat(auto-fit,minmax(0,1fr))] gap-1 relative mb-2" data-v-305056ed><!--[-->`);
        ssrRenderList(__props.args.info.list, (t2, ti) => {
          _push(`<div data-v-305056ed><div class="h-0 relative pt-[100%] rounded-sm overflow-hidden" data-v-305056ed>`);
          _push(ssrRenderComponent(_component_Image, {
            src: t2,
            class: "!absolute top-0 left-0 w-full h-full"
          }, null, _parent));
          _push(`<div class="absolute bottom-0 left-0 w-full h-10 flex items-end text-white text-xs p-2 thumb-mask" data-v-305056ed><span class="line-clamp-1" data-v-305056ed>${ssrInterpolate(__props.args.info.name[ti])}</span></div>`);
          if (__props.args.info.total > 2 && ti == 1) {
            _push(`<span class="absolute top-2 right-2 bg-black/50 text-white px-1 rounded-sm text-xs" data-v-305056ed> ＋${ssrInterpolate(__props.args.info.total - 2)}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="relative divide-y border-1 rounded @md:text-sm text-xs overflow-hidden" data-v-305056ed><div class="grid grid-cols-[30px_1fr_1fr_1fr] divide-x bg-[--el-color-info-light-10]" data-v-305056ed><div class="p-2 flex" data-v-305056ed><i class="i-ph-approximate-equals-duotone text-[--el-color-primary]" data-v-305056ed></i></div><div class="p-2 opacity-70" data-v-305056ed>${ssrInterpolate(_ctx.$t("common.roleBox.userGroup"))}</div><div class="p-2 opacity-70" data-v-305056ed>${ssrInterpolate(_ctx.$t("common.roleBox.getWay"))}</div><div class="p-2 opacity-70" data-v-305056ed>${ssrInterpolate(_ctx.$t("common.roleBox.status"))}</div></div><!--[-->`);
      ssrRenderList(__props.roles ?? 3, (r, ri) => {
        _push(`<div class="${ssrRenderClass(`role-item ${unref(state).rolePicked == ri ? "active" : ""} ${r.disabled ? "opacity-70" : ""}`)}" data-v-305056ed><div class="p-2 flex items-center" data-v-305056ed>`);
        if (unref(state).rolePicked !== ri) {
          _push(`<i class="i-ph-circle opacity-70" data-v-305056ed></i>`);
        } else {
          _push(`<i class="i-ph-check-circle-fill" data-v-305056ed></i>`);
        }
        _push(`</div><div class="p-2 flex items-center" data-v-305056ed>${ssrInterpolate(roleName(r?.level) || "Role name")}</div><div class="p-2 flex justify-center flex-col gap-0.5 relative" data-v-305056ed><div class="flex items-center" data-v-305056ed>`);
        if (r?.role == "credit") {
          _push(ssrRenderComponent(_component_CommonCreditIcon, { class: "w-3.6 h-3.6" }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<span class="flex items-center flex-col line-clamp-1" data-v-305056ed>${(roleType(r) || "Role type") ?? ""}</span></div>`);
        if (priceFormat(r?.finalPrice, unref(action).currency.iso) < priceFormat(r?.price, unref(action).currency.iso) && priceFormat(r?.finalPrice, unref(action).currency.iso) > 0 && r?.role != "credit") {
          _push(`<span class="line-clamp-1 text-[8px] absolute top-1 right-1 bg-[--el-color-danger-light-9] text-[--el-color-error] rounded px-1 h-3 flex items-center" data-v-305056ed> -${ssrInterpolate(discount(r))}% </span>`);
        } else {
          _push(`<!---->`);
        }
        if (r?.finalCredit < r?.credit && r?.finalCredit > 0 && r?.role == "credit") {
          _push(`<span class="line-clamp-1 text-[8px] absolute top-1 right-1 bg-[--el-color-danger-light-9] text-[--el-color-error] rounded px-1 h-3 flex items-center" data-v-305056ed> -${ssrInterpolate(discount(r))}% </span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="p-2 flex items-center" data-v-305056ed>`);
        if (r?.allow) {
          _push(`<span class="line-clamp-1 text-[--el-color-success]" data-v-305056ed>${ssrInterpolate(unref(t)("page.article.rolesInfo.purchased"))}</span>`);
        } else if (r.disabled) {
          _push(`<span data-v-305056ed>${ssrInterpolate(_ctx.$t("common.roleBox.noPermission"))}</span>`);
        } else if (r.role == "credit" && r.finalCredit != r.credit && r.finalCredit > 0) {
          _push(`<span class="flex items-center gap-1" data-v-305056ed>${ssrInterpolate(_ctx.$t("common.roleBox.originalPrice"))} <del class="flex items-center" data-v-305056ed>`);
          _push(ssrRenderComponent(_component_CommonCreditIcon, { class: "w-2.7 h-2.7" }, null, _parent));
          _push(` ${ssrInterpolate(r?.credit)}</del></span>`);
        } else if (priceFormat(r?.finalPrice, unref(action).currency.iso) != priceFormat(r?.price, unref(action).currency.iso) && r.role == "money") {
          _push(`<span class="line-clamp-1 flex items-center gap-1" data-v-305056ed>${ssrInterpolate(_ctx.$t("common.roleBox.originalPrice"))} <del class="flex items-center" data-v-305056ed>${ssrInterpolate(unref(action).currency.symbol + priceFormat(r?.price, unref(action).currency.iso))}</del></span>`);
        } else {
          _push(`<div class="flex items-center opacity-30" data-v-305056ed><i class="i-ph-lock" data-v-305056ed></i></div>`);
        }
        _push(`</div></div>`);
      });
      _push(`<!--]--></div>`);
      if (__props.args?.urls?.[unref(state).downloadButtonIndex]?.password || __props.args?.urls?.[unref(state).downloadButtonIndex]?.code) {
        _push(`<div class="auto-grid gap-2 mt-2 cursor-pointer" style="${ssrRenderStyle({ "--gq-grid-min-width": "140px" })}" data-v-305056ed><div class="flex flex-col border-1 gap-1 rounded p-2" data-v-305056ed><div class="text-xs flex items-center gap-1 justify-between" data-v-305056ed><span class="opacity-70" data-v-305056ed>${ssrInterpolate(_ctx.$t("common.unzipPassword"))}</span>`);
        _push(ssrRenderComponent(_component_el_button, {
          circle: "",
          bg: "",
          size: "small"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="i-ph-copy-duotone" data-v-305056ed${_scopeId}></i>`);
            } else {
              return [
                createVNode("i", { class: "i-ph-copy-duotone" })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div><span class="text-sm" data-v-305056ed>${ssrInterpolate(__props.args?.urls?.[unref(state).downloadButtonIndex]?.password)}</span></div><div class="flex flex-col border-1 gap-1 rounded p-2" data-v-305056ed><div class="text-xs flex items-center gap-1 justify-between" data-v-305056ed><span class="opacity-70" data-v-305056ed>${ssrInterpolate(_ctx.$t("common.extractionCode"))}</span>`);
        _push(ssrRenderComponent(_component_el_button, {
          circle: "",
          bg: "",
          size: "small"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="i-ph-copy-duotone" data-v-305056ed${_scopeId}></i>`);
            } else {
              return [
                createVNode("i", { class: "i-ph-copy-duotone" })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div><span class="text-sm" data-v-305056ed>${ssrInterpolate(__props.args?.urls?.[unref(state).downloadButtonIndex]?.code)}</span></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass(`p-2 mt-2 text-xs gap-1 
          flex flex-col rounded border-1
           flex-wrap ${__props.args?.allow ? "border-[--el-color-success-light-7] bg-[--el-color-success-light-9] text-[--el-color-success-dark-2]" : "border-[--el-color-warning-light-7] bg-[--el-color-warning-light-9] text-[--el-color-warning-dark-2]"}`)}" data-v-305056ed>`);
      if (__props.args?.allow) {
        _push(`<!--[-->${ssrInterpolate(_ctx.$t("common.roleBox.allow"))}<!--]-->`);
      } else {
        _push(`<!--[-->`);
        if (expiredAt()) {
          _push(`<div class="font-normal text-[--el-color-primary] ml-2" data-v-305056ed>${ssrInterpolate(_ctx.$t("page.article.rolesInfo.expireTime", [
            ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).timeAgo(expiredAt())
          ]))}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="flex items-center" data-v-305056ed>${currentUserRoleText() ?? ""}</div><!--]-->`);
      }
      _push(`</div><div class="mt-2 grid grid-cols-[7rem_1fr] flex-1 gap-2" data-v-305056ed>`);
      if (__props.args?.urls?.length > 0) {
        _push(`<div data-v-305056ed>`);
        _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.args?.allow) {
        _push(`<a${ssrRenderAttr("href", __props.args.urls[unref(state).downloadButtonIndex]?.url)} download target="_blank" data-v-305056ed>`);
        _push(ssrRenderComponent(_component_el_button, {
          type: "primary",
          plain: "",
          class: "!m-0 flex-1 w-full",
          onClick: ($event) => unref(state).countDownload(__props.item)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("page.modules.post.downloadButton"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("page.modules.post.downloadButton")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</a>`);
      } else {
        _push(ssrRenderComponent(_component_el_button, {
          type: "primary",
          plain: "",
          class: "!m-0 flex-1 [&:only-child]:col-span-full",
          onClick: ($event) => unref(state).showPay(unref(state).currentRole),
          disabled: Boolean(
            unref(state).currentRole.level == "guest" && unref(viewer).data?.databaseId || unref(state).currentRole.disabled
          )
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (unref(state).currentRole.level !== "guest" && unref(state).currentRole.level !== "all" && !unref(viewer).data?.databaseId) {
                _push2(`<div data-v-305056ed${_scopeId}>${ssrInterpolate(_ctx.$t("common.login.action.login"))}</div>`);
              } else if (showChangeButton(unref(state).currentRole)) {
                _push2(ssrRenderComponent(_component_Blink, {
                  to: "/account/membership",
                  class: "grid grid-cols-[1fr_auto] items-center gap-1.4"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`<div class="flex-1 max-w-full line-clamp-1" data-v-305056ed${_scopeId2}>${ssrInterpolate(_ctx.$t("page.article.rolesInfo.become"))} ${ssrInterpolate(roleName(unref(state).currentRole?.level))}</div><span class="inline-flex" data-v-305056ed${_scopeId2}><i class="i-ph-caret-circle-right" data-v-305056ed${_scopeId2}></i></span>`);
                    } else {
                      return [
                        createVNode("div", { class: "flex-1 max-w-full line-clamp-1" }, toDisplayString(_ctx.$t("page.article.rolesInfo.become")) + " " + toDisplayString(roleName(unref(state).currentRole?.level)), 1),
                        createVNode("span", { class: "inline-flex" }, [
                          createVNode("i", { class: "i-ph-caret-circle-right" })
                        ])
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else {
                _push2(`<!--[-->`);
                if (unref(state).currentRole.role == "money" && !unref(state).currentRole.allow) {
                  _push2(`<span class="mr-1" data-v-305056ed${_scopeId}>${ssrInterpolate(unref(action).currency.symbol + "" + priceFormat(unref(state).currentRole.finalPrice, unref(action).currency.iso))}</span>`);
                } else {
                  _push2(`<!---->`);
                }
                if (unref(state).currentRole.role == "credit" && !unref(state).currentRole.allow) {
                  _push2(`<span class="flex items-center mr-1" data-v-305056ed${_scopeId}>`);
                  _push2(ssrRenderComponent(_component_CommonCreditIcon, null, null, _parent2, _scopeId));
                  _push2(` ${ssrInterpolate(unref(state).currentRole.finalCredit)}</span>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(` ${ssrInterpolate(button(unref(state).currentRole))}<!--]-->`);
              }
            } else {
              return [
                unref(state).currentRole.level !== "guest" && unref(state).currentRole.level !== "all" && !unref(viewer).data?.databaseId ? (openBlock(), createBlock("div", { key: 0 }, toDisplayString(_ctx.$t("common.login.action.login")), 1)) : showChangeButton(unref(state).currentRole) ? (openBlock(), createBlock(_component_Blink, {
                  key: 1,
                  to: "/account/membership",
                  class: "grid grid-cols-[1fr_auto] items-center gap-1.4"
                }, {
                  default: withCtx(() => [
                    createVNode("div", { class: "flex-1 max-w-full line-clamp-1" }, toDisplayString(_ctx.$t("page.article.rolesInfo.become")) + " " + toDisplayString(roleName(unref(state).currentRole?.level)), 1),
                    createVNode("span", { class: "inline-flex" }, [
                      createVNode("i", { class: "i-ph-caret-circle-right" })
                    ])
                  ]),
                  _: 1
                })) : (openBlock(), createBlock(Fragment, { key: 2 }, [
                  unref(state).currentRole.role == "money" && !unref(state).currentRole.allow ? (openBlock(), createBlock("span", {
                    key: 0,
                    class: "mr-1"
                  }, toDisplayString(unref(action).currency.symbol + "" + priceFormat(unref(state).currentRole.finalPrice, unref(action).currency.iso)), 1)) : createCommentVNode("", true),
                  unref(state).currentRole.role == "credit" && !unref(state).currentRole.allow ? (openBlock(), createBlock("span", {
                    key: 1,
                    class: "flex items-center mr-1"
                  }, [
                    createVNode(_component_CommonCreditIcon),
                    createTextVNode(" " + toDisplayString(unref(state).currentRole.finalCredit), 1)
                  ])) : createCommentVNode("", true),
                  createTextVNode(" " + toDisplayString(button(unref(state).currentRole)), 1)
                ], 64))
              ];
            }
          }),
          _: 1
        }, _parent));
      }
      _push(`</div>`);
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/roleBox.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_3 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-305056ed"]]);

export { __nuxt_component_3 as default };
