import { ref, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderStyle, ssrRenderSlot } from 'vue/server-renderer';

const _sfc_main = {
  __name: "CommonScroll",
  __ssrInlineRender: true,
  props: ["scrollX", "scrollY", "gap", "padding", "background"],
  setup(__props) {
    ref(null);
    const showBefore = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        style: `padding-left: ${__props.padding ?? 0};padding-right: ${__props.padding ?? 0};background: ${__props.background ?? "transparent"}`,
        class: `scroll-menu ${unref(showBefore) ? "show-before" : ""}`
      }, _attrs))}><div class="flex items-center h-full"><div class="flex h-full" style="${ssrRenderStyle(`gap: ${__props.gap * 0.25}rem;`)}">`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/scroll.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
