import { aI as useElementSize, a_ as useTransition, x as __nuxt_component_0$1 } from './server.mjs';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { useSSRContext, ref, watch, mergeProps, withCtx, createVNode, renderSlot } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderStyle, ssrRenderSlot } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';
import './index-DRiwogtD.mjs';
import './index-ChPMoinw.mjs';
import './style-h263bamF.mjs';

const _sfc_main = {
  __name: "CommonScrollbar",
  __ssrInlineRender: true,
  props: ["gap", "showArrowButton", "padding", "background"],
  setup(__props) {
    const scrollbar2 = ref(null);
    const scrollInner = ref(null);
    useElementSize(scrollbar2);
    const scrollLift = ref(0);
    const cubicBezierNumber = useTransition(scrollLift, {
      duration: 500,
      transition: [0.85, 0, 0.15, 1]
    });
    ref("right");
    watch(cubicBezierNumber, (value) => {
      scrollbar2.value?.setScrollLeft(value);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      const _component_el_scrollbar = ElScrollbar;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "justify-between scroll-menu relative",
        style: `--gq-scrollbar-padding:${__props.padding};--gq-scrollbar-background:var(${__props.background || "--tbg"})`
      }, _attrs))} data-v-d5c293bf>`);
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(ssrRenderComponent(_component_el_scrollbar, {
        ref_key: "scrollbar",
        ref: scrollbar2,
        class: "scroll-smooth"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center" style="${ssrRenderStyle(`gap: ${__props.gap * 0.25}rem`)}" data-v-d5c293bf${_scopeId}>`);
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", {
                class: "flex items-center",
                ref_key: "scrollInner",
                ref: scrollInner,
                style: `gap: ${__props.gap * 0.25}rem`
              }, [
                renderSlot(_ctx.$slots, "default", {}, void 0, true)
              ], 4)
            ];
          }
        }),
        _: 3
      }, _parent));
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/scrollbar.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const scrollbar = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-d5c293bf"]]);

export { scrollbar as default };
