import { E as ElInput } from './index-Cs8YDU9s.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import _sfc_main$1 from './blink-DRvWMg-X.mjs';
import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import { v as vLoading } from './directive-BPPM1aUC.mjs';
import { d as useRoute, f as useRouter, a as useI18n, h as useServerHost, j as actionStore, b as useSeoMeta, u as useHead, e as useUtils } from './server.mjs';
import { ref, computed, mergeProps, isRef, unref, withCtx, createTextVNode, toDisplayString, createVNode, openBlock, createBlock, createCommentVNode, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrGetDirectiveProps, ssrRenderAttr, ssrRenderList } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './event-BZTOGHfp.mjs';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import '@vue/shared';
import './index-ChPMoinw.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import './index-BKB3Djp4.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import './index-Bp-nwGzu.mjs';
import './aria-BhThsKez.mjs';
import './index-31HAFSrO.mjs';
import '@ctrl/tinycolor';
import './nuxt-link-Dd6LuEo9.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './image-viewer-DG2qIWb8.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './index-Di0Jlzch.mjs';

const _sfc_main = {
  __name: "search",
  __ssrInlineRender: true,
  setup(__props) {
    const route = useRoute();
    const router = useRouter();
    const { t } = useI18n();
    const host = useServerHost().value;
    const siteUrl = "https://" + host;
    const action = actionStore();
    const searchKeyword = ref("");
    const hasSearched = ref(false);
    const searchResult = ref(null);
    const pending = ref(false);
    const performSearch = async (searchTerm) => {
      if (!searchTerm?.trim()) {
        searchResult.value = null;
        hasSearched.value = false;
        return;
      }
      pending.value = true;
      try {
        action.search.key = searchTerm;
        await action.searchAction();
        searchResult.value = action.search.result;
        hasSearched.value = true;
        if (false) ;
      } catch (error) {
        console.error("搜索失败:", error);
        searchResult.value = { edges: [] };
        hasSearched.value = true;
      } finally {
        pending.value = false;
      }
    };
    const handleSearch = () => {
      const term = searchKeyword.value?.trim();
      if (term) {
        performSearch(term);
        if (route.query.q) {
          router.replace({ path: "/search" });
        }
      }
    };
    const currentUrl = computed(() => `${siteUrl}/search`);
    const pageTitle = t("header.search.title");
    const pageDescription = t("header.search.description");
    useSeoMeta({
      title: pageTitle,
      description: pageDescription,
      keywords: t("header.search.keywords"),
      ogTitle: pageTitle,
      ogDescription: pageDescription,
      ogUrl: currentUrl,
      ogType: "website",
      canonical: currentUrl,
      // 所有搜索页面都不索引
      robots: "noindex, nofollow"
    });
    const searchJsonLd = computed(() => {
      return {
        "@context": "https://schema.org",
        "@type": "WebPage",
        "@id": `${currentUrl.value}#search`,
        url: currentUrl.value,
        name: pageTitle,
        description: pageDescription
      };
    });
    const breadcrumbJsonLd = computed(() => {
      return {
        "@context": "https://schema.org",
        "@type": "BreadcrumbList",
        itemListElement: [
          {
            "@type": "ListItem",
            position: 1,
            name: t("common.home"),
            item: siteUrl
          },
          {
            "@type": "ListItem",
            position: 2,
            name: t("header.search.title"),
            item: `${siteUrl}/search`
          }
        ]
      };
    });
    useHead({
      link: [
        {
          rel: "icon",
          type: "image/ico",
          href: "/favicon.ico"
        },
        {
          rel: "canonical",
          href: currentUrl.value
        }
      ],
      script: [
        {
          type: "application/ld+json",
          innerHTML: JSON.stringify(searchJsonLd.value, null, "")
        },
        {
          type: "application/ld+json",
          innerHTML: JSON.stringify(breadcrumbJsonLd.value, null, "")
        }
      ]
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_input = ElInput;
      const _component_el_button = ElButton;
      const _component_Blink = _sfc_main$1;
      const _component_Image = __nuxt_component_4;
      const _directive_loading = vLoading;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "max-w-screen-md min-h-[calc(100vh-8rem)] @md:w-full @md:mx-auto mx-2 w-[calc(100%-1rem)] bg-[--el-bg-color] mt-4 rounded-md p-3 @md:p-6" }, _attrs))} data-v-16aee6c6><div class="section-inner flex flex-col gap-4 max-w-full" data-v-16aee6c6><div class="w-full" data-v-16aee6c6><form role="search" data-v-16aee6c6>`);
      _push(ssrRenderComponent(_component_el_input, {
        modelValue: unref(searchKeyword),
        "onUpdate:modelValue": ($event) => isRef(searchKeyword) ? searchKeyword.value = $event : null,
        placeholder: _ctx.$t("header.search.placeholder"),
        onKeyup: handleSearch,
        clearable: "",
        size: "large",
        class: "search-input",
        "aria-label": _ctx.$t("header.search.placeholder")
      }, {
        prefix: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-magnifying-glass" data-v-16aee6c6${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-magnifying-glass" })
            ];
          }
        }),
        append: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_el_button, {
              onClick: handleSearch,
              loading: unref(pending),
              "aria-label": _ctx.$t("header.search.placeholder")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("header.search.placeholder"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("header.search.placeholder")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_el_button, {
                onClick: handleSearch,
                loading: unref(pending),
                "aria-label": _ctx.$t("header.search.placeholder")
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("header.search.placeholder")), 1)
                ]),
                _: 1
              }, 8, ["loading", "aria-label"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</form></div><div${ssrRenderAttrs(mergeProps({ class: "min-h-100" }, ssrGetDirectiveProps(_ctx, _directive_loading, unref(pending))))} data-v-16aee6c6>`);
      if (!unref(hasSearched)) {
        _push(`<div class="flex items-center justify-center text-sm h-100 opacity-50" role="status" aria-live="polite" data-v-16aee6c6>${ssrInterpolate(_ctx.$t("header.search.noKeyword"))}</div>`);
      } else if (unref(searchResult) && unref(searchResult).edges?.length === 0) {
        _push(`<div class="flex items-center justify-center text-sm h-100 opacity-50" role="status" aria-live="polite" data-v-16aee6c6>${ssrInterpolate(_ctx.$t("header.search.noResult"))}</div>`);
      } else if (unref(searchResult)?.edges?.length) {
        _push(`<div class="flex flex-col" role="main"${ssrRenderAttr("aria-label", _ctx.$t("header.search.searchResult"))} data-v-16aee6c6><div class="text-sm text-gray-500 mb-4" data-v-16aee6c6><span aria-live="polite" aria-atomic="true" data-v-16aee6c6>${ssrInterpolate(_ctx.$t("header.search.resultCount", [unref(searchResult).totalCount || unref(searchResult).edges.length]))}</span></div><ol class="flex flex-col divide-y" data-v-16aee6c6><!--[-->`);
        ssrRenderList(unref(searchResult).edges, (item, index) => {
          _push(`<li data-v-16aee6c6>`);
          _push(ssrRenderComponent(_component_Blink, {
            to: item.node.gqSlug,
            class: "flex items-start gap-4 p-4 hover:bg-[--el-color-info-light-10] transition-colors"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<div class="flex flex-col gap-1 flex-1" data-v-16aee6c6${_scopeId}><h2 class="text-base font-medium" data-v-16aee6c6${_scopeId}>${ssrInterpolate(item.node.title)}</h2>`);
                if (item.node.excerpt) {
                  _push2(`<div class="text-sm text-gray-600 line-clamp-2" data-v-16aee6c6${_scopeId}>${item.node.excerpt ?? ""}</div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<div class="text-xs opacity-80 flex items-center gap-2 mt-2" data-v-16aee6c6${_scopeId}><span class="flex items-center" data-v-16aee6c6${_scopeId}><i class="i-ph-eye mr-1 w-3.2 h-3.2" data-v-16aee6c6${_scopeId}></i> ${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item.node.viewsCache))}</span><span class="flex items-center" data-v-16aee6c6${_scopeId}><i class="i-ph-heart mr-1 w-3.2 h-3.2" data-v-16aee6c6${_scopeId}></i> ${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item.node.likeCount))}</span><span class="flex items-center" data-v-16aee6c6${_scopeId}><i class="i-ph-chat-dots mr-1 w-3.2 h-3.2" data-v-16aee6c6${_scopeId}></i> ${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item.node.commentCount))}</span></div></div>`);
                if (item.node.featuredImage?.node?.sourceUrl) {
                  _push2(ssrRenderComponent(_component_Image, {
                    src: item.node.featuredImage.node.sourceUrl,
                    alt: item.node.title,
                    class: "w-20 h-20 rounded flex-shrink-0"
                  }, null, _parent2, _scopeId));
                } else {
                  _push2(`<!---->`);
                }
              } else {
                return [
                  createVNode("div", { class: "flex flex-col gap-1 flex-1" }, [
                    createVNode("h2", { class: "text-base font-medium" }, toDisplayString(item.node.title), 1),
                    item.node.excerpt ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "text-sm text-gray-600 line-clamp-2",
                      innerHTML: item.node.excerpt
                    }, null, 8, ["innerHTML"])) : createCommentVNode("", true),
                    createVNode("div", { class: "text-xs opacity-80 flex items-center gap-2 mt-2" }, [
                      createVNode("span", { class: "flex items-center" }, [
                        createVNode("i", { class: "i-ph-eye mr-1 w-3.2 h-3.2" }),
                        createTextVNode(" " + toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item.node.viewsCache)), 1)
                      ]),
                      createVNode("span", { class: "flex items-center" }, [
                        createVNode("i", { class: "i-ph-heart mr-1 w-3.2 h-3.2" }),
                        createTextVNode(" " + toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item.node.likeCount)), 1)
                      ]),
                      createVNode("span", { class: "flex items-center" }, [
                        createVNode("i", { class: "i-ph-chat-dots mr-1 w-3.2 h-3.2" }),
                        createTextVNode(" " + toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item.node.commentCount)), 1)
                      ])
                    ])
                  ]),
                  item.node.featuredImage?.node?.sourceUrl ? (openBlock(), createBlock(_component_Image, {
                    key: 0,
                    src: item.node.featuredImage.node.sourceUrl,
                    alt: item.node.title,
                    class: "w-20 h-20 rounded flex-shrink-0"
                  }, null, 8, ["src", "alt"])) : createCommentVNode("", true)
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(`</li>`);
        });
        _push(`<!--]--></ol></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/pages/search.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const search = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-16aee6c6"]]);

export { search as default };
