import { E as ElSelect, a as ElOption } from './index-03hfIBa_.mjs';
import { E as ElAvatar } from './index-R6EFYpWa.mjs';
import { r as useRequest, e as useUtils } from './server.mjs';
import { reactive, mergeProps, unref, withCtx, createVNode, toDisplayString, openBlock, createBlock, Fragment, renderList, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderList, ssrInterpolate } from 'vue/server-renderer';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import '@vue/shared';
import './index-ChPMoinw.mjs';
import './constants-hAKFmBbq.mjs';
import './index-tCyBRCDx.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './index-Bp-nwGzu.mjs';
import './event-BZTOGHfp.mjs';
import './index-BY8mj3AC.mjs';
import './vnode-l2ZP2UQa.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonFormSearchUser",
  __ssrInlineRender: true,
  emits: ["change"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    const form = reactive({
      selected: null,
      loading: false,
      options: [],
      list: [],
      remoteMethod: async (query) => {
        if (query) {
          form.loading = true;
          const res = await useRequest("/api/request", {});
          if (res?.users?.nodes) {
            form.options = res.users?.nodes || [];
          }
        } else {
          form.options = [];
        }
        form.loading = false;
      },
      change: (val) => {
        const user = form.options[val];
        emit("change", user);
        form.selected = null;
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_select = ElSelect;
      const _component_el_option = ElOption;
      const _component_el_avatar = ElAvatar;
      _push(ssrRenderComponent(_component_el_select, mergeProps({
        modelValue: unref(form).selected,
        "onUpdate:modelValue": ($event) => unref(form).selected = $event,
        filterable: "",
        remote: "",
        "reserve-keyword": "",
        placeholder: _ctx.$t("common.searchUser.title"),
        "remote-method": unref(form).remoteMethod,
        loading: unref(form).loading,
        onChange: unref(form).change
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<!--[-->`);
            ssrRenderList(unref(form).options, (item, i) => {
              _push2(ssrRenderComponent(_component_el_option, {
                key: i,
                label: item.name,
                value: i
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="flex items-center gap-2"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_el_avatar, {
                      src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item.avatar.url),
                      size: "small"
                    }, null, _parent3, _scopeId2));
                    _push3(`<div${_scopeId2}>${ssrInterpolate(item.name)}</div></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "flex items-center gap-2" }, [
                        createVNode(_component_el_avatar, {
                          src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item.avatar.url),
                          size: "small"
                        }, null, 8, ["src"]),
                        createVNode("div", null, toDisplayString(item.name), 1)
                      ])
                    ];
                  }
                }),
                _: 2
              }, _parent2, _scopeId));
            });
            _push2(`<!--]-->`);
          } else {
            return [
              (openBlock(true), createBlock(Fragment, null, renderList(unref(form).options, (item, i) => {
                return openBlock(), createBlock(_component_el_option, {
                  key: i,
                  label: item.name,
                  value: i
                }, {
                  default: withCtx(() => [
                    createVNode("div", { class: "flex items-center gap-2" }, [
                      createVNode(_component_el_avatar, {
                        src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item.avatar.url),
                        size: "small"
                      }, null, 8, ["src"]),
                      createVNode("div", null, toDisplayString(item.name), 1)
                    ])
                  ]),
                  _: 2
                }, 1032, ["label", "value"]);
              }), 128))
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/searchUser.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
