import { useSSRContext, mergeProps } from 'vue';
import { ssrRenderAttrs, ssrRenderSlot } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';

const _sfc_main = {
  __name: "CommonSectionBox",
  __ssrInlineRender: true,
  props: ["settings"],
  setup(__props) {
    const props = __props;
    const _value = (path) => {
      return props.settings[path[0]]?.[path[1]] ?? props.settings[path[0]];
    };
    const radius = (type) => {
      switch (type) {
        case "base":
          return "4px";
        case "small":
          return "2px";
        case "round":
          return "20px";
        case "circle":
          return "100%";
        default:
          return "none";
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: `mx-auto section ${_value(["border", "right"]) ? "border-r" : ""}${_value(["border", "left"]) ? "border-l" : ""}${_value(["border", "top"]) ? "border-t" : ""}${_value(["border", "bottom"]) ? "border-b" : ""}`,
        style: `--tspt:${_value(["padding", "top"]) * 0.25}rem;--tspr: ${_value(["padding", "right"]) * 0.25}rem;--tspb: ${_value(["padding", "bottom"]) * 0.25}rem;--tspl: ${_value(["padding", "left"]) * 0.25}rem;--tsmt:${_value(["margin", "top"]) * 0.25}rem;--tsmb:${_value(["margin", "bottom"]) * 0.25}rem;--trtl:${radius(_value(["radius", "topLeft"]))};--trtr:${radius(
          _value(["radius", "topRight"])
        )};--trbr: ${radius(_value(["radius", "bottomRight"]))};--trbl:${radius(
          _value(["radius", "bottomLeft"])
        )};--tsgap:${_value(["gap"]) * 0.25}rem;--tsw:${_value([
          "width"
        ])};--tswi:${_value(["widthInner"])};--tsh:${_value([
          "height"
        ])};--tsbg:${_value(["backgroundCSS"])}`
      }, _attrs))} data-v-a44df0b9>`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/sectionBox.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_0 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-a44df0b9"]]);

export { __nuxt_component_0 as default };
