import { v as viewerStore, a as useI18n, x as __nuxt_component_0$1 } from './server.mjs';
import { useSSRContext, computed, reactive, watch } from 'vue';
import { ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonShare",
  __ssrInlineRender: true,
  props: {
    shareData: {
      type: Object,
      default: () => ({})
    }
  },
  setup(__props, { expose: __expose }) {
    const viewer = viewerStore();
    computed(() => {
      if (viewer?.data?.gqUserRef) {
        return share.params.URL + "?ref=" + viewer.data.gqUserRef;
      } else {
        return share.params.URL;
      }
    });
    const props = __props;
    const { t } = useI18n();
    const share = reactive({
      show: false,
      wechatShow: false,
      templates: {
        qzone: "https://sns.qzone.qq.com/cgi-bin/qzshare/cgi_qzshare_onekey?url={{URL}}&sharesource=qzone&title={{TITLE}}&summary={{SUMMARY}}&pics={{IMAGE}}",
        weibo: "https://service.weibo.com/share/share.php?url={{URL}}&title={{TITLE}}&pic={{IMAGE}}",
        wechat: "javascript:",
        qq: "https://connect.qq.com/widget/shareqq/index.html?url={{URL}}&title={{TITLE}}&pics={{IMAGE}}",
        reddit: "https://www.reddit.com/submit?url={{URL}}&title={{TITLE}}",
        instagram: "https://www.instagram.com/sharer?url={{URL}}",
        facebook: "https://www.facebook.com/sharer/sharer.php?u={{URL}}",
        telegram: "https://t.me/share/url?url={{URL}}&text={{TITLE}}",
        whatsapp: "https://wa.me/?text={{TITLE}} {{URL}}",
        twitter: "https://twitter.com/intent/tweet?url={{URL}}&text={{TITLE}}",
        tumblr: "https://www.tumblr.com/share/link?url={{URL}}&name={{TITLE}}",
        linkedin: "https://www.linkedin.com/shareArticle?mini=true&url={{URL}}&title={{TITLE}}&summary={{SUMMARY}}&source={{SOURCE}}",
        pinterest: "https://pinterest.com/pin/create/button/?url={{URL}}&description={{TITLE}}",
        line: "https://social-plugins.line.me/lineit/share?url={{URL}}",
        email: "mailto:?subject={{TITLE}}&body={{URL}}"
      },
      params: {
        URL: "",
        TITLE: "",
        DESCRIPTION: "",
        SUMMARY: "",
        SOURCE: "",
        IMAGE: ""
      },
      colors: {
        qzone: "#006aff",
        weibo: "#e6162d",
        wechat: "#00bb29",
        qq: "#00a1e0",
        reddit: "#ff4500",
        facebook: "#1877f2",
        twitter: "#1da1f2",
        linkedin: "#0077b5",
        pinterest: "#e60023",
        telegram: "#0088cc",
        whatsapp: "#25d366",
        email: "#000000",
        instagram: "#c32aa3",
        tumblr: "#34527c",
        line: "#00c300"
      },
      action: (type) => {
        if (type == "wechat") {
          share.wechatShow = true;
        } else {
          openWin(share.makeUrl(type), "_blank", 500, 500);
        }
      },
      makeUrl: (type) => {
        return share.templates[type].replace(/\{\{([^}]+)\}\}/g, (match, p1) => {
          return p1 == "TITLE" || p1 == "SUMMARY" || p1 == "DESCRIPTION" ? encodeURIComponent(share.params[p1]) : share.params[p1] || match;
        });
      }
    });
    function openWin(url, name, iWidth, iHeight) {
      var iTop = ((void 0).screen.availHeight - 30 - iHeight) / 2;
      var iLeft = ((void 0).screen.availWidth - 10 - iWidth) / 2;
      (void 0).open(
        url,
        name,
        "height=" + iHeight + ",innerHeight=" + iHeight + ",width=" + iWidth + ",innerWidth=" + iWidth + ",top=" + iTop + ",left=" + iLeft + ",status=no,toolbar=no,menubar=no,location=no,resizable=no,scrollbars=0,titlebar=no"
      );
    }
    watch(
      () => share.show,
      () => {
        if (share.show) {
          if (props.shareData?.title) {
            share.params.TITLE = props.shareData.title;
            share.params.DESCRIPTION = props.shareData.description;
            share.params.SUMMARY = props.shareData.summary;
            share.params.IMAGE = props.shareData.image;
            share.params.URL = props.shareData.url;
            share.params.SOURCE = props.shareData.source;
          } else {
            share.params.TITLE = (void 0).querySelector('meta[property="og:title"]')?.getAttribute("content");
            share.params.DESCRIPTION = (void 0).querySelector('meta[property="og:description"]')?.getAttribute("content");
            share.params.SUMMARY = (void 0).querySelector('meta[property="og:description"]')?.getAttribute("content");
            share.params.IMAGE = (void 0).querySelector('meta[property="og:image"]')?.getAttribute("content");
            share.params.URL = (void 0).location.href;
            share.params.SOURCE = (void 0).location.host;
          }
        }
      }
    );
    __expose({
      share
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(ssrRenderComponent(_component_ClientOnly, _attrs, {}, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/share.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_1 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-7f2f6006"]]);

export { __nuxt_component_1 as default };
