import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import { E as ElTooltip } from './index-Cx5QSQzK.mjs';
import _sfc_main$1 from './creditIcon-eOdkwofx.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { g as getServerSettings, a as useI18n, j as actionStore, v as viewerStore, f as useRouter, e as useUtils, w as isLogin } from './server.mjs';
import { mergeProps, unref, withCtx, createVNode, createTextVNode, toDisplayString, openBlock, createBlock, Fragment, renderList, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderClass } from 'vue/server-renderer';
import 'lodash-unified';
import './image-viewer-DG2qIWb8.mjs';
import './index-ChPMoinw.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-Di0Jlzch.mjs';
import './index-BKB3Djp4.mjs';
import './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import './constants-hAKFmBbq.mjs';
import './svgIcon-BpIUCf-e.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import '@ctrl/tinycolor';

const _sfc_main = {
  __name: "ModulesAccountVerifyStep1",
  __ssrInlineRender: true,
  setup(__props) {
    const settingStore = getServerSettings();
    const { locale } = useI18n();
    const action = actionStore();
    const roleCheck = (roles, data) => {
      const vip = data.gqVIP;
      const lv = data.gqLevel;
      if (!roles) return true;
      return roles.includes(vip) || roles.includes(lv);
    };
    const viewer = viewerStore();
    const router = useRouter();
    const handleClick = (tab, id, key) => {
      if (!isLogin.value) {
        action.showLogin = true;
        return;
      }
      {
        router.push({
          query: {
            step: tab,
            // 添加或修改查询参数 "tab=activity"
            id,
            key
          }
        });
      }
    };
    const levelName = (level) => {
      return useUtils.findNameAndIconByKey(level, settingStore)?.name?.[locale.value];
    };
    const compareTime = (time, min_day) => {
      const now = /* @__PURE__ */ new Date();
      const registeredDate = new Date(time);
      return now.getTime() - registeredDate.getTime() >= parseInt(min_day) * 24 * 60 * 60 * 1e3;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Image = __nuxt_component_4;
      const _component_el_tooltip = ElTooltip;
      const _component_CommonCreditIcon = _sfc_main$1;
      const _component_el_button = ElButton;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "grid grid-cols-2 gap-4" }, _attrs))}><!--[-->`);
      ssrRenderList(unref(settingStore).verify.types, (item, index) => {
        _push(`<div class="flex grid-cols-subgrid flex-col p-2 @md:p-4 rounded-md flex flex-col hover:shadow-lg border-1 transition-all duration-300 gq-bg-green xyz-in"><div class="mb-2 w-fit p-0.4 border-1 rounded-full bg-[--el-bg-color]">`);
        _push(ssrRenderComponent(_component_Image, {
          src: item.icon,
          class: "w-10 h-10 rounded-full"
        }, null, _parent));
        _push(`</div><h2><b>${ssrInterpolate(item.name?.[_ctx.$i18n.locale])}</b></h2><p class="text-[13px] opacity-80">${ssrInterpolate(item.description?.[_ctx.$i18n.locale])}</p><div class="mt-auto">`);
        if (item.requirements?.role || item.requirements?.min_days) {
          _push(`<h2 class="text-xs mt-3 flex items-center gap-1"><i class="i-ph-approximate-equals-duotone text-[--el-color-primary]"></i><span class="opacity-80">${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.precondition"))}</span></h2>`);
        } else {
          _push(`<!---->`);
        }
        if (item.requirements?.role || item.requirements?.min_days) {
          _push(`<div class="border-1 divide-y rounded mt-2" style="${ssrRenderStyle({ "--el-border-color": "var(--el-border-color-lighter)" })}">`);
          if (item.requirements?.role) {
            _push(`<div class="divide-y">`);
            if (item.requirements.role.length > 1) {
              _push(ssrRenderComponent(_component_el_tooltip, {
                transition: "fade-in-linear",
                offset: 0,
                trigger: "click",
                "hide-after": 0,
                "show-after": 0,
                effect: "light",
                "show-arrow": false,
                class: "!p-0",
                "popper-class": "shadow-lg !p-2"
              }, {
                content: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<div class="flex flex-col gap-1"${_scopeId}><!--[-->`);
                    ssrRenderList(item.requirements.role, (level) => {
                      _push2(`<div class="${ssrRenderClass(`flex items-center justify-between p-1 px-2 rounded text-xs w-55 ${level == unref(viewer)?.data?.gqLevel || level == unref(viewer)?.data?.gqVIP ? "bg-[--el-fill-color]" : ""}`)}"${_scopeId}>${ssrInterpolate(levelName(level))} <div class="flex items-center"${_scopeId}><i class="i-ph-check-circle-duotone text-[--el-color-primary]"${_scopeId}></i></div></div>`);
                    });
                    _push2(`<!--]--></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "flex flex-col gap-1" }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(item.requirements.role, (level) => {
                          return openBlock(), createBlock("div", {
                            key: level,
                            class: `flex items-center justify-between p-1 px-2 rounded text-xs w-55 ${level == unref(viewer)?.data?.gqLevel || level == unref(viewer)?.data?.gqVIP ? "bg-[--el-fill-color]" : ""}`
                          }, [
                            createTextVNode(toDisplayString(levelName(level)) + " ", 1),
                            createVNode("div", { class: "flex items-center" }, [
                              createVNode("i", { class: "i-ph-check-circle-duotone text-[--el-color-primary]" })
                            ])
                          ], 2);
                        }), 128))
                      ])
                    ];
                  }
                }),
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`<div class="flex items-center justify-between p-2 text-xs w-full cursor-pointer"${_scopeId}><div class="flex items-center gap-1"${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.role"))} <i class="i-ph-caret-right text-[--el-color-primary]"${_scopeId}></i></div><div${_scopeId}>`);
                    if (roleCheck(item.requirements?.role, unref(viewer)?.data)) {
                      _push2(`<span class="flex"${_scopeId}><i class="i-ph-check-circle-duotone text-[--el-color-primary]"${_scopeId}></i></span>`);
                    } else {
                      _push2(`<span class="flex"${_scopeId}><i class="i-ph-x-circle-duotone text-[--el-color-danger]"${_scopeId}></i></span>`);
                    }
                    _push2(`</div></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "flex items-center justify-between p-2 text-xs w-full cursor-pointer" }, [
                        createVNode("div", { class: "flex items-center gap-1" }, [
                          createTextVNode(toDisplayString(_ctx.$t("page.account.verify.step.step1.role")) + " ", 1),
                          createVNode("i", { class: "i-ph-caret-right text-[--el-color-primary]" })
                        ]),
                        createVNode("div", null, [
                          roleCheck(item.requirements?.role, unref(viewer)?.data) ? (openBlock(), createBlock("span", {
                            key: 0,
                            class: "flex"
                          }, [
                            createVNode("i", { class: "i-ph-check-circle-duotone text-[--el-color-primary]" })
                          ])) : (openBlock(), createBlock("span", {
                            key: 1,
                            class: "flex"
                          }, [
                            createVNode("i", { class: "i-ph-x-circle-duotone text-[--el-color-danger]" })
                          ]))
                        ])
                      ])
                    ];
                  }
                }),
                _: 2
              }, _parent));
            } else {
              _push(`<div><div class="flex items-center justify-between p-2 text-xs"><div>${ssrInterpolate(levelName(item.requirements.role[0]))}</div><div>`);
              if (item.requirements.role[0] === unref(viewer)?.data?.gqLevel || item.requirements.role[0] === unref(viewer)?.data?.gqVIP) {
                _push(`<span> 1 </span>`);
              } else {
                _push(`<span>0</span>`);
              }
              _push(`</div></div></div>`);
            }
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          if (item.requirements?.min_days) {
            _push(`<div class="text-xs flex items-center justify-between p-2"><div>${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.registerTime", [
              item.requirements?.min_days
            ]))}</div><div>`);
            if (compareTime(
              unref(viewer).data.gqRegisteredDate,
              item.requirements?.min_days
            )) {
              _push(`<span class="flex"><i class="i-ph-check-circle-duotone text-[--el-color-primary]"></i></span>`);
            } else {
              _push(`<span class="flex"><i class="i-ph-x-circle-duotone text-[--el-color-danger]"></i></span>`);
            }
            _push(`</div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (item.requirements?.pay?.money?.[unref(action).currency.iso] || item.requirements?.pay?.money?.[unref(action).currency.iso]?.credit) {
          _push(`<!--[--><h2 class="text-xs mt-3 flex items-center justify-between"><div class="flex items-center gap-1"><i class="i-ph-approximate-equals-duotone text-[--el-color-primary]"></i><span class="opacity-80">${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.verifyFee"))}</span></div></h2><div class="border-1 rounded mt-2 text-xs" style="${ssrRenderStyle({ "--el-border-color": "var(--el-border-color-lighter)" })}"><div class="divide-y"><div class="flex items-center p-2 justify-between"><div>`);
          if (item.requirements.pay?.pay_type == "money") {
            _push(`<span>${ssrInterpolate(unref(action).currency.symbol + item.requirements.pay?.money?.[unref(action).currency.iso])}</span>`);
          } else {
            _push(`<span class="flex items-center">`);
            _push(ssrRenderComponent(_component_CommonCreditIcon, { class: "ml-1" }, null, _parent));
            _push(`${ssrInterpolate(item.requirements.pay?.credit)}</span>`);
          }
          _push(`</div><div>`);
          if (item.verify?.moneyPaid) {
            _push(`<span class="flex"><i class="i-ph-check-circle-duotone text-[--el-color-primary]"></i></span>`);
          } else {
            _push(`<span class="flex"><i class="i-ph-scroll-thin opacity-80"></i></span>`);
          }
          _push(`</div></div></div></div><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        if (item.requirements?.role || item.requirements?.min_days) {
          _push(`<h2 class="text-xs mt-3 flex items-center gap-1"><i class="i-ph-approximate-equals-duotone text-[--el-color-primary]"></i><span class="opacity-80">${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.validity"))}</span></h2>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="border-1 rounded mt-2 text-xs p-2">`);
        if (item.expiry > 0) {
          _push(`<span>${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.expiry", [item.expiry]))}</span>`);
        } else {
          _push(`<span>${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.forever"))}</span>`);
        }
        _push(`</div></div><div class="mt-auto w-full">`);
        _push(ssrRenderComponent(_component_el_button, {
          class: "mt-4 w-full",
          type: "primary",
          plain: "",
          disabled: !roleCheck(item.requirements?.role, unref(viewer)?.data) || item.verify?.status == "approved" || item.verify?.status == "pending",
          onClick: ($event) => handleClick(2, item.formId, item.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (item.verify?.status == "pending") {
                _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.pending"))}</span>`);
              } else if (item.verify?.status == "approved") {
                _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.approved"))}</span>`);
              } else if (item.verify?.status == "rejected") {
                _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.rejected"))}</span>`);
              } else if (!roleCheck(item.requirements?.role, unref(viewer)?.data)) {
                _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.notMeet"))}</span>`);
              } else {
                _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.goVerify"))}</span>`);
              }
            } else {
              return [
                item.verify?.status == "pending" ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("page.account.verify.step.step1.pending")), 1)) : item.verify?.status == "approved" ? (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("page.account.verify.step.step1.approved")), 1)) : item.verify?.status == "rejected" ? (openBlock(), createBlock("span", { key: 2 }, toDisplayString(_ctx.$t("page.account.verify.step.step1.rejected")), 1)) : !roleCheck(item.requirements?.role, unref(viewer)?.data) ? (openBlock(), createBlock("span", { key: 3 }, toDisplayString(_ctx.$t("page.account.verify.step.step1.notMeet")), 1)) : (openBlock(), createBlock("span", { key: 4 }, toDisplayString(_ctx.$t("page.account.verify.step.step1.goVerify")), 1))
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></div>`);
      });
      _push(`<!--]--></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/account/verify/step1.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
