import { E as ElButton } from './index-DYnTqrQe.mjs';
import { e as useUtils, r as useRequest } from './server.mjs';
import { useSSRContext, ref, mergeProps, unref, withCtx, openBlock, createBlock, Fragment, createCommentVNode } from 'vue';
import { ssrRenderAttrs, ssrRenderClass, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesSingleCategorySubscribe",
  __ssrInlineRender: true,
  props: ["item", "submitLocked"],
  setup(__props) {
    const submitLocked = ref([]);
    const subscribe = async (item) => {
      if (submitLocked.value[item?.databaseId]) {
        return;
      }
      submitLocked.value[item?.databaseId] = true;
      const res = await useRequest("/api/request", {
        body: {
          data: {
            id: item?.databaseId,
            id: item?.databaseId
          }
        }
      });
      if (res?.gqToggleContent) {
        if (res?.gqToggleContent?.status) {
          item.subscribers += 1;
        } else {
          item.subscribers -= 1;
        }
        item.subscribed = res.gqToggleContent.status;
      }
      submitLocked.value[item?.databaseId] = false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center text-xs gap-3 cursor-pointer group/subscribe ml-auto" }, _attrs))} data-v-ad56fd25><div class="flex whitespace-nowrap opacity-80 gq-gs" data-v-ad56fd25><div class="${ssrRenderClass(`${__props.item?.subscribed ? "group-hover/subscribe:hidden" : ""}`)}" data-v-ad56fd25>`);
      if (__props.item?.subscribed) {
        _push(`<span data-v-ad56fd25>${ssrInterpolate(_ctx.$t("common.subscribe.subscribed"))}</span>`);
      } else {
        _push(`<span data-v-ad56fd25>${ssrInterpolate(_ctx.$t("common.subscribe.subscribe"))}</span>`);
      }
      _push(`<span class="ml-1 gq-gs" data-v-ad56fd25>${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(__props.item?.subscribers || 0))}</span></div><div class="${ssrRenderClass(`${__props.item?.subscribed ? "group-hover/subscribe:block hidden" : "hidden"}`)}" data-v-ad56fd25>${ssrInterpolate(_ctx.$t("common.subscribe.unsubscribe"))}</div></div>`);
      _push(ssrRenderComponent(_component_el_button, {
        class: "!w-8 !h-8 !p-0 subscribe-btn gq-gs",
        onClick: ($event) => subscribe(__props.item),
        plain: "",
        loading: unref(submitLocked)[__props.item?.databaseId],
        type: __props.item?.subscribed ? "default" : "primary",
        style: { "--el-border": "1px dashed var(--el-color-primary-light-9)", "--el-button-hover-bg-color": "var(--el-color-primary-light-9)", "--el-button-hover-text-color": "var(--el-color-primary)", "--el-button-active-bg-color": "var(--el-color-primary-light-9)", "--el-button-active-text-color": "var(--el-color-primary)", "--el-button-disabled-bg-color": "#fff", "--el-button-disabled-text-color": "var(--el-text-color-disabled)", "--el-button-border-color": "var(--el-color-primary-light-8)", "--el-button-bg-color": "transparent" }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (!unref(submitLocked)[__props.item?.databaseId]) {
              _push2(`<!--[-->`);
              if (__props.item?.subscribed) {
                _push2(`<i class="i-ph-bookmark-fill text-[var(--el-color-primary)]" data-v-ad56fd25${_scopeId}></i>`);
              } else {
                _push2(`<i class="i-ph-bookmark-simple" data-v-ad56fd25${_scopeId}></i>`);
              }
              _push2(`<!--]-->`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              !unref(submitLocked)[__props.item?.databaseId] ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                __props.item?.subscribed ? (openBlock(), createBlock("i", {
                  key: 0,
                  class: "i-ph-bookmark-fill text-[var(--el-color-primary)]"
                })) : (openBlock(), createBlock("i", {
                  key: 1,
                  class: "i-ph-bookmark-simple"
                }))
              ], 64)) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/single/category/subscribe.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_2 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-ad56fd25"]]);

export { __nuxt_component_2 as default };
