import { computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs } from 'vue/server-renderer';

const _sfc_main = {
  __name: "CommonSvgIcon",
  __ssrInlineRender: true,
  props: ["d"],
  setup(__props) {
    const props = __props;
    const isImageUrl = computed(() => {
      if (!props.d || typeof props.d !== "string") return false;
      const s = props.d.trim();
      if (s.startsWith("data:image")) return false;
      return /^https?:\/\//i.test(s);
    });
    const dStr = computed(() => {
      return props.d ? `url('${props.d.replace(/'/g, "\\'")}')` : "";
    });
    return (_ctx, _push, _parent, _attrs) => {
      if (__props.d) {
        _push(`<i${ssrRenderAttrs(mergeProps({
          class: ["gq-custom-icon rounded", { "gq-custom-icon--img": unref(isImageUrl) }],
          style: `--un-icon:${unref(dStr)};`
        }, _attrs))}></i>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/svgIcon.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
