import _sfc_main$1 from './creditIcon-eOdkwofx.mjs';
import { E as ElProgress } from './progress-CBrKLnJJ.mjs';
import { g as getServerSettings, j as actionStore, v as viewerStore, e as useUtils, r as useRequest } from './server.mjs';
import { computed, ref, watch, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderList, ssrRenderComponent, ssrRenderClass } from 'vue/server-renderer';
import './svgIcon-BpIUCf-e.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';

const _sfc_main = {
  __name: "ModulesAccountTask",
  __ssrInlineRender: true,
  setup(__props) {
    const settingsStore = getServerSettings();
    const action = actionStore();
    const taskNew = computed(() => {
      return settingsStore?.["task_new"];
    });
    const taskDay = computed(() => {
      return settingsStore?.["task_day"];
    });
    const taskTotal = computed(() => {
      return settingsStore?.["task_total"];
    });
    const myTask = ref({});
    const viewer = viewerStore();
    const registerDays = computed(() => {
      const now = /* @__PURE__ */ new Date();
      const registeredDate = new Date(viewer.data.gqRegisteredDate);
      const timeDiff = now.getTime() - registeredDate.getTime();
      const daysDiff = Math.floor(timeDiff / (1e3 * 60 * 60 * 24));
      return daysDiff;
    });
    const getMyTask = async () => {
      const res = await useRequest("/api/request", {});
      if (res?.guaqi?.account?.task) {
        myTask.value = res.guaqi.account.task;
      } else {
        myTask.value = {};
      }
    };
    watch(() => action.loginAction, () => {
      init();
    });
    const init = () => {
      getMyTask();
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommonCreditIcon = _sfc_main$1;
      const _component_el_progress = ElProgress;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex flex-col gap-6 opacity-80" }, _attrs))}><div><div class="font-600 ml-4">${ssrInterpolate(_ctx.$t(`page.account.task.new.title`))}</div><div class="ml-4 text-xs opacity-50 mt-1">${ssrInterpolate(_ctx.$t(`page.account.task.new.description`))}</div><div class="grid grid-cols-2 gap-3 mt-2"><!--[-->`);
      ssrRenderList(unref(taskNew), (item, key, index) => {
        _push(`<div class="flex border-1 justify-between items-center gap-2 p-3 px-4 bg-gradient-to-br from-[--el-color-info-light-10] to-[--el-color-info-light-10] rounded-md"><div class="flex flex-col"><div class="text-sm">${ssrInterpolate(_ctx.$t(`page.account.task.new.prefix`) + _ctx.$t(`page.account.task.taskItem.${("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).toCamelCase(key)}`))}</div><div class="flex items-center text-xs mt-1 text-[--el-color-primary-dark-2]">`);
        _push(ssrRenderComponent(_component_CommonCreditIcon, { class: "mr-0.5" }, null, _parent));
        _push(` +${ssrInterpolate(item)}</div></div><div class="flex flex-col items-end text-xs"><span class="${ssrRenderClass(`${(unref(myTask)?.[key]?.first ?? 0) == 1 ? "bg-[--el-color-primary-light-8] text-[--el-color-primary]" : "bg-[--el-fill-color-darker] "}  px-2 py-0.6 rounded-md`)}">${ssrInterpolate(unref(myTask)?.[key]?.first ?? 0)}/1 </span></div></div>`);
      });
      _push(`<!--]--></div></div><div><div class="font-600 ml-4">${ssrInterpolate(_ctx.$t(`page.account.task.day.title`))}</div><div class="ml-4 text-xs opacity-50 mt-1">${ssrInterpolate(_ctx.$t(`page.account.task.day.description`))}</div><div class="grid grid-cols-2 gap-3 mt-2"><!--[-->`);
      ssrRenderList(unref(taskDay), (item, key, index) => {
        _push(`<div class="flex border-1 justify-between items-center p-3 px-4 bg-gradient-to-br from-[--el-color-info-light-10] to-[--el-color-info-light-10] rounded-md xyz-in"><div class="flex flex-col"><div class="text-sm">${ssrInterpolate(_ctx.$t(`page.account.task.day.prefix`) + _ctx.$t(`page.account.task.taskItem.${("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).toCamelCase(key)}`))}</div><div class="flex items-center text-xs mt-1 text-[--el-color-warning-dark-2]">`);
        _push(ssrRenderComponent(_component_CommonCreditIcon, { class: "mr-0.5" }, null, _parent));
        _push(` +${ssrInterpolate(item.credit)}</div></div><div class="flex flex-col items-end text-xs gap-2"><span>${ssrInterpolate(unref(myTask)?.[key]?.today ?? 0)}/${ssrInterpolate(item.count)}</span>`);
        _push(ssrRenderComponent(_component_el_progress, {
          "show-text": false,
          class: "w-16",
          percentage: (unref(myTask)?.[key]?.today | 0) / (item.count ?? 1) * 100 > 100 ? 100 : (unref(myTask)?.[key]?.today | 0) / (item.count ?? 1) * 100,
          size: "small",
          color: "var(--el-color-primary)"
        }, null, _parent));
        _push(`</div></div>`);
      });
      _push(`<!--]--></div></div><div><div class="font-600 ml-4">${ssrInterpolate(_ctx.$t(`page.account.task.total.title`))}</div><div class="ml-4 text-xs opacity-50 mt-1">${ssrInterpolate(_ctx.$t(`page.account.task.total.description`))}</div><div class="grid grid-cols-2 gap-3 mt-2"><!--[-->`);
      ssrRenderList(unref(taskTotal), (item, key, index) => {
        _push(`<div class="flex border-1 justify-between items-center p-3 px-4 bg-gradient-to-br from-[--el-color-info-light-10] to-[--el-color-info-light-10] rounded-md xyz-in"><div class="flex flex-col">`);
        if (key !== "register") {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t(`page.account.task.total.prefix`) + _ctx.$t(`page.account.task.taskItem.${("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).toCamelCase(key)}`))}</div>`);
        } else {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t(`page.account.task.total.prefix`) + _ctx.$t(`page.account.task.taskItem.registerTime`))}</div>`);
        }
        _push(`<div class="flex items-center text-xs mt-1 text-[--el-color-success-dark-2]">`);
        _push(ssrRenderComponent(_component_CommonCreditIcon, { class: "mr-0.5" }, null, _parent));
        _push(` +${ssrInterpolate(item.credit)}</div></div>`);
        if (key !== "register") {
          _push(`<div class="flex flex-col items-end text-xs gap-2"><span>${ssrInterpolate(unref(myTask)?.[key]?.total | 0)}/${ssrInterpolate(item.count)}</span>`);
          _push(ssrRenderComponent(_component_el_progress, {
            "show-text": false,
            class: "w-16",
            percentage: (unref(myTask)?.[key]?.total | 0) / (item.count ?? 1) * 100 > 100 ? 100 : (unref(myTask)?.[key]?.total | 0) / (item.count ?? 1) * 100,
            size: "small",
            color: "var(--el-color-primary)"
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<div class="flex flex-col items-end text-xs gap-2"><span><span class="mr-1">${ssrInterpolate(unref(registerDays) | 0)}</span>(${ssrInterpolate(unref(registerDays) % item.count | 0)}/${ssrInterpolate(item.count)})</span>`);
          _push(ssrRenderComponent(_component_el_progress, {
            "show-text": false,
            class: "w-16",
            percentage: (unref(registerDays) % item.count | 0) / (item.count ?? 1) * 100 > 100 ? 100 : (unref(registerDays) % item.count | 0) / (item.count ?? 1) * 100,
            size: "small",
            color: "var(--el-color-primary)"
          }, null, _parent));
          _push(`</div>`);
        }
        _push(`</div>`);
      });
      _push(`<!--]--></div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/account/task.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
