import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import { useSSRContext, ref, computed, mergeProps, unref, isRef, withCtx, createVNode, openBlock, createBlock, Fragment, renderList, toDisplayString } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate } from 'vue/server-renderer';
import { Carousel, Slide, Pagination, Navigation } from 'vue3-carousel';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './server.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';
import './image-viewer-DG2qIWb8.mjs';
import './index-ChPMoinw.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import './index-Di0Jlzch.mjs';
import './index-BKB3Djp4.mjs';

const _sfc_main = {
  __name: "ModulesCommonTopicThumbGallery",
  __ssrInlineRender: true,
  props: {
    item: {
      type: Object,
      default: () => {
      }
    },
    settings: {
      type: Object,
      default: () => {
      }
    },
    isList: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const props = __props;
    const currentIndex = ref(0);
    const ratio = computed(() => {
      return (props.item?.node?.topicContent?.topicExcerpt?.gallery?.[0]?.height ?? 1.3) / (props.item?.node?.topicContent?.topicExcerpt?.gallery?.[0]?.width ?? 1) * 100 + "%";
    });
    const carouselConfig = computed(() => {
      return {
        itemsToShow: 1,
        wrapAround: true,
        gap: 10,
        clamp: true,
        mouseWheel: true,
        autoplay: 0
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Image = __nuxt_component_4;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "thumb-card container-box flex-1 relative overflow-hidden",
        style: `--ratio:${unref(ratio)}`
      }, _attrs))} data-v-f50776fb>`);
      if (__props.isList || __props.item?.node?.topicContent?.topicExcerpt?.gallery?.length == 1) {
        _push(`<div class="w-full h-full object-cover absolute top-0 left-0 flex items-center justify-center" data-v-f50776fb>`);
        _push(ssrRenderComponent(_component_Image, {
          src: __props.item?.node?.topicContent?.topicExcerpt?.gallery?.[0]?.src,
          class: "w-full",
          fit: "contain"
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<div class="w-full h-full object-cover absolute top-0 left-0 flex items-center justify-center" data-v-f50776fb>`);
        _push(ssrRenderComponent(unref(Carousel), mergeProps(unref(carouselConfig), {
          style: { "--vc-pgn-border-radius": "100%", "--vc-pgn-height": "0.4rem", "--vc-pgn-width": "0.4rem", "--vc-pgn-background-color": "var(--el-mask-color-extra-light)", "--vc-pgn-active-color": "var(--el-bg-color)", "--vc-png-bottom": "64px" },
          class: "absolute top-0 left-0 w-full !h-fit !max-h-full rounded",
          transition: 600,
          modelValue: unref(currentIndex),
          "onUpdate:modelValue": ($event) => isRef(currentIndex) ? currentIndex.value = $event : null,
          gap: 0,
          "transition-easing": "cubic-bezier(0.4, 0, 0.2, 1)"
        }), {
          addons: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(unref(Pagination), null, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(unref(Navigation), null, null, _parent2, _scopeId));
              _push2(`<span class="number-text" data-v-f50776fb${_scopeId}>${ssrInterpolate(unref(currentIndex) + 1)}/${ssrInterpolate(__props.item?.node?.topicContent?.topicExcerpt?.gallery?.length)}</span>`);
            } else {
              return [
                createVNode(unref(Pagination)),
                createVNode(unref(Navigation)),
                createVNode("span", { class: "number-text" }, toDisplayString(unref(currentIndex) + 1) + "/" + toDisplayString(__props.item?.node?.topicContent?.topicExcerpt?.gallery?.length), 1)
              ];
            }
          }),
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<!--[-->`);
              ssrRenderList(__props.item?.node?.topicContent?.topicExcerpt?.gallery || 1, (item, i) => {
                _push2(ssrRenderComponent(unref(Slide), {
                  key: i,
                  class: "select-none"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(ssrRenderComponent(_component_Image, {
                        src: item?.src,
                        class: "w-full h-full select-none",
                        fit: "contain"
                      }, null, _parent3, _scopeId2));
                    } else {
                      return [
                        createVNode(_component_Image, {
                          src: item?.src,
                          class: "w-full h-full select-none",
                          fit: "contain"
                        }, null, 8, ["src"])
                      ];
                    }
                  }),
                  _: 2
                }, _parent2, _scopeId));
              });
              _push2(`<!--]-->`);
            } else {
              return [
                (openBlock(true), createBlock(Fragment, null, renderList(__props.item?.node?.topicContent?.topicExcerpt?.gallery || 1, (item, i) => {
                  return openBlock(), createBlock(unref(Slide), {
                    key: i,
                    class: "select-none"
                  }, {
                    default: withCtx(() => [
                      createVNode(_component_Image, {
                        src: item?.src,
                        class: "w-full h-full select-none",
                        fit: "contain"
                      }, null, 8, ["src"])
                    ]),
                    _: 2
                  }, 1024);
                }), 128))
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div>`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/thumbGallery.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_2 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-f50776fb"]]);

export { __nuxt_component_2 as default };
