import { useSSRContext, computed, mergeProps, unref } from 'vue';
import { ssrRenderAttrs, ssrInterpolate } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';

const _sfc_main = {
  __name: "ModulesCommonTopicThumbLocked",
  __ssrInlineRender: true,
  props: [
    "item",
    "settings",
    "isList",
    "style",
    "singleType"
  ],
  setup(__props) {
    const props = __props;
    const type = computed(() => {
      if (props.item?.node?.topicContent?.topicExcerpt?.video?.length > 0 && props.item?.node?.topicContent?.topicExcerpt?.video?.[0]?.width) {
        return "VIDEO";
      } else if (props.item?.node?.topicContent?.topicExcerpt?.gallery?.length > 0 && props.item?.node?.topicContent?.topicExcerpt?.gallery?.[0]?.width) {
        return "GALLERY";
      }
    });
    const ratio = (item) => {
      if (item?.node?.topicContent?.topicExcerpt?.video?.length > 0 && item?.node?.topicContent?.topicExcerpt?.video?.[0]?.width) {
        return item?.node?.topicContent?.topicExcerpt?.video?.[0]?.height / item?.node?.topicContent?.topicExcerpt?.video?.[0]?.width * 100 + "%";
      } else if (item?.node?.topicContent?.topicExcerpt?.gallery?.length > 0 && item?.node?.topicContent?.topicExcerpt?.gallery?.[0]?.width) {
        return item?.node?.topicContent?.topicExcerpt?.gallery?.[0]?.height / item?.node?.topicContent?.topicExcerpt?.gallery?.[0]?.width * 100 + "%";
      }
      return 1.3 / 1 * 100 + "%";
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: __props.isList ? "h-0 pt-[var(--ratio)] relative" : "!h-full relative",
        style: `--ratio:${ratio(__props.item)};`
      }, _attrs))} data-v-e7ec965c><div class="absolute top-0 left-0 w-full h-full flex items-center justify-center flex-col gap-3 bg-[--el-color-info-light-10]" data-v-e7ec965c><span class="opacity-70" data-v-e7ec965c>${ssrInterpolate(unref(type))}</span><i class="i-ph-lock-laminated-thin opacity-70" data-v-e7ec965c></i></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/thumbLocked.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_0 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-e7ec965c"]]);

export { __nuxt_component_0 as default };
