import { x as __nuxt_component_0$1 } from './server.mjs';
import { useSSRContext, computed, mergeProps } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent } from 'vue/server-renderer';
import { u as useColorMode } from './composables-1jje8stA.mjs';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonTopicThumbText",
  __ssrInlineRender: true,
  props: ["isList", "item", "settings", "singleType"],
  setup(__props) {
    const props = __props;
    const colorMode = useColorMode();
    const isDark = computed(() => colorMode.value === "dark");
    const darkPalettes = [
      {
        bg: "#202023",
        // 稍微提亮的深灰
        text: "#2dd4bf",
        quote: "#115e59",
        accent: "#0d9488",
        blobs: ["rgba(15,118,110,0.3)", "rgba(20,184,166,0.15)"],
        emojis: ["👾", "💿", "🧪"]
      },
      {
        bg: "#162032",
        // 稍微提亮的深蓝灰
        text: "#e2e8f0",
        quote: "#1e293b",
        accent: "#38bdf8",
        blobs: ["rgba(3,105,161,0.3)", "rgba(12,74,110,0.15)"],
        emojis: ["🌑", "🌌", "🌠"]
      },
      {
        bg: "#251A1D",
        // 稍微提亮的深红灰
        text: "#fb7185",
        quote: "#881337",
        accent: "#e11d48",
        blobs: ["rgba(190,18,60,0.3)", "rgba(159,18,57,0.15)"],
        emojis: ["🍷", "🥀", "🩸"]
      },
      {
        bg: "#0A220A",
        // 稍微提亮的深绿
        text: "#4ade80",
        quote: "#14532d",
        accent: "#22c55e",
        blobs: ["rgba(21,128,61,0.3)", "rgba(22,101,52,0.15)"],
        emojis: ["📟", "🔋", "🐸"]
      },
      {
        bg: "#222222",
        // 标准深灰
        text: "#fde047",
        quote: "#854d0e",
        accent: "#eab308",
        blobs: ["rgba(202,138,4,0.3)", "rgba(161,98,7,0.15)"],
        emojis: ["👑", "⚡", "🏆"]
      }
    ];
    const lightPalettes = [
      {
        bg: "#FFFEFA",
        // 极淡黄 -> 接近白
        text: "#5F370E",
        quote: "#FDE047",
        accent: "#FEF9C3",
        // 光斑透明度降至 0.2 - 0.3
        blobs: ["rgba(254,240,138,0.3)", "rgba(253,224,71,0.2)"],
        emojis: ["☀️", "🥐", "✨"]
      },
      {
        bg: "#FAFCFA",
        // 极淡绿 -> 接近白
        text: "#2D382B",
        quote: "#CDE0C6",
        accent: "#D8E6D3",
        blobs: ["rgba(200,217,191,0.3)", "rgba(225,234,216,0.2)"],
        emojis: ["🍵", "🌿", "🍃"]
      },
      {
        bg: "#FFFCfd",
        // 极淡粉 -> 接近白
        text: "#881337",
        quote: "#FBCFE8",
        accent: "#FCE7F3",
        blobs: ["rgba(249,168,212,0.3)", "rgba(251,207,232,0.2)"],
        emojis: ["🌸", "🎀", "🍧"]
      },
      {
        bg: "#F5FEFF",
        // 极淡蓝 -> 接近白
        text: "#164E63",
        quote: "#A5F3FC",
        accent: "#CFFAFE",
        blobs: ["rgba(103,232,249,0.3)", "rgba(165,243,252,0.2)"],
        emojis: ["🌊", "🐳", "🧊"]
      },
      {
        bg: "#FCFAFF",
        // 极淡紫 -> 接近白
        text: "#581C87",
        quote: "#E9D5FF",
        accent: "#F3E8FF",
        blobs: ["rgba(216,180,254,0.3)", "rgba(233,213,255,0.2)"],
        emojis: ["🍇", "🔮", "🦄"]
      }
    ];
    const seededRandom = (seed) => {
      let value = seed;
      return () => {
        value = (value * 9301 + 49297) % 233280;
        return value / 233280;
      };
    };
    const textHash = computed(() => {
      let hash = 0;
      const str = props.item?.node?.title || "";
      for (let i = 0; i < str.length; i++) {
        hash = (hash << 5) - hash + str.charCodeAt(i);
        hash |= 0;
      }
      return Math.abs(hash);
    });
    const theme = computed(() => {
      const paletteList = isDark.value ? darkPalettes : lightPalettes;
      return paletteList[textHash.value % paletteList.length];
    });
    computed(() => ({
      backgroundColor: theme.value.bg,
      contain: "paint layout style"
    }));
    computed(() => {
      const rng = seededRandom(textHash.value);
      const colors = theme.value.blobs;
      const gradients = [];
      const count = props.isList ? 1 : 2;
      for (let i = 0; i < count; i++) {
        const x = Math.floor(rng() * 100);
        const y = Math.floor(rng() * 100);
        const color = colors[i % colors.length];
        gradients.push(
          `radial-gradient(circle at ${x}% ${y}%, ${color} 0%, transparent 70%)`
        );
      }
      return {
        backgroundImage: gradients.join(", "),
        mixBlendMode: !props.isList && isDark.value ? "screen" : "normal",
        opacity: isDark.value ? 0.4 : 0.8
      };
    });
    computed(() => {
      const rng = seededRandom(textHash.value + 100);
      const list = [];
      const count = props.isList ? 2 : 2 + Math.floor(rng() * 2);
      for (let i = 0; i < count; i++) {
        const emoji = theme.value.emojis[Math.floor(rng() * theme.value.emojis.length)];
        const size = (props.isList ? 1 : 30) + rng() * 50;
        const isBlurred = rng() > 0.6;
        const finalFilter = props.isList ? "none" : isBlurred ? "blur(2px)" : "none";
        const finalOpacity = isBlurred ? props.isList ? 0.05 : 0.1 : 0.25;
        list.push({
          char: emoji,
          style: {
            fontSize: `${size}px`,
            top: `${10 + rng() * 80}%`,
            left: `${10 + rng() * 80}%`,
            transform: `rotate(${rng() * 60 - 30}deg)`,
            opacity: finalOpacity,
            filter: finalFilter,
            // CSS Filter 是性能杀手
            willChange: "transform"
            // 提示浏览器优化
          }
        });
      }
      return list;
    });
    computed(() => {
      if (isDark.value) {
        return {
          height: "2px",
          bottom: "-4px",
          backgroundColor: theme.value.accent,
          boxShadow: `0 0 8px ${theme.value.accent}`
        };
      } else {
        return {
          height: "0.3em",
          backgroundColor: theme.value.accent,
          opacity: 0.5
        };
      }
    });
    computed(() => {
      const rng = seededRandom(textHash.value + 200);
      return theme.value.emojis[Math.floor(rng() * theme.value.emojis.length)];
    });
    computed(() => {
      const len = props.item?.node?.title.length || 0;
      if (len < 10) return "@xs:text-5xl text-2xl";
      if (len < 20) return "@xs:text-4xl text-1xl";
      if (len < 40) return "@xs:text-3xl text-lg";
      return "@xs:text-2xl text-base";
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_client_only = __nuxt_component_0$1;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "thumb-card container-box",
        style: { contentVisibility: "auto" }
      }, _attrs))} data-v-086ed39c>`);
      _push(ssrRenderComponent(_component_client_only, null, {}, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/thumbText.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_3 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-086ed39c"]]);

export { __nuxt_component_3 as default };
