import { useSSRContext, ref, watch, computed, mergeProps, unref, isRef, createSlots, withCtx, createVNode, openBlock, createBlock, Fragment, renderList, toDisplayString } from 'vue';
import { ssrRenderAttrs, ssrRenderAttr, ssrRenderComponent, ssrRenderList, ssrInterpolate } from 'vue/server-renderer';
import { Carousel, Slide, Pagination, Navigation } from 'vue3-carousel';
import { V as useNuxtApp } from './server.mjs';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonTopicThumbVideo",
  __ssrInlineRender: true,
  props: {
    item: {
      type: Object,
      default: () => {
      }
    },
    settings: {
      type: Object,
      default: () => {
      }
    },
    isList: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    const { $xgPlayer } = useNuxtApp();
    const props = __props;
    const currentIndex = ref(0);
    ref(null);
    const player = ref(null);
    const handleSlideClick = () => {
      if (player.value) {
        if (player.value.paused) {
          player.value.play().catch(() => {
          });
        } else {
          player.value.pause();
        }
      }
    };
    watch(currentIndex, (newIndex) => {
      const videos = props.item?.node?.topicContent?.topicExcerpt?.video || [];
      if (player.value && videos[newIndex]) {
        player.value.src = videos[newIndex]?.src;
        const playVideo = () => {
          if (player.value && player.value.paused) {
            player.value.play().catch(() => {
            });
          }
        };
        player.value.once("ready", playVideo);
        setTimeout(() => {
          playVideo();
        }, 100);
      }
    });
    const ratio = computed(() => {
      return (props.item?.node?.topicContent?.topicExcerpt?.video?.[0]?.height ?? 1.3) / (props.item?.node?.topicContent?.topicExcerpt?.video?.[0]?.width ?? 1) * 100 + "%";
    });
    const carouselConfig = computed(() => {
      return {
        itemsToShow: 1,
        wrapAround: true,
        gap: 10,
        clamp: true,
        mouseWheel: true,
        autoplay: 0
      };
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "thumb-card container-box flex-1 relative overflow-hidden",
        style: `--ratio:${unref(ratio)}`
      }, _attrs))} data-v-5e92df50>`);
      if (__props.isList && __props.item?.node?.topicContent?.topicExcerpt?.video?.length > 0) {
        _push(`<div class="w-full h-full object-cover absolute top-0 left-0 flex items-center justify-center" data-v-5e92df50><video${ssrRenderAttr("src", __props.item?.node?.topicContent?.topicExcerpt?.video[0]?.src + "#t=1")} class="video-cover w-full h-full object-cover" preload="metadata" muted playsinline data-v-5e92df50></video><i class="i-ph-play-circle-fill text-white/50 text-xl absolute top-4 right-4" data-v-5e92df50></i></div>`);
      } else {
        _push(`<div class="w-full object-cover absolute top-0 left-0 h-full w-full" data-v-5e92df50><div class="absolute top-0 left-0 !w-full !h-full" data-v-5e92df50></div>`);
        _push(ssrRenderComponent(unref(Carousel), mergeProps(unref(carouselConfig), {
          style: { "--vc-pgn-border-radius": "100%", "--vc-pgn-height": "0.25rem", "--vc-pgn-width": "0.25rem", "--vc-pgn-background-color": "var(--el-mask-color-extra-light)", "--vc-pgn-active-color": "var(--el-color-primary)", "--vc-png-bottom": "64px" },
          class: "!absolute top-0 left-0 w-full !h-full rounded",
          modelValue: unref(currentIndex),
          "onUpdate:modelValue": ($event) => isRef(currentIndex) ? currentIndex.value = $event : null,
          transition: 600,
          "transition-easing": "cubic-bezier(0.4, 0, 0.2, 1)"
        }), createSlots({
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<!--[-->`);
              ssrRenderList(__props.item?.node?.topicContent?.topicExcerpt?.video || [], (item, i) => {
                _push2(ssrRenderComponent(unref(Slide), { key: i }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`<div class="w-full h-full max-w-full max-h-full object-contain" data-v-5e92df50${_scopeId2}></div>`);
                    } else {
                      return [
                        createVNode("div", {
                          class: "w-full h-full max-w-full max-h-full object-contain",
                          onClick: handleSlideClick
                        })
                      ];
                    }
                  }),
                  _: 2
                }, _parent2, _scopeId));
              });
              _push2(`<!--]-->`);
            } else {
              return [
                (openBlock(true), createBlock(Fragment, null, renderList(__props.item?.node?.topicContent?.topicExcerpt?.video || [], (item, i) => {
                  return openBlock(), createBlock(unref(Slide), { key: i }, {
                    default: withCtx(() => [
                      createVNode("div", {
                        class: "w-full h-full max-w-full max-h-full object-contain",
                        onClick: handleSlideClick
                      })
                    ]),
                    _: 1
                  });
                }), 128))
              ];
            }
          }),
          _: 2
        }, [
          __props.item?.node?.topicContent?.topicExcerpt?.video?.length > 1 ? {
            name: "addons",
            fn: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(ssrRenderComponent(unref(Pagination), null, null, _parent2, _scopeId));
                _push2(ssrRenderComponent(unref(Navigation), null, null, _parent2, _scopeId));
                _push2(`<span class="number-text" data-v-5e92df50${_scopeId}>${ssrInterpolate(unref(currentIndex) + 1)}/${ssrInterpolate(__props.item?.node?.topicContent?.topicExcerpt?.video?.length)}</span>`);
              } else {
                return [
                  createVNode(unref(Pagination)),
                  createVNode(unref(Navigation)),
                  createVNode("span", { class: "number-text" }, toDisplayString(unref(currentIndex) + 1) + "/" + toDisplayString(__props.item?.node?.topicContent?.topicExcerpt?.video?.length), 1)
                ];
              }
            }),
            key: "0"
          } : void 0
        ]), _parent));
        _push(`</div>`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/thumbVideo.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_1 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-5e92df50"]]);

export { __nuxt_component_1 as default };
