import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElRadioGroup, a as ElRadio } from './index-CCMOIr7X.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import _sfc_main$1 from './timeAgo-D7-A3XOx.mjs';
import { E as ElEmpty } from './index-Dbj2uCwz.mjs';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { E as ElAvatar } from './index-R6EFYpWa.mjs';
import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import { v as vLoading } from './directive-BPPM1aUC.mjs';
import { g as getServerSettings, j as actionStore, a as useI18n, v as viewerStore, r as useRequest, w as isLogin, e as useUtils } from './server.mjs';
import { useSSRContext, computed, ref, reactive, watch, mergeProps, unref, withCtx, createTextVNode, toDisplayString, openBlock, createBlock, Fragment, renderList, createVNode, withDirectives, createCommentVNode } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderStyle, ssrGetDirectiveProps, ssrRenderClass } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './event-BZTOGHfp.mjs';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import './index-Bp-nwGzu.mjs';
import './aria-BhThsKez.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './vnode-l2ZP2UQa.mjs';
import './image-viewer-DG2qIWb8.mjs';
import './index-Di0Jlzch.mjs';

const _sfc_main = {
  __name: "ModulesAccountTicket",
  __ssrInlineRender: true,
  setup(__props) {
    const settingsStore = getServerSettings();
    const action = actionStore();
    const { locale } = useI18n();
    const viewer = viewerStore();
    const ticketTypes = computed(() => {
      return settingsStore.ticket.ticket_type[locale.value]?.split("\n").filter((item) => item.trim() !== "").map((item) => item.trim()) || [];
    });
    const scrollBar = ref(null);
    const state = reactive({
      type: "list",
      title: "",
      content: "",
      replyContent: "",
      replyLocked: false,
      closeLocked: false,
      continue: false,
      pageInfo: null,
      list: null,
      ticketChat: null,
      chatLocked: false,
      ticketType: null,
      documents: null,
      locked: false,
      scrollToBottom: () => {
        if (!scrollBar.value) return;
        setTimeout(() => {
          scrollBar.value.setScrollTop(scrollBar.value.wrapRef.scrollHeight);
        }, 300);
      },
      closeTicket: async (group) => {
        if (state.closeLocked) return;
        state.closeLocked = true;
        const res = await useRequest("/api/request", {});
        if (res?.guaqi?.account?.ticket?.closeTicket) {
          state.ticketChat[state.ticketChat?.length - 1].status = "closed";
          state.list.find((item) => item.node.ticketGroup == group).node.status = "closed";
        }
        state.closeLocked = false;
      },
      getDocuments: async (flush = false) => {
        if (state.locked) return;
        state.locked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              after: flush === true ? null : state.pageInfo?.endCursor || null
            }
          }
        });
        if (res?.guaqi?.account?.ticket?.documents) {
          state.documents = res.guaqi.account.ticket.documents;
        }
        if (res?.guaqi?.account?.ticket?.ticketList?.edges) {
          if (!state.list || flush === true) {
            state.list = res?.guaqi?.account?.ticket?.ticketList?.edges;
          } else {
            state.list = [
              ...state.list,
              ...res?.guaqi?.account?.ticket?.ticketList?.edges
            ];
          }
        } else {
          state.list = [];
        }
        if (res?.guaqi?.account?.ticket?.ticketList?.pageInfo) {
          state.pageInfo = res.guaqi.account.ticket.ticketList.pageInfo;
        }
        state.locked = false;
      },
      getTicketChat: async (index) => {
        if (state.chatLocked) return;
        state.chatLocked = true;
        const item = state.list[index];
        const res = await useRequest("/api/request", {
          body: {
            data: {
              fromId: viewer.data.databaseId,
              group: item.node.ticketGroup
            }
          }
        });
        if (res?.guaqi?.account?.ticket?.ticketChat) {
          state.ticketChat = res.guaqi.account.ticket.ticketChat;
          viewer.data.gqTicket = [];
          state.list.find(
            (item2) => item2.node.ticketGroup == item2.node.ticketGroup
          ).node.read = 1;
        }
        state.chatLocked = false;
        state.scrollToBottom();
      },
      createTicket: async (content) => {
        if (state.replyLocked) return;
        state.replyLocked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              title: state.title,
              type: state.type == "create" ? state.ticketType : ""
            }
          }
        });
        if (!res?.gqCreateTicket?.success && res?.gqCreateTicket?.success != 0)
          return;
        if (state.ticketChat) {
          state.ticketChat.push({
            from: {
              databaseId: viewer.data.databaseId,
              avatar: {
                url: viewer.data.avatar.url
              },
              name: viewer.data.name
            },
            fromId: viewer.data.databaseId,
            to: null,
            toId: 0,
            status: "unread",
            content,
            createdAt: (/* @__PURE__ */ new Date()).toISOString()
          });
          state.replyContent = "";
          state.replyLocked = false;
          state.scrollToBottom();
        }
        if (state.type == "create") {
          state.list.unshift({
            node: {
              id: "new",
              ticketType: state.ticketType,
              ticketTitle: state.title,
              createdAt: (/* @__PURE__ */ new Date()).toISOString(),
              status: "unread",
              ticketGroup: res.gqCreateTicket.success
            }
          });
          state.ticketChat = false;
          state.type = "list";
          state.content = "";
          state.title = "";
        }
      }
    });
    const init = () => {
      if (ticketTypes.value.length > 0) {
        state.ticketType = ticketTypes.value[0];
      }
      state.getDocuments(true);
    };
    watch(
      () => action.loginAction,
      () => {
        init();
      }
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      const _component_el_radio_group = ElRadioGroup;
      const _component_el_radio = ElRadio;
      const _component_el_input = ElInput;
      const _component_TimeAgo = _sfc_main$1;
      const _component_el_empty = ElEmpty;
      const _component_el_scrollbar = ElScrollbar;
      const _component_el_avatar = ElAvatar;
      const _component_Image = __nuxt_component_4;
      const _directive_loading = vLoading;
      let _temp0;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: `child-load ${unref(state).list ? "child-load-success" : ""}`
      }, _attrs))} data-v-7654b8e4><div class="inline-flex bg-[--el-color-info-light-10] rounded-md p-2 gq-border-none border-1 xyz-in" data-v-7654b8e4>`);
      _push(ssrRenderComponent(_component_el_button, {
        plain: "",
        size: "small",
        class: `cursor-pointer ${unref(state).type === "list" ? "is-active" : ""}`,
        disabled: !("isLogin" in _ctx ? _ctx.isLogin : unref(isLogin)),
        onClick: ($event) => unref(state).type = "list"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("page.account.ticket.myTicket"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("page.account.ticket.myTicket")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        plain: "",
        size: "small",
        class: `cursor-pointer ${unref(state).type === "create" ? "is-active" : ""}`,
        disabled: !("isLogin" in _ctx ? _ctx.isLogin : unref(isLogin)),
        onClick: ($event) => unref(state).type = "create"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("page.account.ticket.newTicket"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("page.account.ticket.newTicket")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
      if (unref(state).type === "create") {
        _push(`<div class="mt-4 border-1 p-4 rounded-md relative overflow-hidden xyz-in" data-v-7654b8e4>`);
        if (unref(state).list?.length > 0 && unref(state).list[0]?.node?.status != "closed") {
          _push(`<div class="absolute inset-0 bg-[--el-bg-color-overlay] flex flex-col items-center justify-center z-1" data-v-7654b8e4><i class="i-ph-coffee-thin w-10 h-10 opacity-40" data-v-7654b8e4></i><div class="text-sm mt-2 max-w-82 text-center" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.hasTicket"))}</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="flex gap-6 flex-col" data-v-7654b8e4><div data-v-7654b8e4><div class="text-sm mb-2" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.form.type"))} <b class="text-xs text-[--el-color-danger] ml-1" data-v-7654b8e4>*</b></div>`);
        _push(ssrRenderComponent(_component_el_radio_group, {
          modelValue: unref(state).ticketType,
          "onUpdate:modelValue": ($event) => unref(state).ticketType = $event,
          size: "small",
          class: "gap-2",
          style: { "--el-border": "1px solid var(--el-border-color-darker)" }
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<!--[-->`);
              ssrRenderList(unref(ticketTypes), (item) => {
                _push2(ssrRenderComponent(_component_el_radio, {
                  value: item,
                  key: item,
                  class: "!m-0 bg-[--el-color-info-light-10] px-2 rounded-md"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`${ssrInterpolate(item)}`);
                    } else {
                      return [
                        createTextVNode(toDisplayString(item), 1)
                      ];
                    }
                  }),
                  _: 2
                }, _parent2, _scopeId));
              });
              _push2(`<!--]-->`);
            } else {
              return [
                (openBlock(true), createBlock(Fragment, null, renderList(unref(ticketTypes), (item) => {
                  return openBlock(), createBlock(_component_el_radio, {
                    value: item,
                    key: item,
                    class: "!m-0 bg-[--el-color-info-light-10] px-2 rounded-md"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(item), 1)
                    ]),
                    _: 2
                  }, 1032, ["value"]);
                }), 128))
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div><div data-v-7654b8e4><div class="text-sm mb-2" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.form.title"))} <b class="text-xs text-[--el-color-danger] ml-1" data-v-7654b8e4>*</b></div>`);
        _push(ssrRenderComponent(_component_el_input, {
          modelValue: unref(state).title,
          "onUpdate:modelValue": ($event) => unref(state).title = $event,
          placeholder: _ctx.$t("page.account.ticket.form.titlePlaceholder")
        }, null, _parent));
        _push(`</div><div data-v-7654b8e4><div class="text-sm mb-2" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.form.content"))} <b class="text-xs text-[--el-color-danger] ml-1" data-v-7654b8e4>*</b></div>`);
        _push(ssrRenderComponent(_component_el_input, {
          modelValue: unref(state).content,
          "onUpdate:modelValue": ($event) => unref(state).content = $event,
          placeholder: _ctx.$t("page.account.ticket.form.contentPlaceholder"),
          type: "textarea",
          autosize: { minRows: 4, maxRows: 8 }
        }, null, _parent));
        _push(`</div><div class="flex justify-end" data-v-7654b8e4>`);
        _push(ssrRenderComponent(_component_el_button, {
          type: "primary",
          onClick: ($event) => ("isLogin" in _ctx ? _ctx.isLogin : unref(isLogin)) ? unref(state).createTicket(unref(state).content) : unref(action).showLogin = true,
          class: "w-auto"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("page.account.ticket.form.submit"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("page.account.ticket.form.submit")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div></div>`);
      } else {
        _push(`<div class="mt-4 flex flex-col border-1 rounded-md divide-y overflow-hidden xyz-in" data-v-7654b8e4>`);
        if (!unref(state).chatLocked && !unref(state).ticketChat) {
          _push(`<!--[--><div class="item opacity-80 divide-x bg-gradient-to-br to-[--el-fill-color] from-[--el-color-info-light-10]" data-v-7654b8e4><div class="p-2" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.tableHeader.status"))}</div><div class="p-2" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.tableHeader.action"))}</div><div class="p-2" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.tableHeader.type"))}</div><div class="p-2" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.tableHeader.title"))}</div><div class="p-2" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.tableHeader.time"))}</div></div><div class="divide-y" data-v-7654b8e4><!--[-->`);
          ssrRenderList(unref(state).list || 10, (item, index) => {
            _push(`<div class="item divide-x cursor-pointer hover:bg-[--el-color-info-light-10] duration-300 xyz-nested" style="${ssrRenderStyle(`--xyz-index:${index % 20};`)}" data-v-7654b8e4><div class="p-2" data-v-7654b8e4><span class="line-clamp-1 gq-gs" data-v-7654b8e4>`);
            if (item.node?.read == 0) {
              _push(`<span class="text-xs text-[--el-color-danger]" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.unread"))}</span>`);
            } else {
              _push(`<span class="text-xs text-[--el-color-success]" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.read"))}</span>`);
            }
            _push(`</span></div><div class="p-2" data-v-7654b8e4><span class="line-clamp-1 gq-gs" data-v-7654b8e4>`);
            if (item.node?.status == "closed") {
              _push(`<span class="text-xs text-[--el-color-success]" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.tableBody.status.closed"))}</span>`);
            } else {
              _push(`<span class="text-xs text-[--el-color-danger]" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.tableBody.status.open"))}</span>`);
            }
            _push(`</span></div><div class="p-2" data-v-7654b8e4><span class="line-clamp-1 gq-gs" data-v-7654b8e4>${ssrInterpolate(item.node?.ticketType || "New")}</span></div><div class="p-2" data-v-7654b8e4><span class="line-clamp-1 gq-gs" data-v-7654b8e4>${ssrInterpolate(item.node?.ticketTitle || "Ticket Title")}</span></div><div class="p-2" data-v-7654b8e4>`);
            _push(ssrRenderComponent(_component_TimeAgo, {
              date: item.node?.createdAt,
              class: "gq-gs line-clamp-1 gq-gs"
            }, null, _parent));
            _push(`</div></div>`);
          });
          _push(`<!--]--></div>`);
          if (unref(state).list && unref(state).list?.length == 0) {
            _push(`<div class="p-2" data-v-7654b8e4>`);
            _push(ssrRenderComponent(_component_el_empty, {
              description: _ctx.$t("page.account.ticket.tableBody.empty")
            }, null, _parent));
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          if (unref(state).list && unref(state).list?.length > 0) {
            _push(`<div class="flex justify-center" data-v-7654b8e4>`);
            _push(ssrRenderComponent(_component_el_button, {
              onClick: unref(state).getDocuments,
              text: "",
              disabled: !unref(state).pageInfo?.hasNextPage,
              loading: unref(state).locked,
              size: "small",
              class: "!p-6 !w-full"
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  if (unref(state).pageInfo?.hasNextPage) {
                    _push2(`<span data-v-7654b8e4${_scopeId}>${ssrInterpolate(_ctx.$t("page.modules.post.loadMoreButton"))}</span>`);
                  } else {
                    _push2(`<span data-v-7654b8e4${_scopeId}>${ssrInterpolate(_ctx.$t("page.modules.post.noMore"))}</span>`);
                  }
                } else {
                  return [
                    unref(state).pageInfo?.hasNextPage ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("page.modules.post.loadMoreButton")), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("page.modules.post.noMore")), 1))
                  ];
                }
              }),
              _: 1
            }, _parent));
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        } else {
          _push(`<!--[--><div class="flex items-center justify-between p-4 px-2" data-v-7654b8e4>`);
          _push(ssrRenderComponent(_component_el_button, {
            onClick: ($event) => unref(state).ticketChat = null,
            size: "small",
            link: ""
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="i-ph-caret-left" data-v-7654b8e4${_scopeId}></i> ${ssrInterpolate(_ctx.$t("page.account.ticket.backToList"))}`);
              } else {
                return [
                  createVNode("i", { class: "i-ph-caret-left" }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("page.account.ticket.backToList")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`<div class="flex items-center gap-2" data-v-7654b8e4>`);
          if (unref(state).ticketChat?.[0].status == "closed") {
            _push(`<span class="text-xs text-[--el-color-success] flex items-center" data-v-7654b8e4><i class="i-ph-check-circle mr-1" data-v-7654b8e4></i> ${ssrInterpolate(_ctx.$t("page.account.ticket.tableBody.status.closed"))}</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="text-xs" data-v-7654b8e4>ID: ${ssrInterpolate(unref(state).ticketChat?.[0].id)}</span></div></div>`);
          if (unref(state).ticketChat) {
            _push(`<div class="p-4 py-3 text-xs border-b bg-[--el-color-info-light-10]" data-v-7654b8e4> [${ssrInterpolate(unref(state).ticketChat?.[0]?.ticketType)}] ${ssrInterpolate(unref(state).ticketChat?.[0]?.ticketTitle)}</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(ssrRenderComponent(_component_el_scrollbar, {
            class: "relative min-h-80 p-4 flex-1",
            height: "100%",
            "max-height": "460px",
            ref_key: "scrollBar",
            ref: scrollBar
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                if (!unref(state).ticketChat) {
                  _push2(`<div${ssrRenderAttrs(_temp0 = mergeProps({
                    class: "flex items-center justify-center absolute inset-0",
                    style: { "--el-mask-color": "transparent" }
                  }, ssrGetDirectiveProps(_ctx, _directive_loading, !unref(state).ticketChat)))} data-v-7654b8e4${_scopeId}>${"textContent" in _temp0 ? ssrInterpolate(_temp0.textContent) : _temp0.innerHTML ?? ""}</div>`);
                } else {
                  _push2(`<div class="flex flex-col gap-2 text-xs" data-v-7654b8e4${_scopeId}><!--[-->`);
                  ssrRenderList(unref(state).ticketChat, (item, i) => {
                    _push2(`<div data-v-7654b8e4${_scopeId}>`);
                    if (("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).isDifferenceGreaterThanTenMinutes(
                      item.createdAt,
                      unref(state).ticketChat[i - 1]?.createdAt
                    )) {
                      _push2(`<div class="text-center opacity-80 w-full my-2 mb-4 py-0.7 text-[11px] px-2 bg-[--el-fill-color-dark] rounded w-fit mx-auto" data-v-7654b8e4${_scopeId}>`);
                      _push2(ssrRenderComponent(_component_TimeAgo, {
                        date: item.createdAt
                      }, null, _parent2, _scopeId));
                      _push2(`</div>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`<div class="${ssrRenderClass(`flex group/item items-center gap-2 ${item.from?.databaseId == unref(viewer).data.databaseId ? "flex-row-reverse" : ""}`)}" data-v-7654b8e4${_scopeId}>`);
                    if (item.from) {
                      _push2(ssrRenderComponent(_component_el_avatar, {
                        src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item.from?.avatar?.url),
                        size: 32,
                        shape: "square"
                      }, null, _parent2, _scopeId));
                    } else {
                      _push2(`<div class="w-8 h-8 bg-[--el-color-primary-light-9] rounded flex items-center justify-center" data-v-7654b8e4${_scopeId}><i class="i-ph-handshake-fill w-4 h-4" data-v-7654b8e4${_scopeId}></i></div>`);
                    }
                    _push2(`<div class="${ssrRenderClass(`p-2 relative rounded-md ${item.from?.databaseId == unref(viewer).data.databaseId ? "bg-[--el-color-primary-light-9]" : "bg-[--el-color-info-light-10]"}`)}" data-v-7654b8e4${_scopeId}><div data-v-7654b8e4${_scopeId}>${item.content ?? ""}</div></div></div></div>`);
                  });
                  _push2(`<!--]--></div>`);
                }
              } else {
                return [
                  !unref(state).ticketChat ? withDirectives((openBlock(), createBlock("div", {
                    key: 0,
                    class: "flex items-center justify-center absolute inset-0",
                    style: { "--el-mask-color": "transparent" }
                  }, null, 512)), [
                    [_directive_loading, !unref(state).ticketChat]
                  ]) : (openBlock(), createBlock("div", {
                    key: 1,
                    class: "flex flex-col gap-2 text-xs"
                  }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(state).ticketChat, (item, i) => {
                      return openBlock(), createBlock("div", {
                        key: item.id
                      }, [
                        ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).isDifferenceGreaterThanTenMinutes(
                          item.createdAt,
                          unref(state).ticketChat[i - 1]?.createdAt
                        ) ? (openBlock(), createBlock("div", {
                          key: 0,
                          class: "text-center opacity-80 w-full my-2 mb-4 py-0.7 text-[11px] px-2 bg-[--el-fill-color-dark] rounded w-fit mx-auto"
                        }, [
                          createVNode(_component_TimeAgo, {
                            date: item.createdAt
                          }, null, 8, ["date"])
                        ])) : createCommentVNode("", true),
                        createVNode("div", {
                          class: `flex group/item items-center gap-2 ${item.from?.databaseId == unref(viewer).data.databaseId ? "flex-row-reverse" : ""}`
                        }, [
                          item.from ? (openBlock(), createBlock(_component_el_avatar, {
                            key: 0,
                            src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item.from?.avatar?.url),
                            size: 32,
                            shape: "square"
                          }, null, 8, ["src"])) : (openBlock(), createBlock("div", {
                            key: 1,
                            class: "w-8 h-8 bg-[--el-color-primary-light-9] rounded flex items-center justify-center"
                          }, [
                            createVNode("i", { class: "i-ph-handshake-fill w-4 h-4" })
                          ])),
                          createVNode("div", {
                            class: `p-2 relative rounded-md ${item.from?.databaseId == unref(viewer).data.databaseId ? "bg-[--el-color-primary-light-9]" : "bg-[--el-color-info-light-10]"}`
                          }, [
                            createVNode("div", {
                              innerHTML: item.content
                            }, null, 8, ["innerHTML"])
                          ], 2)
                        ], 2)
                      ]);
                    }), 128))
                  ]))
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`<div class="relative p-4 border-t flex flex-col gap-2 bg-gradient-to-br to-[--el-bg-color] from-[--el-color-info-light-10]" data-v-7654b8e4>`);
          _push(ssrRenderComponent(_component_el_input, {
            modelValue: unref(state).replyContent,
            "onUpdate:modelValue": ($event) => unref(state).replyContent = $event,
            placeholder: _ctx.$t("page.account.ticket.reply"),
            type: "textarea",
            autosize: { minRows: 4, maxRows: 8 }
          }, null, _parent));
          _push(`<div class="flex justify-end" data-v-7654b8e4>`);
          _push(ssrRenderComponent(_component_el_button, {
            loading: unref(state).replyLocked,
            disabled: unref(state).replyLocked,
            type: "primary",
            onClick: ($event) => unref(state).createTicket(unref(state).replyContent)
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("page.account.ticket.reply"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("page.account.ticket.reply")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div>`);
          if ((unref(state).ticketChat?.[0]?.status == "closed" || unref(state).ticketChat?.[unref(state).ticketChat?.length - 1]?.from?.databaseId == unref(viewer).data.databaseId || unref(state).ticketChat?.[unref(state).ticketChat?.length - 1]?.fromId == 0) && !unref(state).continue) {
            _push(`<div class="mask absolute inset-0 flex items-center justify-center" data-v-7654b8e4>`);
            if (unref(state).ticketChat?.[unref(state).ticketChat?.length - 1]?.from?.databaseId == unref(viewer).data.databaseId) {
              _push(`<div class="text-xs opacity-80 flex flex-col items-center gap-1" data-v-7654b8e4><i class="i-ph-coffee-thin w-8 h-8" data-v-7654b8e4></i> ${ssrInterpolate(_ctx.$t("page.account.ticket.waiting"))}</div>`);
            } else if (unref(state).ticketChat?.[unref(state).ticketChat?.length - 1]?.status == "closed") {
              _push(`<div class="text-xs opacity-80 flex flex-col items-center gap-1" data-v-7654b8e4><i class="i-ph-check-circle-thin w-8 h-8 text-[--el-color-success]" data-v-7654b8e4></i> ${ssrInterpolate(_ctx.$t("page.account.ticket.hasReply"))}</div>`);
            } else if (!unref(state).continue) {
              _push(`<div class="text-xs flex items-center gap-1" data-v-7654b8e4>`);
              _push(ssrRenderComponent(_component_el_button, {
                onClick: ($event) => unref(state).closeTicket(unref(state).ticketChat[0].ticketGroup),
                type: "success",
                loading: unref(state).closeLocked,
                disabled: unref(state).closeLocked
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    if (!unref(state).closeLocked) {
                      _push2(`<i class="i-ph-check-circle mr-1" data-v-7654b8e4${_scopeId}></i>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(` ${ssrInterpolate(_ctx.$t("page.account.ticket.close"))}`);
                  } else {
                    return [
                      !unref(state).closeLocked ? (openBlock(), createBlock("i", {
                        key: 0,
                        class: "i-ph-check-circle mr-1"
                      })) : createCommentVNode("", true),
                      createTextVNode(" " + toDisplayString(_ctx.$t("page.account.ticket.close")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent));
              _push(ssrRenderComponent(_component_el_button, {
                onClick: ($event) => unref(state).continue = true,
                plain: "",
                type: "primary"
              }, {
                default: withCtx((_, _push2, _parent2, _scopeId) => {
                  if (_push2) {
                    _push2(`${ssrInterpolate(_ctx.$t("page.account.ticket.continue"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("page.account.ticket.continue")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent));
              _push(`</div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div><!--]-->`);
        }
        _push(`</div>`);
      }
      if (unref(state).documents) {
        _push(`<div class="mt-4 border-1 p-3 rounded-md bg-[--el-color-info-light-10] xyz-in" data-v-7654b8e4><h2 class="text-xs" data-v-7654b8e4>${ssrInterpolate(_ctx.$t("page.account.ticket.documents"))}</h2><div class="grid grid-cols-3 gap-2 mt-2" data-v-7654b8e4><!--[-->`);
        ssrRenderList(unref(state).documents, (document) => {
          _push(`<div class="flex items-center gap-2 text-xs p-2 border-1 rounded-md bg-[--el-bg-color] hover:shadow cursor-pointer duration-300" data-v-7654b8e4>`);
          _push(ssrRenderComponent(_component_Image, {
            src: document.thumb?.sourceUrl,
            class: "w-10 h-10 rounded-md"
          }, null, _parent));
          _push(`<div class="flex flex-col gap-0.5 flex-1" data-v-7654b8e4><div class="text-xs font-600" data-v-7654b8e4>${ssrInterpolate(document.name)}</div><div class="line-clamp-1 text-xs opacity-80" data-v-7654b8e4>${ssrInterpolate(document.description)}</div></div></div>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/account/ticket.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const ticket = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-7654b8e4"]]);

export { ticket as default };
