import { _ as __nuxt_component_0$2 } from './server.mjs';
import { E as ElPopover } from './index-CPT03ebO.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { E as ElDivider } from './divider-b4ipVVip.mjs';
import { useSSRContext, ref, unref, withCtx, createVNode, toDisplayString, mergeProps, withDirectives, openBlock, createBlock } from 'vue';
import { ssrRenderComponent, ssrInterpolate, ssrGetDirectiveProps, ssrRenderClass } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import { C as ClickOutside } from './index-BY8mj3AC.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';
import './dropdown-cQfpmYSu.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-ChPMoinw.mjs';
import './constants-hAKFmBbq.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import '@ctrl/tinycolor';

const _sfc_main = {
  __name: "CommonEditorToolbar",
  __ssrInlineRender: true,
  props: ["editor", "settings"],
  setup(__props, { expose: __expose }) {
    const props = __props;
    const showHeadingPopover = ref(false);
    const headingRef = ref(null);
    const headingPopoverRef = ref(null);
    const listRef = ref(null);
    const listPopoverRef = ref(null);
    const showListPopover = ref(false);
    const figureSelect = ref(null);
    const library = ref(null);
    const linkBox = ref(null);
    const toolbarVisible = ref(false);
    const toolbarPosition = ref({ x: 0, y: 0 });
    const onClickOutside = () => {
      unref(headingPopoverRef).headingPopoverRef?.delayHide?.();
      unref(listPopoverRef).listPopoverRef?.delayHide?.();
      showHeadingPopover.value = false;
      showListPopover.value = false;
    };
    let tableElement = null;
    let initialRect = null;
    const updateToolbarPosition = () => {
      if (!tableElement || !initialRect) return;
      const currentRect = tableElement.getBoundingClientRect();
      const deltaX = currentRect.left - initialRect.left;
      const deltaY = currentRect.top - initialRect.top;
      toolbarPosition.value = {
        x: initialRect.left + deltaX,
        y: initialRect.top + deltaY - 40
      };
    };
    props.editor.on("transaction", ({ transaction }) => {
      if (!transaction.selectionSet) return;
      const pos = transaction.selection.$from.pos;
      const dom = props.editor.view.domAtPos(pos);
      if (transaction.getMeta("paste")) {
        const to = props.editor.state.selection.ranges[0].$to;
        const nextNode = to.nodeAfter;
        if (!nextNode) {
          setTimeout(() => {
            props.editor.commands.insertContent("<p></p>");
          }, 100);
        }
      }
      try {
        const dom2 = props.editor.view.domAtPos(pos);
        const linkElement = dom2.node.parentNode?.closest?.("a");
        if (linkElement && props.editor.isActive("link")) {
          linkBox.value?.linkAction?.clickAction?.(linkElement);
        }
      } catch (error) {
        console.error("Error handling link detection:", error);
      }
      if (props.editor.isActive("table")) {
        try {
          tableElement = dom.node.parentNode.closest("table");
          initialRect = tableElement.getBoundingClientRect();
          updateToolbarPosition();
          toolbarVisible.value = true;
        } catch (error) {
          console.log(error);
        }
      } else {
        toolbarVisible.value = false;
        tableElement = null;
        initialRect = null;
      }
    });
    (void 0).addEventListener("scroll", updateToolbarPosition, true);
    (void 0).addEventListener("resize", updateToolbarPosition);
    const handleClick = (event) => {
      const { target } = event;
      linkBox.value?.linkAction.clickAction(target);
    };
    __expose({
      toolbarVisible,
      toolbarPosition,
      handleClick,
      figureSelect,
      library
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommonEditorMediaLibrary = __nuxt_component_0$2;
      const _component_CommonEditorLinks = __nuxt_component_0$2;
      const _component_CommonEditorTableToolbar = __nuxt_component_0$2;
      const _component_el_popover = ElPopover;
      const _component_el_button = ElButton;
      const _component_el_scrollbar = ElScrollbar;
      const _component_el_divider = ElDivider;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_CommonEditorMediaLibrary, {
        ref_key: "library",
        ref: library,
        editor: __props.editor,
        settings: __props.settings
      }, null, _parent));
      _push(ssrRenderComponent(_component_CommonEditorLinks, {
        ref_key: "linkBox",
        ref: linkBox,
        editor: __props.editor
      }, null, _parent));
      _push(ssrRenderComponent(_component_CommonEditorTableToolbar, {
        visible: unref(toolbarVisible),
        position: unref(toolbarPosition),
        editor: __props.editor,
        onUpdate: ($event) => toolbarVisible.value = false
      }, null, _parent));
      if (__props.editor) {
        _push(`<!--[-->`);
        _push(ssrRenderComponent(_component_el_popover, {
          "hide-after": 0,
          ref_key: "headingPopoverRef",
          ref: headingPopoverRef,
          "virtual-ref": unref(headingRef),
          trigger: "click",
          "virtual-triggering": "",
          "popper-style": "padding:6px",
          onShow: ($event) => showHeadingPopover.value = !unref(showHeadingPopover)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="flex flex-col gap-0.5" data-v-b42e4e2d${_scopeId}>`);
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => {
                  __props.editor.chain().focus().toggleHeading({ level: 2 }).run();
                  unref(headingPopoverRef).hide();
                },
                class: { "is-active": __props.editor.isActive("heading", { level: 2 }) },
                style: { "height": "auto" }
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<i class="i-ph-text-h-two h-5 w-5 mr-2" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.h2"))}</span>`);
                  } else {
                    return [
                      createVNode("i", { class: "i-ph-text-h-two h-5 w-5 mr-2" }),
                      createVNode("span", null, toDisplayString(_ctx.$t("common.editor.h2")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`<b data-v-b42e4e2d${_scopeId}></b>`);
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => {
                  __props.editor.chain().focus().toggleHeading({ level: 3 }).run();
                  unref(headingPopoverRef).hide();
                },
                class: { "is-active": __props.editor.isActive("heading", { level: 3 }) },
                style: { "height": "auto" }
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<i class="i-ph-text-h-three h-5 w-5 mr-2" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.h3"))}</span>`);
                  } else {
                    return [
                      createVNode("i", { class: "i-ph-text-h-three h-5 w-5 mr-2" }),
                      createVNode("span", null, toDisplayString(_ctx.$t("common.editor.h3")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "flex flex-col gap-0.5" }, [
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => {
                      __props.editor.chain().focus().toggleHeading({ level: 2 }).run();
                      unref(headingPopoverRef).hide();
                    },
                    class: { "is-active": __props.editor.isActive("heading", { level: 2 }) },
                    style: { "height": "auto" }
                  }, {
                    default: withCtx(() => [
                      createVNode("i", { class: "i-ph-text-h-two h-5 w-5 mr-2" }),
                      createVNode("span", null, toDisplayString(_ctx.$t("common.editor.h2")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick", "class"]),
                  createVNode("b"),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => {
                      __props.editor.chain().focus().toggleHeading({ level: 3 }).run();
                      unref(headingPopoverRef).hide();
                    },
                    class: { "is-active": __props.editor.isActive("heading", { level: 3 }) },
                    style: { "height": "auto" }
                  }, {
                    default: withCtx(() => [
                      createVNode("i", { class: "i-ph-text-h-three h-5 w-5 mr-2" }),
                      createVNode("span", null, toDisplayString(_ctx.$t("common.editor.h3")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick", "class"])
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(_component_el_popover, {
          ref_key: "listPopoverRef",
          ref: listPopoverRef,
          "virtual-ref": unref(listRef),
          trigger: "click",
          "hide-after": 0,
          "virtual-triggering": "",
          "popper-style": "padding:6px",
          onShow: ($event) => showListPopover.value = !unref(showListPopover)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="flex flex-col gap-0.5" data-v-b42e4e2d${_scopeId}>`);
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => {
                  __props.editor.chain().focus().toggleBulletList().run();
                  unref(listPopoverRef).hide();
                },
                class: { "is-active": __props.editor.isActive("bulletList") },
                style: { "height": "auto" }
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<i class="i-ph-list-bullets h-5 w-5 mr-2" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.ul"))}</span>`);
                  } else {
                    return [
                      createVNode("i", { class: "i-ph-list-bullets h-5 w-5 mr-2" }),
                      createVNode("span", null, toDisplayString(_ctx.$t("common.editor.ul")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`<b data-v-b42e4e2d${_scopeId}></b>`);
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => {
                  __props.editor.chain().focus().toggleOrderedList().run();
                  unref(listPopoverRef).hide();
                },
                class: { "is-active": __props.editor.isActive("orderedList") },
                style: { "height": "auto" }
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<i class="i-ph-list-numbers h-5 w-5 mr-2" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.ol"))}</span>`);
                  } else {
                    return [
                      createVNode("i", { class: "i-ph-list-numbers h-5 w-5 mr-2" }),
                      createVNode("span", null, toDisplayString(_ctx.$t("common.editor.ol")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "flex flex-col gap-0.5" }, [
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => {
                      __props.editor.chain().focus().toggleBulletList().run();
                      unref(listPopoverRef).hide();
                    },
                    class: { "is-active": __props.editor.isActive("bulletList") },
                    style: { "height": "auto" }
                  }, {
                    default: withCtx(() => [
                      createVNode("i", { class: "i-ph-list-bullets h-5 w-5 mr-2" }),
                      createVNode("span", null, toDisplayString(_ctx.$t("common.editor.ul")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick", "class"]),
                  createVNode("b"),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => {
                      __props.editor.chain().focus().toggleOrderedList().run();
                      unref(listPopoverRef).hide();
                    },
                    class: { "is-active": __props.editor.isActive("orderedList") },
                    style: { "height": "auto" }
                  }, {
                    default: withCtx(() => [
                      createVNode("i", { class: "i-ph-list-numbers h-5 w-5 mr-2" }),
                      createVNode("span", null, toDisplayString(_ctx.$t("common.editor.ol")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick", "class"])
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`<!--]-->`);
      } else {
        _push(`<!---->`);
      }
      if (__props.editor) {
        _push(ssrRenderComponent(_component_el_scrollbar, { class: "editor-toolbar z-2 bg-[--el-color-info-light-10]" }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="flex items-center @md:py-3 p-2 flex gap-1 mx-auto w-fit" data-v-b42e4e2d${_scopeId}>`);
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => __props.editor.chain().focus().undo().run(),
                disabled: !__props.editor.can().chain().focus().undo().run(),
                class: "!h-auto"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-arrow-u-up-left" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.undo"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-arrow-u-up-left" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.undo")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => __props.editor.chain().focus().redo().run(),
                disabled: !__props.editor.can().chain().focus().redo().run(),
                class: "!h-auto"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-arrow-u-up-right" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.redo"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-arrow-u-up-right" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.redo")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                class: "!h-auto",
                text: "",
                bg: "",
                onClick: ($event) => __props.editor.chain().focus().unsetAllMarks().clearNodes().run()
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-eraser" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.clear"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-eraser" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.clear")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_divider, {
                direction: "vertical",
                style: { "--el-border-color": "var(--el-text-color-placeholder)" }
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, mergeProps({
                size: "small",
                class: [
                  {
                    "is-active": __props.editor.isActive("heading", { level: 2 }) || __props.editor.isActive("heading", { level: 3 })
                  },
                  "!h-auto"
                ],
                text: "",
                bg: "",
                ref_key: "headingRef",
                ref: headingRef
              }, ssrGetDirectiveProps(_ctx, unref(ClickOutside), onClickOutside)), {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="${ssrRenderClass(` ${__props.editor.isActive("heading", { level: 3 }) ? "i-ph-text-h-three" : "i-ph-text-h-two"}`)}" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.heading"))}</span></div><i class="${ssrRenderClass(`i-ph-caret-down-fill mt-auto w-3 h-3 ml-0.6 ${unref(showHeadingPopover) ? "transform scale-y-[-1]" : ""}`)}" data-v-b42e4e2d${_scopeId2}></i>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", {
                          class: ` ${__props.editor.isActive("heading", { level: 3 }) ? "i-ph-text-h-three" : "i-ph-text-h-two"}`
                        }, null, 2),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.heading")), 1)
                      ]),
                      createVNode("i", {
                        class: `i-ph-caret-down-fill mt-auto w-3 h-3 ml-0.6 ${unref(showHeadingPopover) ? "transform scale-y-[-1]" : ""}`
                      }, null, 2)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => __props.editor.chain().focus().toggleBold().run(),
                disabled: !__props.editor.can().chain().focus().toggleBold().run(),
                class: [{ "is-active": __props.editor.isActive("bold") }, "!h-auto"]
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-text-bolder" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.bold"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-text-bolder" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.bold")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => __props.editor.chain().focus().toggleItalic().run(),
                disabled: !__props.editor.can().chain().focus().toggleItalic().run(),
                class: [{ "is-active": __props.editor.isActive("italic") }, "!h-auto"]
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-text-italic" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.italic"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-text-italic" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.italic")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_divider, {
                direction: "vertical",
                style: { "--el-border-color": "var(--el-text-color-placeholder)" }
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, mergeProps({
                size: "small",
                class: [
                  {
                    "is-active": __props.editor.isActive("bulletList") || __props.editor.isActive("orderedList")
                  },
                  "!h-auto"
                ],
                text: "",
                bg: "",
                ref_key: "listRef",
                ref: listRef
              }, ssrGetDirectiveProps(_ctx, unref(ClickOutside), onClickOutside)), {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="${ssrRenderClass(` ${__props.editor.isActive("bulletList") ? "i-ph-list-bullets" : "i-ph-list-numbers"}`)}" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.list"))}</span></div><i class="${ssrRenderClass(`i-ph-caret-down-fill mt-auto w-3 h-3 ml-0.6 ${unref(showListPopover) ? "transform scale-y-[-1]" : ""}`)}" data-v-b42e4e2d${_scopeId2}></i>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", {
                          class: ` ${__props.editor.isActive("bulletList") ? "i-ph-list-bullets" : "i-ph-list-numbers"}`
                        }, null, 2),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.list")), 1)
                      ]),
                      createVNode("i", {
                        class: `i-ph-caret-down-fill mt-auto w-3 h-3 ml-0.6 ${unref(showListPopover) ? "transform scale-y-[-1]" : ""}`
                      }, null, 2)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => __props.editor.chain().focus().toggleBlockquote().run(),
                class: [{ "is-active": __props.editor.isActive("blockquote") }, "!h-auto"]
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-quotes" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.blockquote"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-quotes" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.blockquote")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => __props.editor.chain().focus().setHorizontalRule().run(),
                class: "!h-auto"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-minus-duotone" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.hr"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-minus-duotone" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.hr")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => __props.editor.chain().focus().setCodeBlock().run(),
                class: [{ "is-active": __props.editor.isActive("codeBlock") }, "!h-auto"]
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-code" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.code"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-code" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.code")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_divider, {
                direction: "vertical",
                style: { "--el-border-color": "var(--el-text-color-placeholder)" }
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: ($event) => __props.editor.chain().focus().insertTable({ rows: 3, cols: 3, withHeaderRow: true }).run(),
                class: [{ "is-active": __props.editor.isActive("table") }, "!h-auto"]
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-table" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.table"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-table" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.table")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                onClick: unref(linkBox)?.linkAction.setLink,
                class: [{ "is-active": __props.editor.isActive("link") }, "!h-auto"]
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-link-simple" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.link"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-link-simple" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.link")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                disabled: !__props.settings.allowImage,
                onClick: ($event) => {
                  unref(library).libraryBox.show = true;
                  unref(library).libraryBox.tabs = "upload";
                  unref(library).libraryBox.type = "image";
                },
                class: [
                  { "is-active": __props.editor.isActive("figure") && unref(figureSelect) == "image" },
                  "!h-auto",
                  "relative"
                ]
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-image" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.image"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-image" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.image")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                disabled: !__props.settings.allowVideo,
                onClick: ($event) => {
                  unref(library).libraryBox.show = true;
                  unref(library).libraryBox.tabs = "embed";
                  unref(library).libraryBox.type = "video";
                },
                class: [
                  {
                    "is-active": __props.editor.isActive("figure") && (unref(figureSelect) == "video" || unref(figureSelect) == "iframe")
                  },
                  "!h-auto",
                  "relative"
                ]
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-video" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.video"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-video" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.video")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                disabled: !__props.settings.allowAudio,
                onClick: ($event) => {
                  unref(library).libraryBox.show = true;
                  unref(library).libraryBox.tabs = "external";
                  unref(library).libraryBox.type = "audio";
                },
                class: [
                  { "is-active": __props.editor.isActive("figure") && unref(figureSelect) == "audio" },
                  "!h-auto",
                  "relative"
                ]
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-music-notes" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.audio"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-music-notes" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.audio")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                text: "",
                bg: "",
                disabled: !__props.settings.allowAttachment,
                onClick: ($event) => {
                  unref(library).libraryBox.show = true;
                  unref(library).libraryBox.tabs = "external";
                  unref(library).libraryBox.type = "attachment";
                },
                class: [
                  {
                    "is-active": __props.editor.isActive("figure") && unref(figureSelect) == "attachment"
                  },
                  "!h-auto",
                  "relative"
                ]
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="editor-button" data-v-b42e4e2d${_scopeId2}><i class="i-ph-cloud" data-v-b42e4e2d${_scopeId2}></i><span data-v-b42e4e2d${_scopeId2}>${ssrInterpolate(_ctx.$t("common.editor.attachment"))}</span></div>`);
                  } else {
                    return [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-cloud" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.attachment")), 1)
                      ])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "flex items-center @md:py-3 p-2 flex gap-1 mx-auto w-fit" }, [
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => __props.editor.chain().focus().undo().run(),
                    disabled: !__props.editor.can().chain().focus().undo().run(),
                    class: "!h-auto"
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-arrow-u-up-left" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.undo")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["onClick", "disabled"]),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => __props.editor.chain().focus().redo().run(),
                    disabled: !__props.editor.can().chain().focus().redo().run(),
                    class: "!h-auto"
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-arrow-u-up-right" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.redo")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["onClick", "disabled"]),
                  createVNode(_component_el_button, {
                    size: "small",
                    class: "!h-auto",
                    text: "",
                    bg: "",
                    onClick: ($event) => __props.editor.chain().focus().unsetAllMarks().clearNodes().run()
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-eraser" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.clear")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["onClick"]),
                  createVNode(_component_el_divider, {
                    direction: "vertical",
                    style: { "--el-border-color": "var(--el-text-color-placeholder)" }
                  }),
                  withDirectives((openBlock(), createBlock(_component_el_button, {
                    size: "small",
                    class: [
                      {
                        "is-active": __props.editor.isActive("heading", { level: 2 }) || __props.editor.isActive("heading", { level: 3 })
                      },
                      "!h-auto"
                    ],
                    text: "",
                    bg: "",
                    ref_key: "headingRef",
                    ref: headingRef
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", {
                          class: ` ${__props.editor.isActive("heading", { level: 3 }) ? "i-ph-text-h-three" : "i-ph-text-h-two"}`
                        }, null, 2),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.heading")), 1)
                      ]),
                      createVNode("i", {
                        class: `i-ph-caret-down-fill mt-auto w-3 h-3 ml-0.6 ${unref(showHeadingPopover) ? "transform scale-y-[-1]" : ""}`
                      }, null, 2)
                    ]),
                    _: 1
                  }, 8, ["class"])), [
                    [unref(ClickOutside), onClickOutside]
                  ]),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => __props.editor.chain().focus().toggleBold().run(),
                    disabled: !__props.editor.can().chain().focus().toggleBold().run(),
                    class: [{ "is-active": __props.editor.isActive("bold") }, "!h-auto"]
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-text-bolder" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.bold")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["onClick", "disabled", "class"]),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => __props.editor.chain().focus().toggleItalic().run(),
                    disabled: !__props.editor.can().chain().focus().toggleItalic().run(),
                    class: [{ "is-active": __props.editor.isActive("italic") }, "!h-auto"]
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-text-italic" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.italic")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["onClick", "disabled", "class"]),
                  createVNode(_component_el_divider, {
                    direction: "vertical",
                    style: { "--el-border-color": "var(--el-text-color-placeholder)" }
                  }),
                  withDirectives((openBlock(), createBlock(_component_el_button, {
                    size: "small",
                    class: [
                      {
                        "is-active": __props.editor.isActive("bulletList") || __props.editor.isActive("orderedList")
                      },
                      "!h-auto"
                    ],
                    text: "",
                    bg: "",
                    ref_key: "listRef",
                    ref: listRef
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", {
                          class: ` ${__props.editor.isActive("bulletList") ? "i-ph-list-bullets" : "i-ph-list-numbers"}`
                        }, null, 2),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.list")), 1)
                      ]),
                      createVNode("i", {
                        class: `i-ph-caret-down-fill mt-auto w-3 h-3 ml-0.6 ${unref(showListPopover) ? "transform scale-y-[-1]" : ""}`
                      }, null, 2)
                    ]),
                    _: 1
                  }, 8, ["class"])), [
                    [unref(ClickOutside), onClickOutside]
                  ]),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => __props.editor.chain().focus().toggleBlockquote().run(),
                    class: [{ "is-active": __props.editor.isActive("blockquote") }, "!h-auto"]
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-quotes" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.blockquote")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["onClick", "class"]),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => __props.editor.chain().focus().setHorizontalRule().run(),
                    class: "!h-auto"
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-minus-duotone" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.hr")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["onClick"]),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => __props.editor.chain().focus().setCodeBlock().run(),
                    class: [{ "is-active": __props.editor.isActive("codeBlock") }, "!h-auto"]
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-code" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.code")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["onClick", "class"]),
                  createVNode(_component_el_divider, {
                    direction: "vertical",
                    style: { "--el-border-color": "var(--el-text-color-placeholder)" }
                  }),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: ($event) => __props.editor.chain().focus().insertTable({ rows: 3, cols: 3, withHeaderRow: true }).run(),
                    class: [{ "is-active": __props.editor.isActive("table") }, "!h-auto"]
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-table" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.table")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["onClick", "class"]),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    onClick: unref(linkBox)?.linkAction.setLink,
                    class: [{ "is-active": __props.editor.isActive("link") }, "!h-auto"]
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-link-simple" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.link")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["onClick", "class"]),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    disabled: !__props.settings.allowImage,
                    onClick: ($event) => {
                      unref(library).libraryBox.show = true;
                      unref(library).libraryBox.tabs = "upload";
                      unref(library).libraryBox.type = "image";
                    },
                    class: [
                      { "is-active": __props.editor.isActive("figure") && unref(figureSelect) == "image" },
                      "!h-auto",
                      "relative"
                    ]
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-image" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.image")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["disabled", "onClick", "class"]),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    disabled: !__props.settings.allowVideo,
                    onClick: ($event) => {
                      unref(library).libraryBox.show = true;
                      unref(library).libraryBox.tabs = "embed";
                      unref(library).libraryBox.type = "video";
                    },
                    class: [
                      {
                        "is-active": __props.editor.isActive("figure") && (unref(figureSelect) == "video" || unref(figureSelect) == "iframe")
                      },
                      "!h-auto",
                      "relative"
                    ]
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-video" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.video")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["disabled", "onClick", "class"]),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    disabled: !__props.settings.allowAudio,
                    onClick: ($event) => {
                      unref(library).libraryBox.show = true;
                      unref(library).libraryBox.tabs = "external";
                      unref(library).libraryBox.type = "audio";
                    },
                    class: [
                      { "is-active": __props.editor.isActive("figure") && unref(figureSelect) == "audio" },
                      "!h-auto",
                      "relative"
                    ]
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-music-notes" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.audio")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["disabled", "onClick", "class"]),
                  createVNode(_component_el_button, {
                    size: "small",
                    text: "",
                    bg: "",
                    disabled: !__props.settings.allowAttachment,
                    onClick: ($event) => {
                      unref(library).libraryBox.show = true;
                      unref(library).libraryBox.tabs = "external";
                      unref(library).libraryBox.type = "attachment";
                    },
                    class: [
                      {
                        "is-active": __props.editor.isActive("figure") && unref(figureSelect) == "attachment"
                      },
                      "!h-auto",
                      "relative"
                    ]
                  }, {
                    default: withCtx(() => [
                      createVNode("div", { class: "editor-button" }, [
                        createVNode("i", { class: "i-ph-cloud" }),
                        createVNode("span", null, toDisplayString(_ctx.$t("common.editor.attachment")), 1)
                      ])
                    ]),
                    _: 1
                  }, 8, ["disabled", "onClick", "class"])
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/editor/toolbar.client.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const toolbar_client = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-b42e4e2d"]]);

export { toolbar_client as default };
