import { E as ElButton } from './index-DYnTqrQe.mjs';
import __nuxt_component_1 from './typeSettings-DCgOAzjB.mjs';
import { j as actionStore, a as useI18n, v as viewerStore, _ as __nuxt_component_0$2, e as useUtils } from './server.mjs';
import { useSSRContext, ref, computed, mergeProps, withCtx, createVNode, unref, toDisplayString, createTextVNode } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderClass } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './index-R6EFYpWa.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-ChPMoinw.mjs';
import './vnode-l2ZP2UQa.mjs';
import './searchUser-Jfe3dbov.mjs';
import './index-03hfIBa_.mjs';
import './index-tCyBRCDx.mjs';
import './index-Bp-nwGzu.mjs';
import './event-BZTOGHfp.mjs';
import './index-BY8mj3AC.mjs';
import './index-Cs8YDU9s.mjs';
import './index-BKB3Djp4.mjs';
import './creditIcon-eOdkwofx.mjs';
import './svgIcon-BpIUCf-e.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './blink-DRvWMg-X.mjs';
import './nuxt-link-Dd6LuEo9.mjs';
import './date-picker-panel-rcoVm3W9.mjs';
import 'dayjs';
import 'dayjs/plugin/customParseFormat.js';
import 'dayjs/plugin/advancedFormat.js';
import 'dayjs/plugin/localeData.js';
import 'dayjs/plugin/weekOfYear.js';
import 'dayjs/plugin/weekYear.js';
import 'dayjs/plugin/dayOfYear.js';
import 'dayjs/plugin/isSameOrAfter.js';
import 'dayjs/plugin/isSameOrBefore.js';
import './index-D3BlhKEk.mjs';

/* empty css               */
const _sfc_main = {
  __name: "ModulesCommonTopicFormTools",
  __ssrInlineRender: true,
  props: ["editor", "data", "settings", "action"],
  setup(__props) {
    const props = __props;
    const limit = ref(props.settings.maxCount || 1200);
    const inc = (key) => {
      return props.settings?.attrsPicked?.includes(key) || false;
    };
    const actionSt = actionStore();
    const locked = ref(false);
    const { t } = useI18n();
    const viewer = viewerStore();
    const allow = computed(() => {
      if (!props.action.menu.communityCatMetas?.isJoin && props.action.menu?.communityCatMetas?.settings?.joinRole?.type != "free") {
        return false;
      }
      if (!props.action.menu.communityCatMetas?.settings?.topicCan?.can) {
        return false;
      }
      if (props.action.showTags) {
        return false;
      }
      return true;
    });
    const allowPublish = computed(() => {
      if (props.action.form.type == "bounty") {
        if (props.action.form.bounty.type == "credit") {
          return props.action.form.bounty.value && props.action.form.bounty.value < viewer.data.gqCredit;
        }
        if (props.action.form.bounty.type == "money") {
          return props.action.form.bounty.value && props.action.form.bounty.value < viewer.data.gqMoney[actionSt.currency.iso];
        }
      }
      return true;
    });
    const editorAction = (type, tabs) => {
      props.editor.editToolbar.library.libraryBox.show = true;
      props.editor.editToolbar.library.libraryBox.type = type;
      props.editor.editToolbar.library.libraryBox.tabs = tabs;
      props.editor.editToolbar.library.libraryBox.simply = true;
    };
    const characterCount = computed(
      () => props.editor?.storage.characterCount.characters() || 0
    );
    const submit = async () => {
      locked.value = true;
      const form = props.action.form;
      const args = {
        form,
        title: form.title,
        content: props.editor.getHTML(),
        characterCount: characterCount.value,
        cat: props.action.menu.databaseId,
        tag: props.action.tag || null
      };
      const res = await useUtils.submitTopic(args, t, props.settings.attrsPicked);
      if (res) {
        form.title = "";
        form.bounty = {
          type: "credit",
          deadline: "",
          value: "",
          target: "all",
          targetList: []
        };
        form.vote = {
          type: "radio",
          deadline: "",
          list: [
            {
              text: "",
              vote: 0
            },
            {
              text: "",
              vote: 0
            }
          ]
        };
        form.roles = {
          active: "public",
          money: "",
          credit: "",
          checkList: []
        };
        form.type = "say";
        props.editor.commands.clearContent(true);
        res.createCommunityTopic.communityTopic.new = 1;
        props.data.list.edges.unshift({
          node: res.createCommunityTopic.communityTopic
        });
        props.action.showList = false;
      }
      locked.value = false;
    };
    const set = (type) => {
      if (type == "#") {
        props.action.showTagBox();
        return;
      }
      if (currentPosition()) {
        type = "" + type;
      }
      props.editor.chain().focus().insertContent(type).run();
    };
    const currentPosition = () => {
      const { doc, selection } = props.editor.state;
      const { from, to } = selection;
      if (from === to && from > 1) {
        const previousCharPosition = from - 1;
        const previousChar = doc.textBetween(previousCharPosition, from, " ");
        if (previousChar.trim() !== "") {
          return true;
        } else {
          return false;
        }
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      const _component_ModulesCommonTopicFormTypeSettings = __nuxt_component_1;
      const _component_CommonEditorRuleSettings = __nuxt_component_0$2;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "-mt-10.4" }, _attrs))} data-v-5ef71294><div class="relative p-2 px-3 flex justify-between items-center border-t rounded-bl-md rounded-br-m mb-3 -ml-[--tpl] -mr-[--tpr] @md:mx-0" data-v-5ef71294><div class="flex items-center gap-1" data-v-5ef71294>`);
      _push(ssrRenderComponent(_component_el_button, {
        link: "",
        style: { "--el-fill-color-light": "var(--el-bg-color-overlay)" },
        onClick: ($event) => set("@")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-at" data-v-5ef71294${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-at" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        link: "",
        style: { "--el-fill-color-light": "var(--el-bg-color-overlay)" },
        onClick: ($event) => set("#")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-hash" data-v-5ef71294${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-hash" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="flex items-center gap-3 opacity-50" data-v-5ef71294><span class="text-xs font-bold" data-v-5ef71294>${ssrInterpolate(unref(characterCount) + "/" + unref(limit))}</span><i class="i-ph-markdown-logo-light h-6 w-6" data-v-5ef71294></i></div></div>`);
      _push(ssrRenderComponent(_component_ModulesCommonTopicFormTypeSettings, {
        settings: __props.settings,
        action: __props.action
      }, null, _parent));
      _push(`<div class="flex justify-between items-center submit-tools mt-2 @md:m-0 @md:mt-2 -ml-[--tpl] -mr-[--tpr] @md:pl-0" data-v-5ef71294><div class="${ssrRenderClass(`flex gap-5 justify-around h-7 items-center tools @md:p-0 pl-2 ${!unref(allow) ? "opacity-50" : ""}`)}" data-v-5ef71294>`);
      if (inc("image") || inc("video") || inc("audio") || inc("file")) {
        _push(`<!--[-->`);
        if (__props.action.menu.communityCatMetas?.settings?.allowImage && inc("image")) {
          _push(ssrRenderComponent(_component_el_button, {
            link: "",
            class: "!text-lg !m-0 !text-[#ff3a55]",
            disabled: !unref(viewer).data.gqRoles?.media?.image?.can || !unref(allow),
            onClick: ($event) => editorAction("image", "upload")
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="i-ph-image-fill @md:mr-1" data-v-5ef71294${_scopeId}></i><span class="text-sm @md:block hidden" data-v-5ef71294${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.tools.image"))}</span>`);
              } else {
                return [
                  createVNode("i", { class: "i-ph-image-fill @md:mr-1" }),
                  createVNode("span", { class: "text-sm @md:block hidden" }, toDisplayString(_ctx.$t("page.community.tools.image")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        if (__props.action.menu.communityCatMetas?.settings?.allowVideo && inc("video")) {
          _push(ssrRenderComponent(_component_el_button, {
            link: "",
            class: "!text-lg !m-0 !text-[#71a257]",
            disabled: !unref(viewer).data.gqRoles?.media?.video?.can || !unref(allow),
            onClick: ($event) => editorAction("video", "embed")
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="i-ph-monitor-play-fill @md:mr-1" data-v-5ef71294${_scopeId}></i><span class="text-sm @md:block hidden" data-v-5ef71294${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.tools.video"))}</span>`);
              } else {
                return [
                  createVNode("i", { class: "i-ph-monitor-play-fill @md:mr-1" }),
                  createVNode("span", { class: "text-sm @md:block hidden" }, toDisplayString(_ctx.$t("page.community.tools.video")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        if (__props.action.menu.communityCatMetas?.settings?.allowAudio && inc("audio")) {
          _push(ssrRenderComponent(_component_el_button, {
            link: "",
            class: "!text-lg !m-0 !text-[#9d87d2]",
            disabled: !unref(viewer).data.gqRoles?.media?.audio?.can || !unref(allow),
            onClick: ($event) => editorAction("audio", "external")
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="i-ph-music-notes-fill @md:mr-1" data-v-5ef71294${_scopeId}></i><span class="text-sm @md:block hidden" data-v-5ef71294${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.tools.audio"))}</span>`);
              } else {
                return [
                  createVNode("i", { class: "i-ph-music-notes-fill @md:mr-1" }),
                  createVNode("span", { class: "text-sm @md:block hidden" }, toDisplayString(_ctx.$t("page.community.tools.audio")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        if (__props.action.menu.communityCatMetas?.settings?.allowFile && inc("file")) {
          _push(ssrRenderComponent(_component_el_button, {
            link: "",
            class: "!text-lg !m-0 !text-[#00a5ff]",
            disabled: !unref(viewer).data.gqRoles?.media?.file?.can || !unref(allow),
            onClick: ($event) => editorAction("attachment", "external")
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="i-ph-file-cloud-fill @md:mr-1" data-v-5ef71294${_scopeId}></i><span class="text-sm @md:block hidden" data-v-5ef71294${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.tools.attachment"))}</span>`);
              } else {
                return [
                  createVNode("i", { class: "i-ph-file-cloud-fill @md:mr-1" }),
                  createVNode("span", { class: "text-sm @md:block hidden" }, toDisplayString(_ctx.$t("page.community.tools.attachment")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<span class="text-xs opacity-50" data-v-5ef71294>请勿发布无意义内容！ </span>`);
      }
      _push(`</div><div class="flex gap-6 items-center submit-button ml-auto @md:p-0 pl-3 pr-3" data-v-5ef71294>`);
      if (inc("roles")) {
        _push(`<div class="${ssrRenderClass(!unref(allow) ? "opacity-50 pointer-events-none" : "")}" data-v-5ef71294>`);
        _push(ssrRenderComponent(_component_CommonEditorRuleSettings, {
          settings: __props.settings,
          action: __props.action
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_el_button, {
        type: `${!unref(allowPublish) || !unref(allow) ? "default" : "primary"}`,
        onClick: submit,
        disabled: unref(locked) || !unref(allowPublish) || !unref(allow),
        loading: unref(locked)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("page.community.tools.publish"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("page.community.tools.publish")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/form/tools.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_5 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-5ef71294"]]);

export { __nuxt_component_5 as default };
