import { E as ElDialog } from './index-awVc4A7-.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import { E as ElSelect, a as ElOption } from './index-03hfIBa_.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { g as getServerSettings, v as viewerStore, j as actionStore, e as useUtils, r as useRequest } from './server.mjs';
import { useSSRContext, reactive, resolveDirective, mergeProps, unref, withCtx, createTextVNode, toDisplayString, openBlock, createBlock, Fragment, renderList, createVNode, withDirectives } from 'vue';
import { ssrRenderComponent, ssrRenderStyle, ssrGetDirectiveProps, ssrRenderList, ssrInterpolate } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './use-dialog-7J0bwlna.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import 'lodash-unified';
import './aria-BhThsKez.mjs';
import './event-BZTOGHfp.mjs';
import '@vue/shared';
import './vnode-l2ZP2UQa.mjs';
import './index-Di0Jlzch.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './index-DRiwogtD.mjs';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import './index-Bp-nwGzu.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-tCyBRCDx.mjs';
import './index-BY8mj3AC.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesAccountWealthTransfer",
  __ssrInlineRender: true,
  emits: ["update"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const settingsStore = getServerSettings();
    const viewer = viewerStore();
    const action = actionStore();
    const emit = __emit;
    const state = reactive({
      dialogVisible: false,
      from: action.currency.iso,
      to: settingsStore.currency.find(
        (item) => item.symbol_iso !== action.currency.iso
      )?.symbol_iso,
      amount: "1.00",
      toAmount: 0,
      show: () => {
        state.dialogVisible = !state.dialogVisible;
      },
      symbol: (iso) => {
        return settingsStore.currency.find(
          (item) => item.symbol_iso === iso
        )?.symbol;
      },
      rate: (from, to) => {
        const defaultRate = settingsStore.currency.find(
          (item) => item.symbol_iso === from
        )?.rate;
        const targetRate = settingsStore.currency.find(
          (item) => item.symbol_iso === to
        )?.rate;
        return (targetRate / defaultRate).toFixed(2);
      },
      name: (iso) => {
        return settingsStore.currency.find(
          (item) => item.symbol_iso === iso
        )?.name;
      },
      swap: () => {
        const temp = state.from;
        state.from = state.to;
        state.to = temp;
        updateAmount("amount");
        updateAmount("toAmount");
      },
      transfer: async () => {
        const res = await useRequest("/api/request", {
          body: {
            data: {
              from: state.from,
              to: state.to,
              amount: state.amount
            }
          }
        });
        if (res?.gqWealthTransfer?.success) {
          state.dialogVisible = false;
          state.amount = "1.00";
          updateAmount("toAmount");
          emit("update", state);
        }
      },
      amountExchange: (from, to, amount) => {
        const defaultRate = settingsStore.currency.find(
          (item) => item.symbol_iso === from
        )?.rate;
        const targetRate = settingsStore.currency.find(
          (item) => item.symbol_iso === to
        )?.rate;
        return useUtils.div(amount * targetRate, defaultRate);
      }
    });
    const updateAmount = (type) => {
      if (type === "amount") {
        state.toAmount = state.amountExchange(state.from, state.to, state.amount);
      } else {
        state.amount = state.amountExchange(state.to, state.from, state.toAmount);
      }
    };
    __expose({
      show: state.show
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_dialog = ElDialog;
      const _component_el_input = ElInput;
      const _component_el_select = ElSelect;
      const _component_el_option = ElOption;
      const _component_el_button = ElButton;
      const _directive_decimal = resolveDirective("decimal");
      _push(ssrRenderComponent(_component_el_dialog, mergeProps({
        modelValue: unref(state).dialogVisible,
        "onUpdate:modelValue": ($event) => unref(state).dialogVisible = $event,
        title: _ctx.$t("page.account.wealth.transfer.title"),
        "lock-scroll": false,
        "append-to-body": true,
        "close-on-click-modal": false,
        width: "295"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="exchange-balance" data-v-9ef3de75${_scopeId}><div class="flex items-center flex-col" data-v-9ef3de75${_scopeId}><div class="w-full border-1 border-[--el-color-primary-light-7] rounded-md overflow-hidden" data-v-9ef3de75${_scopeId}><div style="${ssrRenderStyle({ "--el-border-color": "transparent", "--el-border-color-dark": "transparent", "--el-border-color-hover": "transparent" })}" class="w-full flex gap-2 items-stretch" data-v-9ef3de75${_scopeId}><label class="flex flex-col pt-2" data-v-9ef3de75${_scopeId}><span class="text-xs ml-3 opacity-70" data-v-9ef3de75${_scopeId}>${_ctx.$t("page.account.wealth.transfer.from", [unref(state).name(unref(state).from)[_ctx.$i18n.locale] + "/" + unref(state).from + "(" + unref(state).symbol(unref(state).from) + ")"]) ?? ""}</span>`);
            _push2(ssrRenderComponent(_component_el_input, mergeProps({
              modelValue: unref(state).amount,
              "onUpdate:modelValue": ($event) => unref(state).amount = $event,
              class: "!text-lg",
              step: "0.01",
              onInput: ($event) => updateAmount("amount"),
              type: "number",
              style: { "--el-input-focus-border-color": "transparent" }
            }, ssrGetDirectiveProps(_ctx, _directive_decimal, { decimals: 2, min: 0, max: unref(viewer).data.gqMoney[unref(state).from] })), null, _parent2, _scopeId));
            _push2(`</label><div class="w-29 h-full bg-[--el-color-info-light-10] border-l-1 border-[--el-border-color-lighter]" data-v-9ef3de75${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_select, {
              modelValue: unref(state).from,
              "onUpdate:modelValue": ($event) => unref(state).from = $event,
              size: "large",
              class: "!h-full",
              onChange: ($event) => updateAmount("amount"),
              style: { "--el-border-color": "transparent", "--el-border-color-dark": "transparent", "--el-border-color-hover": "transparent", "--el-color-primary": "transparent" }
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<!--[-->`);
                  ssrRenderList(unref(settingsStore).currency, (item) => {
                    _push3(ssrRenderComponent(_component_el_option, {
                      key: item.symbol_iso,
                      value: item.symbol_iso,
                      disabled: item.symbol_iso === unref(state).to
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(item.name?.[_ctx.$i18n.locale] + "/" + item.symbol_iso + " (" + item.symbol + ")")}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(item.name?.[_ctx.$i18n.locale] + "/" + item.symbol_iso + " (" + item.symbol + ")"), 1)
                          ];
                        }
                      }),
                      _: 2
                    }, _parent3, _scopeId2));
                  });
                  _push3(`<!--]-->`);
                } else {
                  return [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(settingsStore).currency, (item) => {
                      return openBlock(), createBlock(_component_el_option, {
                        key: item.symbol_iso,
                        value: item.symbol_iso,
                        disabled: item.symbol_iso === unref(state).to
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(item.name?.[_ctx.$i18n.locale] + "/" + item.symbol_iso + " (" + item.symbol + ")"), 1)
                        ]),
                        _: 2
                      }, 1032, ["value", "disabled"]);
                    }), 128))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div></div><div class="flex items-center justify-between text-xs w-full pl-6 py-5 left-line" data-v-9ef3de75${_scopeId}><div class="flex flex-col gap-2 opacity-90" data-v-9ef3de75${_scopeId}><span data-v-9ef3de75${_scopeId}>${_ctx.$t("page.account.wealth.transfer.formBalance", [unref(state).name(unref(state).from)[_ctx.$i18n.locale], unref(state).symbol(unref(state).from) + ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(viewer).data.gqMoney[unref(state).from], unref(state).from)]) ?? ""}</span><span data-v-9ef3de75${_scopeId}>${_ctx.$t("page.account.wealth.transfer.toBalance", [unref(state).name(unref(state).to)[_ctx.$i18n.locale], unref(state).symbol(unref(state).to) + ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(viewer).data.gqMoney[unref(state).to], unref(state).to)]) ?? ""}</span><span data-v-9ef3de75${_scopeId}>${_ctx.$t("page.account.wealth.transfer.rate", [unref(state).rate(unref(state).from, unref(state).to)]) ?? ""}</span></div>`);
            _push2(ssrRenderComponent(_component_el_button, {
              class: "flex items-center justify-center rounded-full is-active",
              onClick: ($event) => unref(state).swap(),
              circle: ""
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<i class="i-ph-arrows-down-up" data-v-9ef3de75${_scopeId2}></i>`);
                } else {
                  return [
                    createVNode("i", { class: "i-ph-arrows-down-up" })
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div><div class="w-full border-1 rounded-md overflow-hidden border-[--el-color-primary-light-7]" data-v-9ef3de75${_scopeId}><div style="${ssrRenderStyle({ "--el-border-color": "transparent", "--el-border-color-dark": "transparent", "--el-border-color-hover": "transparent" })}" class="w-full flex items-center gap-2" data-v-9ef3de75${_scopeId}><label class="flex flex-col pt-2" data-v-9ef3de75${_scopeId}><span class="text-xs ml-3 opacity-70" data-v-9ef3de75${_scopeId}>${_ctx.$t("page.account.wealth.transfer.transferTo", [unref(state).name(unref(state).to)[_ctx.$i18n.locale] + "/" + unref(state).to + "(" + unref(state).symbol(unref(state).to) + ")"]) ?? ""}</span>`);
            _push2(ssrRenderComponent(_component_el_input, mergeProps({
              modelValue: unref(state).toAmount,
              "onUpdate:modelValue": ($event) => unref(state).toAmount = $event,
              class: "!text-lg",
              step: "0.01",
              onInput: ($event) => updateAmount("toAmount"),
              type: "number",
              style: { "--el-input-focus-border-color": "transparent" }
            }, ssrGetDirectiveProps(_ctx, _directive_decimal, { decimals: 2, min: 0, max: 999999999 })), null, _parent2, _scopeId));
            _push2(`</label><div class="w-29 h-full bg-[--el-color-info-light-10] border-l-1 border-[--el-border-color-lighter]" data-v-9ef3de75${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_select, {
              modelValue: unref(state).to,
              "onUpdate:modelValue": ($event) => unref(state).to = $event,
              size: "large",
              style: { "--el-border-color": "transparent", "--el-border-color-dark": "transparent", "--el-border-color-hover": "transparent", "--el-color-primary": "transparent" },
              onChange: ($event) => updateAmount("toAmount")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<!--[-->`);
                  ssrRenderList(unref(settingsStore).currency, (item) => {
                    _push3(ssrRenderComponent(_component_el_option, {
                      key: item.symbol_iso,
                      value: item.symbol_iso,
                      disabled: item.symbol_iso === unref(state).from
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(item.name?.[_ctx.$i18n.locale] + "/" + item.symbol_iso + " (" + item.symbol + ")")}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(item.name?.[_ctx.$i18n.locale] + "/" + item.symbol_iso + " (" + item.symbol + ")"), 1)
                          ];
                        }
                      }),
                      _: 2
                    }, _parent3, _scopeId2));
                  });
                  _push3(`<!--]-->`);
                } else {
                  return [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(settingsStore).currency, (item) => {
                      return openBlock(), createBlock(_component_el_option, {
                        key: item.symbol_iso,
                        value: item.symbol_iso,
                        disabled: item.symbol_iso === unref(state).from
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(item.name?.[_ctx.$i18n.locale] + "/" + item.symbol_iso + " (" + item.symbol + ")"), 1)
                        ]),
                        _: 2
                      }, 1032, ["value", "disabled"]);
                    }), 128))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div></div></div><div class="text-base mt-4 text-[--el-color-primary-dark-2] bg-[--el-color-primary-light-9] p-2 rounded text-center border-dashed border-1 border-[--el-color-primary-light-7]" data-v-9ef3de75${_scopeId}><span data-v-9ef3de75${_scopeId}>${ssrInterpolate(unref(state).amount + " " + unref(state).from)}</span><span class="mx-2" data-v-9ef3de75${_scopeId}>=</span><span data-v-9ef3de75${_scopeId}>${ssrInterpolate(unref(state).toAmount + " " + unref(state).to)}</span></div><div data-v-9ef3de75${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              onClick: unref(state).transfer,
              class: "w-full mt-4",
              disabled: !unref(state).amount || parseFloat(unref(state).amount) > unref(viewer).data.gqMoney[unref(state).from]
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("page.account.wealth.transfer.transfer"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("page.account.wealth.transfer.transfer")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "exchange-balance" }, [
                createVNode("div", { class: "flex items-center flex-col" }, [
                  createVNode("div", { class: "w-full border-1 border-[--el-color-primary-light-7] rounded-md overflow-hidden" }, [
                    createVNode("div", {
                      style: { "--el-border-color": "transparent", "--el-border-color-dark": "transparent", "--el-border-color-hover": "transparent" },
                      class: "w-full flex gap-2 items-stretch"
                    }, [
                      createVNode("label", { class: "flex flex-col pt-2" }, [
                        createVNode("span", {
                          class: "text-xs ml-3 opacity-70",
                          innerHTML: _ctx.$t("page.account.wealth.transfer.from", [unref(state).name(unref(state).from)[_ctx.$i18n.locale] + "/" + unref(state).from + "(" + unref(state).symbol(unref(state).from) + ")"])
                        }, null, 8, ["innerHTML"]),
                        withDirectives(createVNode(_component_el_input, {
                          modelValue: unref(state).amount,
                          "onUpdate:modelValue": ($event) => unref(state).amount = $event,
                          class: "!text-lg",
                          step: "0.01",
                          onInput: ($event) => updateAmount("amount"),
                          type: "number",
                          style: { "--el-input-focus-border-color": "transparent" }
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "onInput"]), [
                          [_directive_decimal, { decimals: 2, min: 0, max: unref(viewer).data.gqMoney[unref(state).from] }]
                        ])
                      ]),
                      createVNode("div", { class: "w-29 h-full bg-[--el-color-info-light-10] border-l-1 border-[--el-border-color-lighter]" }, [
                        createVNode(_component_el_select, {
                          modelValue: unref(state).from,
                          "onUpdate:modelValue": ($event) => unref(state).from = $event,
                          size: "large",
                          class: "!h-full",
                          onChange: ($event) => updateAmount("amount"),
                          style: { "--el-border-color": "transparent", "--el-border-color-dark": "transparent", "--el-border-color-hover": "transparent", "--el-color-primary": "transparent" }
                        }, {
                          default: withCtx(() => [
                            (openBlock(true), createBlock(Fragment, null, renderList(unref(settingsStore).currency, (item) => {
                              return openBlock(), createBlock(_component_el_option, {
                                key: item.symbol_iso,
                                value: item.symbol_iso,
                                disabled: item.symbol_iso === unref(state).to
                              }, {
                                default: withCtx(() => [
                                  createTextVNode(toDisplayString(item.name?.[_ctx.$i18n.locale] + "/" + item.symbol_iso + " (" + item.symbol + ")"), 1)
                                ]),
                                _: 2
                              }, 1032, ["value", "disabled"]);
                            }), 128))
                          ]),
                          _: 1
                        }, 8, ["modelValue", "onUpdate:modelValue", "onChange"])
                      ])
                    ])
                  ]),
                  createVNode("div", { class: "flex items-center justify-between text-xs w-full pl-6 py-5 left-line" }, [
                    createVNode("div", { class: "flex flex-col gap-2 opacity-90" }, [
                      createVNode("span", {
                        innerHTML: _ctx.$t("page.account.wealth.transfer.formBalance", [unref(state).name(unref(state).from)[_ctx.$i18n.locale], unref(state).symbol(unref(state).from) + ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(viewer).data.gqMoney[unref(state).from], unref(state).from)])
                      }, null, 8, ["innerHTML"]),
                      createVNode("span", {
                        innerHTML: _ctx.$t("page.account.wealth.transfer.toBalance", [unref(state).name(unref(state).to)[_ctx.$i18n.locale], unref(state).symbol(unref(state).to) + ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(viewer).data.gqMoney[unref(state).to], unref(state).to)])
                      }, null, 8, ["innerHTML"]),
                      createVNode("span", {
                        innerHTML: _ctx.$t("page.account.wealth.transfer.rate", [unref(state).rate(unref(state).from, unref(state).to)])
                      }, null, 8, ["innerHTML"])
                    ]),
                    createVNode(_component_el_button, {
                      class: "flex items-center justify-center rounded-full is-active",
                      onClick: ($event) => unref(state).swap(),
                      circle: ""
                    }, {
                      default: withCtx(() => [
                        createVNode("i", { class: "i-ph-arrows-down-up" })
                      ]),
                      _: 1
                    }, 8, ["onClick"])
                  ]),
                  createVNode("div", { class: "w-full border-1 rounded-md overflow-hidden border-[--el-color-primary-light-7]" }, [
                    createVNode("div", {
                      style: { "--el-border-color": "transparent", "--el-border-color-dark": "transparent", "--el-border-color-hover": "transparent" },
                      class: "w-full flex items-center gap-2"
                    }, [
                      createVNode("label", { class: "flex flex-col pt-2" }, [
                        createVNode("span", {
                          class: "text-xs ml-3 opacity-70",
                          innerHTML: _ctx.$t("page.account.wealth.transfer.transferTo", [unref(state).name(unref(state).to)[_ctx.$i18n.locale] + "/" + unref(state).to + "(" + unref(state).symbol(unref(state).to) + ")"])
                        }, null, 8, ["innerHTML"]),
                        withDirectives(createVNode(_component_el_input, {
                          modelValue: unref(state).toAmount,
                          "onUpdate:modelValue": ($event) => unref(state).toAmount = $event,
                          class: "!text-lg",
                          step: "0.01",
                          onInput: ($event) => updateAmount("toAmount"),
                          type: "number",
                          style: { "--el-input-focus-border-color": "transparent" }
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "onInput"]), [
                          [_directive_decimal, { decimals: 2, min: 0, max: 999999999 }]
                        ])
                      ]),
                      createVNode("div", { class: "w-29 h-full bg-[--el-color-info-light-10] border-l-1 border-[--el-border-color-lighter]" }, [
                        createVNode(_component_el_select, {
                          modelValue: unref(state).to,
                          "onUpdate:modelValue": ($event) => unref(state).to = $event,
                          size: "large",
                          style: { "--el-border-color": "transparent", "--el-border-color-dark": "transparent", "--el-border-color-hover": "transparent", "--el-color-primary": "transparent" },
                          onChange: ($event) => updateAmount("toAmount")
                        }, {
                          default: withCtx(() => [
                            (openBlock(true), createBlock(Fragment, null, renderList(unref(settingsStore).currency, (item) => {
                              return openBlock(), createBlock(_component_el_option, {
                                key: item.symbol_iso,
                                value: item.symbol_iso,
                                disabled: item.symbol_iso === unref(state).from
                              }, {
                                default: withCtx(() => [
                                  createTextVNode(toDisplayString(item.name?.[_ctx.$i18n.locale] + "/" + item.symbol_iso + " (" + item.symbol + ")"), 1)
                                ]),
                                _: 2
                              }, 1032, ["value", "disabled"]);
                            }), 128))
                          ]),
                          _: 1
                        }, 8, ["modelValue", "onUpdate:modelValue", "onChange"])
                      ])
                    ])
                  ])
                ]),
                createVNode("div", { class: "text-base mt-4 text-[--el-color-primary-dark-2] bg-[--el-color-primary-light-9] p-2 rounded text-center border-dashed border-1 border-[--el-color-primary-light-7]" }, [
                  createVNode("span", null, toDisplayString(unref(state).amount + " " + unref(state).from), 1),
                  createVNode("span", { class: "mx-2" }, "="),
                  createVNode("span", null, toDisplayString(unref(state).toAmount + " " + unref(state).to), 1)
                ]),
                createVNode("div", null, [
                  createVNode(_component_el_button, {
                    type: "primary",
                    onClick: unref(state).transfer,
                    class: "w-full mt-4",
                    disabled: !unref(state).amount || parseFloat(unref(state).amount) > unref(viewer).data.gqMoney[unref(state).from]
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("page.account.wealth.transfer.transfer")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick", "disabled"])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/account/wealth/transfer.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_8 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-9ef3de75"]]);

export { __nuxt_component_8 as default };
