import { E as ElProgress } from './progress-CBrKLnJJ.mjs';
import { a as useI18n, E as ElMessage, r as useRequest } from './server.mjs';
import { ref, mergeProps, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrIncludeBooleanAttr, ssrRenderAttr, ssrRenderComponent, ssrRenderSlot } from 'vue/server-renderer';
import { nanoid } from 'nanoid';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'lodash-unified';
import 'quick-lru';

const CHUNK_SIZE = 1024 * 1024;
const MAX_CONCURRENT_UPLOADS = 3;
const _sfc_main = {
  __name: "CommonFormUpload",
  __ssrInlineRender: true,
  props: ["showIcon", "showProgress", "multiple", "accept", "mediaType"],
  emits: ["upload-complete", "upload-progress", "files-selected", "upload-error"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const uploadProgress = ref(0);
    const input = ref(null);
    const uploadResults = ref([]);
    const { t } = useI18n();
    const showMsg = ref(true);
    const isUploading = ref(false);
    const uploadMsg = ref({ success: null, error: null, uploading: null });
    const fileProgress = ref({});
    const colors = [
      { color: "var(--el-color-primary-light-8)", percentage: 20 },
      { color: "var(--el-color-primary-light-7)", percentage: 40 },
      { color: "var(--el-color-primary-light-5)", percentage: 60 },
      { color: "var(--el-color-primary-light-3)", percentage: 80 },
      { color: "var(--el-color-primary)", percentage: 100 }
    ];
    const emit = __emit;
    const handleFiles = (selectedFiles) => {
      return new Promise((resolve, reject) => {
        if (isUploading.value && showMsg.value) {
          ElMessage.error("Please wait until current upload finishes.");
          reject("Upload in progress");
          return;
        }
        if (selectedFiles.length > 0) {
          const filesWithIds = selectedFiles.map((file) => ({
            file,
            id: nanoid(),
            blob: URL.createObjectURL(file)
          }));
          emit("files-selected", filesWithIds);
          isUploading.value = true;
          if (uploadMsg.value.success) {
            uploadMsg.value.success.close();
          }
          if (showMsg.value) uploadMsg.value.uploading = ElMessage.info(t("common.uploadFile.uploading"));
          uploadProgress.value = 1;
          fileProgress.value = {};
          filesWithIds.forEach(({ file, id }) => {
            fileProgress.value[id] = 0;
          });
          uploadFilesInChunks(filesWithIds).then(resolve).catch(reject);
        }
      });
    };
    const uploadFilesInChunks = (filesWithIds) => {
      return new Promise((resolve, reject) => {
        const totalFiles = filesWithIds.length;
        let uploadedFiles = 0;
        const updateOverallProgress = (fileProgressValue, fileId) => {
          if (!fileProgress.value[fileId]) {
            fileProgress.value[fileId] = 0;
          }
          fileProgress.value[fileId] = fileProgressValue;
          emit("upload-progress", { ...fileProgress.value });
          const totalProgress = Object.values(fileProgress.value).reduce((acc, progress) => acc + progress, 0) / totalFiles;
          const roundedProgress = Math.round(totalProgress);
          if (roundedProgress !== uploadProgress.value) {
            uploadProgress.value = roundedProgress;
          }
        };
        filesWithIds.forEach(({ file, id }, index) => {
          const fileSize = file.size;
          uploadFileInChunks(file, id, index, fileSize, updateOverallProgress).then(() => {
            uploadedFiles++;
            if (uploadedFiles === totalFiles) {
              uploadProgress.value = 100;
              input.value.value = "";
              setTimeout(() => {
                emit("upload-complete", uploadResults.value);
                resolve(uploadResults.value);
              }, 100);
              isUploading.value = false;
              if (showMsg.value) {
                uploadMsg.value.uploading.close();
                uploadMsg.value.success = ElMessage.success(t("common.uploadFile.success"));
              }
            }
          }).catch((error) => {
            console.log(error);
            isUploading.value = false;
            uploadProgress.value = 0;
            input.value.value = "";
            emit("upload-error", id);
            reject(error);
          });
        });
      });
    };
    const uploadFileInChunks = (file, fileId, index, fileSize, updateOverallProgress) => {
      return new Promise((resolve, reject) => {
        const totalChunks = Math.ceil(file.size / CHUNK_SIZE);
        let currentChunk = 0;
        let offset = 0;
        const uploadNextChunk = () => {
          if (currentChunk < totalChunks) {
            const chunk = file.slice(offset, offset + CHUNK_SIZE);
            uploadChunk(chunk, currentChunk, totalChunks, file.name, fileSize, fileId).then((res) => {
              if (currentChunk == totalChunks - 1) {
                uploadResults.value[index] = { ...res.fileUpload, nanoid: res.fileId };
              }
              offset += CHUNK_SIZE;
              currentChunk++;
              updateOverallProgress(currentChunk / totalChunks * 100, fileId);
              setTimeout(uploadNextChunk, 0);
            }).catch((error) => {
              ElMessage.error(error.message);
              uploadProgress.value = 0;
              input.value.value = "";
              isUploading.value = false;
              emit("upload-error", fileId);
              reject(error);
            });
          } else {
            resolve();
          }
        };
        uploadNextChunk();
      });
    };
    const uploadQueue = [];
    let activeUploads = 0;
    const processQueue = () => {
      while (activeUploads < MAX_CONCURRENT_UPLOADS && uploadQueue.length > 0) {
        const { chunk, chunkIndex, totalChunks, fileName, fileSize, fileId, resolve, reject } = uploadQueue.shift();
        activeUploads++;
        uploadSingleChunk(chunk, chunkIndex, totalChunks, fileName, fileSize, fileId).then((res) => {
          activeUploads--;
          resolve(res);
          processQueue();
        }).catch((error) => {
          activeUploads--;
          uploadProgress.value = 0;
          input.value.value = "";
          isUploading.value = false;
          emit("upload-error", fileId);
          reject(error);
          processQueue();
        });
      }
    };
    const uploadChunk = (chunk, chunkIndex, totalChunks, fileName, fileSize, fileId) => {
      return new Promise((resolve, reject) => {
        uploadQueue.push({ chunk, chunkIndex, totalChunks, fileName, fileSize, fileId, resolve, reject });
        processQueue();
      });
    };
    const uploadSingleChunk = (chunk, chunkIndex, totalChunks, fileName, fileSize, fileId) => {
      return new Promise(async (resolve, reject) => {
        const formData = new FormData();
        formData.append("chunk", chunk);
        formData.append("chunkIndex", chunkIndex);
        formData.append("totalChunks", totalChunks);
        formData.append("fileName", fileName);
        formData.append("fileSize", fileSize);
        try {
          const res = await useRequest("/api/upload", { method: "POST", body: formData });
          if (!res.errors) {
            resolve({ ...res.data, fileId });
          } else {
            emit("upload-error", fileId);
            uploadProgress.value = 0;
            input.value.value = "";
            isUploading.value = false;
            reject(new Error(res.errors.map((error) => error.message).join(", ")));
          }
        } catch (error) {
          emit("upload-error", fileId);
          uploadProgress.value = 0;
          input.value.value = "";
          isUploading.value = false;
          console.log(error);
          reject(new Error(error.message));
        }
      });
    };
    __expose({ handleFiles, showMsg });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_progress = ElProgress;
      _push(`<label${ssrRenderAttrs(mergeProps({ class: "flex w-30 h-30 items-center justify-center bg-[--el-color-info-light-10] group/file cursor-pointer relative" }, _attrs))}>`);
      if (uploadProgress.value == 0 && __props.showIcon) {
        _push(`<i class="i-ph-plus opacity-50 group-hover/file:opacity-100 transition"></i>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<input${ssrIncludeBooleanAttr(isUploading.value) ? " disabled" : ""} type="file"${ssrIncludeBooleanAttr(__props.multiple) ? " multiple" : ""}${ssrRenderAttr("accept", __props.accept)} class="hidden">`);
      if (uploadProgress.value > 0 && uploadProgress.value < 100 && __props.showProgress) {
        _push(ssrRenderComponent(_component_el_progress, {
          type: "circle",
          color: colors,
          "show-text": false,
          class: "absolute inset-auto z-2",
          "stroke-width": 2,
          width: 90,
          percentage: uploadProgress.value
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</label>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/upload.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
