import { E as ElDialog } from './index-awVc4A7-.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import { a as useI18n, E as ElMessage, r as useRequest, s as useIntervalFn, _ as __nuxt_component_0$2 } from './server.mjs';
import { useSSRContext, ref, computed, reactive, watch, unref, withCtx, createVNode, createTextVNode, toDisplayString, openBlock, createBlock, createCommentVNode, withKeys } from 'vue';
import { ssrRenderComponent, ssrInterpolate } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './use-dialog-7J0bwlna.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import 'lodash-unified';
import './aria-BhThsKez.mjs';
import './event-BZTOGHfp.mjs';
import '@vue/shared';
import './vnode-l2ZP2UQa.mjs';
import './index-Di0Jlzch.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './index-DRiwogtD.mjs';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import './index-Bp-nwGzu.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonFormVerify",
  __ssrInlineRender: true,
  setup(__props, { expose: __expose }) {
    const dropdown = ref(null);
    const captcha = ref(null);
    const { t } = useI18n();
    const countryDialCodes = ref(null);
    const { locale } = useI18n();
    const phoneOrEmail = computed(() => {
      if (form.type == "phone")
        return (countryDialCodes?.countryDialCodes?.picked[1] ? countryDialCodes?.countryDialCodes?.picked[1] + " " : "") + (form.newPhone ? form.newPhone : form.phone);
      if (form.type == "email") return form.newEmail ? form.newEmail : form.email;
      if (form.phone || form.email) {
        return form.phone || form.email;
      }
      return null;
    });
    const type = computed(() => {
      if (form.newEmail || form.newPhone) return "verify";
      return "auth";
    });
    const form = reactive({
      newEmail: null,
      newPhone: null,
      show: false,
      type: "phone",
      verifyType: "phone",
      verifyLocked: false,
      verifyData: null,
      timer: 0,
      phone: "",
      email: "",
      code: "",
      verifySuccess: false,
      saveSuccess: false,
      getCodeLocked: false,
      verificationSign: "",
      interval: useIntervalFn(
        () => {
          if (form.timer <= 1) {
            form.getCodeLocked = false;
            form.interval.pause();
          } else {
            form.timer--;
          }
        },
        1e3,
        {
          // 默认不开启定时任务
          immediate: false
        }
      ),
      checkVerify: () => {
        form.verifyData = JSON.parse(localStorage.getItem("guaqi_verify"));
        if (form.verifyData) {
          if (Date.now() - 1e3 * 60 * 1 > form.verifyData.expired) {
            localStorage.removeItem("guaqi_verify");
            form.verifyData = null;
            form.verifySuccess = false;
            return false;
          }
          return true;
        }
        return false;
      },
      doAction: {
        captchaShow: () => {
          if (form.verifySuccess || form.checkVerify()) {
            form.verifySuccess = true;
            captcha.value.show = true;
            return;
          }
          captcha.value.show = true;
          return;
        },
        showDropdown: () => {
          if (!dropdown.value) return;
          dropdown.value.handleOpen();
        },
        verify: async () => {
          if (form.verifyLocked) return;
          form.verifyLocked = true;
          form.saveSuccess = false;
          const res = await useRequest("/api/request", {
            body: {
              data: {
                verificationSign: form.verificationSign,
                verificationInput: form.code,
                captchaSign: captcha.value.captchaSign,
                captchaInput: captcha.value.captchaInput,
                lang: locale.value,
                siteUrl: (void 0).origin,
                timestamp: captcha.value.timestamp,
                type: form.type,
                phoneOrEmail: phoneOrEmail.value,
                action: form.verifySuccess || !form.email && !form.phone ? "newData" : "verify",
                verifyData: form.verifyData ? JSON.stringify(form.verifyData) : ""
              }
            }
          });
          if (res?.guaqi?.utils?.verifyCode) {
            if (!form.newEmail && !form.newPhone) {
              localStorage.setItem(
                "guaqi_verify",
                JSON.stringify({
                  verificationSign: form.verificationSign,
                  verificationInput: form.code,
                  captchaSign: captcha.value.captchaSign,
                  captchaInput: captcha.value.captchaInput,
                  timestamp: captcha.value.timestamp,
                  action: "verify",
                  type: form.type,
                  phoneOrEmail: "",
                  expired: Date.now() + 1e3 * 60 * 5
                })
              );
              ElMessage.success(t("common.verify.verifySuccess"));
            }
            form.show = false;
            form.verifySuccess = true;
            if (form.newEmail || form.newPhone) {
              form.saveSuccess = true;
              ElMessage.success(t("common.login.moreInfomation.success"));
            }
            form.code = "";
          }
          form.verifyLocked = false;
        },
        getCode: async function() {
          if (!form.checkVerify() && (form.newEmail || form.newPhone) && (form.email || form.phone)) {
            ElMessage.error(t("common.verify.verifyExpired"));
            form.newEmail = null;
            form.newPhone = null;
            form.verifySuccess = false;
            return;
          }
          if (form.getCodeLocked) {
            return;
          }
          form.getCodeLocked = true;
          const res = await useRequest("/api/request", {
            body: {
              data: {
                captchaSign: captcha.value.captchaSign,
                captchaInput: captcha.value.captchaInput,
                type: form.type,
                lang: locale.value,
                siteUrl: (void 0).origin,
                timestamp: captcha.value.timestamp,
                phoneOrEmail: phoneOrEmail.value,
                action: form.verifySuccess || !form.email && !form.phone ? "newData" : "verify"
              }
            }
          });
          if (res?.guaqi?.utils?.getCode) {
            if (form.timer === 0) {
              form.timer = 60;
              form.interval.resume();
            }
            form.verificationSign = res.guaqi.utils.getCode;
          } else {
            captcha.value.success = false;
            form.getCodeLocked = false;
            form.interval.pause();
            form.timer = 0;
          }
        }
      }
    });
    watch(
      () => captcha?.value?.success,
      (val) => {
        if (val) {
          form.captcha = captcha.value.captchaSign;
          form.captchaInput = captcha.value.captchaInput;
          form.doAction.getCode();
        }
      }
    );
    __expose({
      form,
      captcha
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_dialog = ElDialog;
      const _component_el_button = ElButton;
      const _component_el_input = ElInput;
      const _component_CommonFormCaptcha = __nuxt_component_0$2;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_el_dialog, {
        modelValue: unref(form).show,
        "onUpdate:modelValue": ($event) => unref(form).show = $event,
        width: "290px",
        "show-close": false,
        "lock-scroll": false,
        "append-to-body": true,
        "close-on-click-modal": false
      }, {
        header: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex justify-center w-full relative font-600" data-v-17f717fc${_scopeId}>`);
            if (!unref(form).newEmail && !unref(form).newPhone) {
              _push2(`<span data-v-17f717fc${_scopeId}>${ssrInterpolate(_ctx.$t("common.verify.title"))}</span>`);
            } else if (unref(form).type == "phone") {
              _push2(`<span data-v-17f717fc${_scopeId}>${ssrInterpolate(_ctx.$t("common.verify.newPhone"))}</span>`);
            } else {
              _push2(`<span data-v-17f717fc${_scopeId}>${ssrInterpolate(_ctx.$t("common.verify.newEmail"))}</span>`);
            }
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              circle: "",
              size: "small",
              text: "",
              class: "ml-6 absolute right-0",
              onClick: ($event) => unref(form).show = false
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<i class="i-ph-x-bold" data-v-17f717fc${_scopeId2}></i>`);
                } else {
                  return [
                    createVNode("i", { class: "i-ph-x-bold" })
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex justify-center w-full relative font-600" }, [
                !unref(form).newEmail && !unref(form).newPhone ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("common.verify.title")), 1)) : unref(form).type == "phone" ? (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("common.verify.newPhone")), 1)) : (openBlock(), createBlock("span", { key: 2 }, toDisplayString(_ctx.$t("common.verify.newEmail")), 1)),
                createVNode(_component_el_button, {
                  type: "primary",
                  circle: "",
                  size: "small",
                  text: "",
                  class: "ml-6 absolute right-0",
                  onClick: ($event) => unref(form).show = false
                }, {
                  default: withCtx(() => [
                    createVNode("i", { class: "i-ph-x-bold" })
                  ]),
                  _: 1
                }, 8, ["onClick"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="mx-4 mb-4" data-v-17f717fc${_scopeId}><div class="flex justify-center mb-2" data-v-17f717fc${_scopeId}>`);
            if (unref(form).newEmail || unref(form).newPhone) {
              _push2(`<i class="i-ph-identification-card-thin w-10 h-10 opacity-40" data-v-17f717fc${_scopeId}></i>`);
            } else {
              _push2(`<i class="i-ph-shield-checkered-thin w-10 h-10 opacity-40" data-v-17f717fc${_scopeId}></i>`);
            }
            _push2(`</div><div class="flex flex-col justify-center text-sm text-center flex-wrap gap-1" data-v-17f717fc${_scopeId}><span class="text-xs" data-v-17f717fc${_scopeId}>${ssrInterpolate(_ctx.$t("common.verify.desc"))}</span>`);
            if (unref(form)[unref(form).type]) {
              _push2(`<span data-v-17f717fc${_scopeId}>${ssrInterpolate(_ctx.$t("common.verify.desc2", [
                unref(form).newEmail ? _ctx.$t("common.verify.newEmail") : unref(form).newPhone ? _ctx.$t("common.verify.newPhone") : _ctx.$t("common.verify.desc3")
              ]))}</span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div></div><div class="text-xs bg-[--el-color-info-light-10] justify-around rounded p-2 mx-4 flex items-center gap-2 relative" data-v-17f717fc${_scopeId}>`);
            if (unref(form).newEmail || unref(form).newPhone) {
              _push2(`<div class="w-full flex justify-center" data-v-17f717fc${_scopeId}>`);
              if (unref(form).newEmail) {
                _push2(`<div class="text-xl" data-v-17f717fc${_scopeId}>${ssrInterpolate(unref(form).newEmail)}</div>`);
              } else if (unref(form).newPhone) {
                _push2(`<div class="text-xl" data-v-17f717fc${_scopeId}>${ssrInterpolate(unref(form).newPhone)}</div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
            } else {
              _push2(`<div class="flex items-center gap-2 justify-center w-full" data-v-17f717fc${_scopeId}>`);
              if (unref(form).email && unref(form).phone) {
                _push2(ssrRenderComponent(_component_el_button, {
                  circle: "",
                  class: "!rounded",
                  text: "",
                  size: "small",
                  onClick: ($event) => unref(form).type = unref(form).type == "phone" ? "email" : "phone"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`<i class="i-ph-arrows-clockwise" data-v-17f717fc${_scopeId2}></i>`);
                    } else {
                      return [
                        createVNode("i", { class: "i-ph-arrows-clockwise" })
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`<div data-v-17f717fc${_scopeId}>`);
              if (unref(form).type == "phone") {
                _push2(`<div class="flex items-center" data-v-17f717fc${_scopeId}>${ssrInterpolate(_ctx.$t("common.verify.phone", [unref(form).phone]))}</div>`);
              } else {
                _push2(`<div class="flex items-center" data-v-17f717fc${_scopeId}>${ssrInterpolate(_ctx.$t("common.verify.email"))}: ${ssrInterpolate(unref(form).email)}</div>`);
              }
              _push2(`</div></div>`);
            }
            _push2(`</div><div class="mt-4 flex items-center gap-2 border-1 mx-4 p-2 rounded" data-v-17f717fc${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_input, {
              modelValue: unref(form).code,
              "onUpdate:modelValue": ($event) => unref(form).code = $event,
              placeholder: _ctx.$t("common.verify.code"),
              class: "w-2/3",
              onKeyup: unref(form).doAction.verify
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              class: "w-1/3",
              text: "",
              link: "",
              size: "small",
              plain: "",
              onClick: unref(form).doAction.captchaShow,
              disabled: unref(form).getCodeLocked
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div><div class="mt-12 flex items-center gap-2 w-1/3 mx-auto" data-v-17f717fc${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              class: "w-full",
              onClick: unref(form).doAction.verify,
              disabled: !unref(form).code,
              loading: unref(form).verifyLocked
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  if (unref(form).newEmail || unref(form).newPhone) {
                    _push3(`<span data-v-17f717fc${_scopeId2}>${ssrInterpolate(_ctx.$t("common.edit.save"))}</span>`);
                  } else {
                    _push3(`<span data-v-17f717fc${_scopeId2}>${ssrInterpolate(_ctx.$t("common.verify.verify"))}</span>`);
                  }
                } else {
                  return [
                    unref(form).newEmail || unref(form).newPhone ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("common.edit.save")), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("common.verify.verify")), 1))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "mx-4 mb-4" }, [
                createVNode("div", { class: "flex justify-center mb-2" }, [
                  unref(form).newEmail || unref(form).newPhone ? (openBlock(), createBlock("i", {
                    key: 0,
                    class: "i-ph-identification-card-thin w-10 h-10 opacity-40"
                  })) : (openBlock(), createBlock("i", {
                    key: 1,
                    class: "i-ph-shield-checkered-thin w-10 h-10 opacity-40"
                  }))
                ]),
                createVNode("div", { class: "flex flex-col justify-center text-sm text-center flex-wrap gap-1" }, [
                  createVNode("span", { class: "text-xs" }, toDisplayString(_ctx.$t("common.verify.desc")), 1),
                  unref(form)[unref(form).type] ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("common.verify.desc2", [
                    unref(form).newEmail ? _ctx.$t("common.verify.newEmail") : unref(form).newPhone ? _ctx.$t("common.verify.newPhone") : _ctx.$t("common.verify.desc3")
                  ])), 1)) : createCommentVNode("", true)
                ])
              ]),
              createVNode("div", { class: "text-xs bg-[--el-color-info-light-10] justify-around rounded p-2 mx-4 flex items-center gap-2 relative" }, [
                unref(form).newEmail || unref(form).newPhone ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "w-full flex justify-center"
                }, [
                  unref(form).newEmail ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "text-xl"
                  }, toDisplayString(unref(form).newEmail), 1)) : unref(form).newPhone ? (openBlock(), createBlock("div", {
                    key: 1,
                    class: "text-xl"
                  }, toDisplayString(unref(form).newPhone), 1)) : createCommentVNode("", true)
                ])) : (openBlock(), createBlock("div", {
                  key: 1,
                  class: "flex items-center gap-2 justify-center w-full"
                }, [
                  unref(form).email && unref(form).phone ? (openBlock(), createBlock(_component_el_button, {
                    key: 0,
                    circle: "",
                    class: "!rounded",
                    text: "",
                    size: "small",
                    onClick: ($event) => unref(form).type = unref(form).type == "phone" ? "email" : "phone"
                  }, {
                    default: withCtx(() => [
                      createVNode("i", { class: "i-ph-arrows-clockwise" })
                    ]),
                    _: 1
                  }, 8, ["onClick"])) : createCommentVNode("", true),
                  createVNode("div", null, [
                    unref(form).type == "phone" ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "flex items-center"
                    }, toDisplayString(_ctx.$t("common.verify.phone", [unref(form).phone])), 1)) : (openBlock(), createBlock("div", {
                      key: 1,
                      onClick: unref(form).doAction.showDropdown,
                      class: "flex items-center"
                    }, toDisplayString(_ctx.$t("common.verify.email")) + ": " + toDisplayString(unref(form).email), 9, ["onClick"]))
                  ])
                ]))
              ]),
              createVNode("div", { class: "mt-4 flex items-center gap-2 border-1 mx-4 p-2 rounded" }, [
                createVNode(_component_el_input, {
                  modelValue: unref(form).code,
                  "onUpdate:modelValue": ($event) => unref(form).code = $event,
                  placeholder: _ctx.$t("common.verify.code"),
                  class: "w-2/3",
                  onKeyup: withKeys(unref(form).doAction.verify, ["enter"])
                }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onKeyup"]),
                createVNode(_component_el_button, {
                  type: "primary",
                  class: "w-1/3",
                  text: "",
                  link: "",
                  size: "small",
                  plain: "",
                  onClick: unref(form).doAction.captchaShow,
                  disabled: unref(form).getCodeLocked
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick", "disabled"])
              ]),
              createVNode("div", { class: "mt-12 flex items-center gap-2 w-1/3 mx-auto" }, [
                createVNode(_component_el_button, {
                  type: "primary",
                  class: "w-full",
                  onClick: unref(form).doAction.verify,
                  disabled: !unref(form).code,
                  loading: unref(form).verifyLocked
                }, {
                  default: withCtx(() => [
                    unref(form).newEmail || unref(form).newPhone ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("common.edit.save")), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("common.verify.verify")), 1))
                  ]),
                  _: 1
                }, 8, ["onClick", "disabled", "loading"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_CommonFormCaptcha, {
        ref_key: "captcha",
        ref: captcha,
        verifyType: unref(form).type,
        phoneOrEmail: unref(phoneOrEmail),
        type: unref(type),
        action: unref(form).verifySuccess || !unref(form).email && !unref(form).phone ? "newData" : "verify"
      }, null, _parent));
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/verify.client.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const verify_client = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-17f717fc"]]);

export { verify_client as default };
