import { E as ElRadioGroup, a as ElRadio } from './index-CCMOIr7X.mjs';
import { E as ElCheckboxGroup, a as ElCheckbox } from './index-VQeHi7JP.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { j as actionStore, a as useI18n, e as useUtils, w as isLogin, r as useRequest } from './server.mjs';
import { useSSRContext, ref, computed, mergeProps, unref, isRef, withCtx, createTextVNode, toDisplayString, openBlock, createBlock, Fragment, renderList } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderList, ssrRenderClass, ssrRenderStyle } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '@vue/shared';
import './event-BZTOGHfp.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import './index-31HAFSrO.mjs';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonTopicVote",
  __ssrInlineRender: true,
  props: ["vote"],
  setup(__props) {
    const props = __props;
    const votedRecord = ref(null);
    const action = actionStore();
    const voteData = computed(() => {
      return votedRecord.value ?? props.vote;
    });
    const { locale } = useI18n();
    const text = (text2) => {
      if (typeof text2 === "string") return text2;
      return text2[locale.value];
    };
    const proportions = (list, vote) => {
      vote = parseInt(vote);
      const total = Object.values(list).reduce((acc, item) => acc + parseInt(item.vote), 0);
      if (total == 0) return 0;
      return Math.round(vote / total * 100);
    };
    const picked = ref(0);
    const pickedData = computed(() => {
      if (!voteData.value.picked) return [];
      try {
        return JSON.parse(voteData.value.picked).map((item) => parseInt(item)).filter((item) => !isNaN(item));
      } catch (error) {
        console.error("解析 picked 失败:", error);
        return [];
      }
    });
    const check = ref([]);
    const voteRecord = async () => {
      if (!isLogin.value) {
        action.showLogin = true;
        return;
      }
      if (props.vote.type === "radio") {
        [picked.value];
      } else if (props.vote.type === "checkbox") {
        check.value;
      } else if (props.vote.type === "pk") {
        [picked.value];
      }
      const res = await useRequest("/api/request", {
        body: {
          data: {
            postId: props.vote.postId,
            voteType: props.vote.type
          }
        }
      });
      if (res?.gqAddVoteRecord?.data) {
        votedRecord.value = res.gqAddVoteRecord.data;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_radio_group = ElRadioGroup;
      const _component_el_radio = ElRadio;
      const _component_el_checkbox_group = ElCheckboxGroup;
      const _component_el_checkbox = ElCheckbox;
      const _component_el_button = ElButton;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "flex w-82 flex-col p-3 border rounded max-w-full gap-3",
        style: { "--el-border-color": "var(--el-color-primary-light-9)", "--gq-vote-bg": "var(--el-fill-color-extra-light)" }
      }, _attrs))} data-v-6c50b1ef><div class="flex justify-between border-b pb-2 text-xs" data-v-6c50b1ef>`);
      if (unref(voteData).type !== "pk") {
        _push(`<!--[--><span class="flex items-center" data-v-6c50b1ef><i class="i-ph-chart-bar mr-1 text-[var(--el-color-primary)]" data-v-6c50b1ef></i> ${ssrInterpolate(_ctx.$t("page.community.list.vote.voteCount", [unref(voteData).total ?? 0]))}</span><span class="flex items-center gap-2" data-v-6c50b1ef><b class="font-normal text-[var(--el-color-primary)] bg-[var(--el-color-primary-light-9)] p-1 rounded-sm" data-v-6c50b1ef>${ssrInterpolate(_ctx.$t("page.community.types.vote." + unref(voteData).type))}</b></span><!--]-->`);
      } else {
        _push(`<!--[--><span class="flex items-center" data-v-6c50b1ef><i class="i-ph-boxing-glove mr-1 text-[var(--el-color-primary)]" data-v-6c50b1ef></i> ${ssrInterpolate(_ctx.$t("page.community.list.vote.voteJoin", [unref(voteData).total ?? 0]))}</span><span data-v-6c50b1ef><b class="font-normal text-[var(--el-color-primary)] bg-[var(--el-color-primary-light-9)] p-1 rounded-sm" data-v-6c50b1ef> PK </b></span><!--]-->`);
      }
      _push(`</div>`);
      if (unref(voteData).type === "radio") {
        _push(`<div data-v-6c50b1ef>`);
        if (!unref(voteData).voted && !unref(voteData).hasExpired) {
          _push(`<div data-v-6c50b1ef>`);
          _push(ssrRenderComponent(_component_el_radio_group, {
            modelValue: unref(picked),
            "onUpdate:modelValue": ($event) => isRef(picked) ? picked.value = $event : null,
            class: "flex flex-col !items-start w-full !gap-1",
            onClick: () => {
            },
            style: { "--el-border": "1px solid var(--el-color-primary-light-3)" }
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<!--[-->`);
                ssrRenderList(unref(voteData).list, (item, i) => {
                  _push2(ssrRenderComponent(_component_el_radio, {
                    value: i,
                    class: "w-full rounded"
                  }, {
                    default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                      if (_push3) {
                        _push3(`${ssrInterpolate(text(item.text))}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(text(item.text)), 1)
                        ];
                      }
                    }),
                    _: 2
                  }, _parent2, _scopeId));
                });
                _push2(`<!--]-->`);
              } else {
                return [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref(voteData).list, (item, i) => {
                    return openBlock(), createBlock(_component_el_radio, {
                      value: i,
                      class: "w-full rounded"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(text(item.text)), 1)
                      ]),
                      _: 2
                    }, 1032, ["value"]);
                  }), 256))
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div>`);
        } else {
          _push(`<div class="flex flex-col gap-4" data-v-6c50b1ef><!--[-->`);
          ssrRenderList(unref(voteData)?.list, (item, i) => {
            _push(`<div class="text-xs rounded-sm overflow-hidden flex flex-col gap-0.5" data-v-6c50b1ef><div class="flex justify-between" data-v-6c50b1ef><div class="flex-1 mr-2 flex" data-v-6c50b1ef><span class="line-clamp-1" data-v-6c50b1ef>${ssrInterpolate(text(item.text))}</span></div><span class="opacity-80" data-v-6c50b1ef>${ssrInterpolate(item.vote)} ${ssrInterpolate(_ctx.$t("page.community.list.vote.votes"))} (${ssrInterpolate(proportions(unref(voteData).list, item.vote))}%) </span></div><div class="bg-[var(--el-color-info-light-7)] rounded-sm h-2 overflow-hidden relative" data-v-6c50b1ef><span class="${ssrRenderClass(`bg-[var(--el-color-info)] rounded-sm absolute left-0 top-0 h-full ${unref(pickedData).includes(parseInt(i)) ? "bg-[var(--el-color-primary-light-3)]" : ""}`)}" style="${ssrRenderStyle(`width:${proportions(unref(voteData).list, item.vote)}%`)}" data-v-6c50b1ef></span></div></div>`);
          });
          _push(`<!--]--></div>`);
        }
        _push(`</div>`);
      } else if (unref(voteData).type === "checkbox") {
        _push(`<div data-v-6c50b1ef>`);
        if (!unref(voteData).voted && !unref(voteData).hasExpired) {
          _push(`<div data-v-6c50b1ef>`);
          _push(ssrRenderComponent(_component_el_checkbox_group, {
            modelValue: unref(check),
            "onUpdate:modelValue": ($event) => isRef(check) ? check.value = $event : null,
            class: "flex flex-col !items-start",
            onClick: () => {
            },
            style: { "--el-border": "1px solid var(--el-color-primary-light-3)" }
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<!--[-->`);
                ssrRenderList(unref(voteData).list, (item, i) => {
                  _push2(ssrRenderComponent(_component_el_checkbox, {
                    value: i,
                    class: "!m-0"
                  }, {
                    default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                      if (_push3) {
                        _push3(`${ssrInterpolate(text(item.text))}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(text(item.text)), 1)
                        ];
                      }
                    }),
                    _: 2
                  }, _parent2, _scopeId));
                });
                _push2(`<!--]-->`);
              } else {
                return [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref(voteData).list, (item, i) => {
                    return openBlock(), createBlock(_component_el_checkbox, {
                      value: i,
                      class: "!m-0"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(text(item.text)), 1)
                      ]),
                      _: 2
                    }, 1032, ["value"]);
                  }), 256))
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div>`);
        } else {
          _push(`<div class="flex flex-col gap-4" data-v-6c50b1ef><!--[-->`);
          ssrRenderList(unref(voteData)?.list, (item, i) => {
            _push(`<div class="text-xs rounded-sm overflow-hidden flex flex-col gap-0.5" data-v-6c50b1ef><div class="flex justify-between" data-v-6c50b1ef><div class="flex-1 mr-2 flex" data-v-6c50b1ef><span class="line-clamp-1" data-v-6c50b1ef>${ssrInterpolate(text(item.text))}</span></div><span class="opacity-80" data-v-6c50b1ef>${ssrInterpolate(item.vote)}${ssrInterpolate(_ctx.$t("page.community.list.vote.votes"))} (${ssrInterpolate(proportions(unref(voteData).list, item.vote))}%) </span></div><div class="bg-[var(--el-color-info-light-7)] rounded-sm h-2 overflow-hidden relative" data-v-6c50b1ef><span class="${ssrRenderClass(`bg-[var(--el-color-info)] rounded-sm absolute left-0 top-0 h-full ${unref(pickedData).includes(parseInt(i)) ? "bg-[var(--el-color-primary-light-3)]" : ""}`)}" style="${ssrRenderStyle(`width:${proportions(unref(voteData).list, item.vote)}%`)}" data-v-6c50b1ef></span></div></div>`);
          });
          _push(`<!--]--></div>`);
        }
        _push(`</div>`);
      } else if (unref(voteData).type === "pk") {
        _push(`<div class="flex flex-col" data-v-6c50b1ef>`);
        if (!unref(voteData).voted && !unref(voteData).hasExpired) {
          _push(`<div class="flex items-center w-full rounded-sm overflow-hidden cursor-pointer" data-v-6c50b1ef><div class="flex items-center w-[50%] bg-[--el-color-danger-light-9] p-2 pk-left relative h-10 group/pk" data-v-6c50b1ef><i class="i-ph-boxing-glove text-[var(--el-color-danger)] text-[10px] hidden group-hover/pk:block absolute top-0.5 left-0.5" data-v-6c50b1ef></i><span class="line-clamp-2 w-full text-[var(--el-color-danger)] text-xs ml-2" data-v-6c50b1ef>${ssrInterpolate(text(unref(voteData).list[0].text))}</span></div><div class="flex items-center w-[50%] bg-[--el-color-primary-light-9] p-2 pk-right relative h-10 group/pk" data-v-6c50b1ef><i class="i-ph-boxing-glove text-[var(--el-color-primary)] text-[10px] hidden group-hover/pk:block absolute top-0.5 right-0.5" data-v-6c50b1ef></i><span class="line-clamp-2 w-full text-[var(--el-color-primary)] text-xs mr-2 text-right" data-v-6c50b1ef>${ssrInterpolate(text(unref(voteData).list[1].text))}</span></div></div>`);
        } else {
          _push(`<!--[--><div class="flex items-center w-full h-2 justify-between gap-4 mb-2 mt-1" data-v-6c50b1ef><div class="text-xs text-[var(--el-color-danger)] flex items-center" data-v-6c50b1ef>`);
          if (unref(pickedData).includes(0)) {
            _push(`<i class="i-ph-boxing-glove mr-0.5 text-[var(--el-color-danger)] text-[10px]" data-v-6c50b1ef></i>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="line-clamp-2" data-v-6c50b1ef>${ssrInterpolate(unref(voteData).list[0].vote)}${ssrInterpolate(_ctx.$t("page.community.list.vote.votes"))} (${ssrInterpolate(proportions(unref(voteData).list, unref(voteData).list[0].vote))}%)</span></div><div class="text-xs text-[var(--el-color-primary)] flex items-center" data-v-6c50b1ef>`);
          if (unref(pickedData).includes(1)) {
            _push(`<i class="i-ph-boxing-glove mr-0.5 text-[var(--el-color-primary)] text-[10px]" data-v-6c50b1ef></i>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="line-clamp-2" data-v-6c50b1ef>${ssrInterpolate(unref(voteData).list[1].vote)}${ssrInterpolate(_ctx.$t("page.community.list.vote.votes"))} (${ssrInterpolate(proportions(unref(voteData).list, unref(voteData).list[1].vote))}%)</span></div></div><div class="flex items-center w-full rounded-sm overflow-hidden cursor-pointer picked-pk flex-1" data-v-6c50b1ef><div class="flex items-center bg-[--el-color-danger] px-2 pk-left relative h-2 group/pk" style="${ssrRenderStyle(`width:${proportions(unref(voteData).list, unref(voteData).list[0].vote) == 0 && proportions(unref(voteData).list, unref(voteData).list[1].vote) == 0 ? 100 : proportions(unref(voteData).list, unref(voteData).list[0].vote)}%`)}" data-v-6c50b1ef><span class="line-clamp-1 w-full text-[var(--el-color-danger)] text-xs ml-2" data-v-6c50b1ef></span></div><div class="flex items-center bg-[--el-color-primary] px-2 pk-right relative h-2 group/pk" style="${ssrRenderStyle(`width:${proportions(unref(voteData).list, unref(voteData).list[0].vote) == 0 && proportions(unref(voteData).list, unref(voteData).list[1].vote) == 0 ? 100 : proportions(unref(voteData).list, unref(voteData).list[1].vote)}%`)}" data-v-6c50b1ef><span class="line-clamp-1 w-full text-[var(--el-color-primary)] text-xs mr-2" data-v-6c50b1ef></span></div></div><div class="flex w-full h-2 justify-between gap-4 mt-2 h-auto" data-v-6c50b1ef><div class="flex-1" data-v-6c50b1ef><span class="text-xs text-[var(--el-color-danger)] line-clamp-2" data-v-6c50b1ef>${ssrInterpolate(text(unref(voteData).list[0].text))}</span></div><div class="flex-1" data-v-6c50b1ef><span class="text-xs text-[var(--el-color-primary)] line-clamp-2 text-right" data-v-6c50b1ef>${ssrInterpolate(text(unref(voteData).list[1].text))}</span></div></div><!--]-->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flex items-center justify-between" data-v-6c50b1ef>`);
      if (unref(voteData).type === "pk" && !unref(voteData).voted && !unref(voteData).hasExpired) {
        _push(`<div class="text-xs opacity-80" data-v-6c50b1ef>${ssrInterpolate(_ctx.$t("page.community.list.vote.result"))}</div>`);
      } else {
        _push(`<!---->`);
      }
      if (!unref(voteData).voted && !unref(voteData).hasExpired) {
        _push(`<div class="flex items-center justify-between w-full flex-1" data-v-6c50b1ef>`);
        if (unref(voteData).type !== "pk") {
          _push(ssrRenderComponent(_component_el_button, {
            type: "primary",
            size: "small",
            onClick: voteRecord
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("page.community.list.vote.vote"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("page.community.list.vote.vote")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="text-xs ml-auto" data-v-6c50b1ef>`);
        if (!unref(voteData).hasExpired) {
          _push(`<span class="text-[11px] bg-[var(--el-color-success-light-9)] p-1 rounded-sm text-[var(--el-color-success)]" data-v-6c50b1ef>${ssrInterpolate(_ctx.$t("page.community.list.vote.endAt", [
            ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).timeAgo(unref(voteData).deadline)
          ]))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<div class="ml-auto flex-1" data-v-6c50b1ef>`);
        if (unref(voteData).hasExpired) {
          _push(`<span class="text-[11px] bg-[var(--el-color-danger-light-9)] p-1 rounded-sm text-[var(--el-color-danger)]" data-v-6c50b1ef>${ssrInterpolate(_ctx.$t("page.community.list.vote.ended"))}</span>`);
        } else {
          _push(`<span class="text-[11px] text-[var(--el-color-success)] bg-[var(--el-color-success-light-9)] p-1 rounded-sm" data-v-6c50b1ef>${ssrInterpolate(_ctx.$t("page.community.list.vote.voted"))}</span>`);
        }
        _push(`</div>`);
      }
      _push(`</div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/vote.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_6 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-6c50b1ef"]]);

export { __nuxt_component_6 as default };
