import { e as useUtils, x as __nuxt_component_0$1 } from './server.mjs';
import { useSSRContext, ref, getCurrentInstance, computed, watch, mergeProps, unref } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import { a as audioStore } from './audio-CfS8Ng0x.mjs';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesSingleAudioWaveform",
  __ssrInlineRender: true,
  props: ["audio", "settings", "item"],
  setup(__props, { expose: __expose }) {
    const audio = audioStore();
    const props = __props;
    const parentSvg = ref(null);
    ref(null);
    const ready = ref(false);
    const duration = ref(0);
    ref("");
    const { uid } = getCurrentInstance();
    const currentIndex = ref(-1);
    computed(() => {
      if (currentIndex.value == -1) return 0;
      if (!audio.list[currentIndex.value]) return 0;
      const currentDuration = duration.value || audio.ele?.duration || 0;
      return audio.list[currentIndex.value] && currentDuration > 0 ? audio.list[currentIndex.value]?.currentTime / currentDuration * 100 + "%" : 0;
    });
    const currentTime = computed(() => {
      if (currentIndex.value == -1) return 0;
      return audio.list[currentIndex.value]?.currentTime || 0;
    });
    watch(
      () => audio.playing,
      (val) => {
        if (val && audio.src === props.audio.src) {
          currentIndex.value = audio.list.findIndex(
            (item) => item.src === props.audio.src
          );
          if (audio.ele && audio.ele.duration) {
            duration.value = audio.ele.duration;
          }
        }
      }
    );
    watch(
      () => audio.ele?.duration,
      (newVal) => {
        if (audio.src === props.audio.src && newVal) {
          duration.value = newVal;
        }
      }
    );
    const play = (event) => {
      audio.setData({
        thumb: props.audio.thumb,
        src: props.audio.src,
        title: props.audio.name,
        duration: props.audio.duration || 0
      });
      setTimeout(() => {
        audio.playing = true;
        currentIndex.value = audio.list.findIndex(
          (item) => item.src == props.audio.src
        );
        if (audio.ele && audio.ele.duration) {
          duration.value = audio.ele.duration;
        } else if (props.audio.duration) {
          duration.value = props.audio.duration;
        }
        const svgRect = parentSvg.value.getBoundingClientRect();
        const mouseX = event.offsetX * 100 / svgRect.width;
        const targetDuration = duration.value || props.audio.duration || 100;
        if (mouseX >= 0 && mouseX < svgRect.width && targetDuration > 0) {
          let ctime = targetDuration * mouseX / 100;
          audio.list[currentIndex.value].currentTime = ctime;
          audio.ele.currentTime = ctime;
        }
      }, 10);
    };
    __expose({
      play
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex-1 relative flex w-full items-center gap-2" }, _attrs))} data-v-e9e0317f>`);
      if (__props.settings.attrsPicked.includes("duration")) {
        _push(`<span class="opacity-80 text-xs w-7.4 duration-start" data-v-e9e0317f>${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).secondsToTime(unref(currentTime)))}</span>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.settings.attrsPicked.includes("waves")) {
        _push(`<div class="@md:h-3 h-2 w-full relative cursor-pointer flex-1" data-v-e9e0317f><div class="absolute top-0 left-0 w-full h-full overflow-hidden" data-v-e9e0317f>`);
        _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
        if (!unref(ready)) {
          _push(`<svg viewBox="0 0 100 100" class="default-waveform !w-full !h-full" preserveAspectRatio="none" data-v-e9e0317f><rect x="0" y="45" width="100" height="10" data-v-e9e0317f></rect></svg>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.settings.attrsPicked.includes("duration")) {
        _push(`<span class="opacity-80 text-xs w-7.4 duration-end" data-v-e9e0317f>`);
        _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
        _push(`</span>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/single/audio/waveform.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_2 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-e9e0317f"]]);

export { __nuxt_component_2 as default };
