import { E as ElDialog } from './index-awVc4A7-.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import { E as ElSelect, a as ElOption } from './index-03hfIBa_.mjs';
import { V as useNuxtApp, v as viewerStore, j as actionStore, a as useI18n, r as useRequest, E as ElMessage, e as useUtils } from './server.mjs';
import { useSSRContext, reactive, computed, watch, resolveDirective, mergeProps, unref, withCtx, createTextVNode, toDisplayString, openBlock, createBlock, Fragment, renderList, createVNode, withDirectives } from 'vue';
import { ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrGetDirectiveProps } from 'vue/server-renderer';
import NumberFlow from '@number-flow/vue';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './use-dialog-7J0bwlna.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import 'lodash-unified';
import './aria-BhThsKez.mjs';
import './event-BZTOGHfp.mjs';
import '@vue/shared';
import './vnode-l2ZP2UQa.mjs';
import './index-Di0Jlzch.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './index-DRiwogtD.mjs';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import './index-Bp-nwGzu.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-tCyBRCDx.mjs';
import './index-BY8mj3AC.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesAccountWealthWithdrawal",
  __ssrInlineRender: true,
  emits: ["success"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const { $serverSettings } = useNuxtApp();
    const viewer = viewerStore();
    const action = actionStore();
    const { t } = useI18n();
    const emits = __emit;
    const state = reactive({
      locked: false,
      currency: "",
      show: false,
      withdrawn: 0,
      channelList: computed(() => {
        return $serverSettings.wealth_settings.balance.withdraw_channel?.[state.currency]?.split(",");
      }),
      channel: {
        type: "",
        account: ""
      },
      getRealMoney: computed(() => {
        const rate = $serverSettings.wealth_settings.balance.withdraw_commission / 100;
        return useUtils.mul(state.withdrawn, 1 - rate);
      }),
      symbol: computed(() => {
        return $serverSettings.currency[state.index]?.symbol;
      }),
      index: computed(() => {
        return $serverSettings.currency.findIndex(
          (item) => item.symbol_iso === state.currency
        );
      }),
      action: async () => {
        if (state.locked) return;
        state.locked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              withdrawn: state.withdrawn,
              currency: state.currency,
              account: state.channel.account,
              channel: state.channel.type
            }
          }
        });
        if (res?.gqWithdrawal?.success) {
          state.show = false;
          ElMessage.success(t("page.account.wealth.withdrawal.box.success"));
          emits("success", "withdrawal");
        }
        state.locked = false;
      }
    });
    state.currency = $serverSettings.currency[0].symbol_iso;
    watch(
      () => viewer.data.databaseId,
      (val) => {
        if (val) {
          state.withdrawn = viewer.data.gqMoney[state.currency];
        }
      }
    );
    watch(
      () => action.currency.iso,
      (val) => {
        state.withdrawn = viewer.data.gqMoney[val];
        state.currency = val;
        state.channel = {
          type: "",
          account: ""
        };
      }
    );
    __expose({
      state
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_dialog = ElDialog;
      const _component_el_button = ElButton;
      const _component_el_input = ElInput;
      const _component_el_select = ElSelect;
      const _component_el_option = ElOption;
      const _directive_decimal = resolveDirective("decimal");
      _push(ssrRenderComponent(_component_el_dialog, mergeProps({
        modelValue: unref(state).show,
        "onUpdate:modelValue": ($event) => unref(state).show = $event,
        "append-to-body": true,
        "lock-scroll": false,
        title: _ctx.$t("page.account.wealth.withdrawal.box.title"),
        width: "310px"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div data-v-0327a945${_scopeId}><div class="inline-flex bg-[--el-color-info-light-10] rounded-md p-1 gq-border-none border-1 gap-2 mb-3" data-v-0327a945${_scopeId}><!--[-->`);
            ssrRenderList(unref($serverSettings).currency, (item, i) => {
              _push2(ssrRenderComponent(_component_el_button, {
                plain: "",
                size: "small",
                class: `cursor-pointer !m-0 ${unref(state).currency === item.symbol_iso ? "is-active" : ""}`,
                onClick: ($event) => {
                  unref(state).currency = item.symbol_iso;
                  unref(state).withdrawn = ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(
                    unref(viewer).data.gqMoney[item.symbol_iso],
                    item.symbol_iso
                  );
                }
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(item.symbol_iso)}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(item.symbol_iso), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent2, _scopeId));
            });
            _push2(`<!--]--></div><div class="grid grid-cols-2 text-xs text-[--el-color-info-dark-2] border-1 border-[--el-color-info-light-7] rounded p-2 mb-3 gap-3" data-v-0327a945${_scopeId}><div class="flex gap-1 flex-col" data-v-0327a945${_scopeId}><div data-v-0327a945${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.wealth.withdrawal.box.balance"))} ${ssrInterpolate(unref($serverSettings).currency[unref(state).index].symbol_iso)}： </div><div class="text-[--el-color-primary]" data-v-0327a945${_scopeId}>${ssrInterpolate(unref($serverSettings).currency[unref(state).index].symbol)} `);
            _push2(ssrRenderComponent(unref(NumberFlow), {
              value: unref(viewer).data.gqMoney[unref(state).currency] || 0,
              format: {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2,
                useGrouping: false
              }
            }, null, _parent2, _scopeId));
            _push2(`</div></div><div class="flex gap-1 flex-col" data-v-0327a945${_scopeId}><div data-v-0327a945${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.wealth.withdrawal.box.min"))} ${ssrInterpolate(unref($serverSettings).currency[unref(state).index].symbol_iso)}： </div><div class="text-[--el-color-primary]" data-v-0327a945${_scopeId}>${ssrInterpolate(unref($serverSettings).currency[unref(state).index].symbol)} `);
            _push2(ssrRenderComponent(unref(NumberFlow), {
              value: unref($serverSettings).wealth_settings.balance.withdraw_min?.[unref(state).currency] || 0,
              format: {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2,
                useGrouping: false
              }
            }, null, _parent2, _scopeId));
            _push2(`</div></div><div class="flex gap-1 flex-col" data-v-0327a945${_scopeId}><div data-v-0327a945${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.wealth.withdrawal.box.commission"))}</div><div class="text-[--el-color-primary]" data-v-0327a945${_scopeId}>${ssrInterpolate(unref($serverSettings).wealth_settings.balance.withdraw_commission + "%")}</div></div>`);
            if (unref(state).withdrawn >= parseFloat(
              unref($serverSettings).wealth_settings.balance.withdraw_min[unref(state).currency]
            )) {
              _push2(`<div class="flex gap-1 flex-col" data-v-0327a945${_scopeId}><div data-v-0327a945${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.wealth.withdrawal.box.real"))}</div><div class="text-[--el-color-primary]" data-v-0327a945${_scopeId}>${ssrInterpolate(unref(state).symbol)} `);
              _push2(ssrRenderComponent(unref(NumberFlow), {
                value: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(state).getRealMoney, unref(state).currency),
                format: {
                  minimumFractionDigits: 2,
                  maximumFractionDigits: 2,
                  useGrouping: false
                }
              }, null, _parent2, _scopeId));
              _push2(`</div></div>`);
            } else {
              _push2(`<div class="flex gap-1 flex-col" data-v-0327a945${_scopeId}><div class="opacity-70" data-v-0327a945${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.wealth.withdrawal.box.need"))}</div><div class="text-red-500" data-v-0327a945${_scopeId}>${ssrInterpolate(unref($serverSettings).currency[unref(state).index]?.symbol + ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(
                unref($serverSettings).wealth_settings.balance.withdraw_min[unref(state).currency],
                unref(state).currency
              ))}</div></div>`);
            }
            _push2(`</div><div class="flex flex-col gap-1 border-dashed border-1 border-[--el-color-primary-light-7] rounded p-2 bg-[--el-color-primary-light-9] channel-input" data-v-0327a945${_scopeId}><div class="text-xs" data-v-0327a945${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.wealth.withdrawal.box.account"))}</div>`);
            _push2(ssrRenderComponent(_component_el_input, {
              modelValue: unref(state).channel.account,
              "onUpdate:modelValue": ($event) => unref(state).channel.account = $event,
              placeholder: _ctx.$t("page.account.wealth.withdrawal.box.accountPlaceholder"),
              class: "!overflow-hidden bg-[--el-bg-color] rounded overflow-hidden",
              size: "large",
              style: { "--el-input-border": "0", "--el-input-hover-border": "0", "--el-input-focus-border": "0", "--el-input-clear-hover-color": "transparent", "---el-input-focus-border-color": "transparent", "--el-border-color": "transparent", "--el-border-color-hover": "transparent", "--el-border-color-focus": "transparent", "--el-border-color-focus-hover": "transparent", "--el-border-color-focus-active": "transparent", "--el-border-color-focus-active-hover": "transparent", "--el-border-color-focus-active-focus": "transparent" }
            }, {
              prepend: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_el_select, {
                    modelValue: unref(state).channel.type,
                    "onUpdate:modelValue": ($event) => unref(state).channel.type = $event,
                    placeholder: _ctx.$t("page.account.wealth.withdrawal.box.channel"),
                    class: "!w-20 rounded-sm"
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`<!--[-->`);
                        ssrRenderList(unref(state).channelList, (item) => {
                          _push4(ssrRenderComponent(_component_el_option, {
                            key: item,
                            label: item,
                            value: item
                          }, null, _parent4, _scopeId3));
                        });
                        _push4(`<!--]-->`);
                      } else {
                        return [
                          (openBlock(true), createBlock(Fragment, null, renderList(unref(state).channelList, (item) => {
                            return openBlock(), createBlock(_component_el_option, {
                              key: item,
                              label: item,
                              value: item
                            }, null, 8, ["label", "value"]);
                          }), 128))
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_el_select, {
                      modelValue: unref(state).channel.type,
                      "onUpdate:modelValue": ($event) => unref(state).channel.type = $event,
                      placeholder: _ctx.$t("page.account.wealth.withdrawal.box.channel"),
                      class: "!w-20 rounded-sm"
                    }, {
                      default: withCtx(() => [
                        (openBlock(true), createBlock(Fragment, null, renderList(unref(state).channelList, (item) => {
                          return openBlock(), createBlock(_component_el_option, {
                            key: item,
                            label: item,
                            value: item
                          }, null, 8, ["label", "value"]);
                        }), 128))
                      ]),
                      _: 1
                    }, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`<div class="text-xs mt-2" data-v-0327a945${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.wealth.withdrawal.box.amount"))}</div>`);
            _push2(ssrRenderComponent(_component_el_input, mergeProps({
              modelValue: unref(state).withdrawn,
              "onUpdate:modelValue": ($event) => unref(state).withdrawn = $event,
              type: "number",
              class: "!text-lg",
              step: "0.01",
              style: { "--el-input-bg-color": "var(--el-bg-color)", "--el-input-border-color": "var(--el-color-primary-light-7)", "--el-input-hover-border-color": "var(--el-color-primary-light-7)", "--el-input-focus-border-color": "var(--el-color-primary-light-7)", "--el-input-text-color": "var(--el-color-primary)" },
              size: "large"
            }, ssrGetDirectiveProps(_ctx, _directive_decimal, {
              decimals: 2,
              min: 0,
              max: unref(viewer).data.gqMoney[unref(state).currency]
            })), {
              prefix: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<span class="w-3" data-v-0327a945${_scopeId2}>${ssrInterpolate(unref($serverSettings).currency[unref(state).index]?.symbol)}</span>`);
                } else {
                  return [
                    createVNode("span", { class: "w-3" }, toDisplayString(unref($serverSettings).currency[unref(state).index]?.symbol), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div><div class="text-xs bg-[--el-color-warning-light-10] mt-2 text-[--el-color-warning-dark-2] rounded p-2 border-1 border-[--el-color-warning-light-7]" data-v-0327a945${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.wealth.withdrawal.box.desc"))}</div><div data-v-0327a945${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              class: "mt-4 w-full",
              onClick: unref(state).action,
              loading: unref(state).locked,
              disabled: unref(state).withdrawn < parseFloat(
                unref($serverSettings).wealth_settings.balance.withdraw_min[unref(state).currency]
              ) || !unref(state).channel.type || !unref(state).channel.account ? true : false
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("page.account.wealth.withdrawal.box.submit"))} ${ssrInterpolate(unref(state).symbol)} `);
                  _push3(ssrRenderComponent(unref(NumberFlow), {
                    value: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(state).getRealMoney, unref(state).currency),
                    format: {
                      minimumFractionDigits: 2,
                      maximumFractionDigits: 2,
                      useGrouping: false
                    }
                  }, null, _parent3, _scopeId2));
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("page.account.wealth.withdrawal.box.submit")) + " " + toDisplayString(unref(state).symbol) + " ", 1),
                    createVNode(unref(NumberFlow), {
                      value: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(state).getRealMoney, unref(state).currency),
                      format: {
                        minimumFractionDigits: 2,
                        maximumFractionDigits: 2,
                        useGrouping: false
                      }
                    }, null, 8, ["value"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", null, [
                createVNode("div", { class: "inline-flex bg-[--el-color-info-light-10] rounded-md p-1 gq-border-none border-1 gap-2 mb-3" }, [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref($serverSettings).currency, (item, i) => {
                    return openBlock(), createBlock(_component_el_button, {
                      plain: "",
                      size: "small",
                      class: `cursor-pointer !m-0 ${unref(state).currency === item.symbol_iso ? "is-active" : ""}`,
                      onClick: ($event) => {
                        unref(state).currency = item.symbol_iso;
                        unref(state).withdrawn = ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(
                          unref(viewer).data.gqMoney[item.symbol_iso],
                          item.symbol_iso
                        );
                      }
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(item.symbol_iso), 1)
                      ]),
                      _: 2
                    }, 1032, ["class", "onClick"]);
                  }), 256))
                ]),
                createVNode("div", { class: "grid grid-cols-2 text-xs text-[--el-color-info-dark-2] border-1 border-[--el-color-info-light-7] rounded p-2 mb-3 gap-3" }, [
                  createVNode("div", { class: "flex gap-1 flex-col" }, [
                    createVNode("div", null, toDisplayString(_ctx.$t("page.account.wealth.withdrawal.box.balance")) + " " + toDisplayString(unref($serverSettings).currency[unref(state).index].symbol_iso) + "： ", 1),
                    createVNode("div", { class: "text-[--el-color-primary]" }, [
                      createTextVNode(toDisplayString(unref($serverSettings).currency[unref(state).index].symbol) + " ", 1),
                      createVNode(unref(NumberFlow), {
                        value: unref(viewer).data.gqMoney[unref(state).currency] || 0,
                        format: {
                          minimumFractionDigits: 2,
                          maximumFractionDigits: 2,
                          useGrouping: false
                        }
                      }, null, 8, ["value"])
                    ])
                  ]),
                  createVNode("div", { class: "flex gap-1 flex-col" }, [
                    createVNode("div", null, toDisplayString(_ctx.$t("page.account.wealth.withdrawal.box.min")) + " " + toDisplayString(unref($serverSettings).currency[unref(state).index].symbol_iso) + "： ", 1),
                    createVNode("div", { class: "text-[--el-color-primary]" }, [
                      createTextVNode(toDisplayString(unref($serverSettings).currency[unref(state).index].symbol) + " ", 1),
                      createVNode(unref(NumberFlow), {
                        value: unref($serverSettings).wealth_settings.balance.withdraw_min?.[unref(state).currency] || 0,
                        format: {
                          minimumFractionDigits: 2,
                          maximumFractionDigits: 2,
                          useGrouping: false
                        }
                      }, null, 8, ["value"])
                    ])
                  ]),
                  createVNode("div", { class: "flex gap-1 flex-col" }, [
                    createVNode("div", null, toDisplayString(_ctx.$t("page.account.wealth.withdrawal.box.commission")), 1),
                    createVNode("div", { class: "text-[--el-color-primary]" }, toDisplayString(unref($serverSettings).wealth_settings.balance.withdraw_commission + "%"), 1)
                  ]),
                  unref(state).withdrawn >= parseFloat(
                    unref($serverSettings).wealth_settings.balance.withdraw_min[unref(state).currency]
                  ) ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "flex gap-1 flex-col"
                  }, [
                    createVNode("div", null, toDisplayString(_ctx.$t("page.account.wealth.withdrawal.box.real")), 1),
                    createVNode("div", { class: "text-[--el-color-primary]" }, [
                      createTextVNode(toDisplayString(unref(state).symbol) + " ", 1),
                      createVNode(unref(NumberFlow), {
                        value: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(state).getRealMoney, unref(state).currency),
                        format: {
                          minimumFractionDigits: 2,
                          maximumFractionDigits: 2,
                          useGrouping: false
                        }
                      }, null, 8, ["value"])
                    ])
                  ])) : (openBlock(), createBlock("div", {
                    key: 1,
                    class: "flex gap-1 flex-col"
                  }, [
                    createVNode("div", { class: "opacity-70" }, toDisplayString(_ctx.$t("page.account.wealth.withdrawal.box.need")), 1),
                    createVNode("div", { class: "text-red-500" }, toDisplayString(unref($serverSettings).currency[unref(state).index]?.symbol + ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(
                      unref($serverSettings).wealth_settings.balance.withdraw_min[unref(state).currency],
                      unref(state).currency
                    )), 1)
                  ]))
                ]),
                createVNode("div", { class: "flex flex-col gap-1 border-dashed border-1 border-[--el-color-primary-light-7] rounded p-2 bg-[--el-color-primary-light-9] channel-input" }, [
                  createVNode("div", { class: "text-xs" }, toDisplayString(_ctx.$t("page.account.wealth.withdrawal.box.account")), 1),
                  createVNode(_component_el_input, {
                    modelValue: unref(state).channel.account,
                    "onUpdate:modelValue": ($event) => unref(state).channel.account = $event,
                    placeholder: _ctx.$t("page.account.wealth.withdrawal.box.accountPlaceholder"),
                    class: "!overflow-hidden bg-[--el-bg-color] rounded overflow-hidden",
                    size: "large",
                    style: { "--el-input-border": "0", "--el-input-hover-border": "0", "--el-input-focus-border": "0", "--el-input-clear-hover-color": "transparent", "---el-input-focus-border-color": "transparent", "--el-border-color": "transparent", "--el-border-color-hover": "transparent", "--el-border-color-focus": "transparent", "--el-border-color-focus-hover": "transparent", "--el-border-color-focus-active": "transparent", "--el-border-color-focus-active-hover": "transparent", "--el-border-color-focus-active-focus": "transparent" }
                  }, {
                    prepend: withCtx(() => [
                      createVNode(_component_el_select, {
                        modelValue: unref(state).channel.type,
                        "onUpdate:modelValue": ($event) => unref(state).channel.type = $event,
                        placeholder: _ctx.$t("page.account.wealth.withdrawal.box.channel"),
                        class: "!w-20 rounded-sm"
                      }, {
                        default: withCtx(() => [
                          (openBlock(true), createBlock(Fragment, null, renderList(unref(state).channelList, (item) => {
                            return openBlock(), createBlock(_component_el_option, {
                              key: item,
                              label: item,
                              value: item
                            }, null, 8, ["label", "value"]);
                          }), 128))
                        ]),
                        _: 1
                      }, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                    ]),
                    _: 1
                  }, 8, ["modelValue", "onUpdate:modelValue", "placeholder"]),
                  createVNode("div", { class: "text-xs mt-2" }, toDisplayString(_ctx.$t("page.account.wealth.withdrawal.box.amount")), 1),
                  withDirectives((openBlock(), createBlock(_component_el_input, {
                    modelValue: unref(state).withdrawn,
                    "onUpdate:modelValue": ($event) => unref(state).withdrawn = $event,
                    type: "number",
                    class: "!text-lg",
                    step: "0.01",
                    style: { "--el-input-bg-color": "var(--el-bg-color)", "--el-input-border-color": "var(--el-color-primary-light-7)", "--el-input-hover-border-color": "var(--el-color-primary-light-7)", "--el-input-focus-border-color": "var(--el-color-primary-light-7)", "--el-input-text-color": "var(--el-color-primary)" },
                    size: "large"
                  }, {
                    prefix: withCtx(() => [
                      createVNode("span", { class: "w-3" }, toDisplayString(unref($serverSettings).currency[unref(state).index]?.symbol), 1)
                    ]),
                    _: 1
                  }, 8, ["modelValue", "onUpdate:modelValue"])), [
                    [_directive_decimal, {
                      decimals: 2,
                      min: 0,
                      max: unref(viewer).data.gqMoney[unref(state).currency]
                    }]
                  ])
                ]),
                createVNode("div", { class: "text-xs bg-[--el-color-warning-light-10] mt-2 text-[--el-color-warning-dark-2] rounded p-2 border-1 border-[--el-color-warning-light-7]" }, toDisplayString(_ctx.$t("page.account.wealth.withdrawal.box.desc")), 1),
                createVNode("div", null, [
                  createVNode(_component_el_button, {
                    type: "primary",
                    class: "mt-4 w-full",
                    onClick: unref(state).action,
                    loading: unref(state).locked,
                    disabled: unref(state).withdrawn < parseFloat(
                      unref($serverSettings).wealth_settings.balance.withdraw_min[unref(state).currency]
                    ) || !unref(state).channel.type || !unref(state).channel.account ? true : false
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("page.account.wealth.withdrawal.box.submit")) + " " + toDisplayString(unref(state).symbol) + " ", 1),
                      createVNode(unref(NumberFlow), {
                        value: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(state).getRealMoney, unref(state).currency),
                        format: {
                          minimumFractionDigits: 2,
                          maximumFractionDigits: 2,
                          useGrouping: false
                        }
                      }, null, 8, ["value"])
                    ]),
                    _: 1
                  }, 8, ["onClick", "loading", "disabled"])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/account/wealth/withdrawal.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_9 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-0327a945"]]);

export { __nuxt_component_9 as default };
