import { E as ElDialog } from './index-awVc4A7-.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { g as getServerSettings, e as useUtils, r as useRequest } from './server.mjs';
import { ref, mergeProps, unref, isRef, withCtx, createTextVNode, toDisplayString, openBlock, createBlock, createVNode, Fragment, renderList, createCommentVNode, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrInterpolate, ssrRenderList } from 'vue/server-renderer';
import './use-dialog-7J0bwlna.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import 'lodash-unified';
import './aria-BhThsKez.mjs';
import './event-BZTOGHfp.mjs';
import '@vue/shared';
import './vnode-l2ZP2UQa.mjs';
import './index-Di0Jlzch.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesAccountPromotionWithdrawn",
  __ssrInlineRender: true,
  props: ["data"],
  setup(__props, { expose: __expose }) {
    const show = ref(false);
    const success = ref(false);
    const close = () => {
      show.value = false;
      useUtils.navigateTo("/account/wealth?type=balance");
      setTimeout(() => {
        success.value = false;
      }, 100);
    };
    const settingsStore = getServerSettings();
    const locked = ref(false);
    const withdraw = async () => {
      if (locked.value) return;
      locked.value = true;
      const res = await useRequest("/api/request", {});
      if (res?.gqWithdrawPromotion?.success) {
        success.value = true;
      }
      locked.value = false;
    };
    __expose({
      show
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_dialog = ElDialog;
      const _component_el_button = ElButton;
      _push(ssrRenderComponent(_component_el_dialog, mergeProps({
        modelValue: unref(show),
        "onUpdate:modelValue": ($event) => isRef(show) ? show.value = $event : null,
        title: unref(success) ? "" : _ctx.$t("page.account.promotion.withdrawnBox.title"),
        "lock-scroll": false,
        "close-on-click-modal": false,
        "append-to-body": true,
        width: "280"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (!unref(success)) {
              _push2(`<div${_scopeId}><div class="text-xs flex-col flex gap-2 mb-4"${_scopeId}><div${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.promotion.withdrawnBox.cycle", [__props.data.cycle]))}</div><div${_scopeId}><div class="flex flex-col mt-1 border-1 divide-y rounded bg-[--el-color-info-light-10]"${_scopeId}><div class="p-2 py-1"${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.promotion.withdrawnBox.unaccounted"))}</div><!--[-->`);
              ssrRenderList(__props.data.statistics, (item, i) => {
                _push2(`<div class="p-1 flex justify-between items-center px-2 opacity-70"${_scopeId}><span${_scopeId}>${ssrInterpolate(item.currency)}</span><span${_scopeId}>${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).isoToSymbol(
                  item.currency,
                  unref(settingsStore).currency
                ) + ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(item.withdrawn, item.currency))}</span></div>`);
              });
              _push2(`<!--]--></div></div><div class="opacity-70"${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.promotion.withdrawnBox.unaccountedDesc"))}</div></div><hr${_scopeId}><h2 class="mt-4"${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.promotion.withdrawnBox.accounted"))}</h2><div class="flex text-xs flex-col mt-2 border-1 divide-y rounded-md bg-[--el-color-info-light-10]"${_scopeId}><!--[-->`);
              ssrRenderList(__props.data.statistics, (item) => {
                _push2(`<div class="flex justify-between p-2 items-center"${_scopeId}><div${_scopeId}>${ssrInterpolate(item.currency)}</div><div class="text-[--el-color-primary-dark-2]"${_scopeId}>${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).isoToSymbol(
                  item.currency,
                  unref(settingsStore).currency
                ) + ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(item.withdrawable, item.currency))}</div></div>`);
              });
              _push2(`<!--]--></div><div class="flex justify-end mt-4"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_el_button, {
                type: "primary",
                onClick: withdraw,
                class: "w-full",
                loading: unref(locked)
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("page.account.promotion.withdrawnBox.title"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("page.account.promotion.withdrawnBox.title")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div></div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(success)) {
              _push2(`<div class="flex flex-col gap-4"${_scopeId}><div class="text-center flex justify-center"${_scopeId}><i class="i-ph-check-circle-fill text-[--el-color-success] text-4xl"${_scopeId}></i></div><div class="text-center text-lg font-600"${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.promotion.withdrawnBox.success"))}</div><div class="text-center text-sm text-[--el-text-color-regular]"${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.promotion.withdrawnBox.successDesc"))}</div><div class="mt-4 flex justify-center"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_el_button, {
                type: "primary",
                onClick: close
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("page.account.promotion.withdrawnBox.successBtn"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("page.account.promotion.withdrawnBox.successBtn")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div></div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              !unref(success) ? (openBlock(), createBlock("div", { key: 0 }, [
                createVNode("div", { class: "text-xs flex-col flex gap-2 mb-4" }, [
                  createVNode("div", null, toDisplayString(_ctx.$t("page.account.promotion.withdrawnBox.cycle", [__props.data.cycle])), 1),
                  createVNode("div", null, [
                    createVNode("div", { class: "flex flex-col mt-1 border-1 divide-y rounded bg-[--el-color-info-light-10]" }, [
                      createVNode("div", { class: "p-2 py-1" }, toDisplayString(_ctx.$t("page.account.promotion.withdrawnBox.unaccounted")), 1),
                      (openBlock(true), createBlock(Fragment, null, renderList(__props.data.statistics, (item, i) => {
                        return openBlock(), createBlock("div", {
                          key: i,
                          class: "p-1 flex justify-between items-center px-2 opacity-70"
                        }, [
                          createVNode("span", null, toDisplayString(item.currency), 1),
                          createVNode("span", null, toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).isoToSymbol(
                            item.currency,
                            unref(settingsStore).currency
                          ) + ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(item.withdrawn, item.currency)), 1)
                        ]);
                      }), 128))
                    ])
                  ]),
                  createVNode("div", { class: "opacity-70" }, toDisplayString(_ctx.$t("page.account.promotion.withdrawnBox.unaccountedDesc")), 1)
                ]),
                createVNode("hr"),
                createVNode("h2", { class: "mt-4" }, toDisplayString(_ctx.$t("page.account.promotion.withdrawnBox.accounted")), 1),
                createVNode("div", { class: "flex text-xs flex-col mt-2 border-1 divide-y rounded-md bg-[--el-color-info-light-10]" }, [
                  (openBlock(true), createBlock(Fragment, null, renderList(__props.data.statistics, (item) => {
                    return openBlock(), createBlock("div", {
                      key: item.currency,
                      class: "flex justify-between p-2 items-center"
                    }, [
                      createVNode("div", null, toDisplayString(item.currency), 1),
                      createVNode("div", { class: "text-[--el-color-primary-dark-2]" }, toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).isoToSymbol(
                        item.currency,
                        unref(settingsStore).currency
                      ) + ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(item.withdrawable, item.currency)), 1)
                    ]);
                  }), 128))
                ]),
                createVNode("div", { class: "flex justify-end mt-4" }, [
                  createVNode(_component_el_button, {
                    type: "primary",
                    onClick: withdraw,
                    class: "w-full",
                    loading: unref(locked)
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("page.account.promotion.withdrawnBox.title")), 1)
                    ]),
                    _: 1
                  }, 8, ["loading"])
                ])
              ])) : createCommentVNode("", true),
              unref(success) ? (openBlock(), createBlock("div", {
                key: 1,
                class: "flex flex-col gap-4"
              }, [
                createVNode("div", { class: "text-center flex justify-center" }, [
                  createVNode("i", { class: "i-ph-check-circle-fill text-[--el-color-success] text-4xl" })
                ]),
                createVNode("div", { class: "text-center text-lg font-600" }, toDisplayString(_ctx.$t("page.account.promotion.withdrawnBox.success")), 1),
                createVNode("div", { class: "text-center text-sm text-[--el-text-color-regular]" }, toDisplayString(_ctx.$t("page.account.promotion.withdrawnBox.successDesc")), 1),
                createVNode("div", { class: "mt-4 flex justify-center" }, [
                  createVNode(_component_el_button, {
                    type: "primary",
                    onClick: close
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("page.account.promotion.withdrawnBox.successBtn")), 1)
                    ]),
                    _: 1
                  })
                ])
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/account/promotion/withdrawn.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
