import { ref, watch, unref, mergeProps, withCtx, createVNode, openBlock, createBlock, toDisplayString, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderAttr, ssrRenderClass, ssrInterpolate } from 'vue/server-renderer';
import { NodeViewWrapper } from '@tiptap/vue-3';
import { a as useI18n, aI as useElementSize } from './server.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonEditorWpImage",
  __ssrInlineRender: true,
  props: ["editor", "node", "deleteNode"],
  setup(__props) {
    const props = __props;
    const { t } = useI18n();
    const containerWidth = ref(0);
    const container = ref(null);
    const { width } = useElementSize(container);
    const editCaption = () => {
      const newCaption = prompt(t("common.editor.library.editDescription"), props.node.attrs.caption || "");
      if (newCaption !== null) {
        props.editor.commands.updateAttributes("image", { caption: newCaption });
      }
    };
    watch(width, (newWidth) => {
      containerWidth.value = newWidth;
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(ssrRenderComponent(unref(NodeViewWrapper), mergeProps({
        class: "relative wp-block-image w-fit min-w-30 mx-auto",
        style: `--wp-block-image-max-width: ${unref(containerWidth)}px;`,
        ref_key: "container",
        ref: container,
        "data-drag-handle": ""
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<img${ssrRenderAttr("src", __props.node.attrs.src)}${ssrRenderAttr("alt", __props.node.attrs.alt)} class="${ssrRenderClass(__props.node.attrs.class)}"${_scopeId}><div class="flex figcaption items-center justify-center gap-1 cursor-pointer"${_scopeId}>`);
            if (__props.node.attrs.caption) {
              _push2(`<span${_scopeId}>${ssrInterpolate(__props.node.attrs.caption)}</span>`);
            } else {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("common.editor.library.addDescription"))}</span>`);
            }
            _push2(`<i class="i-ph-pencil-line opacity-80"${_scopeId}></i></div>`);
          } else {
            return [
              createVNode("img", {
                src: __props.node.attrs.src,
                alt: __props.node.attrs.alt,
                class: __props.node.attrs.class
              }, null, 10, ["src", "alt"]),
              createVNode("div", {
                onClick: editCaption,
                class: "flex figcaption items-center justify-center gap-1 cursor-pointer"
              }, [
                __props.node.attrs.caption ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(__props.node.attrs.caption), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("common.editor.library.addDescription")), 1)),
                createVNode("i", { class: "i-ph-pencil-line opacity-80" })
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/editor/wpImage.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
