import { c as defineEventHandler, u as useRuntimeConfig, f as readBody, g as getCookie, w as wpClient } from '../../../_/nitro.mjs';
import { s as storeTokens } from '../../../_/cookie.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue';
import 'vue-bundle-renderer/runtime';
import 'vue/server-renderer';

const refresh = defineEventHandler(async (event) => {
  var _a, _b, _c, _d, _e, _f, _g, _h;
  const config = useRuntimeConfig();
  try {
    const body = await readBody(event);
    let refreshToken = getCookie(event, "refreshToken");
    if (body == null ? void 0 : body.refreshToken) {
      refreshToken = body.refreshToken;
    }
    const res = await wpClient(config.private.apiBase, {
      method: "post",
      headers: {
        "host": event.context.host,
        "X-Fe-Route": event.context.host,
        "X-Fe-Ip": event.context.ip
      },
      body: {
        query: `
                    mutation refreshToken {
                        refreshToken(input: {refreshToken: "${refreshToken}"}) {
                            authToken
                            authTokenExpiration
                        }
                    }
                `
      },
      timeout: 1e4,
      // 10秒超时
      retry: 0
      // 禁用自动重试
    });
    if ((_b = (_a = res == null ? void 0 : res.data) == null ? void 0 : _a.refreshToken) == null ? void 0 : _b.authToken) {
      storeTokens(event, {
        authToken: (_d = (_c = res == null ? void 0 : res.data) == null ? void 0 : _c.refreshToken) == null ? void 0 : _d.authToken,
        authTokenExpiration: (_f = (_e = res == null ? void 0 : res.data) == null ? void 0 : _e.refreshToken) == null ? void 0 : _f.authTokenExpiration
      });
      return (_h = (_g = res == null ? void 0 : res.data) == null ? void 0 : _g.refreshToken) == null ? void 0 : _h.authToken;
    }
    return {
      statusCode: 401,
      message: "refreshToken is required"
    };
  } catch (error) {
    return {
      statusCode: 401,
      message: "refreshToken is required"
    };
  }
});

export { refresh as default };
