import { c as defineEventHandler, l as getQuery, m as setHeader } from '../../_/nitro.mjs';
import { g as getClients } from '../../_/getClients.mjs';
import { createAvatar } from '@dicebear/core';
import { notionists } from '@dicebear/collection';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue';
import 'vue-bundle-renderer/runtime';
import 'vue/server-renderer';

const avatar = defineEventHandler(async (event) => {
  try {
    const allowedHosts = await getClients(event);
    if (!allowedHosts.includes(event.context.host)) {
      event.node.res.statusCode = 503;
      return "Service Unavailable";
    }
    const query = getQuery(event);
    const seed = String(query.seed || Math.random().toString(36).slice(2, 10)).replace(/[^a-zA-Z0-9_-]/g, "");
    const scale = Math.min(Number(query.scale) || 120, 500);
    const svg = createAvatar(notionists, { seed, scale, cache: true, backgroundColor: [
      "b6e3f4",
      "c0aede",
      "d1d4f9",
      "f4e4f3",
      "ffd6cc",
      "ffe4b5",
      "e8f5e9",
      "fff4e6",
      "f0e6ff",
      "ffe0f0",
      "e3f2fd",
      "fce4ec",
      "f1f8e9",
      "fff3e0",
      "ede7f6",
      "e0f2f1",
      "fff9c4",
      "f3e5f5",
      "e8eaf6",
      "ffebee"
    ] }).toString();
    setHeader(event, "Content-Type", "image/svg+xml");
    setHeader(event, "Cache-Control", "public, max-age=86400");
    return svg;
  } catch (error) {
    console.error("[avatar] Error:", error);
    event.node.res.statusCode = 503;
    return "Service Unavailable";
  }
});

export { avatar as default };
