import { c as defineEventHandler, u as useRuntimeConfig, h as getHeader, i as readRawBody, j as createError, k as setResponseHeader } from '../../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue';
import 'vue-bundle-renderer/runtime';
import 'vue/server-renderer';

function stripLastSegment(str) {
  return str.replace(/\/[^/]*$/, "") || str;
}
const callback = defineEventHandler(async (event) => {
  const config = useRuntimeConfig();
  const ct = getHeader(event, "content-type") || "";
  const raw = await readRawBody(event);
  const host = event.context.host;
  if (!raw) throw createError({ statusCode: 400, statusMessage: "Empty body" });
  try {
    const url = stripLastSegment(config.private.apiBase) + "/gq/pay-callback";
    const resp = await $fetch(url, {
      method: "POST",
      headers: { "Content-Type": ct, "host": host, "X-Fe-Route": host },
      body: raw,
      timeout: 3e4,
      // 30秒超时
      retry: 0,
      // 禁用自动重试
      onResponseError({ response }) {
        throw createError({ statusCode: response.status, statusMessage: response.statusText });
      }
    });
    setResponseHeader(event, "Content-Type", "text/plain");
    return resp;
  } catch (e) {
    throw createError({ statusCode: e.statusCode || 500, statusMessage: e.statusMessage });
  }
});

export { callback as default };
